/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.clientlisteners.listeners;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.clientlisteners.ClientListenersModel;
import net.sipsnet.client.constants.IntentConstants;
import smile.cti.client.ClientConnector;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionEventListener;
import smile.cti.client.SessionInfo;

public class SessionListener
implements SessionEventListener {
    String TAG = "SessionListener";
    private final ClientListenersModel clientListenersModel;

    public SessionListener(ClientListenersModel clientListenersModel) {
        this.clientListenersModel = clientListenersModel;
    }

    public void sessionEvent(int event, SessionInfo sessionInfo) {
        if (event == 2) {
            return;
        }
        if (event == 3) {
            ClientSingleton.getInstance().removeAvatar(sessionInfo.getSessionId());
            if (sessionInfo.hasAvatar()) {
                Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
                optionalClientConnector.ifPresent(clientConnector -> {
                    File file = clientConnector.getAvatar(sessionInfo);
                    if (file != null && file.exists()) {
                        ClientSingleton.getInstance().removeAvatar(sessionInfo.getSessionId());
                        if (ClientSingleton.getInstance().setAvatarImage(null, sessionInfo.getSessionId(), file, 32, 32, true)) {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("sessionInfo", sessionInfo);
                            data.put("event", event);
                            this.clientListenersModel.notifyMessage(IntentConstants.SESSION_IMAGE_LOAD, data);
                        }
                    }
                });
            }
        } else {
            ClientSingleton.getInstance().getMainViewModel().onSessionInfoEventReceived(sessionInfo, event);
        }
    }

    public void messagesLoaded(List<MessageInfo> messages, SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messagesLoaded sessionInfo=" + sessionInfo + " messages=" + messages.size());
        if (ClientSingleton.getInstance().getLastAction().contains(IntentConstants.MESSAGES_LOADED)) {
            ClientSingleton.getInstance().getMainViewModel().onMessagesLoaded(messages, sessionInfo, ClientSingleton.getInstance().getLastAction());
        } else {
            ClientSingleton.getInstance().getMainViewModel().onMessagesLoaded(messages, sessionInfo);
        }
    }

    public void messageReceived(MessageInfo messageInfo, SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messageReceived sessionInfo=" + sessionInfo + " messageInfo=" + messageInfo + " id=" + messageInfo.getId());
        if (messageInfo instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)messageInfo;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "messageReceived fileInfo = " + fileInfo + " fileInfo.isLoading()=" + fileInfo.isLoading() + " isLoaded() = " + fileInfo.isLoaded() + " hasFile() = " + fileInfo.hasFile());
        }
        ClientSingleton.getInstance().getMainViewModel().onMessageReceived(sessionInfo, messageInfo);
    }

    public void messageUpdated(MessageInfo messageInfo, SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messageUpdated sessionInfo=" + sessionInfo + " messageInfo=" + messageInfo);
        ClientSingleton.getInstance().getMainViewModel().onMessageUpdated(sessionInfo, messageInfo);
    }

    public void messageRemoved(MessageInfo messageInfo, SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messageRemoved sessionInfo=" + sessionInfo + " messageInfo=" + messageInfo);
        ClientSingleton.getInstance().getMainViewModel().onMessageRemoved(sessionInfo, messageInfo);
    }
}

