/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.observer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.observer.IGUIObserver;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.threadpool.NotificationThreadPoolManager;

public class ClientObserver
implements IGUIObservable,
IGUIObserver {
    private MyAction myAction = () -> {
        try {
            this.timerTick();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    };
    private int totalWork = 0;
    private Timer timer = new Timer(true);
    private TimerTask timerTask;
    private final Map<String, List<IGUIObservable>> observerObjects = new HashMap<String, List<IGUIObservable>>();
    private final ObservableList<Pair<IGUIObservable, Pair<String, Map<String, Object>>>> observableList = FXCollections.observableArrayList();
    private String name = "MyPeriodicScheduled";
    private long delay;
    private final AtomicBoolean lastNotificationReceive = new AtomicBoolean();

    private ClientObserver(String name) {
        this.name = this.name + name;
        ClientSingleton.toLog(this.getClass().getSimpleName(), name + " start");
    }

    public static ClientObserver getInstance(String name) {
        return new ClientObserver(name);
    }

    public void setMyAction(MyAction myAction) {
        this.myAction = myAction;
    }

    public ClientObserver startWithScheduled(int delay) {
        this.delay = delay;
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                if (ClientObserver.this.myAction != null) {
                    ClientObserver.this.myAction.execute();
                }
            }
        };
        this.timer.scheduleAtFixedRate(this.timerTask, 50L, (long)delay);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timerTick() throws Throwable {
        ObservableList<Pair<IGUIObservable, Pair<String, Map<String, Object>>>> observableList = this.observableList;
        synchronized (observableList) {
            ++this.totalWork;
            if (this.lastNotificationReceive.get()) {
                // empty if block
            }
            if (!this.observableList.isEmpty()) {
                try {
                    for (int i = this.observableList.size() - 1; i >= 0; --i) {
                        Pair pair = (Pair)this.observableList.remove(i);
                        if (pair == null) continue;
                        NotificationThreadPoolManager.getInstance().execute(() -> {
                            IGUIObservable iguiObservable = (IGUIObservable)pair.getKey();
                            Pair notPair = (Pair)pair.getValue();
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "NotificationThreadPoolManager : " + Thread.currentThread().getName() + " " + pair);
                            iguiObservable.onNotifiedMessage((String)notPair.getKey(), (Map)notPair.getValue());
                        });
                    }
                }
                catch (Exception ex) {
                    ClientSingleton.errorLog(this.getClass().getSimpleName(), ex);
                }
                this.lastNotificationReceive.set(false);
            }
        }
    }

    @Override
    public void registerObserver(IGUIObservable iGuiObserver, String action) {
        List list = this.observerObjects.computeIfAbsent(action, k -> new ArrayList());
        list.removeIf(iguiObservable -> iguiObservable.getClass().getSimpleName().equals(iGuiObserver.getClass().getSimpleName()));
        list.add(0, iGuiObserver);
    }

    @Override
    public void registerObserver(IGUIObservable iGuiObserver, String[] actions) {
        for (String action : actions) {
            this.registerObserver(iGuiObserver, action);
        }
    }

    @Override
    public void removeObserver(IGUIObservable iGuiObserver, String action) {
        List<IGUIObservable> list = this.observerObjects.get(action);
        if (list != null) {
            list.remove(iGuiObserver);
        }
    }

    @Override
    public void releaseAllObservers() {
        this.observerObjects.forEach((str, list) -> list.clear());
        this.observerObjects.clear();
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        if (ClientSingleton.getInstance().getMainViewModel().isSystemSleep()) {
            return;
        }
        this.restartTimer();
        this.onTik(action, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTik(String action, Map<String, Object> data) {
        ObservableList<Pair<IGUIObservable, Pair<String, Map<String, Object>>>> observableList = this.observableList;
        synchronized (observableList) {
            List<IGUIObservable> list = this.observerObjects.get(action);
            if (list == null) {
                return;
            }
            for (IGUIObservable iGuiObserver : list) {
                Pair pair = new Pair((Object)action, data);
                if (!this.observableList.stream().filter(iGuiObservablePair -> ((IGUIObservable)iGuiObservablePair.getKey()).equals(iGuiObserver)).map(Pair::getValue).noneMatch(stringMapPair -> stringMapPair.equals((Object)pair))) continue;
                this.observableList.add((Object)new Pair((Object)iGuiObserver, (Object)pair));
            }
            this.lastNotificationReceive.set(true);
        }
    }

    public synchronized void restartTimer() {
        if (this.lastNotificationReceive.get() && System.currentTimeMillis() - this.timerTask.scheduledExecutionTime() > this.delay * 3L) {
            this.timerTask.cancel();
            this.timer.cancel();
            this.timer.purge();
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (ClientObserver.this.myAction != null) {
                        ClientObserver.this.myAction.execute();
                    }
                }
            };
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate(this.timerTask, 50L, this.delay);
        }
    }

    public void shutDown() {
        this.timerTask.cancel();
        this.timer.cancel();
        this.timer.purge();
    }

    public void checkForRunning() {
        this.restartTimer();
    }

    public String toString() {
        return Thread.currentThread().getName() + " : " + this.name;
    }
}

