/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.theme;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;

public class Theme {
    private static Theme themeClass;
    public static int WITHOUT_EXTRA_COLOR;
    public static int WHITE_EXTRA_COLOR;
    public static int RED_EXTRA_COLOR;
    public static int ALERT_TEXT_AREA;
    public static int INCOMING_TEXT_AREA;
    public static int OUTGOING_TEXT_AREA;
    public static int REPLY_TEXT_AREA;
    public static int COMMENT_TEXT_AREA;
    public static int WHITE_TEXT_AREA;
    public static int PROFILE_TEXT_AREA;
    public static int CALL_LINE_BACKGROUND;
    public static int CALL_CHAT_LINE_BACKGROUND;
    public static int CALL_PANE_HOLD_BACKGROUND;
    public static int CALL_NOTIFICATION_BACKGROUND;
    public static int CALL_TRANSFER_BACKGROUND;
    public static int NOTIFICATION_BACKGROUND;
    public static int WITH_BASE_COLOR;
    public static int WITH_SECOND_BASE_COLOR;
    private String CURRENT_TEMPLATE = "";
    private String CSS_TEMPLATE;
    private String CSS_SLIDER_BAR;
    private String CSS_PROGRESS_BAR;
    private String CSS_VIRTUALIZED_SCROLL;
    private String CSS_SCROLL_PANE;
    private String CSS_CONTEXT_MENU;
    private String CSS_ALERT_TEXT_AREA;
    private String CSS_TEXT_AREA;
    private String CSS_PROFILES_PANE;
    private String CSS_KEY_TEMPLATE;
    private String CSS_NOTIFICATION_BACKGROUND;
    private final String CSS_LOGIN_LABELS_TEXT_FILL = "-fx-text-fill: %s;-fx-font-family: \"Arial\";-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-background-color: transparent;";
    private final String CSS_CHAT_MESSAGES_TEXT_FILL = "-fx-text-fill: %s;-fx-font-family: \"Arial\";-fx-font-size: 11pt;-fx-line-height: 1.19;-fx-background-color: transparent;";
    private final String CSS_CHAT_HEADER_TEXT_FILL = "-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";";
    private final String CSS_CHAT_PLAYER_TEXT_FILL = "-fx-text-fill: %s;-fx-font-family: \"Arial\";-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-background-color: transparent;";
    private final String CSS_TAB_CELL_TEXT_FILL = "-fx-font-size: 11pt;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";";
    private final String CSS_SUBJECTS_TEXT_FILL = "-fx-font-size: 11px;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";";
    private final String CSS_TAB_SELECTED_CELL = "-fx-background-color: %s; -fx-border-radius: 15 15 15 15;-fx-background-radius: 15 15 15 15;";
    private final String CSS_TAB_SELECTED_CELL_SEARCH = "-fx-background-color: %s;-fx-padding:2 2 2 2;-fx-border-radius: 10 10 10 10;-fx-background-radius: 10 10 10 10;-fx-cursor:hand";
    private final String CSS_TAB_CELL_DATE_TEXT_FILL = "-fx-font-size: 8pt;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";";
    private final String CSS_TAB_TITLE_TEXT_FILL = "-fx-text-fill: %s;-fx-font-size: 16px;-fx-font-weight: bold;-fx-font-family: \"Arial\";";
    private final String CSS_CALLS_DATE_TEXT_FILL = "-fx-background-color:%s; -fx-text-fill: %s; -fx-font-family: \"Arial\";-fx-font-size: 11px;-fx-line-height: 1.19;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;";
    private final String CSS_LOGIN_BUTTON = "-fx-background-color:%s;-fx-text-fill: %s;-fx-border-radius: 16;-fx-background-radius: 16;-fx-background-insets: 0,1,2,3,0;-fx-font-family: \"Arial\";-fx-font-size: 14px;";
    private final String CSS_TEXT_FILL_TEMPLATE = "-fx-text-fill:%s;-fx-prompt-text-fill: #989898;-fx-padding:  0;-fx-border-insets:  0;-fx-background-insets: 0;-fx-background-color:transparent;-fx-border-width: 0 0 0 0;-fx-border-color: transparent;";
    private final String CSS_BACKGROUND_TEMPLATE = "-fx-background-color:%s;";
    private final String CSS_PROGRESS_TEMPLATE = "-fx-progress-color:%s;";
    private final String CSS_POPUP_WINDOWS = "-fx-background-color:%s;-fx-border-radius: 13 13 13 13;-fx-background-radius: 13 13 13 13;-fx-background-insets: 4 4 4 4;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.23), 8, 0, 0, 8);";
    private final String CSS_CHAT_TOP_AND_BOTTOM = "-fx-background-color: %s;-fx-border-radius: 13 13 13 13;-fx-background-radius: 13 13 13 13;";
    private final String CSS_ROUNDED_PANE_BACKGROUND = "-fx-text-box-border: transparent;-fx-border-radius: 13;-fx-background-radius: 13;-fx-padding: 0;-fx-background-insets: 0;-fx-background-color: transparent, %s, transparent, %s;";
    private final String CSS_CALL_PANE_BACKGROUND = "-fx-background-color: %s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;";
    private final String CSS_CALL_NOTIFICATION_BACKGROUND = "-fx-background-color:%s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);";
    private final String CSS_CHAT_REPLY_MESSAGE_BACKGROUND = "-fx-background-color: %s;-fx-padding: 0;-fx-background-insets: 0;-fx-border-radius: 0 10 10 10;-fx-background-radius: 0 10 10 10";
    private final ObjectProperty<ThemeType> theme = new SimpleObjectProperty((Object)ThemeType.LIGHT);

    public boolean isDarkTheme() {
        return this.getTheme() == ThemeType.DARK;
    }

    private Theme() {
    }

    public static Theme getInstance() {
        if (themeClass == null) {
            themeClass = new Theme();
        }
        return themeClass;
    }

    public void setCSS_TEMPLATE(String CSS_TEMPLATE) {
        this.CSS_TEMPLATE = CSS_TEMPLATE;
    }

    public void setCSS_SLIDER_BAR(String CSS_SLIDER_BAR) {
        this.CSS_SLIDER_BAR = CSS_SLIDER_BAR;
    }

    public void setCSS_PROGRESS_BAR(String CSS_PROGRESS_BAR) {
        this.CSS_PROGRESS_BAR = CSS_PROGRESS_BAR;
    }

    public void setCSS_VIRTUALIZED_SCROLL(String CSS_VIRTUALIZED_SCROLL) {
        this.CSS_VIRTUALIZED_SCROLL = CSS_VIRTUALIZED_SCROLL;
    }

    public void setCSS_SCROLL_PANE(String CSS_SCROLL_PANE) {
        this.CSS_SCROLL_PANE = CSS_SCROLL_PANE;
    }

    public void setCSS_CONTEXT_MENU(String CSS_CONTEXT_MENU) {
        this.CSS_CONTEXT_MENU = CSS_CONTEXT_MENU;
    }

    public void setCSS_ALERT_TEXT_AREA(String CSS_ALERT_TEXT_AREA) {
        this.CSS_ALERT_TEXT_AREA = CSS_ALERT_TEXT_AREA;
    }

    public void setCSS_TEXT_AREA(String CSS_TEXT_AREA) {
        this.CSS_TEXT_AREA = CSS_TEXT_AREA;
    }

    public void setCSS_PROFILES_PANE(String CSS_PROFILES_PANE) {
        this.CSS_PROFILES_PANE = CSS_PROFILES_PANE;
    }

    public void setCSS_KEY_TEMPLATE(String CSS_KEY_TEMPLATE) {
        this.CSS_KEY_TEMPLATE = CSS_KEY_TEMPLATE;
    }

    public void setCSS_NOTIFICATION_BACKGROUND(String CSS_NOTIFICATION_BACKGROUND) {
        this.CSS_NOTIFICATION_BACKGROUND = CSS_NOTIFICATION_BACKGROUND;
    }

    public ThemeType getTheme() {
        return (ThemeType)((Object)this.theme.get());
    }

    public ObjectProperty<ThemeType> themeProperty() {
        return this.theme;
    }

    public Theme setTheme(ThemeType theme) {
        this.theme.set((Object)theme);
        return themeClass;
    }

    public void applyTo(Scene scene) {
        scene.getStylesheets().removeAll((Object[])new String[]{this.CURRENT_TEMPLATE});
        String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.BASE_COLOR);
        this.CURRENT_TEMPLATE = this.formatedString(this.CSS_TEMPLATE, color, color);
        this.addStylesheets(scene, this.CURRENT_TEMPLATE);
    }

    public void applyTo(String key, Scene scene) {
        if (key.equals(Constants.POPUP_WINDOWS_BACKGROUND)) {
            scene.getStylesheets().clear();
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            String css = this.formatedString(this.CSS_TEMPLATE, color, color);
            this.addStylesheets(scene, css);
        } else if (key.equals(Constants.CALL_NOTIFICATION_STYLE)) {
            scene.getStylesheets().clear();
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            String css = this.formatedString(this.CSS_TEMPLATE, color, color);
            this.addStylesheets(scene, css);
        }
    }

    public void applyProfilesPaneTo(Pane pane) {
        String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.PROFILES_PANE_BACKGROUND);
        String css = this.formatedString(this.CSS_PROFILES_PANE, color);
        this.addStylesheets(pane, css);
    }

    public void applyTabCellTo(Pane pane, boolean isSelected) {
        this.applyTabCellTo(pane, isSelected, true);
    }

    public void applyTabCellTo(Pane pane, boolean isSelected, boolean isTabsCell) {
        String color = isSelected ? ClientSingleton.getInstance().getStyleValue(this.getTheme(), isTabsCell ? Constants.TABS_SELECTED_CELL : Constants.CONTACT_SELECTED_CELL) : "transparent";
        String css = this.formatedString("-fx-background-color: %s; -fx-border-radius: 15 15 15 15;-fx-background-radius: 15 15 15 15;", color);
        pane.setStyle(css);
    }

    public void applyTabCellTo(Region region, boolean isSelected) {
        String color = isSelected ? ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TABS_SELECTED_CELL) : "transparent";
        String css = this.formatedString("-fx-background-color: %s;-fx-padding:2 2 2 2;-fx-border-radius: 10 10 10 10;-fx-background-radius: 10 10 10 10;-fx-cursor:hand", color);
        region.setStyle(css);
    }

    public void applyTabTo(Pane pane, boolean isSelected) {
        String color = isSelected ? (this.isDarkTheme() ? "#1e1e1e" : "#424242") : "transparent";
        String css = this.formatedString("-fx-background-color: %s; -fx-border-radius: 15 15 15 15;-fx-background-radius: 15 15 15 15;", color);
        pane.setStyle(css);
    }

    public void applyReplyMessageTo(Pane pane, String color) {
        String css = this.formatedString("-fx-background-color: %s;-fx-padding: 0;-fx-background-insets: 0;-fx-border-radius: 0 10 10 10;-fx-background-radius: 0 10 10 10", color);
        pane.setStyle(css);
    }

    public void applyReplyMessageScrollTo(Pane pane, String color) {
        String color1 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_REPLY_MESSAGE_TEXT_FILL);
        String color2 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TAB_CELL_TEXT_FILL);
        String css = this.formatedString(this.CSS_VIRTUALIZED_SCROLL, color, color, color1, color, color2);
        this.addStylesheets(pane, css);
    }

    public void applyTo(String key, Pane pane) {
        if (key.equals(Constants.BASE_COLOR)) {
            pane.getStylesheets().removeAll((Object[])new String[]{this.CURRENT_TEMPLATE});
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.BASE_COLOR);
            this.CURRENT_TEMPLATE = this.formatedString(this.CSS_TEMPLATE, color, color);
            this.addStylesheets(pane, this.CURRENT_TEMPLATE);
        } else if (key.equals(Constants.CONTEXT_MENU)) {
            String css = this.getContextMenuClass();
            this.addStylesheets(pane, css);
        } else if (key.equals(Constants.POPUP_WINDOWS_BACKGROUND) || key.equals(Constants.LOGIN_BACKGROUND_STYLE)) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            String css = this.formatedString("-fx-background-color:%s;-fx-border-radius: 13 13 13 13;-fx-background-radius: 13 13 13 13;-fx-background-insets: 4 4 4 4;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.23), 8, 0, 0, 8);", color);
            pane.setStyle(css);
        } else if (key.equals(Constants.TABS_VIRTUALIZED_SCROLL) || key.equals(Constants.PROFILE_VIRTUALIZED_SCROLL) || key.equals(Constants.REPLY_VIRTUALIZED_SCROLL)) {
            pane.getStylesheets().clear();
            String color = "";
            color = key.equals(Constants.TABS_VIRTUALIZED_SCROLL) ? ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.BASE_COLOR) : (key.equals(Constants.PROFILE_VIRTUALIZED_SCROLL) ? ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.SECOND_BASE_COLOR) : ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_REPLY_MESSAGE_BACKGROUND));
            String color1 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TAB_CELL_TEXT_FILL);
            String css = this.formatedString(this.CSS_VIRTUALIZED_SCROLL, color, color, color1, color, color1);
            this.addStylesheets(pane, css);
        } else if (key.equals(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND)) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            String css = this.formatedString("-fx-background-color: %s;-fx-border-radius: 13 13 13 13;-fx-background-radius: 13 13 13 13;", color);
            pane.setStyle(css);
        } else if (key.equals(Constants.CHAT_REPLY_MESSAGE_BACKGROUND)) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            String css = this.formatedString("-fx-background-color: %s;-fx-padding: 0;-fx-background-insets: 0;-fx-border-radius: 0 10 10 10;-fx-background-radius: 0 10 10 10", color);
            pane.setStyle(css);
        } else if (key.equals(Constants.TABS_SEARCH_BACKGROUND) || key.equals(Constants.SELECTED_LINE_STYLE)) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            String css = this.formatedString("-fx-background-color:%s;", color);
            pane.setStyle(css);
        } else {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            String css = this.formatedString(this.CSS_KEY_TEMPLATE, key, color, color);
            this.addStylesheets(pane, css);
            pane.getStyleClass().add((Object)key);
        }
    }

    private String getContextMenuClass() {
        return this.getContextMenuClass(false);
    }

    private String getContextMenuClass(boolean isBaseColor) {
        String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), isBaseColor ? Constants.BASE_COLOR : Constants.SECOND_BASE_COLOR);
        String color1 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TABS_TITLE_TEXT_FILL);
        String color2 = this.isDarkTheme() ? "#595959" : "#d9e0ef";
        return this.formatedString(this.CSS_CONTEXT_MENU, color, color1, color1, color2, color2);
    }

    public void applyTo(String key, Pane pane, boolean isBaseColor) {
        String css = "";
        if (key.equals(Constants.CONTEXT_MENU)) {
            pane.getStylesheets().clear();
            css = this.getContextMenuClass(isBaseColor);
            this.addStylesheets(pane, css);
        }
    }

    public void applyTo(String key, Control control) {
        this.applyTo(key, control, null);
    }

    public void applyTo(String key, Control control, String color) {
        String css = "";
        if (color == null) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
        }
        if (key.equals(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL)) {
            css = this.formatedString("-fx-text-fill:%s;-fx-prompt-text-fill: #989898;-fx-padding:  0;-fx-border-insets:  0;-fx-background-insets: 0;-fx-background-color:transparent;-fx-border-width: 0 0 0 0;-fx-border-color: transparent;", color);
            control.setStyle(css);
        } else if (key.equals(Constants.TAB_CELL_TEXT_FILL)) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TAB_CELL_TEXT_FILL);
            css = this.formatedString("-fx-text-fill:%s;-fx-prompt-text-fill: #989898;-fx-padding:  0;-fx-border-insets:  0;-fx-background-insets: 0;-fx-background-color:transparent;-fx-border-width: 0 0 0 0;-fx-border-color: transparent;", color);
            control.setStyle(css);
        } else if (key.equals(Constants.SCROLL_PANE_STYLE) || key.equals(Constants.SCROLL_PANE_SECOND_STYLE)) {
            if (color == null) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key.equals(Constants.SCROLL_PANE_STYLE) ? Constants.BASE_COLOR : Constants.PROFILES_PANE_BACKGROUND);
            }
            String color2 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TAB_CELL_TEXT_FILL);
            css = this.formatedString(this.CSS_SCROLL_PANE, color, color2, color, color2, color, color, color);
            this.addStylesheets(control, css);
        } else if (key.equals(Constants.CONTEXT_MENU)) {
            css = this.getContextMenuClass();
            this.addStylesheets(control, css);
        } else if (key.equals(Constants.PROGRESS_BAR_STYLE)) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.PROGRESS_INDICATOR_STYLE);
            css = this.formatedString(this.CSS_PROGRESS_BAR, color, color, color);
            this.addStylesheets(control, css);
        } else if (key.equals(Constants.SLIDER_BAR_STYLE)) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.PROGRESS_INDICATOR_STYLE);
            css = this.formatedString(this.CSS_SLIDER_BAR, color);
            this.addStylesheets(control, css);
        } else {
            css = key.equals(Constants.PROGRESS_INDICATOR_STYLE) ? this.formatedString("-fx-progress-color:%s;", color) : this.formatedString("-fx-background-color:%s;", color);
            control.setStyle(css);
        }
    }

    public void applyTo(String key, ImageButton imageButton) {
        if (key.equals(Constants.CONTEXT_MENU)) {
            String css = this.getContextMenuClass();
            this.addStylesheets((Pane)imageButton, css);
        } else {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            imageButton.setBackgroundColor(color);
        }
    }

    public void applyTo(String key, Labeled label) {
        this.applyTo(key, label, WITHOUT_EXTRA_COLOR);
    }

    public void applyTo(String key, Labeled label, String color) {
        String css = "";
        if (key.equals(Constants.CHAT_DATE_LABEL_STYLE)) {
            String color1 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_DATE_LABEL_TEXT_FILL);
            css = this.formatedString("-fx-background-color:%s; -fx-text-fill: %s; -fx-font-family: \"Arial\";-fx-font-size: 11px;-fx-line-height: 1.19;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;", color, color1);
        }
        label.setStyle(css);
    }

    public void applyTo(String key, Labeled label, int extraColor) {
        String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
        if (extraColor == WHITE_EXTRA_COLOR) {
            color = "#ffffff";
        } else if (extraColor == RED_EXTRA_COLOR) {
            color = "#e65d5d";
        }
        String css = "";
        if (key.equals(Constants.TAB_CELL_TEXT_FILL)) {
            css = this.formatedString("-fx-font-size: 11pt;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";", color);
        } else if (key.equals(Constants.CHAT_CELL_HEADER_TEXT_FILL)) {
            css = this.formatedString("-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";", color);
        } else if (key.equals(Constants.TAB_CELL_DATE_TEXT_FILL)) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), extraColor != WITHOUT_EXTRA_COLOR ? color : Constants.TAB_CELL_TEXT_FILL);
            css = this.formatedString("-fx-font-size: 8pt;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";", color);
        } else if (key.equals(Constants.TABS_TITLE_TEXT_FILL)) {
            css = this.formatedString("-fx-text-fill: %s;-fx-font-size: 16px;-fx-font-weight: bold;-fx-font-family: \"Arial\";", color);
        } else if (key.equals(Constants.CHAT_DATE_LABEL_STYLE)) {
            String color1 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_DATE_LABEL_TEXT_FILL);
            css = this.formatedString("-fx-background-color:%s; -fx-text-fill: %s; -fx-font-family: \"Arial\";-fx-font-size: 11px;-fx-line-height: 1.19;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;", color, color1);
        } else if (key.equals(Constants.LOGIN_LABEL_TEXT_FILL)) {
            css = this.formatedString("-fx-text-fill: %s;-fx-font-family: \"Arial\";-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-background-color: transparent;", color);
        } else if (key.equals(Constants.LOGIN_BUTTON_BACKGROUND_STYLE)) {
            String color1 = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.LOGIN_BUTTON_TEXT_FILL);
            css = this.formatedString("-fx-background-color:%s;-fx-text-fill: %s;-fx-border-radius: 16;-fx-background-radius: 16;-fx-background-insets: 0,1,2,3,0;-fx-font-family: \"Arial\";-fx-font-size: 14px;", color, color1);
        } else if (key.equals(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL)) {
            css = this.formatedString("-fx-text-fill:%s;-fx-prompt-text-fill: #989898;-fx-padding:  0;-fx-border-insets:  0;-fx-background-insets: 0;-fx-background-color:transparent;-fx-border-width: 0 0 0 0;-fx-border-color: transparent;", color);
        } else if (key.equals(Constants.CHAT_MESSAGE_TEXT_FILL)) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TAB_CELL_TEXT_FILL);
            css = this.formatedString("-fx-text-fill: %s;-fx-font-family: \"Arial\";-fx-font-size: 11pt;-fx-line-height: 1.19;-fx-background-color: transparent;", color);
        } else if (key.equals(Constants.CHAT_PLAYER_TEXT_FIELD)) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TAB_CELL_TEXT_FILL);
            css = this.formatedString("-fx-text-fill: %s;-fx-font-family: \"Arial\";-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-background-color: transparent;", color);
        } else if (key.equals(Constants.SUBJECT_TEXT_FILL)) {
            if (extraColor != WHITE_EXTRA_COLOR && extraColor != RED_EXTRA_COLOR) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
            }
            css = this.formatedString("-fx-font-size: 11px;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";", color);
        } else {
            css = this.formatedString("-fx-background-color:%s;", color);
        }
        label.setStyle(css);
    }

    public void applyTo(String key, Text label) {
        this.applyTo(key, label, WITHOUT_EXTRA_COLOR);
    }

    public void applyTo(String key, Text label, int extraColor) {
        String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), key);
        if (extraColor == WHITE_EXTRA_COLOR) {
            color = "#ffffff";
        } else if (extraColor == RED_EXTRA_COLOR) {
            color = "#e65d5d";
        }
        String css = "";
        css = this.formatedString("-fx-font-size: 11pt;-fx-line-height: 1.19;-fx-text-fill: %s;-fx-font-family: \"Arial\";", color);
        label.setStyle(css);
    }

    public void applyTextAreaTo(int themeTextAreaType, TextArea textArea) {
        String color = "";
        String textFill = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.TAB_CELL_TEXT_FILL);
        String css = "";
        if (themeTextAreaType == ALERT_TEXT_AREA) {
            color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.POPUP_WINDOWS_BACKGROUND);
            css = this.formatedString(this.CSS_ALERT_TEXT_AREA, textFill, color, color, color, color, color, color, textFill);
        } else {
            if (themeTextAreaType == INCOMING_TEXT_AREA) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_INCOMING_MESSAGE_BACKGROUND);
            } else if (themeTextAreaType == OUTGOING_TEXT_AREA) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_OUTGOING_MESSAGE_BACKGROUND);
            } else if (themeTextAreaType == REPLY_TEXT_AREA) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_REPLY_MESSAGE_BACKGROUND);
            } else if (themeTextAreaType == COMMENT_TEXT_AREA) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CHAT_COMMENT_MESSAGE_BACKGROUND);
                textFill = this.getCommentTextFill(true);
            } else if (themeTextAreaType == WHITE_TEXT_AREA) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.BASE_COLOR);
            } else if (themeTextAreaType == PROFILE_TEXT_AREA) {
                color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.SECOND_BASE_COLOR);
            }
            css = this.formatedString(this.CSS_TEXT_AREA, textFill, color, color, color, color, textFill, color, color);
        }
        textArea.getStylesheets().clear();
        this.addStylesheets((Control)textArea, css);
    }

    public void applyCallPaneTo(int mode, Pane pane) {
        String css = "";
        if (mode == CALL_LINE_BACKGROUND) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CALL_LINE_STYLE);
            css = this.formatedString("-fx-background-color: %s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;", color);
        } else if (mode == CALL_CHAT_LINE_BACKGROUND) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CALL_CHAT_LINE_STYLE);
            css = this.formatedString("-fx-background-color: %s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;", color);
        } else if (mode == CALL_PANE_HOLD_BACKGROUND) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CALL_HOLD_STYLE);
            css = this.formatedString("-fx-background-color: %s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;", color);
        } else if (mode == CALL_NOTIFICATION_BACKGROUND) {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CALL_NOTIFICATION_STYLE);
            css = this.formatedString("-fx-background-color:%s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);", color);
        } else {
            String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.CALL_TRANSFER_STYLE);
            css = this.formatedString("-fx-background-color:%s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);", color);
        }
        pane.setStyle(css);
    }

    public void applyNotificationPaneTo(Pane pane) {
        String color = ClientSingleton.getInstance().getStyleValue(this.getTheme(), Constants.NOTIFICATION_STYLE);
        String css = this.formatedString(this.CSS_NOTIFICATION_BACKGROUND, color, MyStyledTextArea.getFontColor());
        pane.getStylesheets().clear();
        this.addStylesheets(pane, css);
        pane.getStyleClass().add((Object)"root");
    }

    public void applyRoundedBackgroundTo(int colorMode, Pane pane) {
        String color = "";
        if (colorMode == WITH_BASE_COLOR) {
            color = ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR);
        } else if (colorMode == WITH_SECOND_BASE_COLOR) {
            color = ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR);
        }
        pane.setStyle(this.formatedString("-fx-text-box-border: transparent;-fx-border-radius: 13;-fx-background-radius: 13;-fx-padding: 0;-fx-background-insets: 0;-fx-background-color: transparent, %s, transparent, %s;", color, color));
    }

    public String getCommentTextFill(boolean isComment) {
        String color = isComment ? (Theme.getInstance().isDarkTheme() ? "#1e1e1e" : "#252b40") : MyStyledTextArea.getFontColor();
        return color;
    }

    public String formatedString(String target, String ... values) {
        return String.format(target, values);
    }

    public void addStylesheets(Scene scene, String css) {
        if (!ClientSingleton.getInstance().isJavaVersion11()) {
            scene.getStylesheets().add((Object)css);
        } else {
            this.writeTmpCss(scene, css);
        }
    }

    public void addStylesheets(Pane pane, String css) {
        if (!ClientSingleton.getInstance().isJavaVersion11()) {
            pane.getStylesheets().add((Object)css);
        } else {
            this.writeTmpCss(pane, css);
        }
    }

    public void addStylesheets(Control control, String css) {
        if (!ClientSingleton.getInstance().isJavaVersion11()) {
            control.getStylesheets().add((Object)css);
        } else {
            this.writeTmpCss(control, css);
        }
    }

    private void writeTmpCss(Scene previewPane, String css) {
        try {
            Path cssPath = Theme.getPath(css);
            previewPane.getStylesheets().removeIf(path -> path.startsWith("fx-theme-"));
            previewPane.getStylesheets().add((Object)cssPath.toUri().toURL().toExternalForm());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeTmpCss(Pane previewPane, String css) {
        try {
            Path cssPath = Theme.getPath(css);
            previewPane.getStylesheets().removeIf(path -> path.startsWith("fx-theme-"));
            previewPane.getStylesheets().add((Object)cssPath.toUri().toURL().toExternalForm());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeTmpCss(Control previewPane, String css) {
        try {
            Path cssPath = Theme.getPath(css);
            previewPane.getStylesheets().removeIf(path -> path.startsWith("fx-theme-"));
            previewPane.getStylesheets().add((Object)cssPath.toUri().toURL().toExternalForm());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Path getPath(String css) throws IOException {
        Path cssPath = Files.createTempFile("fx-theme-", ".css", new FileAttribute[0]);
        Files.writeString(cssPath, (CharSequence)css, new OpenOption[0]);
        cssPath.toFile().deleteOnExit();
        return cssPath;
    }

    static {
        WITHOUT_EXTRA_COLOR = -1;
        WHITE_EXTRA_COLOR = 0;
        RED_EXTRA_COLOR = 1;
        ALERT_TEXT_AREA = 2;
        INCOMING_TEXT_AREA = 3;
        OUTGOING_TEXT_AREA = 4;
        REPLY_TEXT_AREA = 5;
        COMMENT_TEXT_AREA = 6;
        WHITE_TEXT_AREA = 7;
        PROFILE_TEXT_AREA = 8;
        CALL_LINE_BACKGROUND = 9;
        CALL_CHAT_LINE_BACKGROUND = 10;
        CALL_PANE_HOLD_BACKGROUND = 11;
        CALL_NOTIFICATION_BACKGROUND = 12;
        CALL_TRANSFER_BACKGROUND = 13;
        NOTIFICATION_BACKGROUND = 14;
        WITH_BASE_COLOR = 15;
        WITH_SECOND_BASE_COLOR = 16;
    }

    public static enum ThemeType {
        LIGHT,
        DARK;

    }
}

