/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.utils;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.Chronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextInputDialog;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.utils.viewers.phonesmenu.MyPhonesMenu;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.utils.viewers.trunksmenu.MyTrunksMenu;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.contactslist.ContactsMultiColumnList;
import net.sipsnet.client.views.servicescontacts.ServicesContactsController;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.reactfx.value.Var;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class ClientUtil {
    private final List<String> services = Arrays.asList("zoho", "dynamics", "bitrix24", "azure", "google", "microsoft", "office365", "zendesk", "hubspot");
    private static final String[] THUMBNAILS_IMAGE_SUFFIXES = new String[]{"png.jpg", "gif.jpg", "jpg.jpg", "jpeg.jpg", "bmp.jpg", "ico.jpg", "cur.jpg", "xbm.jpg"};
    private static final String TAG_LOG = "ClientUtil";
    public static int WEB_TITLE = 0;
    public static int WEB_DESCRIPTION = 1;
    public static int WEB_IMAGE = 2;
    public static int WEB_DATA_SIZE = 3;
    public static String dayMessageFormat = "yyyy.MM.dd";
    private final SimpleDateFormat[] checkedDateFormats = new SimpleDateFormat[]{new SimpleDateFormat("d"), new SimpleDateFormat("yyyy"), new SimpleDateFormat(dayMessageFormat)};
    private final Map<String, Map<String, Object>> linkMessages = new HashMap<String, Map<String, Object>>();
    private ContactsMultiColumnList contactsMultiColumnList;
    private ContactsMultiColumnList transferMultiColumnList;
    private ContactsMultiColumnList shareMessageMultiColumnList;
    String[] extend = new String[]{"3ds.png", "3gp.png", "7z.png", "aac.png", "abc.png", "ai.png", "aif.png", "apk.png", "avi.png", "bat.png", "bmp.png", "c.png", "c4d.png", "c4d@2x.png", "cda.png", "cdr.png", "cgi.png", "class.png", "cpp.png", "css.png", "csv.png", "db.png", "dbf.png", "dmg.png", "doc.png", "docx.png", "dxf.png", "dxv.png", "eps.png", "exe.png", "fbx.png", "flac.png", "flv.png", "gif.png", "h.png", "hip.png", "html.png", "ico.png", "img.png", "ipa.png", "iso.png", "jar.png", "java.png", "jpg.png", "js.png", "json.png", "log.png", "m.png", "m4v.png", "m4v@2x.png", "a.png", "max.png", "mb.png", "mdb.png", "mdx.png", "midi.png", "mkv.png", "mov.png", "mp3.png", "mp4.png", "mpa.png", "mpg.png", "msi.png", "nrg.png", "obj.png", "odt.png", "ogg.png", "otf.png", "pages.png", "pdf.png", "php.png", ".png", "psd.png", "py.png", "rar.png", "raw.png", "rb.png", "rpm.png", "rtf.png", "sh.png", "sketch.png", "sql.png", "svg.png", "swf.png", "swift.png", "tar.png", "tga.png", "tiff.png", "ttf.png", "txt.png", "unknown.png", "vcd.png", "wav.png", "wma.png", "wmv.png", "xls.png", "xlsx.png", "xml.png", "zip.png"};
    private static OS os = null;

    public <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    public String getTimeDuration(long duration) {
        int minutes = (int)Math.floor(duration / 1000L / 60L);
        int seconds = (int)(duration / 1000L - (long)minutes * 60L);
        return (minutes < 10 ? "0" : "") + minutes + ":" + String.format("%02d", seconds);
    }

    public String getDateWMonthString(long time) {
        try {
            return this.checkedDateFormats[2].format(time);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public String getDateMarker(String value) {
        String[] split = value.split("\\.");
        LocalDateTime localDateTime = LocalDateTime.of(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]), 0, 0);
        long timeInMillis = localDateTime.atZone(ZoneId.systemDefault()).toEpochSecond() * 1000L;
        String yyyy = this.checkedDateFormats[1].format(timeInMillis);
        String month = new SimpleDateFormat("MMMM").format(timeInMillis);
        if (!yyyy.equals(this.checkedDateFormats[1].format(System.currentTimeMillis()))) {
            return this.checkedDateFormats[0].format(timeInMillis) + " " + month.substring(0, 3) + " " + yyyy;
        }
        return this.checkedDateFormats[0].format(timeInMillis) + " " + month.substring(0, 3);
    }

    public String getDateLabel(long time) {
        return this.getZonedDateTime(time).format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
    }

    private ZonedDateTime getZonedDateTime(long time) {
        Instant instant = Instant.ofEpochSecond(time / 1000L);
        return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    private boolean isToDate(ZonedDateTime zonedDateTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("dd.MM");
        String current = LocalDate.now().format(dtf);
        String dateTime = zonedDateTime.format(dtf);
        return dateTime.startsWith(current);
    }

    public String getTimeLabel(long time) {
        if (this.is24HourLocale()) {
            return new SimpleDateFormat("HH:mm", Locale.getDefault()).format(new Date(time)) + " ";
        }
        return new SimpleDateFormat("hh:mm a", Locale.getDefault()).format(new Date(time)) + " ";
    }

    public String getDateTimeString(long time) {
        Instant instant = Instant.ofEpochSecond(time / 1000L);
        Date date = new Date(time);
        Date date1 = new Date(System.currentTimeMillis());
        if (date.getDate() == date1.getDate() && date.getMonth() == date1.getMonth() && date.getYear() == date1.getYear()) {
            return this.getTimeLabel(time);
        }
        Format format = this.createMonthDayFormat(FormatStyle.SHORT, null, Locale.getDefault(), date.getYear() != date1.getYear());
        return this.getTimeLabel(time) + " " + format.format(date.toInstant().atZone(ZoneId.systemDefault()));
    }

    private Format createMonthDayFormat(FormatStyle dateStyle, FormatStyle timeStyle, Locale locale, boolean isWithYear) {
        String pattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(dateStyle, timeStyle, Chronology.ofLocale(locale), locale);
        if (isWithYear) {
            pattern = pattern.replaceFirst("\\P{IsLetter}+[Yy]+[,]+", "");
            pattern = pattern.replaceFirst("^[Yy]+\\P{IsLetter}+[,]+", "");
        } else {
            pattern = pattern.replaceAll("((' de ')|[^dM]*)y[^dM]*", "");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
        return formatter.toFormat();
    }

    private boolean is24HourLocale() {
        boolean is24Hour;
        DateFormat natural = DateFormat.getTimeInstance(1, Locale.getDefault());
        if (natural instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)natural;
            String pattern = sdf.toPattern();
            is24Hour = this.hasDesignator(pattern, 'H');
        } else {
            is24Hour = false;
        }
        return is24Hour;
    }

    private boolean hasDesignator(CharSequence inFormat, char designator) {
        if (inFormat == null) {
            return false;
        }
        int length = inFormat.length();
        boolean insideQuote = false;
        for (int i = 0; i < length; ++i) {
            char c = inFormat.charAt(i);
            if (c == '\'') {
                insideQuote = !insideQuote;
                continue;
            }
            if (insideQuote || c != designator) continue;
            return true;
        }
        return false;
    }

    public void setArrowImage(ImageView imageView, MessageInfo lastMessage) {
        String path = this.getArrowPngName(lastMessage);
        ClientSingleton.getInstance().setCachedImage(imageView, path);
    }

    private String getArrowPngName(MessageInfo lastMessage) {
        if (lastMessage == null) {
            return "";
        }
        String arrow = "";
        arrow = lastMessage.getType() == 8 ? (lastMessage.getStatus() == 12 || lastMessage.getStatus() != 6 && lastMessage.getCallDuration() == 0 ? "arrow_missed.png" : (lastMessage.getStatus() == 6 || MessageInfoCellLabels.isMyMessage(lastMessage) ? "arrow_out.png" : "arrow_inc.png")) : (lastMessage.getStatus() == -1 || lastMessage.getStatus() == 0 || lastMessage.getStatus() == 3 || lastMessage.getStatus() == 4 ? "arrow_out.png" : "arrow_inc.png");
        return "tab/calls/" + arrow;
    }

    public void setStyledTextFont(Text text, boolean isHoovered, String color) {
        int size = 12;
        this.setStyledTextFont(text, isHoovered, color, size);
    }

    public void setStyledTextFont(Text text, boolean isHoovered, String color, int size) {
        boolean isLink = text.getText().contains("http:") || text.getText().contains("https:") || isHoovered;
        String style = "-fx-text-fill:" + color + ";-fx-font-family: \"Arial\";-fx-font-size: " + size + "pt;-fx-line-height: 1.19;-fx-background-color: red;";
        text.setFill((Paint)Color.web((String)color));
        text.setStyle(style);
        text.setUnderline(isLink);
    }

    public void setStyledTextFont(Text text, boolean isHoovered, String color, int size, boolean isLink) {
        String style = "-fx-text-fill:" + color + ";-fx-font-family: \"Arial\";-fx-font-size: " + size + "pt;-fx-line-height: 1.19;-fx-background-color: transparent;";
        text.setFill((Paint)Color.web((String)color));
        text.setStyle(style);
        text.setUnderline(isLink);
    }

    public void setStyledTextControl(Text text, boolean isBold, String color, int size, boolean isLink) {
        String style = "-fx-font-family: \"Arial\";-fx-font-size: " + size + "pt;";
        if (isBold) {
            style = style + "-fx-font-weight: bold";
        }
        text.setFill((Paint)Color.web((String)color));
        text.setStyle(style);
        text.setUnderline(isLink);
    }

    public void openWebBrowser(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                String[] surl = new String[]{"firefox", url};
                Runtime.getRuntime().exec(surl);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void openFile(File file) {
        this.openFile(file, false);
    }

    public void openFile(File file, boolean autodelete) {
        if (FileInfo.isExecutable((String)file.getName())) {
            return;
        }
        MyThreadPoolManager.getInstance().execute(() -> {
            try {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(file);
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "file=" + file.getAbsolutePath());
                        if (autodelete) {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            file.delete();
                        }
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                Runtime runProcess = Runtime.getRuntime();
                String[] url = new String[3];
                if (ClientUtil.getOS() == OS.WINDOWS) {
                    url[0] = "cmd";
                    url[1] = "/c";
                } else {
                    url[0] = "/bin/sh";
                    url[1] = "-c";
                }
                url[2] = "\"" + file.getAbsolutePath() + "\"";
                Process process = runProcess.exec(url);
                if (autodelete) {
                    process.waitFor();
                    file.delete();
                }
            }
            catch (Exception e) {
                if (autodelete && file != null) {
                    file.delete();
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Error opening file : " + e.getMessage());
                this.showAlert(ClientSingleton.getInstance().getString("open_file_error"));
            }
        });
    }

    private Optional<Element> getFirstElement(NodeList nodeList) {
        if (nodeList.getLength() > 0 && nodeList.item(0) instanceof Element) {
            return Optional.of((Element)nodeList.item(0));
        }
        return Optional.empty();
    }

    private void showNodeContent(org.w3c.dom.Node n, int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.print(" ");
        }
        System.out.println(n.getNodeName() + ":" + n.getNodeValue());
        NodeList children = n.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.showNodeContent(children.item(i), depth + 1);
        }
    }

    public void setMouseCursor(Node node) {
        node.setOnMouseExited(event -> ((Node)event.getSource()).setCursor(Cursor.DEFAULT));
        node.setOnMouseEntered(event -> ((Node)event.getSource()).setCursor(Cursor.HAND));
    }

    public void removeMouseCursor(Node node) {
        node.setOnMouseExited(null);
        node.setOnMouseEntered(null);
    }

    public Map<String, Object> getLinkData(String messageId) {
        HashMap<String, Object> data;
        if (this.linkMessages.containsKey(messageId)) {
            data = this.linkMessages.get(messageId);
        } else {
            data = new HashMap();
            this.linkMessages.put(messageId, data);
        }
        return data;
    }

    public void setLinkData(String messageId, Map<String, Object> map) {
        this.linkMessages.put(messageId, map);
    }

    public void removeLinkData(String messageId) {
        this.linkMessages.remove(messageId);
    }

    public void changeSize(Pane pane, double width, double height) {
        Duration cycleDuration = Duration.millis((double)500.0);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(cycleDuration, new KeyValue[]{new KeyValue((WritableValue)pane.maxWidthProperty(), (Object)width, Interpolator.EASE_BOTH)}), new KeyFrame(cycleDuration, new KeyValue[]{new KeyValue((WritableValue)pane.maxHeightProperty(), (Object)height, Interpolator.EASE_BOTH)})});
        timeline.play();
        timeline.setOnFinished(event -> {});
    }

    public void changeWidth(Control pane, double width) {
        Duration cycleDuration = Duration.millis((double)300.0);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(cycleDuration, new KeyValue[]{new KeyValue((WritableValue)pane.maxWidthProperty(), (Object)width, Interpolator.EASE_BOTH)}), new KeyFrame(cycleDuration, new KeyValue[]{new KeyValue((WritableValue)pane.prefWidthProperty(), (Object)width, Interpolator.EASE_BOTH)}), new KeyFrame(cycleDuration, new KeyValue[]{new KeyValue((WritableValue)pane.minWidthProperty(), (Object)width, Interpolator.EASE_BOTH)})});
        timeline.play();
        timeline.setOnFinished(event -> {});
    }

    public void changeHeight(Pane pane, double height) {
        Duration cycleDuration = Duration.millis((double)500.0);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(cycleDuration, new KeyValue[]{new KeyValue((WritableValue)pane.maxHeightProperty(), (Object)height, Interpolator.EASE_BOTH)})});
        timeline.play();
        timeline.setOnFinished(event -> pane.setMinHeight(height));
    }

    public void showAlert(String text) {
        this.showAlert(text, null, null);
    }

    public void showAlert(String text, String buttonTitle, EventHandler<MouseEvent> mouseEvent) {
        this.showAlert(text, buttonTitle, mouseEvent, false);
    }

    public void showAlert(String text, String buttonTitle, EventHandler<MouseEvent> mouseEvent, boolean isAutoClose) {
        this.showAlert("", text, buttonTitle, mouseEvent, isAutoClose);
    }

    public void showAlert(String title, String text, String buttonTitle, EventHandler<MouseEvent> mouseEvent, boolean isAutoClose) {
        ClientSingleton.getInstance().runLater(() -> this.callAlert(title, text, buttonTitle, mouseEvent, isAutoClose));
    }

    private void callAlert(String title, String text, String buttonTitle, EventHandler<MouseEvent> mouseEvent, boolean isAutoClose) {
        MyAlert myAlert = new MyAlert();
        myAlert.setTitle(title).setMessage(text).setAutoClose(isAutoClose);
        if (mouseEvent != null) {
            myAlert.addPositiveButton(buttonTitle, mouseEvent);
        }
        myAlert.addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)event -> myAlert.close())).setAlwaysOnTop(true).buildDialogAndShow();
    }

    public Optional<String> showInputAlert(String header, String text, String inputText, String buttonTitle) {
        TextInputDialog tid = new TextInputDialog(inputText);
        tid.setTitle(ClientSingleton.getInstance().getPackageName());
        tid.setHeaderText(header);
        tid.setContentText(text);
        tid.getDialogPane().getButtonTypes().clear();
        ButtonType accept = new ButtonType(buttonTitle, ButtonBar.ButtonData.OK_DONE);
        ButtonType cancel = new ButtonType(ClientSingleton.getInstance().getString("cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        tid.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{accept, cancel});
        Optional result = tid.showAndWait();
        return result;
    }

    public void saveCallRecordFile(String fileName) {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.getRecord(fileName, new FileTransferListener(){
            final /* synthetic */ ClientConnector val$clientConnector;
            {
                this.val$clientConnector = clientConnector;
            }

            public void transferStarted(FileInfo fileInfo) {
            }

            public void transferProgress(FileInfo fileInfo) {
            }

            public void transferEnded(FileInfo fileInfo) {
                AtomicReference<File> file = new AtomicReference<File>();
                try {
                    file.set(this.val$clientConnector.getFile(fileInfo));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (file.get() == null) {
                    return;
                }
                Platform.runLater(() -> {
                    String name = ((File)file.get()).getName();
                    int n = name.indexOf("-");
                    if (n != -1) {
                        name = name.substring(n + 1);
                    }
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
                    fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
                    fileChooser.setInitialFileName(name);
                    Stage stage = ClientSingleton.getInstance().getMainViewModel().getParentWindow();
                    File selectedFile = fileChooser.showSaveDialog((Window)stage);
                    if (selectedFile != null) {
                        if (selectedFile.exists()) {
                            boolean bl = selectedFile.delete();
                        }
                        MyThreadPoolManager.getInstance().execute(() -> {
                            try (FileInputStream fis = new FileInputStream((File)file.get());
                                 FileOutputStream fos = new FileOutputStream(selectedFile);){
                                byte[] b = new byte[4096];
                                int i = 0;
                                while ((i = fis.read(b)) != -1) {
                                    fos.write(b, 0, i);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    }
                });
            }
        }));
    }

    public void closeContactListView() {
        if (this.contactsMultiColumnList != null) {
            this.contactsMultiColumnList.hide();
            this.contactsMultiColumnList = null;
        }
        if (this.transferMultiColumnList != null) {
            this.transferMultiColumnList.hide();
            this.transferMultiColumnList = null;
        }
        if (this.shareMessageMultiColumnList != null) {
            this.shareMessageMultiColumnList.hide();
            this.shareMessageMultiColumnList = null;
        }
    }

    public void transferCallTo(LineInfo lineInfo, ICallPanesVisibility iCallPanesVisibility, boolean isAddToOpenedPopupList, boolean isAlwaysOnTop) {
        if (AudioCaller.getWorkingLinesCount() == 1) {
            if (this.contactsMultiColumnList != null) {
                return;
            }
            if (lineInfo.getState() != 4) {
                AudioCaller.setHoldLine(lineInfo);
            }
            this.showTransferPane(lineInfo, iCallPanesVisibility, isAddToOpenedPopupList, new ArrayList<ContactInfo>(lineInfo.getContacts()));
        } else if (AudioCaller.getWorkingLinesCount() > 1) {
            if (lineInfo.getState() == 4) {
                AudioCaller.transferCallTo(lineInfo);
            } else {
                ArrayList<ContactInfo> list = new ArrayList<ContactInfo>(lineInfo.getContacts());
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    for (LineInfo li : clientConnector.getLines()) {
                        if (li.getState() != 4) continue;
                        list.addAll(li.getContacts());
                    }
                });
                if (lineInfo.getState() != 4) {
                    AudioCaller.setHoldLine(lineInfo);
                }
                this.showTransferPane(null, iCallPanesVisibility, isAddToOpenedPopupList, list);
            }
        }
    }

    private void showTransferPane(LineInfo lineInfo, ICallPanesVisibility iCallPanesVisibility, boolean isAddToOpenedPopupList, List<ContactInfo> excludeContacts) {
        AtomicReference<LineInfo> atomicReference = new AtomicReference<LineInfo>();
        if (lineInfo != null) {
            excludeContacts = new ArrayList<ContactInfo>(lineInfo.getContacts());
            atomicReference.set(lineInfo);
        } else {
            atomicReference.set(AudioCaller.getActiveLine());
        }
        this.transferMultiColumnList = ContactsMultiColumnList.getInstance(excludeContacts, isAddToOpenedPopupList);
        this.transferMultiColumnList.setListTitle("call_transfer_to");
        this.transferMultiColumnList.setSingleTouchSelection(true);
        this.transferMultiColumnList.setShowSelectLabels(true);
        this.transferMultiColumnList.setTransferMode(true);
        this.transferMultiColumnList.setTitleOnTheTopLine(true);
        this.transferMultiColumnList.setWithSearchImage(true);
        this.transferMultiColumnList.setWithServices(true);
        this.transferMultiColumnList.setExtraPane(this.getExtraPane(false));
        this.transferMultiColumnList.setOnCloseEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.closeContactListView()));
        this.transferMultiColumnList.setWithButtonSelection(true);
        MyLabelButton blindTransfer = this.transferMultiColumnList.addButton("call_blind_transfer", (EventHandler<MouseEvent>)((EventHandler)event -> {
            boolean isHideDialog = false;
            List<ContactInfo> list = this.transferMultiColumnList.getSelectedIds();
            if (!list.isEmpty()) {
                AudioCaller.transferCall(list.get(0));
                isHideDialog = true;
            } else {
                String number = this.transferMultiColumnList.getNumber();
                if (!number.isEmpty()) {
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.transferCall(number));
                    isHideDialog = true;
                }
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "call_blind_transfer isHideDialog=" + isHideDialog);
            if (isHideDialog) {
                this.closeContactListView();
            }
        }), false);
        MyLabelButton attendedTransfer = this.transferMultiColumnList.addButton("call_attended_transfer", (EventHandler<MouseEvent>)((EventHandler)event -> {
            String number;
            boolean isHideDialog = false;
            List<ContactInfo> list = this.transferMultiColumnList.getSelectedIds();
            if (!list.isEmpty()) {
                ContactInfo contactInfo = list.get(0);
                AudioCaller.makeCall(contactInfo);
                isHideDialog = true;
            } else if (!this.transferMultiColumnList.getNumber().isEmpty() && !(number = this.transferMultiColumnList.getNumber()).isEmpty()) {
                AudioCaller.makeCall(number, false);
                isHideDialog = true;
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "call_attended_transfer isHideDialog=" + isHideDialog);
            if (isHideDialog) {
                this.closeContactListView();
            }
        }), false);
        this.transferMultiColumnList.build();
        if (iCallPanesVisibility != null) {
            iCallPanesVisibility.setCallPanesVisible();
            this.transferMultiColumnList.setICallPanesVisibility(iCallPanesVisibility);
        }
        this.transferMultiColumnList.setTextFieldPropertyListener((ChangeListener<? super String>)((ChangeListener)(observableValue, oldValue, newValue) -> {
            if (oldValue.isEmpty() && !newValue.isEmpty()) {
                blindTransfer.setEnabled(true);
                attendedTransfer.setEnabled(true);
            } else if (!oldValue.isEmpty() && newValue.isEmpty() && this.transferMultiColumnList.getSelectedIds().isEmpty()) {
                blindTransfer.setEnabled(false);
                attendedTransfer.setEnabled(false);
            }
        }));
        this.transferMultiColumnList.show();
    }

    public void addParticipantToCall(LineInfo lineInfo, ICallPanesVisibility iCallPanesVisibility, boolean isAddToOpenedPopupList, boolean isAlwaysOnTop) {
        this.addParticipantToCall(null, lineInfo, iCallPanesVisibility, isAddToOpenedPopupList, isAlwaysOnTop);
    }

    public void addParticipantToCall(Stage stage, LineInfo lineInfo, ICallPanesVisibility iCallPanesVisibility, boolean isAddToOpenedPopupList, boolean isAlwaysOnTop) {
        if (this.contactsMultiColumnList != null) {
            return;
        }
        this.contactsMultiColumnList = ContactsMultiColumnList.getInstance(new ArrayList<ContactInfo>(lineInfo.getContacts()), isAddToOpenedPopupList);
        this.contactsMultiColumnList.setListTitle("call_add_participant");
        this.contactsMultiColumnList.setSingleTouchSelection(true);
        this.contactsMultiColumnList.setShowSelectLabels(true);
        this.contactsMultiColumnList.setTitleOnTheTopLine(true);
        this.contactsMultiColumnList.setWithSearchImage(true);
        this.contactsMultiColumnList.setExtraPane(this.getExtraPane(false));
        this.contactsMultiColumnList.setAlwaysOnTop(isAlwaysOnTop);
        this.contactsMultiColumnList.setIContactSelected((contactInfo, isSelected) -> {
            if (lineInfo.getState() != 4) {
                AudioCaller.setHoldLine(lineInfo);
                TimerExecutor.getInstance().setMyAction(() -> AudioCaller.makeCall(contactInfo)).startWithDelay(200L);
            } else {
                AudioCaller.makeCall(contactInfo);
            }
            this.closeContactListView();
        });
        this.contactsMultiColumnList.setOnCloseEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            if (lineInfo.getState() == 4) {
                AudioCaller.setActiveLine(lineInfo);
            }
            this.closeContactListView();
        }));
        MyLabelButton myLabelButton = this.contactsMultiColumnList.addButton("action_make_call", (EventHandler<MouseEvent>)((EventHandler)event -> {
            String number = this.contactsMultiColumnList.getNumber();
            if (!number.isEmpty()) {
                AudioCaller.makeCall(number, true);
                this.closeContactListView();
            }
        }));
        myLabelButton.setEnabled(false);
        if (iCallPanesVisibility != null) {
            iCallPanesVisibility.setCallPanesVisible();
            this.contactsMultiColumnList.setICallPanesVisibility(iCallPanesVisibility);
        }
        this.contactsMultiColumnList.build();
        this.contactsMultiColumnList.setTextFieldPropertyListener((ChangeListener<? super String>)((ChangeListener)(observableValue, oldValue, newValue) -> {
            if (oldValue.isEmpty() && !newValue.isEmpty()) {
                myLabelButton.setEnabled(true);
            } else if (!oldValue.isEmpty() && newValue.isEmpty()) {
                myLabelButton.setEnabled(false);
            }
        }));
        this.contactsMultiColumnList.show(stage);
    }

    public void addParticipantToSession(SessionInfo sessionInfo) {
        ContactsMultiColumnList contactsMultiColumnList = ContactsMultiColumnList.getInstance(sessionInfo.getParties(), true);
        contactsMultiColumnList.setTitleOnTheTopLine(true);
        contactsMultiColumnList.setWithSearchImage(true);
        contactsMultiColumnList.setListTitle("action_add_participant");
        contactsMultiColumnList.addButton("group_add", (EventHandler<MouseEvent>)((EventHandler)event -> {
            contactsMultiColumnList.hide();
            ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("action_adding_participant"));
            MyThreadPoolManager.getInstance().execute(() -> this.updateSessionMembers(sessionInfo, contactsMultiColumnList.getSelectedIds()));
        }), false);
        contactsMultiColumnList.build().show();
    }

    public void shareMessage(MessageInfo messageInfo) {
        if (messageInfo == null) {
            return;
        }
        AtomicReference atomicReference = new AtomicReference();
        ClientSingleton.getInstance().getContactInfoByUserId(messageInfo.getSenderId()).ifPresent(atomicReference::set);
        ArrayList<ContactInfo> list = new ArrayList<ContactInfo>();
        if (atomicReference.get() != null) {
            list.add((ContactInfo)atomicReference.get());
        }
        this.shareMessageMultiColumnList = ContactsMultiColumnList.getInstance(list, true);
        this.shareMessageMultiColumnList.setTitleOnTheTopLine(true);
        this.shareMessageMultiColumnList.setSingleTouchSelection(true);
        this.shareMessageMultiColumnList.setWithSearchImage(true);
        this.shareMessageMultiColumnList.setWithButtonSelection(true);
        this.shareMessageMultiColumnList.setShowOnlyUsers("showApprovedContacts");
        this.shareMessageMultiColumnList.addButton("message_menu_share", (EventHandler<MouseEvent>)((EventHandler)event -> {
            if (!this.shareMessageMultiColumnList.getSelectedIds().isEmpty()) {
                this.sendSharedMessage(messageInfo, this.shareMessageMultiColumnList.getSelectedIds());
                this.closeContactListView();
            }
        }), false);
        this.shareMessageMultiColumnList.build().show();
    }

    public void shareContact(ContactInfo contactInfo) {
        if (contactInfo == null) {
            return;
        }
        List<String> choices = List.of(ClientSingleton.getInstance().getString("share_all_users"), ClientSingleton.getInstance().getString("share_selected_users"));
        String result = choices.get(1);
        if (ClientSingleton.getInstance().canShareContact(contactInfo)) {
            String title = ClientSingleton.getInstance().getString("message_menu_share") + " : " + contactInfo;
            result = MyPhonesMenu.getInstance().setTitle(title).showAndWait(choices);
            if (result == null || result.isEmpty()) {
                return;
            }
        }
        if (result.equals(choices.get(0))) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> TimerExecutor.getInstance().start(() -> {
                try {
                    clientConnector.shareContact(contactInfo);
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("contactInfo", contactInfo);
                    ClientSingleton.getInstance().doNotify(Constants.OPEN_PROFILE, data);
                }
                catch (Exception e) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Error shareContact : " + e.getMessage());
                }
            }));
        } else {
            AtomicReference<ContactInfo> atomicReference = new AtomicReference<ContactInfo>(contactInfo);
            ArrayList<ContactInfo> list = new ArrayList<ContactInfo>();
            if (atomicReference.get() != null) {
                list.add(atomicReference.get());
            }
            ContactsMultiColumnList contactsMultiColumnList = ContactsMultiColumnList.getInstance(list, true);
            contactsMultiColumnList.setTitleOnTheTopLine(true);
            contactsMultiColumnList.setWithSearchImage(true);
            contactsMultiColumnList.setShowOnlyUsers("showApprovedContacts");
            contactsMultiColumnList.addButton("message_menu_share", (EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                List<ContactInfo> contacts = contactsMultiColumnList.getSelectedIds();
                for (ContactInfo contact : contacts) {
                    SessionInfo sessionInfo = ClientSingleton.getInstance().getSessionInfo(contact, true);
                    if (sessionInfo == null) {
                        sessionInfo = ClientSingleton.getInstance().getClientConnector().get().getSession(contact);
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "shareContact created sessionInfo=" + sessionInfo);
                    }
                    try {
                        clientConnector.sendContact(contactInfo, sessionInfo, 0);
                    }
                    catch (Exception exception) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Error in shareContact() : " + exception.getMessage());
                    }
                }
            })));
            contactsMultiColumnList.build().show();
        }
    }

    public void shareContactList(List<ContactInfo> contactInfoList) {
        if (contactInfoList == null || contactInfoList.isEmpty()) {
            return;
        }
        AtomicReference<List<ContactInfo>> atomicReference = new AtomicReference<List<ContactInfo>>(contactInfoList);
        ArrayList<ContactInfo> list = new ArrayList<ContactInfo>();
        if (atomicReference.get() != null) {
            list.addAll((Collection<ContactInfo>)atomicReference.get());
        }
        ContactsMultiColumnList contactsMultiColumnList = ContactsMultiColumnList.getInstance(list, true);
        contactsMultiColumnList.setTitleOnTheTopLine(true);
        contactsMultiColumnList.setWithSearchImage(true);
        contactsMultiColumnList.setShowOnlyUsers("showApprovedContacts");
        contactsMultiColumnList.addButton("message_menu_share", (EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List<ContactInfo> contacts = contactsMultiColumnList.getSelectedIds();
            contactInfoList.forEach(contactInfo -> {
                for (ContactInfo contact : contacts) {
                    SessionInfo sessionInfo = ClientSingleton.getInstance().getSessionInfo(contact, true);
                    try {
                        clientConnector.sendContact(contactInfo, sessionInfo, 0);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        })));
        contactsMultiColumnList.build().show();
    }

    private void updateSessionMembers(SessionInfo sessionInfo, List<ContactInfo> checked) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateSessionMembers checked=" + checked);
        if (checked.isEmpty()) {
            return;
        }
        List add = checked.stream().filter(contactInfo -> !sessionInfo.getParties().contains(contactInfo)).collect(Collectors.toList());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "add members=" + add);
        if (!add.isEmpty()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    clientConnector.updateSession(sessionInfo, 1, new HashSet(add), sessionInfo.hasAvatar());
                }
                catch (Exception exception) {
                    ClientSingleton.getInstance().removeLoadingPane();
                    exception.printStackTrace();
                }
            });
        }
        AtomicReference<ContactInfo> firstContact = new AtomicReference<ContactInfo>();
        if (!sessionInfo.getParties().isEmpty()) {
            firstContact.set((ContactInfo)sessionInfo.getParties().get(0));
        }
        List remove = sessionInfo.getParties().stream().filter(contactInfo -> {
            if (firstContact.get() != null && ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo).equals(ClientSingleton.getInstance().getUserID((ContactInfo)firstContact.get()))) {
                return false;
            }
            return !checked.contains(contactInfo);
        }).collect(Collectors.toList());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "remove members=" + remove);
        if (!remove.isEmpty()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    clientConnector.updateSession(sessionInfo, 2, new HashSet(remove), sessionInfo.hasAvatar());
                }
                catch (Exception exception) {
                    ClientSingleton.getInstance().removeLoadingPane();
                    exception.printStackTrace();
                }
            });
        }
    }

    public void createChat() {
        AtomicBoolean hasSMSTrunk = new AtomicBoolean();
        this.contactsMultiColumnList = ContactsMultiColumnList.getInstance(new ArrayList<ContactInfo>(), true);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            hasSMSTrunk.set(!clientConnector.getSIPTrunksForSMS().isEmpty());
            this.contactsMultiColumnList.setWithoutUsers(!clientConnector.canChat() || !clientConnector.canSeeUsers());
        });
        this.contactsMultiColumnList.setShowSelectLabels(hasSMSTrunk.get());
        this.contactsMultiColumnList.setItemOnList(!hasSMSTrunk.get() ? 12 : 11);
        this.contactsMultiColumnList.setListTitle("chat_create");
        this.contactsMultiColumnList.setSingleTouchSelection(true);
        this.contactsMultiColumnList.setColumnCount(1);
        this.contactsMultiColumnList.setTitleOnTheTopLine(true);
        this.contactsMultiColumnList.setWithMouseSelection(true);
        this.contactsMultiColumnList.setSelectWithArrow(true);
        this.contactsMultiColumnList.setWithSearchImage(true);
        if (hasSMSTrunk.get()) {
            this.contactsMultiColumnList.setExtraPane(this.getExtraPane(true));
        }
        this.contactsMultiColumnList.setIContactSelected((contactInfo, isSelected) -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ClientSingleton.getInstance().setLastAction(IntentConstants.SESSION_CREATED);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("contactInfo", contactInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
            this.closeContactListView();
        }));
        this.contactsMultiColumnList.setOnCloseEvent((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.closeContactListView()));
        this.contactsMultiColumnList.build().show();
    }

    private Pane getExtraPane(boolean withChevronImage) {
        VBox extraPane = new VBox();
        extraPane.setAlignment(Pos.CENTER);
        MyLabel labelBox = new MyLabel();
        VBox.setVgrow((Node)labelBox, (Priority)Priority.ALWAYS);
        labelBox.setText(ClientSingleton.getInstance().getString("new_contact"));
        labelBox.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL));
        labelBox.setLabelFontSize(14);
        labelBox.setLabelFontFamily("Arial");
        labelBox.setTextAlignment(Pos.CENTER_LEFT);
        labelBox.prefWidthProperty().bind((ObservableValue)extraPane.widthProperty());
        labelBox.setLabelMarginLeft(10);
        extraPane.getChildren().add((Object)labelBox);
        MyLabel nameBox = new MyLabel();
        VBox.setVgrow((Node)nameBox, (Priority)Priority.ALWAYS);
        nameBox.setId("text");
        nameBox.setLabelMarginLeft(10);
        nameBox.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL));
        nameBox.setLabelFontSize(14);
        nameBox.setLabelFontFamily("Arial");
        nameBox.setTextAlignment(Pos.BOTTOM_LEFT);
        nameBox.setAlignment(Pos.CENTER);
        nameBox.setMinHeight(30.0);
        nameBox.prefWidthProperty().bind((ObservableValue)extraPane.widthProperty());
        if (withChevronImage) {
            ImageButton imageButton = new ImageButton();
            imageButton.setBackgroundColor("transparent");
            imageButton.setSize(20, 20);
            imageButton.setImagePath("other/dark_chevron_right.png");
            HBox.setMargin((Node)imageButton, (Insets)new Insets(0.0, 3.0, 0.0, 0.0));
            nameBox.getChildren().add((Object)imageButton);
            nameBox.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                String number;
                if (this.contactsMultiColumnList != null) {
                    this.closeContactListView();
                }
                if ((number = nameBox.getText()) != null && !number.isEmpty()) {
                    Optional<SessionInfo> oSessionInfo = ClientSingleton.getInstance().getSessionInfoByNumber(number);
                    Optional<Object> oContactInfo = Optional.empty();
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "oSessionInfo 1 = " + oSessionInfo);
                    if (oSessionInfo.isEmpty()) {
                        oContactInfo = ClientSingleton.getInstance().getContactInfoByNumberOrByName(number);
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "oContactInfo 2 = " + oContactInfo);
                    }
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    if (oSessionInfo.isEmpty() && oContactInfo.isEmpty()) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Create new contact with number = " + number);
                        ContactInfo contactInfo = ContactInfo.createContact(null);
                        contactInfo.addCustomDetail("Phone", (Object)number);
                        data.put("contactInfo", contactInfo);
                    } else if (oSessionInfo.isPresent()) {
                        data.put("sessionInfo", oSessionInfo.get());
                    } else {
                        data.put("contactInfo", oContactInfo.get());
                    }
                    ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
                }
            }));
            nameBox.setOnMouseEntered(event -> {
                Theme.getInstance().applyTabCellTo((Pane)nameBox, true, false);
                ((Node)event.getSource()).setCursor(Cursor.HAND);
            });
            nameBox.setOnMouseExited(event -> {
                Theme.getInstance().applyTabCellTo((Pane)nameBox, false, false);
                ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
            });
        }
        extraPane.getChildren().add((Object)nameBox);
        extraPane.setAlignment(Pos.CENTER_LEFT);
        extraPane.setMaxHeight(50.0);
        extraPane.setMinHeight(50.0);
        return extraPane;
    }

    private void sendSharedMessage(MessageInfo messageInfo, List<ContactInfo> list) {
        if (list == null) {
            return;
        }
        final ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
        SessionInfo session = null;
        for (ContactInfo contactInfo : list) {
            session = ClientSingleton.getInstance().getSessionInfo(contactInfo);
            if (session == null) {
                session = ClientSingleton.getInstance().getClientConnector().get().getSession(contactInfo);
            }
            if (messageInfo instanceof FileInfo) {
                final boolean isSendMMS = !session.canChat() && ClientSingleton.getInstance().canMMS(session);
                FileInfo fileInfo = (FileInfo)messageInfo;
                File file = null;
                try {
                    file = ClientSingleton.getInstance().getClientConnector().get().getFile(fileInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (file != null && file.exists()) {
                    try {
                        if (isSendMMS) {
                            AudioCaller.sendSmsMms(session, file, false);
                            continue;
                        }
                        clientConnector.sendFile(file, session, 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                final SessionInfo sessionInfo = session;
                fileInfo.addTransfrerListener(new FileTransferListener(){

                    public void transferStarted(FileInfo fileInfo) {
                    }

                    public void transferProgress(FileInfo fileInfo) {
                    }

                    public void transferEnded(FileInfo fileInfo) {
                        fileInfo.removeTransfrerListener((FileTransferListener)this);
                        try {
                            File file = ClientSingleton.getInstance().getClientConnector().get().getFile(fileInfo);
                            if (isSendMMS) {
                                AudioCaller.sendSmsMms(sessionInfo, file, false);
                            } else {
                                clientConnector.sendFile(file, sessionInfo, 0);
                            }
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "File : " + file.getName() + " sent successful");
                        }
                        catch (Exception e) {
                            ClientSingleton.errorLog(this.getClass().getSimpleName(), e);
                        }
                    }
                });
                clientConnector.loadFile(fileInfo);
                continue;
            }
            String text = messageInfo.getType() != 20 ? messageInfo.getContent() : MessageInfoCellLabels.setContentLabel(messageInfo);
            if (!session.canChat() && ClientSingleton.getInstance().canSMS(session)) {
                AudioCaller.sendSmsMms(session, text, false);
                continue;
            }
            clientConnector.sendMessage(text, session);
        }
        if (list.size() == 1) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", session);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        }
    }

    public Pane addServiceLocation(Map<String, String> map, int rightPadding) {
        String url = map.get("url");
        String title = map.get("title");
        AtomicReference<String> png = new AtomicReference<String>(map.containsKey("open_url") && !map.get("open_url").isEmpty() ? "" : "tab/res_tabs_on/tab_contacts_tel_on.png");
        this.services.forEach(s -> {
            if (title != null && title.toLowerCase().startsWith((String)s)) {
                png.set("crm/" + s + ".png");
            }
        });
        VBox vBox = new VBox();
        VBox.setMargin((Node)vBox, (Insets)new Insets(3.0, (double)rightPadding, 8.0, 0.0));
        HBox titleBox = new HBox();
        VBox.setMargin((Node)titleBox, (Insets)new Insets(3.0, 5.0, 0.0, 0.0));
        titleBox.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        titleBox.setAlignment(Pos.CENTER_LEFT);
        titleBox.setMaxWidth(40.0);
        titleBox.setMinHeight(40.0);
        titleBox.prefHeight(40.0);
        HBox ivBox = new HBox();
        HBox.setHgrow((Node)ivBox, (Priority)Priority.ALWAYS);
        ivBox.setAlignment(Pos.CENTER);
        ivBox.setMinWidth(40.0);
        ImageView ivAvatarService = new ImageView();
        ivAvatarService.setPreserveRatio(true);
        ivAvatarService.setPickOnBounds(true);
        if (!png.get().isEmpty()) {
            ClientSingleton.getInstance().setImageToImageView(ivAvatarService, png.get());
            ivBox.getChildren().add((Object)ivAvatarService);
        }
        Text value = new Text(title);
        try {
            ClientSingleton.getInstance().setStyledTextFont(value, false, ClientSingleton.getInstance().getStyleValue(Constants.SUBJECT_TEXT_FILL), 9);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        titleBox.getChildren().addAll((Object[])new Node[]{ivBox, value});
        HBox urlBox = new HBox();
        VBox.setMargin((Node)urlBox, (Insets)new Insets(0.0, 5.0, 3.0, 40.0));
        urlBox.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        HBox linkBox = new HBox();
        linkBox.setMinHeight(40.0);
        linkBox.prefHeight(40.0);
        HBox.setHgrow((Node)linkBox, (Priority)Priority.ALWAYS);
        linkBox.setAlignment(Pos.CENTER_LEFT);
        HBox hbAvatarBox = new HBox();
        hbAvatarBox.setMinHeight(40.0);
        hbAvatarBox.prefHeight(40.0);
        hbAvatarBox.setFillHeight(true);
        hbAvatarBox.setAlignment(Pos.CENTER);
        ImageView ivAvatar = new ImageView();
        HBox.setMargin((Node)ivAvatar, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        ivAvatar.setPreserveRatio(true);
        ivAvatar.setPickOnBounds(true);
        ClientSingleton.getInstance().setImageToImageView(ivAvatar, "crm/openurl.png");
        Text location = new Text(map.containsKey("open_url") && !map.get("open_url").isEmpty() ? map.get("open_url") : ClientSingleton.getInstance().getString("profile_open"));
        try {
            ClientSingleton.getInstance().setStyledTextFont(location, false, WhiteLabels.getCustomBlueColor(), 9, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientSingleton.getInstance().setMouseCursor((Node)location);
        location.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            if (map.containsKey("open_url")) {
                ClientSingleton.getInstance().openWebBrowser(url);
            } else {
                ServicesContactsController.getInstance().setLocation(url).setTitle((String)map.get("title")).buildAndShow();
            }
        });
        VBox.setMargin((Node)location, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        linkBox.getChildren().addAll((Object[])new Node[]{ivAvatar, location});
        HBox copyLinkBox = new HBox();
        HBox.setHgrow((Node)copyLinkBox, (Priority)Priority.ALWAYS);
        copyLinkBox.setAlignment(Pos.CENTER_LEFT);
        HBox hbAvatarBoxCopy = new HBox();
        hbAvatarBoxCopy.setMinHeight(40.0);
        hbAvatarBoxCopy.prefHeight(40.0);
        hbAvatarBoxCopy.setFillHeight(true);
        hbAvatarBoxCopy.setAlignment(Pos.CENTER);
        ImageView ivAvatarCopy = new ImageView();
        HBox.setMargin((Node)ivAvatarCopy, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        ivAvatarCopy.setPreserveRatio(true);
        ivAvatarCopy.setPickOnBounds(true);
        ClientSingleton.getInstance().setImageToImageView(ivAvatarCopy, "crm/copylink.png");
        Text copyLocation = new Text(ClientSingleton.getInstance().getString("profile_copy_link"));
        try {
            ClientSingleton.getInstance().setStyledTextFont(copyLocation, false, WhiteLabels.getCustomBlueColor(), 9, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClientSingleton.getInstance().setMouseCursor((Node)copyLocation);
        copyLocation.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(url);
            clipboard.setContent((Map)content);
        });
        VBox.setMargin((Node)copyLocation, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        copyLinkBox.getChildren().addAll((Object[])new Node[]{ivAvatarCopy, copyLocation});
        urlBox.getChildren().addAll((Object[])new Node[]{linkBox, copyLinkBox});
        vBox.getChildren().addAll((Object[])new Node[]{titleBox, urlBox});
        return vBox;
    }

    public void toClipBoard(MessageInfo messageInfo, boolean isLink) {
        Object name = "";
        String text = messageInfo.getContent();
        if (!isLink) {
            if (ClientSingleton.getInstance().getClientConnector().get().getUserId().equals(messageInfo.getSenderId())) {
                name = "[" + ClientSingleton.getInstance().getString("my_message") + "] : ";
            } else {
                Optional<ContactInfo> optionalContactInfo = ClientSingleton.getInstance().getContactInfoByUserId(messageInfo.getSenderId());
                if (!optionalContactInfo.isPresent()) {
                    optionalContactInfo = ClientSingleton.getInstance().getContactInfoByNumber(messageInfo.getSenderId());
                }
                if (optionalContactInfo.isPresent()) {
                    name = "[" + optionalContactInfo.get() + "] : ";
                }
            }
            if (messageInfo.getType() == 20) {
                if (text.contains("text\":\"")) {
                    text = JsonMessageParser.getJsonText(text);
                } else if (text.contains("content\":\"")) {
                    text = JsonMessageParser.getJsonContent(text);
                }
            }
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString((String)name + (!isLink ? "\"" : "") + text + (!isLink ? "\"" : ""));
            clipboard.setContent((Map)content);
        } else {
            List<String> list = MyUtils.bindLink(messageInfo.getContent());
            for (String url : list) {
                if (!MessageInfoCellLabels.isLink(url)) continue;
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(url);
                clipboard.setContent((Map)content);
                break;
            }
        }
    }

    public boolean isThumbnailImage(String fileName) {
        for (String thumbnailsImageSuffix : THUMBNAILS_IMAGE_SUFFIXES) {
            if (!fileName.endsWith("." + thumbnailsImageSuffix)) continue;
            return true;
        }
        return false;
    }

    public boolean isHasFileIcon(String suffix) {
        return Arrays.asList(this.extend).contains(suffix);
    }

    public void updateTransferView(String serviceId) {
        if (this.transferMultiColumnList != null) {
            this.transferMultiColumnList.updateTransferView(serviceId);
        }
    }

    public static OS getOS() {
        if (os == null) {
            String operSys = System.getProperty("os.name").toLowerCase();
            if (operSys.contains("win")) {
                os = OS.WINDOWS;
            } else if (operSys.contains("nix") || operSys.contains("nux") || operSys.contains("aix")) {
                os = OS.LINUX;
            } else if (operSys.contains("mac")) {
                os = OS.MAC;
            } else if (operSys.contains("sunos")) {
                os = OS.SOLARIS;
            }
        }
        return os;
    }

    public void setSmoothScrolling(VirtualFlow<?, ?> flow, Var<Double> scrollDirection) {
        double[] frictions = new double[]{0.99, 0.7, 0.5, 0.2, 0.1, 0.099, 0.08, 0.08, 0.07, 0.07, 0.06, 0.06, 0.05, 0.009, 0.005, 0.003, 0.001};
        double[] pushes = new double[]{1.0};
        double[] derivatives = new double[frictions.length];
        Timeline timeline = new Timeline();
        EventHandler dragHandler = event -> timeline.stop();
        EventHandler scrollHandler = event -> {
            if (event.getEventType() == ScrollEvent.SCROLL) {
                int direction = event.getDeltaY() > 0.0 ? -1 : 1;
                for (int i = 0; i < pushes.length; ++i) {
                    int n = i;
                    derivatives[n] = derivatives[n] + (double)direction * pushes[i];
                }
                if (timeline.getStatus() == Animation.Status.STOPPED) {
                    timeline.play();
                }
                event.consume();
            }
        };
        if (flow.getParent() != null) {
            flow.getParent().addEventFilter(MouseEvent.DRAG_DETECTED, dragHandler);
        }
        flow.parentProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventFilter(MouseEvent.DRAG_DETECTED, dragHandler);
            }
            if (newValue != null) {
                newValue.addEventFilter(MouseEvent.DRAG_DETECTED, dragHandler);
            }
        });
        flow.addEventFilter(MouseEvent.DRAG_DETECTED, dragHandler);
        flow.addEventFilter(ScrollEvent.ANY, scrollHandler);
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)3.0), event -> {
            int i;
            for (i = 0; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] * frictions[i];
            }
            for (i = 1; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] + derivatives[i - 1];
            }
            double dy = derivatives[derivatives.length - 1];
            scrollDirection.setValue((Object)((Double)scrollDirection.getValue() + dy));
            if (Math.abs(dy) < 0.001) {
                timeline.stop();
            }
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
    }

    public void initImageAndTitle(Stage stage) {
        String path = "taskbar/logo.png";
        ClientSingleton.getInstance().getImageFromResources(path).ifPresent(image -> stage.getIcons().add(0, image));
        stage.setTitle(ClientSingleton.getInstance().getPackageName());
    }

    public static VBox getLoadingAnchorPane(String text) {
        int PANE_WIDTH = 300;
        int MAX_HEIGHT = 200;
        VBox vBox = new VBox();
        Theme.getInstance().applyTo(Constants.POPUP_WINDOWS_BACKGROUND, (Pane)vBox);
        vBox.setMaxWidth((double)(PANE_WIDTH + 10));
        vBox.setPrefWidth((double)(PANE_WIDTH + 10));
        vBox.setMaxHeight((double)MAX_HEIGHT);
        vBox.setMinHeight((double)MAX_HEIGHT);
        HBox header = ClientUtil.getHeader();
        header.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        header.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        vBox.getChildren().add((Object)header);
        HBox textPane = new HBox();
        textPane.setAlignment(Pos.CENTER);
        textPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        VBox.setMargin((Node)textPane, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        textPane.prefWidthProperty().bind((ObservableValue)vBox.widthProperty());
        VBox.setVgrow((Node)textPane, (Priority)Priority.ALWAYS);
        vBox.getChildren().add((Object)textPane);
        MyTextArea myTextArea = new MyTextArea(text, (Pane)textPane, false);
        myTextArea.setAlertBackground();
        myTextArea.prefWidthProperty().bind((ObservableValue)textPane.widthProperty());
        myTextArea.setStyle("-fx-background-color:red;");
        myTextArea.setMaxHeight(40.0);
        textPane.getChildren().add((Object)myTextArea);
        vBox.layout();
        return vBox;
    }

    private static HBox getHeader() {
        int HEADER_HEIGHT = 40;
        HBox hBox = new HBox();
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setMinHeight((double)HEADER_HEIGHT);
        hBox.setMaxHeight((double)HEADER_HEIGHT);
        hBox.setAlignment(Pos.CENTER_LEFT);
        HBox hbAvatarBox = new HBox();
        hbAvatarBox.setMinHeight((double)HEADER_HEIGHT);
        hbAvatarBox.prefHeight((double)HEADER_HEIGHT);
        hbAvatarBox.setFillHeight(true);
        hbAvatarBox.setAlignment(Pos.CENTER);
        ImageView ivAvatar = new ImageView();
        ivAvatar.setPreserveRatio(true);
        ivAvatar.setPickOnBounds(true);
        ClientSingleton.getInstance().setImageToImageView(ivAvatar, "notify_emblem.png");
        hbAvatarBox.getChildren().add((Object)ivAvatar);
        HBox.setMargin((Node)hbAvatarBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        hBox.getChildren().add((Object)hbAvatarBox);
        Label lbContactTitle = new Label(ClientSingleton.getInstance().getPackageName());
        HBox.setMargin((Node)lbContactTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)lbContactTitle);
        HBox.setHgrow((Node)lbContactTitle, (Priority)Priority.ALWAYS);
        lbContactTitle.prefHeightProperty().bind((ObservableValue)hBox.prefHeightProperty());
        hBox.getChildren().add((Object)lbContactTitle);
        return hBox;
    }

    public void addTextAreaToReply(final Pane pane, MessageInfo messageInfo, boolean isReplay) {
        Object text = MessageInfoCellLabels.setContentLabel(messageInfo);
        if (isReplay && ((String)text).length() > 80) {
            text = ((String)text).substring(0, 80) + " ...";
        }
        this.addTextAreaToPane(pane, (String)text, true, new IInnerMessageTextArea(){

            @Override
            public void resizeParent(int height, int linesCount) {
                double lines = (double)linesCount + 0.5;
                pane.setPrefHeight(Math.min(100.0, 25.0 * lines));
                pane.setMinHeight(Math.min(100.0, 25.0 * lines));
                pane.setMaxHeight(Math.min(100.0, 25.0 * lines));
            }

            @Override
            public void sendMessage(String message) {
            }

            @Override
            public void clearEditedMessage() {
            }

            @Override
            public void clearMessagePane(int height) {
            }
        });
    }

    public VirtualizedScrollPane<MyStyledTextArea> addTextAreaToPane(Pane pane, String text, IInnerMessageTextArea iInnerMessageTextArea) {
        return this.addTextAreaToPane(pane, text, false, iInnerMessageTextArea);
    }

    private VirtualizedScrollPane<MyStyledTextArea> addTextAreaToPane(Pane pane, String text, boolean isWithBigPaddings, IInnerMessageTextArea iInnerMessageTextArea) {
        VirtualizedScrollPane<MyStyledTextArea> virtualizedScrollPane = this.createReplyTextArea(pane, text, iInnerMessageTextArea);
        virtualizedScrollPane.prefWidthProperty().bind((ObservableValue)pane.widthProperty());
        virtualizedScrollPane.prefHeightProperty().bind((ObservableValue)pane.heightProperty());
        pane.getChildren().add(virtualizedScrollPane);
        if (isWithBigPaddings) {
            virtualizedScrollPane.setMaxHeight(100.0);
            pane.setMaxHeight(100.0);
            VBox.setMargin((Node)pane, (Insets)new Insets(0.0, 10.0, 10.0, 16.0));
        }
        return virtualizedScrollPane;
    }

    private VirtualizedScrollPane<MyStyledTextArea> createReplyTextArea(Pane pane, String text, IInnerMessageTextArea iInnerMessageTextArea) {
        MyStyledTextArea myStyledTextArea = new MyStyledTextArea(iInnerMessageTextArea, null, ClientSingleton.getInstance().getStyleValue(Constants.CHAT_REPLY_MESSAGE_TEXT_FILL), 10);
        myStyledTextArea.setContentToStyledTextArea(text);
        VirtualizedScrollPane virtualizedScrollPane = new VirtualizedScrollPane((Node)myStyledTextArea);
        myStyledTextArea.setEditable(false);
        virtualizedScrollPane.getStylesheets().clear();
        return virtualizedScrollPane;
    }

    public void createMeeting(SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCall sessionInfo=" + sessionInfo + " sessionInfo.isGroup()=" + sessionInfo.isGroup());
        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_start_meeting"), ClientSingleton.getInstance().getString("alert_dialog_title3"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> TimerExecutor.getInstance().setMyAction(() -> {
            List list = clientConnector.getMeetingServices();
            if (list.size() == 1) {
                try {
                    clientConnector.createMeeting(sessionInfo, (String)list.get(0));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                MyTrunksMenu myTrunksMenu = new MyTrunksMenu(null);
                myTrunksMenu.showAndWait(ClientSingleton.getInstance().getString("create_meeting"), list, serviceName -> {
                    try {
                        clientConnector.createMeeting(sessionInfo, (String)list.get(0));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }).startWithDelayInGUIThread(100L))));
    }

    public String getCallTitle(String sessionName, MessageInfo messageInfo) {
        Object title = "";
        String from = messageInfo.getCallCallerNumber();
        String to = messageInfo.getCallCalledNumber();
        if (from != null && to != null) {
            if (sessionName.equals(from)) {
                if (messageInfo.getStatus() == 12 || messageInfo.getStatus() != 6 && messageInfo.getCallDuration() == 0) {
                    title = ClientSingleton.getInstance().getString("call_missed") + " " + ClientSingleton.getInstance().getString("call_detail_to") + " " + to;
                } else if (messageInfo.getStatus() == 6) {
                    String call_to = ClientSingleton.getInstance().getString("call_from").replace(":", "");
                    title = call_to + " " + to;
                } else {
                    String call_from = ClientSingleton.getInstance().getString("call_to").replace(":", "");
                    title = call_from + " " + to;
                }
            } else if (sessionName.equals(to)) {
                if (messageInfo.getStatus() == 12 || messageInfo.getStatus() != 6 && messageInfo.getCallDuration() == 0) {
                    title = ClientSingleton.getInstance().getString("call_missed") + " " + ClientSingleton.getInstance().getString("call_detail_to") + " " + from;
                } else if (messageInfo.getStatus() == 6) {
                    String call_from = ClientSingleton.getInstance().getString("call_from").replace(":", "");
                    title = call_from + " " + from;
                } else {
                    String call_to = ClientSingleton.getInstance().getString("call_to").replace(":", "");
                    title = call_to + " " + from;
                }
            } else {
                title = messageInfo.getStatus() == 12 || messageInfo.getStatus() != 6 && messageInfo.getCallDuration() == 0 ? ClientSingleton.getInstance().getString("call_missed") + " " + ClientSingleton.getInstance().getString("call_detail_from") + " " + from + " " + ClientSingleton.getInstance().getString("call_detail_to") + " " + to : ClientSingleton.getInstance().getString("call_detail_from") + " " + from + " " + ClientSingleton.getInstance().getString("call_detail_to") + " " + to;
            }
        } else {
            title = from != null && messageInfo.getStatus() == 5 ? ClientSingleton.getInstance().getString("call_detail_incoming") + " " + from : (to != null && messageInfo.getStatus() == 6 ? ClientSingleton.getInstance().getString("call_detail_outgoing") + " " + to : messageInfo.getCallPartyNumber());
        }
        if (title == null && messageInfo.getContent().contains("Conference")) {
            title = ClientSingleton.getInstance().getString("call_conference");
        }
        if (title != null) {
            title = ((String)title).toLowerCase();
            title = ((String)title).replace("ringotel", "");
        }
        return title;
    }

    public static enum OS {
        WINDOWS,
        LINUX,
        MAC,
        SOLARIS;

    }
}

