/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.utils;

import java.util.List;
import java.util.Map;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import org.json.smile.JSONException;
import org.json.smile.JSONObject;
import smile.cti.client.MessageInfo;

public class JsonMessageParser {
    public static final String JSON_TAG_TEXT = "text\":\"";
    public static final String JSON_TAG_CONTENT = "content\":\"";
    public static final String JSON_TAG_NUMBER = "number\":\"";
    public static final String JSON_TAG_FROM = "from\":\"";
    public static final String JSON_TAG_FILE = "file\":\"";

    public static Pair<String, String> getCallerCalled(MessageInfo messageInfo) throws JSONException {
        JSONObject object = new JSONObject(messageInfo.getContent());
        String caller = object.has("caller") ? object.getString("caller") : "";
        String called = object.has("called") ? object.getString("called") : "";
        return new Pair((Object)caller, (Object)called);
    }

    public static Pair<String, String> getCallerCalled(String json, int messageStatus) throws JSONException {
        String called;
        if (!ClientSingleton.getInstance().isChatWithTrunks()) {
            return null;
        }
        JSONObject object = new JSONObject(json);
        String caller = object.has("caller") ? object.getString("caller") : "";
        String string = called = object.has("called") ? object.getString("called") : "";
        if (messageStatus == 5 || messageStatus == 12) {
            String trunkName = JsonMessageParser.getTrunkName(called);
            return new Pair((Object)caller, (Object)trunkName);
        }
        String trunkName = JsonMessageParser.getTrunkName(caller);
        return new Pair((Object)trunkName, (Object)called);
    }

    public static String getTrunkName(String number) {
        List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks();
        if (trunks == null) {
            return number;
        }
        String trunkName = number;
        for (int i = 0; i < trunks.size(); ++i) {
            Map map = (Map)trunks.get(i);
            if (map.get("number") == null || !map.get("number").toString().equals(number)) continue;
            trunkName = map.get("name") != null ? map.get("name").toString() : null;
            break;
        }
        return trunkName;
    }

    public static String getFrom(String json) {
        if (json.contains(JSON_TAG_FROM)) {
            String from = null;
            try {
                JSONObject object = new JSONObject(json);
                from = object.getString("from");
            }
            catch (JSONException e) {
                from = JsonMessageParser.getJsonFrom(json);
            }
            return from;
        }
        return null;
    }

    public static Pair<String, Integer> getMessageString(String json, int messageStatus, boolean withMissedCall) throws JSONException {
        Object text = "";
        int duration = 0;
        if (json.contains("\"number\"")) {
            String number = "";
            try {
                JSONObject object = new JSONObject(json);
                text = object.has("text") ? object.getString("text") : JsonMessageParser.getJsonText(json);
                number = object.has("number") ? object.getString("number") : JsonMessageParser.getJsonNumber(json);
            }
            catch (JSONException e) {
                e.printStackTrace();
                text = JsonMessageParser.getJsonText(json);
                number = JsonMessageParser.getJsonNumber(json);
            }
            if (((String)text).startsWith("{") && ((String)text).endsWith("}")) {
                text = ((String)text).replace("}{", "\n");
                text = ((String)text).replace("{", "");
                text = ((String)text).replace("}", "");
            }
            text = (String)text + "\n " + number;
        } else if (json.contains("\"caller\"") || json.contains("\"called\"")) {
            JSONObject object = new JSONObject(json);
            duration = object.getInt("duration");
            String caller = object.has("caller") ? object.getString("caller") : "";
            String called = object.has("called") ? object.getString("called") : "";
            int cs = -1;
            if (duration == 0) {
                if (messageStatus == 5 || messageStatus == 12) {
                    if (messageStatus == 5 && object.has("cause")) {
                        cs = object.getInt("cause");
                        if (cs == 26) {
                            text = ClientSingleton.getInstance().getString("AnsweredElsewhere");
                            duration = -1;
                        } else if (withMissedCall) {
                            text = ClientSingleton.getInstance().getString("call_missed");
                        }
                    } else if (withMissedCall) {
                        text = ClientSingleton.getInstance().getString("call_missed");
                    }
                } else if (object.has("cause")) {
                    cs = object.getInt("cause");
                    text = JsonMessageParser.getCauseDescription(cs, messageStatus);
                }
            }
            if (((String)text).isEmpty()) {
                text = messageStatus == 5 || messageStatus == 12 ? (caller.isEmpty() ? called : caller) : (!called.isEmpty() ? called : caller);
            }
        }
        return new Pair(text, (Object)duration);
    }

    public static String getCaller(String json, int messageStatus) throws JSONException {
        String text = "";
        if (json.contains("\"caller\"") || json.contains("\"called\"")) {
            String called;
            JSONObject object = new JSONObject(json);
            String caller = object.has("caller") ? object.getString("caller") : "";
            String string = called = object.has("called") ? object.getString("called") : "";
            text = messageStatus == 5 || messageStatus == 12 ? (!caller.isEmpty() ? caller : called) : (!called.isEmpty() ? called : caller);
        }
        return text;
    }

    public static String getCauseDescription(int cause, int status) {
        if (cause == -1) {
            return "";
        }
        switch (cause & 0x7F) {
            case 1: {
                return ClientSingleton.getInstance().getString("UserAbsent");
            }
            case 2: 
            case 3: {
                return ClientSingleton.getInstance().getString("NoRouteToDestination");
            }
            case 16: {
                return ClientSingleton.getInstance().getString("NoAnswer");
            }
            case 17: {
                return ClientSingleton.getInstance().getString("UserBusy");
            }
            case 19: {
                return ClientSingleton.getInstance().getString("NoAnswer");
            }
            case 20: {
                return ClientSingleton.getInstance().getString("SubscriberAbsent");
            }
            case 21: {
                return ClientSingleton.getInstance().getString("CallRejected");
            }
            case 22: 
            case 23: {
                return ClientSingleton.getInstance().getString("NumberChanged");
            }
            case 26: {
                return ClientSingleton.getInstance().getString("AnsweredElsewhere");
            }
            case 27: {
                return ClientSingleton.getInstance().getString("DestinationOutOfOrder");
            }
            case 28: {
                return ClientSingleton.getInstance().getString("InvalidNumberFormat");
            }
            case 31: {
                return ClientSingleton.getInstance().getString("UserAbsent");
            }
            case 34: {
                return ClientSingleton.getInstance().getString("ServiceNotAvailable");
            }
            case 55: {
                return ClientSingleton.getInstance().getString("UserBusy");
            }
            case 63: {
                return ClientSingleton.getInstance().getString("ServiceNotAvailable");
            }
        }
        return status == 6 ? ClientSingleton.getInstance().getString("CallRejected") : ClientSingleton.getInstance().getString("call_missed");
    }

    public static String getJsonFrom(String contentLabel) {
        return JsonMessageParser.getJsonTag(contentLabel, JSON_TAG_FROM);
    }

    public static String getJsonNumber(String contentLabel) {
        return JsonMessageParser.getJsonTag(contentLabel, JSON_TAG_NUMBER);
    }

    public static String getJsonText(String contentLabel) {
        return JsonMessageParser.getJsonTag(contentLabel, JSON_TAG_TEXT);
    }

    public static String getJsonContent(String contentLabel) {
        return JsonMessageParser.getJsonTag(contentLabel, JSON_TAG_CONTENT);
    }

    public static String getJsonTag(String content, String tag) {
        String tagEnd;
        String text = content.replace("\u201c", "\"");
        int index = text.indexOf(tag);
        boolean equals = JSON_TAG_TEXT.equals(tag) || JSON_TAG_CONTENT.equals(tag) || JSON_TAG_FILE.equals(tag);
        String string = tagEnd = equals ? "\"," : "\",\"";
        if (index != -1) {
            int start = index + tag.length();
            int endIndex = text.indexOf(tagEnd, start);
            if (endIndex == -1) {
                tagEnd = equals ? "\"}" : "\"";
                endIndex = text.indexOf(tagEnd, start);
            }
            try {
                text = text.substring(start, endIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public static boolean hasTag(String content, String tag) {
        if (content == null || tag == null) {
            return false;
        }
        return content.contains(tag);
    }
}

