/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.connector.utils.resources;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.scene.image.Image;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.connector.utils.resources.ImageResource;
import net.sipsnet.client.constants.Constants;

public class JarResources {
    private static JarResources jarResources;
    private final String resourcesJarPath;
    private final String resourcesJarPrefix;
    public boolean debugOn = false;
    private final List<String> zipEntryList = new ArrayList<String>();
    private boolean hasDarkTheme = false;

    private JarResources() {
        String appName = ClientSingleton.getStartExeName().toLowerCase().replace(" ", "");
        Object dirPath = System.getProperty("user.dir");
        this.resourcesJarPath = (String)dirPath + File.separator + "bin" + File.separator + Constants.RESOURCES_PREFIX + appName + ".jar";
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            dirPath = "jar:file:/" + ((String)dirPath).replace("\\", "/").replace(" ", "%20");
        }
        this.resourcesJarPrefix = (String)dirPath + "/bin/" + Constants.RESOURCES_PREFIX + appName + ".jar!";
        this.getJarContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarResources getInstance() {
        Class<JarResources> clazz = JarResources.class;
        synchronized (JarResources.class) {
            if (jarResources == null) {
                jarResources = new JarResources();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return jarResources;
        }
    }

    public boolean isHasDarkTheme() {
        return this.hasDarkTheme;
    }

    private void getJarContent() {
        try (JarFile jarFile = new JarFile(this.resourcesJarPath);){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory()) {
                    if (!entry.getName().contains("dark")) continue;
                    this.hasDarkTheme = true;
                    continue;
                }
                if (entry.getName().contains("dark/") || ClientUtil.getOS() == ClientUtil.OS.MAC && entry.getName().contains("logo_tray")) continue;
                String name = entry.getName();
                this.zipEntryList.add("/" + name);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasResourceInJAR(String resourceName) {
        if (Theme.getInstance().isDarkTheme() && !((String)resourceName).startsWith("/dark")) {
            resourceName = "/dark" + (String)resourceName;
        }
        return this.zipEntryList.contains(resourceName);
    }

    public ImageResource getResource(String resourceName) {
        if (Theme.getInstance().isDarkTheme() && !((String)resourceName).startsWith("/dark")) {
            resourceName = "/dark" + (String)resourceName;
        }
        Image image = null;
        if ((image = this.getImage((String)resourceName, image, -1.0, -1.0)) == null) {
            return null;
        }
        double width = image.getWidth();
        double height = image.getHeight();
        if (!((String)resourceName).contains("@2x") && this.hasResourceInJAR((String)(resourceName = ((String)resourceName).replace(".png", "@2x.png")))) {
            image = this.getImage((String)resourceName, image, width, height);
        }
        return new ImageResource(image, width, height);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Image getImage(String resourceName, Image image, double width, double height) {
        try (FileInputStream fis = new FileInputStream(this.resourcesJarPath);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry zipEntry = null;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!resourceName.equals("/" + zipEntry.getName())) continue;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    zis.transferTo(byteArrayOutputStream);
                    try (ByteArrayInputStream in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        image = new Image((InputStream)in);
                        return image;
                    }
                }
                finally {
                    byteArrayOutputStream.close();
                    return image;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

