/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Builder<T> {
    private final Supplier<T> instantiator;
    private final List<Consumer<T>> instanceModifiers = new ArrayList<Consumer<T>>();

    public Builder(Supplier<T> instantiator) {
        this.instantiator = instantiator;
    }

    public static <T> Builder<T> of(Supplier<T> instantiator) {
        return new Builder<T>(instantiator);
    }

    public <U> Builder<T> with(BiConsumer<T, U> consumer, U value) {
        Consumer<Object> c = instance -> consumer.accept(instance, value);
        this.instanceModifiers.add(c);
        return this;
    }

    public T build() {
        Object value = this.instantiator.get();
        this.instanceModifiers.forEach(modifier -> modifier.accept(value));
        this.instanceModifiers.clear();
        return value;
    }
}

