/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.util.Utils;
import java.security.AccessController;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public final class PrismSettings {
    public static final boolean verbose;
    public static final boolean debug;
    public static final boolean trace;
    public static final boolean printAllocs;
    public static final boolean isVsyncEnabled;
    public static final boolean dirtyOptsEnabled;
    public static final boolean occlusionCullingEnabled;
    public static final boolean scrollCacheOpt;
    public static final boolean threadCheck;
    public static final boolean cacheSimpleShapes;
    public static final boolean cacheComplexShapes;
    public static final boolean useNewImageLoader;
    public static final List<String> tryOrder;
    public static final int prismStatFrequency;
    public static final RasterizerType rasterizerSpec;
    public static final String refType;
    public static final boolean forceRepaint;
    public static final boolean noFallback;
    public static final boolean showDirtyRegions;
    public static final boolean showOverdraw;
    public static final boolean printRenderGraph;
    public static final int minRTTSize;
    public static final int dirtyRegionCount;
    public static final boolean disableBadDriverWarning;
    public static final boolean forceGPU;
    public static final int maxTextureSize;
    public static final int primTextureSize;
    public static final boolean disableRegionCaching;
    public static final boolean forcePow2;
    public static final boolean noClampToZero;
    public static final boolean disableD3D9Ex;
    public static final boolean allowHiDPIScaling;
    public static final long maxVram;
    public static final long targetVram;
    public static final boolean poolStats;
    public static final boolean poolDebug;
    public static final boolean disableEffects;
    public static final int glyphCacheWidth;
    public static final int glyphCacheHeight;
    public static final String perfLog;
    public static final boolean perfLogExitFlush;
    public static final boolean perfLogFirstPaintFlush;
    public static final boolean perfLogFirstPaintExit;
    public static final boolean superShader;
    public static final boolean forceUploadingPainter;
    public static final boolean forceAlphaTestShader;
    public static final boolean forceNonAntialiasedShape;
    public static final boolean javaVersion13;

    private static void printBooleanOption(boolean opt, String trueStr) {
        if (opt) {
            System.out.println(trueStr);
        } else {
            System.out.print("Not ");
            System.out.print(Character.toLowerCase(trueStr.charAt(0)));
            System.out.println(trueStr.substring(1));
        }
    }

    private static int parseInt(String s, int dflt, int trueDflt, String errMsg) {
        return "true".equalsIgnoreCase(s) ? trueDflt : PrismSettings.parseInt(s, dflt, errMsg);
    }

    private static int parseInt(String s, int dflt, String errMsg) {
        block3: {
            if (s != null) {
                try {
                    return Integer.parseInt(s);
                }
                catch (Exception e) {
                    if (errMsg == null) break block3;
                    System.err.println(errMsg);
                }
            }
        }
        return dflt;
    }

    private static long parseLong(String s, long dflt, long rel, String errMsg) {
        block15: {
            if (s != null && s.length() > 0) {
                long mult = 1L;
                if (s.endsWith("%")) {
                    if (rel > 0L) {
                        try {
                            s = s.substring(0, s.length() - 1);
                            double percent = Double.parseDouble(s);
                            if (percent >= 0.0 && percent <= 100.0) {
                                return Math.round((double)rel * percent / 100.0);
                            }
                        }
                        catch (Exception percent) {
                            // empty catch block
                        }
                    }
                    if (errMsg != null) {
                        System.err.println(errMsg);
                    }
                    return dflt;
                }
                if (s.endsWith("k") || s.endsWith("K")) {
                    mult = 1024L;
                } else if (s.endsWith("m") || s.endsWith("M")) {
                    mult = 0x100000L;
                } else if (s.endsWith("g") || s.endsWith("G")) {
                    mult = 0x40000000L;
                }
                if (mult > 1L) {
                    s = s.substring(0, s.length() - 1);
                }
                try {
                    return Long.parseLong(s) * mult;
                }
                catch (Exception e) {
                    if (errMsg == null) break block15;
                    System.err.println(errMsg);
                }
            }
        }
        return dflt;
    }

    private static String[] split(String str, String delim) {
        StringTokenizer st = new StringTokenizer(str, delim);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i++] = st.nextToken();
        }
        return ret;
    }

    private static boolean getBoolean(Properties properties, String key, boolean dflt) {
        String strval = properties.getProperty(key);
        return strval != null ? Boolean.parseBoolean(strval) : dflt;
    }

    private static boolean getBoolean(Properties properties, String key, boolean dflt, boolean dfltIfDefined) {
        String strval = properties.getProperty(key);
        if (strval != null && strval.length() == 0) {
            return dfltIfDefined;
        }
        return strval != null ? Boolean.parseBoolean(strval) : dflt;
    }

    private static int getInt(Properties properties, String key, int dflt, int trueDflt, String errMsg) {
        return PrismSettings.parseInt(properties.getProperty(key), dflt, trueDflt, errMsg);
    }

    private static int getInt(Properties properties, String key, int dflt, String errMsg) {
        return PrismSettings.parseInt(properties.getProperty(key), dflt, errMsg);
    }

    private static long getLong(Properties properties, String key, long dflt, String errMsg) {
        return PrismSettings.parseLong(properties.getProperty(key), dflt, 0L, errMsg);
    }

    private static long getLong(Properties properties, String key, long dflt, long rel, String errMsg) {
        return PrismSettings.parseLong(properties.getProperty(key), dflt, rel, errMsg);
    }

    static {
        int size;
        Properties systemProperties = (Properties)AccessController.doPrivileged(() -> System.getProperties());
        javaVersion13 = PrismSettings.getInt(systemProperties, "java.specification.version", 12, null) >= 13;
        isVsyncEnabled = PrismSettings.getBoolean(systemProperties, "prism.vsync", true) && !PrismSettings.getBoolean(systemProperties, "javafx.animation.fullspeed", false);
        dirtyOptsEnabled = PrismSettings.getBoolean(systemProperties, "prism.dirtyopts", true);
        occlusionCullingEnabled = dirtyOptsEnabled && PrismSettings.getBoolean(systemProperties, "prism.occlusion.culling", true);
        dirtyRegionCount = Utils.clamp((int)0, (int)PrismSettings.getInt(systemProperties, "prism.dirtyregioncount", 6, null), (int)15);
        scrollCacheOpt = PrismSettings.getBoolean(systemProperties, "prism.scrollcacheopt", false);
        threadCheck = PrismSettings.getBoolean(systemProperties, "prism.threadcheck", false);
        showDirtyRegions = PrismSettings.getBoolean(systemProperties, "prism.showdirty", false);
        showOverdraw = PrismSettings.getBoolean(systemProperties, "prism.showoverdraw", false);
        printRenderGraph = PrismSettings.getBoolean(systemProperties, "prism.printrendergraph", false);
        forceRepaint = PrismSettings.getBoolean(systemProperties, "prism.forcerepaint", false);
        noFallback = PrismSettings.getBoolean(systemProperties, "prism.noFallback", false);
        String cache = systemProperties.getProperty("prism.cacheshapes", "complex");
        if ("all".equals(cache) || "true".equals(cache)) {
            cacheSimpleShapes = true;
            cacheComplexShapes = true;
        } else if ("complex".equals(cache)) {
            cacheSimpleShapes = false;
            cacheComplexShapes = true;
        } else {
            cacheSimpleShapes = false;
            cacheComplexShapes = false;
        }
        useNewImageLoader = PrismSettings.getBoolean(systemProperties, "prism.newiio", true);
        verbose = PrismSettings.getBoolean(systemProperties, "prism.verbose", false);
        prismStatFrequency = PrismSettings.getInt(systemProperties, "prism.printStats", 0, 1, "Try -Dprism.printStats=<true or number>");
        debug = PrismSettings.getBoolean(systemProperties, "prism.debug", false);
        trace = PrismSettings.getBoolean(systemProperties, "prism.trace", false);
        printAllocs = PrismSettings.getBoolean(systemProperties, "prism.printallocs", false);
        disableBadDriverWarning = PrismSettings.getBoolean(systemProperties, "prism.disableBadDriverWarning", false);
        forceGPU = PrismSettings.getBoolean(systemProperties, "prism.forceGPU", false);
        String order = systemProperties.getProperty("prism.order");
        String[] tryOrderArr = order != null ? PrismSettings.split(order, ",") : (PlatformUtil.isWindows() ? new String[]{"d3d", "sw"} : (PlatformUtil.isMac() ? new String[]{"es2", "sw"} : (PlatformUtil.isIOS() ? new String[]{"es2"} : (PlatformUtil.isAndroid() ? new String[]{"es2"} : (PlatformUtil.isLinux() ? new String[]{"es2", "sw"} : new String[]{"sw"})))));
        tryOrder = List.of(tryOrderArr);
        RasterizerType rSpec = null;
        String rOrder = systemProperties.getProperty("prism.rasterizerorder");
        if (rOrder != null) {
            String[] stringArray = PrismSettings.split(rOrder.toLowerCase(), ",");
            int n = stringArray.length;
            block7: for (int i = 0; i < n; ++i) {
                String s;
                switch (s = stringArray[i]) {
                    case "marlin": 
                    case "doublemarlin": {
                        rSpec = RasterizerType.DoubleMarlin;
                        break block7;
                    }
                }
            }
        }
        if (rSpec == null) {
            rSpec = RasterizerType.DoubleMarlin;
        }
        rasterizerSpec = rSpec;
        String primtex = systemProperties.getProperty("prism.primtextures");
        primTextureSize = primtex == null ? (PlatformUtil.isEmbedded() ? -1 : 0) : (primtex.equals("true") ? -1 : (primtex.equals("false") ? 0 : PrismSettings.parseInt(primtex, 0, "Try -Dprism.primtextures=[true|false|<number>]")));
        refType = systemProperties.getProperty("prism.reftype");
        forcePow2 = PrismSettings.getBoolean(systemProperties, "prism.forcepowerof2", false);
        noClampToZero = PrismSettings.getBoolean(systemProperties, "prism.noclamptozero", false);
        allowHiDPIScaling = PrismSettings.getBoolean(systemProperties, "prism.allowhidpi", true);
        maxVram = PrismSettings.getLong(systemProperties, "prism.maxvram", 0x20000000L, "Try -Dprism.maxvram=<long>[kKmMgG]");
        targetVram = PrismSettings.getLong(systemProperties, "prism.targetvram", maxVram / 8L, maxVram, "Try -Dprism.targetvram=<long>[kKmMgG]|<double(0,100)>%");
        poolStats = PrismSettings.getBoolean(systemProperties, "prism.poolstats", false);
        poolDebug = PrismSettings.getBoolean(systemProperties, "prism.pooldebug", false);
        if (verbose) {
            PrismSettings.printBooleanOption(javaVersion13, "Java version higher then 13");
            System.out.print("Prism pipeline init order: ");
            for (String s : tryOrder) {
                System.out.print(s + " ");
            }
            System.out.println();
            if (rOrder != null) {
                System.out.println("Requested rasterizer preference order: " + rOrder);
            }
            System.out.println("Using " + rSpec);
            PrismSettings.printBooleanOption(dirtyOptsEnabled, "Using dirty region optimizations");
            if (primTextureSize == 0) {
                System.out.println("Not using texture mask for primitives");
            } else if (primTextureSize < 0) {
                System.out.println("Using system sized mask for primitives");
            } else {
                System.out.println("Using " + primTextureSize + " sized mask for primitives");
            }
            PrismSettings.printBooleanOption(forcePow2, "Forcing power of 2 sizes for textures");
            PrismSettings.printBooleanOption(!noClampToZero, "Using hardware CLAMP_TO_ZERO mode");
            PrismSettings.printBooleanOption(allowHiDPIScaling, "Opting in for HiDPI pixel scaling");
        }
        if ((size = PrismSettings.getInt(systemProperties, "prism.maxTextureSize", 4096, "Try -Dprism.maxTextureSize=<number>")) <= 0) {
            size = Integer.MAX_VALUE;
        }
        maxTextureSize = size;
        minRTTSize = PrismSettings.getInt(systemProperties, "prism.minrttsize", PlatformUtil.isEmbedded() ? 16 : 0, "Try -Dprism.minrttsize=<number>");
        disableRegionCaching = PrismSettings.getBoolean(systemProperties, "prism.disableRegionCaching", false);
        disableD3D9Ex = PrismSettings.getBoolean(systemProperties, "prism.disableD3D9Ex", false);
        disableEffects = PrismSettings.getBoolean(systemProperties, "prism.disableEffects", false);
        glyphCacheWidth = PrismSettings.getInt(systemProperties, "prism.glyphCacheWidth", 1024, "Try -Dprism.glyphCacheWidth=<number>");
        glyphCacheHeight = PrismSettings.getInt(systemProperties, "prism.glyphCacheHeight", 1024, "Try -Dprism.glyphCacheHeight=<number>");
        perfLog = systemProperties.getProperty("sun.perflog");
        perfLogExitFlush = PrismSettings.getBoolean(systemProperties, "sun.perflog.fx.exitflush", false, true);
        perfLogFirstPaintFlush = PrismSettings.getBoolean(systemProperties, "sun.perflog.fx.firstpaintflush", false, true);
        perfLogFirstPaintExit = PrismSettings.getBoolean(systemProperties, "sun.perflog.fx.firstpaintexit", false, true);
        superShader = PrismSettings.getBoolean(systemProperties, "prism.supershader", true);
        forceUploadingPainter = PrismSettings.getBoolean(systemProperties, "prism.forceUploadingPainter", false);
        forceAlphaTestShader = PrismSettings.getBoolean(systemProperties, "prism.forceAlphaTestShader", false);
        forceNonAntialiasedShape = PrismSettings.getBoolean(systemProperties, "prism.forceNonAntialiasedShape", false);
    }

    public static enum RasterizerType {
        DoubleMarlin("Double Precision Marlin Rasterizer");

        private final String publicName;

        private RasterizerType(String publicname) {
            this.publicName = publicname;
        }

        public String toString() {
            return this.publicName;
        }
    }
}

