/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.audiocontrols;

import com.sun.jna.Function;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public class SpotyVolume {
    private static final Guid.CLSID CLSID_MMDeviceEnumerator = new Guid.CLSID("BCDE0395-E52F-467C-8E3D-C4579291692E");
    private static final Guid.IID IID_IMMDeviceEnumerator = new Guid.IID("A95664D2-9614-4F35-A746-DE8DB63617E6");
    private static final Guid.IID IID_IAudioSessionManager2 = new Guid.IID("77AA99A0-1BD6-484F-8BC7-2C654C9A9B6F");
    private static final Guid.IID IID_ISimpleAudioVolume = new Guid.IID("87ce5498-68d6-44e5-9215-6da47ef883d8");
    private static final Guid.IID IID_IAudioSessionControl2 = new Guid.IID("bfb7ff88-7239-4fc9-8fa2-07c950be9c6d");
    private static final PointerByReference MMDeviceEnumerator = new PointerByReference();
    private static final PointerByReference MMDevice = new PointerByReference();
    private static final PointerByReference AudioSessionManager2 = new PointerByReference();
    private static final PointerByReference AudioSessionEnumerator = new PointerByReference();
    private static final PointerByReference SimpleAudioVolume = new PointerByReference();
    private static final PointerByReference MMDeviceCollection = new PointerByReference();
    private static final int VTABLE_IMMDeviceEnumerator_EnumAudioEndpoints = 24;
    private static final int VTABLE_IMMDeviceCollection_GetCount = 24;
    private static final int VTABLE_IMMDeviceCollection_Item = 32;
    private static final int VTABLE_IMMDevice_Activate = 24;
    private static final int VTABLE_IAudioSessionManager2_GetSessionEnumerator = 40;
    private static final int VTABLE_IAudioSessionEnumerator_GetCount = 24;
    private static final int VTABLE_IAudioSessionEnumerator_GetSession = 32;
    private static final int VTABLE_IAudioSessionControl2_GetSessionIdentifier = 96;
    private static final int VTABLE_IAudioSessionControl2_QueryInterface = 0;
    private static final int VTABLE_ISimpleAudioVolume_SetMute = 40;
    private static SpotyVolume spotyVolume;

    public static SpotyVolume getInstance() {
        if (spotyVolume == null) {
            spotyVolume = new SpotyVolume();
        }
        return spotyVolume;
    }

    private SpotyVolume() {
        WinNT.HRESULT ris = Ole32.INSTANCE.CoInitializeEx(null, 0);
        if (!WinNT.S_OK.equals((Object)ris)) {
            throw new RuntimeException("Ole32::CoInitializeEx() error result: " + ris.intValue());
        }
        if (!WinNT.S_OK.equals((Object)Ole32.INSTANCE.CoCreateInstance((Guid.GUID)CLSID_MMDeviceEnumerator, null, 1, (Guid.GUID)IID_IMMDeviceEnumerator, MMDeviceEnumerator))) {
            throw new RuntimeException("Ole32::CoCreateInstance() failed");
        }
    }

    private void getEnumAudioEndpoints() {
        Pointer MMDeviceEnumeratorPointer = MMDeviceEnumerator.getValue();
        Pointer MMDeviceEnumeratorVirtualTable = MMDeviceEnumeratorPointer.getPointer(0L);
        Function EnumAudioEndpoints = Function.getFunction((Pointer)MMDeviceEnumeratorVirtualTable.getPointer(24L), (int)63);
        int eDataFlow = 0;
        int eRole = 1;
        if (!WinNT.S_OK.equals(EnumAudioEndpoints.invoke(WinNT.HRESULT.class, new Object[]{MMDeviceEnumeratorPointer, eDataFlow, eRole, MMDeviceCollection}))) {
            throw new RuntimeException("IMMDeviceEnumerator::EnumAudioEndpoints() failed");
        }
    }

    private int getDeviceCollectionCount() {
        Pointer MMDeviceCollectionPointer = MMDeviceCollection.getValue();
        Pointer MMDeviceCollectionVirtualTable = MMDeviceCollectionPointer.getPointer(0L);
        Function GetCount = Function.getFunction((Pointer)MMDeviceCollectionVirtualTable.getPointer(24L), (int)63);
        IntByReference ris = new IntByReference();
        if (!WinNT.S_OK.equals(GetCount.invoke(WinNT.HRESULT.class, new Object[]{MMDeviceCollectionPointer, ris}))) {
            throw new RuntimeException("IMMDeviceCollection::GetCount() failed");
        }
        return ris.getValue();
    }

    private void getDeviceCollectionItem(int device) {
        Pointer MMDeviceCollectionPointer = MMDeviceCollection.getValue();
        Pointer MMDeviceCollectionVirtualTable = MMDeviceCollectionPointer.getPointer(0L);
        Function Item2 = Function.getFunction((Pointer)MMDeviceCollectionVirtualTable.getPointer(32L), (int)63);
        if (!WinNT.S_OK.equals(Item2.invoke(WinNT.HRESULT.class, new Object[]{MMDeviceCollectionPointer, device, MMDevice}))) {
            throw new RuntimeException("IMMDeviceCollection::Item() failed");
        }
    }

    private void activateDevice() {
        Pointer MMDevicePointer = MMDevice.getValue();
        Pointer MMDeviceVirtualTable = MMDevicePointer.getPointer(0L);
        Function Activate = Function.getFunction((Pointer)MMDeviceVirtualTable.getPointer(24L), (int)63);
        if (!WinNT.S_OK.equals(Activate.invoke(WinNT.HRESULT.class, new Object[]{MMDevicePointer, IID_IAudioSessionManager2, 1, null, AudioSessionManager2}))) {
            throw new RuntimeException("IMMDevice::Activate() failed");
        }
    }

    private void getSessionEnumerator() {
        Pointer AudioSessionManager2Pointer = AudioSessionManager2.getValue();
        Pointer AudioSessionManager2PointerVirtualTable = AudioSessionManager2Pointer.getPointer(0L);
        Function GetSessionEnumerator = Function.getFunction((Pointer)AudioSessionManager2PointerVirtualTable.getPointer(40L), (int)63);
        if (!WinNT.S_OK.equals(GetSessionEnumerator.invoke(WinNT.HRESULT.class, new Object[]{AudioSessionManager2Pointer, AudioSessionEnumerator}))) {
            throw new RuntimeException("IAudioSessionManager2::GetSessionEnumerator() failed");
        }
    }

    private int getCount() {
        Pointer AudioSessionEnumeratorPointer = AudioSessionEnumerator.getValue();
        Pointer AudioSessionEnumeratorVirtualTable = AudioSessionEnumeratorPointer.getPointer(0L);
        Function GetCount = Function.getFunction((Pointer)AudioSessionEnumeratorVirtualTable.getPointer(24L), (int)63);
        IntByReference resultPointer = new IntByReference();
        if (!WinNT.S_OK.equals(GetCount.invoke(WinNT.HRESULT.class, new Object[]{AudioSessionEnumeratorPointer, resultPointer}))) {
            throw new RuntimeException("IAudioSessionEnumerator::GetCount() failed");
        }
        return resultPointer.getValue();
    }

    private void getSession(int index, PointerByReference IAudioSessionControl2) {
        Pointer AudioSessionEnumeratorPointer = AudioSessionEnumerator.getValue();
        Pointer AudioSessionEnumeratorVirtualTable = AudioSessionEnumeratorPointer.getPointer(0L);
        Function GetSession = Function.getFunction((Pointer)AudioSessionEnumeratorVirtualTable.getPointer(32L), (int)63);
        if (!WinNT.S_OK.equals(GetSession.invoke(WinNT.HRESULT.class, new Object[]{AudioSessionEnumeratorPointer, index, IAudioSessionControl2}))) {
            throw new RuntimeException("IAudioSessionEnumerator::GetSession() failed");
        }
    }

    private void getExtendedIAudioSessionControl(PointerByReference IAudioSessionControl, PointerByReference IAudioSessionControl2) {
        Pointer AudioSessionControlPointer = IAudioSessionControl.getValue();
        Pointer AudioSessionControlVirtualTable = AudioSessionControlPointer.getPointer(0L);
        Function QueryInterface = Function.getFunction((Pointer)AudioSessionControlVirtualTable.getPointer(0L), (int)63);
        if (!WinNT.S_OK.equals(QueryInterface.invoke(WinNT.HRESULT.class, new Object[]{AudioSessionControlPointer, IID_IAudioSessionControl2, IAudioSessionControl2}))) {
            throw new RuntimeException("IAudioSessionControl::QueryInterface() failed");
        }
    }

    private String GetSessionIdentifier(PointerByReference AudioSessionControl2) {
        Pointer AudioSessionControl2Pointer = AudioSessionControl2.getValue();
        Pointer AudioSessionControl2VirtualTable = AudioSessionControl2Pointer.getPointer(0L);
        Function GetSessionIdentifier = Function.getFunction((Pointer)AudioSessionControl2VirtualTable.getPointer(96L), (int)63);
        PointerByReference ris = new PointerByReference();
        if (!WinNT.S_OK.equals(GetSessionIdentifier.invoke(WinNT.HRESULT.class, new Object[]{AudioSessionControl2Pointer, ris}))) {
            throw new RuntimeException("IAudioSessionControl2::GetSessionIdentifier() failed");
        }
        return ris.getValue().getWideString(0L);
    }

    private void getSimpleAudioVolume(PointerByReference AudioSessionControl2) {
        Pointer AudioSessionControl2Pointer = AudioSessionControl2.getValue();
        Pointer AudioSessionControl2VirtualTable = AudioSessionControl2Pointer.getPointer(0L);
        Function QueryInterface = Function.getFunction((Pointer)AudioSessionControl2VirtualTable.getPointer(0L), (int)63);
        if (!WinNT.S_OK.equals(QueryInterface.invoke(WinNT.HRESULT.class, new Object[]{AudioSessionControl2Pointer, IID_ISimpleAudioVolume, SimpleAudioVolume}))) {
            throw new RuntimeException("IAudioSessionControl2::QueryInterface() failed");
        }
    }

    private void setMute(boolean mute) {
        Pointer SimpleAudioVolumePointer = SimpleAudioVolume.getValue();
        Pointer SimpleAudioVolumeVirtualTable = SimpleAudioVolumePointer.getPointer(0L);
        Function SetMute = Function.getFunction((Pointer)SimpleAudioVolumeVirtualTable.getPointer(40L), (int)63);
        WinDef.BOOL m = new WinDef.BOOL(mute);
        if (!WinNT.S_OK.equals(SetMute.invoke(WinNT.HRESULT.class, new Object[]{SimpleAudioVolumePointer, m, null}))) {
            throw new RuntimeException("ISimpleAudioVolume::SetMute() failed");
        }
    }

    public void muteTargetApplication(boolean mute) {
        this.getEnumAudioEndpoints();
        int countEndpoints = this.getDeviceCollectionCount();
        for (int ep = 0; ep < countEndpoints; ++ep) {
            this.getDeviceCollectionItem(ep);
            this.activateDevice();
            this.getSessionEnumerator();
            int count = this.getCount();
            for (int i = 0; i < count; ++i) {
                PointerByReference AudioSessionControl = new PointerByReference();
                this.getSession(i, AudioSessionControl);
                PointerByReference AudioSessionControl2 = new PointerByReference();
                this.getExtendedIAudioSessionControl(AudioSessionControl, AudioSessionControl2);
                String id = this.GetSessionIdentifier(AudioSessionControl2);
                if (!id.contains("Spotify")) continue;
                this.getSimpleAudioVolume(AudioSessionControl2);
                this.setMute(mute);
            }
        }
    }
}

