/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.audiorecorder;

import com.smile.sound.WavAudioFormat;
import com.smile.sound.wavFormatHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import smile.cti.phone.PhoneDevice;

public class VoiceMessageRecorder {
    private final PhoneDevice device;
    private File file;
    private FileOutputStream fos;
    private boolean recording;
    private long startTime;
    private long duration;
    private WavAudioFormat format = WavAudioFormat.PCM_LINEAR16;

    public VoiceMessageRecorder(PhoneDevice device) {
        this.device = device;
    }

    public void setWavFormat(WavAudioFormat format) {
        this.format = format;
    }

    public void reset() throws Exception {
        if (this.recording) {
            this.stopRecord();
        }
        if (this.file != null) {
            this.file.delete();
        }
        this.file = null;
    }

    public void startRecord() throws Exception {
        if (this.file == null) {
            this.file = File.createTempFile("rec", ".wav");
        }
        this.fos = new FileOutputStream(this.file, true);
        this.device.startRecord((OutputStream)this.fos, null);
        this.startTime = System.currentTimeMillis();
        this.recording = true;
    }

    public void stopRecord() throws Exception {
        this.device.stopRecord(null);
        this.recording = false;
        this.duration += System.currentTimeMillis() - this.startTime;
        this.fos.close();
    }

    public long getDuration() {
        return this.recording ? this.duration + System.currentTimeMillis() - this.startTime : this.duration;
    }

    public File getFile() throws Exception {
        if (this.file == null) {
            return null;
        }
        if (this.recording) {
            this.stopRecord();
        }
        FileInputStream stream = new FileInputStream(this.file);
        int dataLength = ((InputStream)stream).available();
        byte[] buffer = new byte[dataLength];
        ((InputStream)stream).read(buffer);
        ((InputStream)stream).close();
        FileOutputStream fos = new FileOutputStream(this.file);
        wavFormatHeader hdr = new wavFormatHeader(this.format);
        hdr.setDataLength(dataLength);
        fos.write(hdr.toByteArray());
        fos.write(buffer);
        fos.close();
        return this.file;
    }
}

