/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.scheduledwork;

import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;

public class TimerExecutor {
    private final Scheduler ioScheduler = Schedulers.from((Executor)MyThreadPoolManager.getInstance(15).getThreadPoolExecutor());
    private MyAction myAction;
    private Disposable job;

    private TimerExecutor() {
    }

    public static TimerExecutor getInstance() {
        return new TimerExecutor();
    }

    public TimerExecutor setMyAction(MyAction myAction) {
        this.myAction = myAction;
        return this;
    }

    public void start(MyAction myAction) {
        this.setMyAction(myAction);
        this.startWithDelay(20L);
    }

    public void startInGUI(MyAction myAction) {
        if (Platform.isFxApplicationThread()) {
            try {
                myAction.execute();
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
        } else {
            this.setMyAction(myAction);
            this.startWithDelayInGUIThread(20L);
        }
    }

    public void startWithDelay(long delay) {
        this.job = Single.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)this.ioScheduler).doOnError(this.getThrowableConsumer()).subscribe(t -> {
            if (this.myAction != null) {
                this.myAction.execute();
            }
            this.cancel();
        }, this.getThrowableConsumer());
    }

    public void startWithDelayInGUIThread(long delay) {
        this.job = Single.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)this.ioScheduler).observeOn((Scheduler)JavaFxScheduler.platform()).doOnError(this.getThrowableConsumer()).subscribe(t -> {
            this.myAction.execute();
            this.cancel();
        }, this.getThrowableConsumer());
    }

    public void cancel() throws Exception {
        this.myAction = null;
        if (this.job != null && !this.job.isDisposed()) {
            this.job.dispose();
        }
        this.job = null;
    }

    public Consumer<? super Throwable> getThrowableConsumer() {
        return throwable -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "----------------------");
            throwable.printStackTrace();
        };
    }
}

