/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.splitpane;

import javafx.animation.Animation;
import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.splitpane.ISplitPaneDividerSlider;

public class MySplitPaneDividerSlider {
    private final Direction direction;
    private final SplitPane splitPane;
    private final int dividerIndex;
    private BooleanProperty aimContentVisibleProperty;
    private DoubleProperty lastDividerPositionProperty;
    private DoubleProperty currentDividerPositionProperty;
    private Region content;
    private Region childContent;
    private double contentInitialMaxWidth;
    private double contentInitialMaxHeight;
    private double childContentInitialMaxWidth;
    private double childContentInitialMaxHeight;
    private Transition slideTransition;
    private final Duration cycleDuration;
    private SplitPane.Divider dividerToMove;
    private final double visibilityMode = 1.0;
    private final ISplitPaneDividerSlider mListener;
    private String id = "";
    public static final double START_DIVIDER_POSITION = 0.0;
    public static final double END_DIVIDER_POSITION = 1.0;
    public static final double MAX_CONTENT_WIDTH = 5000.0;
    public static final double MIN_CONTENT_WIDTH = 0.0;
    public static final boolean VISIBLE_CONTENT = true;
    public static final boolean INVISIBLE_CONTENT = false;

    public MySplitPaneDividerSlider(SplitPane splitPane, int dividerIndex, Direction direction, ISplitPaneDividerSlider mListener) {
        this(splitPane, dividerIndex, direction, Duration.millis((double)350.0), mListener);
    }

    public MySplitPaneDividerSlider(SplitPane splitPane, int dividerIndex, Direction direction, Duration cycleDuration, ISplitPaneDividerSlider mListener) {
        this.direction = direction;
        this.splitPane = splitPane;
        this.dividerIndex = dividerIndex;
        this.cycleDuration = cycleDuration;
        this.mListener = mListener;
        this.init();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private void init() {
        this.slideTransition = new SlideTransition(this.cycleDuration);
        this.slideTransition.statusProperty().addListener((event, oldValue, newValue) -> {
            if (newValue == Animation.Status.STOPPED) {
                if (this.isAimContentVisible()) {
                    this.restoreContentSize();
                    if (this.mListener != null) {
                        this.mListener.dividerOpened(this.id);
                    }
                } else {
                    double position = this.direction == Direction.LEFT || this.direction == Direction.UP ? 0.0 : 1.0;
                    this.setCurrentDividerPosition(position);
                    if (this.mListener != null) {
                        this.mListener.dividerClosed(this.id);
                    }
                }
            }
        });
        switch (this.direction) {
            case LEFT: 
            case UP: {
                this.content = (Region)this.splitPane.getItems().get(this.dividerIndex);
                this.childContent = (Region)this.splitPane.getItems().get(this.dividerIndex + 1);
                break;
            }
            case RIGHT: 
            case DOWN: {
                this.childContent = (Region)this.splitPane.getItems().get(this.dividerIndex);
                this.content = (Region)this.splitPane.getItems().get(this.dividerIndex + 1);
            }
        }
        this.contentInitialMaxHeight = this.content.getMaxHeight();
        this.contentInitialMaxWidth = this.content.getMaxWidth();
        this.childContentInitialMaxHeight = this.childContent.getMaxHeight();
        this.childContentInitialMaxWidth = this.childContent.getMaxWidth();
        this.dividerToMove = (SplitPane.Divider)this.splitPane.getDividers().get(this.dividerIndex);
    }

    public void initDividerOnStartPosition() {
        this.moveDivider(true, 0.0, 5000.0, false);
    }

    public void moveDividerToStartPosition() {
        ClientSingleton.getInstance().runLater(() -> this.moveDivider(true, 0.0, 5000.0));
    }

    public void moveDividerToEndPosition() {
        this.moveDivider(false, 1.0, 0.0);
    }

    public void moveDivider(boolean visibility, double dividerPosition, double maxContentWidth) {
        this.moveDivider(visibility, dividerPosition, maxContentWidth, true);
    }

    public void moveDivider(boolean visibility, double dividerPosition, double maxContentWidth, boolean withTransition) {
        this.setAimContentVisible(visibility);
        this.setLastDividerPosition(dividerPosition);
        this.contentInitialMaxWidth = maxContentWidth;
        this.childContentInitialMaxWidth = this.contentInitialMaxWidth == 5000.0 ? 0.0 : (this.contentInitialMaxWidth == 0.0 ? 5000.0 : 5000.0);
        this.content.setMaxHeight(this.contentInitialMaxHeight);
        this.content.setMaxWidth(this.contentInitialMaxWidth);
        this.childContent.setMaxHeight(this.childContentInitialMaxHeight);
        this.childContent.setMaxWidth(this.childContentInitialMaxWidth);
        if (withTransition) {
            this.content.setMinSize(0.0, 0.0);
            this.slideTransition.play();
        } else {
            this.setCurrentDividerPosition(0.0);
        }
    }

    public boolean isDividerOnStartPosition() {
        return this.contentInitialMaxWidth == 5000.0;
    }

    public void onResizeSplit() {
        this.setDividerPosition(this.getLastDividerPosition());
    }

    public void setDividerPosition(double position) {
        ((SplitPane.Divider)this.splitPane.getDividers().get(this.dividerIndex)).setPosition(position);
        this.setCurrentDividerPosition(((SplitPane.Divider)this.splitPane.getDividers().get(this.dividerIndex)).getPosition());
    }

    private void restoreContentSize() {
        this.content.setMaxHeight(this.contentInitialMaxHeight);
        this.content.setMaxWidth(this.contentInitialMaxWidth);
        this.childContent.setMaxHeight(this.childContentInitialMaxHeight);
        this.childContent.setMaxWidth(this.childContentInitialMaxWidth);
        this.setCurrentDividerPosition(this.getLastDividerPosition());
    }

    public DoubleProperty lastDividerPositionProperty() {
        if (this.lastDividerPositionProperty == null) {
            this.lastDividerPositionProperty = new SimpleDoubleProperty();
        }
        return this.lastDividerPositionProperty;
    }

    public double getLastDividerPosition() {
        return this.lastDividerPositionProperty().get();
    }

    public void setLastDividerPosition(double lastDividerPosition) {
        this.lastDividerPositionProperty().set(lastDividerPosition);
    }

    public DoubleProperty currentDividerPositionProperty() {
        if (this.currentDividerPositionProperty == null) {
            this.currentDividerPositionProperty = new SimpleDoubleProperty();
        }
        return this.currentDividerPositionProperty;
    }

    public double getCurrentDividerPosition() {
        return this.currentDividerPositionProperty().get();
    }

    public void setCurrentDividerPosition(double currentDividerPosition) {
        this.currentDividerPositionProperty().set(currentDividerPosition);
        this.dividerToMove.setPosition(currentDividerPosition);
    }

    public BooleanProperty aimContentVisibleProperty() {
        if (this.aimContentVisibleProperty == null) {
            this.aimContentVisibleProperty = new SimpleBooleanProperty(true);
        }
        return this.aimContentVisibleProperty;
    }

    public void setAimContentVisible(boolean aimContentVisible) {
        this.aimContentVisibleProperty().set(aimContentVisible);
    }

    public boolean isAimContentVisible() {
        return this.aimContentVisibleProperty().get();
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }

    private class SlideTransition
    extends Transition {
        public SlideTransition(Duration cycleDuration) {
            this.setCycleDuration(cycleDuration);
        }

        protected void interpolate(double d) {
            switch (MySplitPaneDividerSlider.this.direction) {
                case LEFT: 
                case UP: {
                    if (MySplitPaneDividerSlider.this.isAimContentVisible()) {
                        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "LEFT delta " + (MySplitPaneDividerSlider.this.getCurrentDividerPosition() + d) + " last=" + MySplitPaneDividerSlider.this.getLastDividerPosition());
                        if (MySplitPaneDividerSlider.this.getCurrentDividerPosition() + d <= MySplitPaneDividerSlider.this.getLastDividerPosition()) {
                            MySplitPaneDividerSlider.this.setCurrentDividerPosition(MySplitPaneDividerSlider.this.getCurrentDividerPosition() + d);
                            break;
                        }
                        this.stop();
                        break;
                    }
                    if (MySplitPaneDividerSlider.this.getCurrentDividerPosition() > 0.0) {
                        MySplitPaneDividerSlider.this.setCurrentDividerPosition(MySplitPaneDividerSlider.this.getCurrentDividerPosition() - d);
                        break;
                    }
                    this.stop();
                    break;
                }
                case RIGHT: 
                case DOWN: {
                    if (MySplitPaneDividerSlider.this.isAimContentVisible()) {
                        if (MySplitPaneDividerSlider.this.getCurrentDividerPosition() - d >= MySplitPaneDividerSlider.this.getLastDividerPosition()) {
                            MySplitPaneDividerSlider.this.setCurrentDividerPosition(MySplitPaneDividerSlider.this.getCurrentDividerPosition() - d);
                            break;
                        }
                        this.stop();
                        break;
                    }
                    if (MySplitPaneDividerSlider.this.getCurrentDividerPosition() < 1.0) {
                        MySplitPaneDividerSlider.this.setCurrentDividerPosition(MySplitPaneDividerSlider.this.getCurrentDividerPosition() + d);
                        break;
                    }
                    this.stop();
                }
            }
        }
    }
}

