/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.ssl;

import com.smile.security.TrustManager;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Vector;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.sipsnet.client.connector.ClientSingleton;

public class TrustSSLProvider {
    private final HostnameVerifier hostNameVerifier = (hostname, session) -> true;
    private SSLSocketFactory sslSocketFactory;
    private X509Certificate[] acceptedIssuers;

    public TrustSSLProvider() {
        try {
            this.initAcceptedIssuers();
            this.sslSocketFactory = this.createSSLSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SSLSocketFactory createSSLSocketFactory() throws Exception {
        X509TrustManager trustManager = this.getX509TrustManager();
        SSLContext context = SSLContext.getInstance("TLS");
        javax.net.ssl.TrustManager[] trustManagers = new javax.net.ssl.TrustManager[]{trustManager};
        context.init(null, trustManagers, null);
        return context.getSocketFactory();
    }

    public HostnameVerifier getHostNameVerifier() {
        return this.hostNameVerifier;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    private void initAcceptedIssuers() throws Exception {
        String[] ksFiles = new String[]{"security/cacert.p12", "net/sipsnet/client/security/cacerts.p12"};
        char[] ks_password = new char[]{};
        Vector issuers = new Vector();
        for (int i = 0; i < ksFiles.length; ++i) {
            try {
                KeyStore ks = TrustManager.getkeyStore((String)ksFiles[i], (char[])ks_password);
                ClientSingleton.toLog(this.getClass().getSimpleName(), "getTrustManager = " + ks);
                if (ks == null) continue;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
                tmf.init(ks);
                X509TrustManager trustManager = (X509TrustManager)tmf.getTrustManagers()[0];
                X509Certificate[] icerts = trustManager.getAcceptedIssuers();
                Collections.addAll(issuers, icerts);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.acceptedIssuers = new X509Certificate[issuers.size()];
        issuers.copyInto(this.acceptedIssuers);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getTrustManager acceptedIssuers = " + this.acceptedIssuers);
    }

    private X509TrustManager getX509TrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return TrustSSLProvider.this.acceptedIssuers;
            }
        };
    }
}

