/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.threadpool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MyThreadPoolManager {
    private final BlockingQueue<Runnable> mWorkQueue = new LinkedBlockingQueue<Runnable>();
    private final MyThreadPoolExecutor mThreadPool = new MyThreadPoolExecutor();
    private static final long KEEP_ALIVE_TIME = 1L;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final int CORE_POOL_SIZE = 4;
    private static int MAXIMUM_POOL_SIZE = 8;
    private static MyThreadPoolManager sInstance = null;

    private MyThreadPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MyThreadPoolManager getInstance() {
        Class<MyThreadPoolManager> clazz = MyThreadPoolManager.class;
        synchronized (MyThreadPoolManager.class) {
            if (sInstance == null) {
                sInstance = new MyThreadPoolManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MyThreadPoolManager getInstance(int maxThreadPoolSize) {
        Class<MyThreadPoolManager> clazz = MyThreadPoolManager.class;
        synchronized (MyThreadPoolManager.class) {
            MAXIMUM_POOL_SIZE = maxThreadPoolSize;
            if (sInstance == null) {
                sInstance = new MyThreadPoolManager();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.mThreadPool;
    }

    public void interruptThread(Runnable r) throws Exception {
        this.mThreadPool.interruptThread(r);
    }

    public void shutDownNow() {
        this.mThreadPool.shutdownNow();
    }

    public void execute(Runnable runnable) {
        this.mThreadPool.execute(runnable);
    }

    class MyThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Map<Runnable, Thread> executingThreads;

        public MyThreadPoolExecutor() {
            super(4, MAXIMUM_POOL_SIZE, 1L, KEEP_ALIVE_TIME_UNIT, MyThreadPoolManager.this.mWorkQueue);
            this.executingThreads = new HashMap<Runnable, Thread>(MAXIMUM_POOL_SIZE);
        }

        public synchronized void interruptThread(Runnable r) {
            Thread t = this.executingThreads.remove(r);
            if (t != null) {
                t.interrupt();
            }
        }

        @Override
        protected synchronized void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            this.executingThreads.put(r, t);
        }

        @Override
        protected synchronized void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.executingThreads.remove(r);
        }

        @Override
        public synchronized List<Runnable> shutdownNow() {
            List<Runnable> runnables = super.shutdownNow();
            for (Thread t : this.executingThreads.values()) {
                t.interrupt();
            }
            return runnables;
        }
    }
}

