/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.threadpool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NotificationThreadPoolManager {
    private final BlockingQueue<Runnable> mWorkQueue = new LinkedBlockingQueue<Runnable>();
    private final MyThreadPoolExecutor mThreadPool = new MyThreadPoolExecutor();
    private static final long KEEP_ALIVE_TIME = 10L;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final int CORE_POOL_SIZE = 4;
    private static final int MAXIMUM_POOL_SIZE = 4;
    private static NotificationThreadPoolManager sInstance = null;

    private NotificationThreadPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationThreadPoolManager getInstance() {
        Class<NotificationThreadPoolManager> clazz = NotificationThreadPoolManager.class;
        synchronized (NotificationThreadPoolManager.class) {
            if (sInstance == null) {
                sInstance = new NotificationThreadPoolManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void interruptThread(Runnable r) throws Exception {
        this.mThreadPool.interruptThread(r);
    }

    public void shutDownNow() {
        this.mThreadPool.shutdownNow();
    }

    public void execute(Runnable runnable) {
        this.mThreadPool.execute(runnable);
    }

    class MyThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Map<Runnable, Thread> executingThreads;

        public MyThreadPoolExecutor() {
            super(4, 4, 10L, KEEP_ALIVE_TIME_UNIT, NotificationThreadPoolManager.this.mWorkQueue);
            this.executingThreads = new HashMap<Runnable, Thread>(4);
        }

        public synchronized void interruptThread(Runnable r) {
            Thread t = this.executingThreads.remove(r);
            if (t != null) {
                t.interrupt();
            }
        }

        @Override
        protected synchronized void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            this.executingThreads.put(r, t);
        }

        @Override
        protected synchronized void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.executingThreads.remove(r);
        }

        @Override
        public synchronized List<Runnable> shutdownNow() {
            List<Runnable> runnables = super.shutdownNow();
            for (Thread t : this.executingThreads.values()) {
                t.interrupt();
            }
            return runnables;
        }
    }
}

