/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.threadpool;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SingleThreadPoolManager {
    private final BlockingQueue<Runnable> mWorkQueue = new LinkedBlockingQueue<Runnable>();
    private final MyThreadPoolExecutor mThreadPool = new MyThreadPoolExecutor();
    private static final long KEEP_ALIVE_TIME = 1L;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAXIMUM_POOL_SIZE = 1;
    private static SingleThreadPoolManager sInstance = null;

    private SingleThreadPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SingleThreadPoolManager getInstance() {
        Class<SingleThreadPoolManager> clazz = SingleThreadPoolManager.class;
        synchronized (SingleThreadPoolManager.class) {
            if (sInstance == null) {
                sInstance = new SingleThreadPoolManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.mThreadPool;
    }

    public void interruptThread(Runnable r) throws Exception {
        this.mThreadPool.interruptThread(r);
    }

    public void shutDownNow() {
        this.mThreadPool.shutdownNow();
    }

    public void execute(Runnable runnable) {
        this.mThreadPool.execute(runnable);
    }

    class MyThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Map<Runnable, Thread> executingThreads;

        public MyThreadPoolExecutor() {
            super(1, 1, 1L, KEEP_ALIVE_TIME_UNIT, SingleThreadPoolManager.this.mWorkQueue);
            this.executingThreads = new HashMap<Runnable, Thread>(1);
        }

        public synchronized void interruptThread(Runnable r) {
            Thread t = this.executingThreads.remove(r);
            if (t != null) {
                t.interrupt();
            }
        }

        @Override
        protected synchronized void beforeExecute(Thread t, Runnable r) {
            super.beforeExecute(t, r);
            this.executingThreads.put(r, t);
        }

        @Override
        protected synchronized void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.executingThreads.remove(r);
        }

        @Override
        public synchronized List<Runnable> shutdownNow() {
            List<Runnable> runnables = super.shutdownNow();
            for (Thread t : this.executingThreads.values()) {
                t.interrupt();
            }
            return runnables;
        }
    }
}

