/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.usb;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class TouchDetector {
    public void init() {
        try {
            JFrame frame = new JFrame("TEST");
            frame.setSize(500, 500);
            frame.setVisible(true);
            JPanel panel = new JPanel();
            panel.setBackground(Color.red);
            frame.add(panel);
            WinDef.HWND hwnd = new WinDef.HWND();
            hwnd.setPointer(Native.getComponentPointer((Component)frame));
            Native.setLastError((int)0);
            int windowThreadID = User32.INSTANCE.GetWindowThreadProcessId(hwnd, null);
            if (windowThreadID == 0) {
                int x = Native.getLastError();
                throw new IllegalStateException("error calling GetWindowThreadProcessId when installing machine-shutdown handler " + x);
            }
            EventHookProc proc = new EventHookProc();
            proc.hhook = User32.INSTANCE.SetWindowsHookEx(4, (WinUser.HOOKPROC)new EventHookProc(), null, windowThreadID);
            if (proc.hhook == null) {
                int x = Native.getLastError();
                throw new IllegalStateException("error calling SetWindowsHookEx when installing machine-shutdown handler " + x);
            }
            System.out.println("Installed WIndows Event hook procedure");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        TouchDetector h = new TouchDetector();
        h.init();
    }

    public final class EventHookProc
    implements WinHookProc {
        public WinUser.HHOOK hhook;

        @Override
        public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, CWPSSTRUCT hookProcStruct) {
            if (nCode >= 0 && hookProcStruct.message.intValue() == 282) {
                System.out.println("YOU JUST TOUCHED   x: " + MouseInfo.getPointerInfo().getLocation().x + "    y: " + MouseInfo.getPointerInfo().getLocation().y);
            }
            return User32.INSTANCE.CallNextHookEx(this.hhook, nCode, wParam, hookProcStruct.lParam);
        }
    }

    public static interface GetMsgProc
    extends WinUser.HOOKPROC {
        public WinDef.LRESULT callback(int var1, WinDef.WPARAM var2, WinUser.MSG var3);
    }

    public static interface WinHookProc
    extends WinUser.HOOKPROC {
        public WinDef.LRESULT callback(int var1, WinDef.WPARAM var2, CWPSSTRUCT var3);
    }

    public static class CWPSSTRUCT
    extends Structure {
        public WinDef.LPARAM lParam;
        public WinDef.WPARAM wParam;
        public WinDef.DWORD message;
        public WinDef.HWND hwnd;

        protected List getFieldOrder() {
            return Arrays.asList("lParam", "wParam", "message", "hwnd");
        }
    }
}

