/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.usb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.usb.IUsbNotification;
import net.sipsnet.client.utils.usb.planctronics_poly.PlantronicsREST;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.event.HidServicesEvent;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceStructure;
import smile.cti.client.LineInfo;

public class UsbHidController
implements HidServicesListener,
IUsbNotification {
    private final List<HidDevice> canOpenHidDevices = new ArrayList<HidDevice>();
    private HidServices hidServices;
    private Thread scanThread;
    private final int scanInterval = 2000;
    private long lastConnectedTime;
    private boolean down;
    private final Map<String, Character> yelinkDTMF = new HashMap<String, Character>();
    private final Map<String, String> yelinkNumbers = new HashMap<String, String>();
    private final boolean IS_YEALINK_TEST = false;
    private final String YEALINK_CALLING_NUMBER_ENDS = "020000000200000002010000";
    private final String YEALINK_OFFHOOK = "0200000002010000";
    private final String YEALINK_OFFHOOK_MAC_PREFIX = "9b0100009b000000";
    private final String YEALINK_END_CALL = "0240000002000000";

    public void start() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "create");
        PlantronicsREST.doShowDeviceInfo();
        HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
        hidServicesSpecification.setAutoStart(false);
        hidServicesSpecification.setAutoDataRead(true);
        hidServicesSpecification.setDataReadInterval(500);
        hidServicesSpecification.setDataReadTimeout(100);
        hidServicesSpecification.setScanInterval(5000);
        HidApi.logTraffic = true;
        this.hidServices = HidManager.getHidServices((HidServicesSpecification)hidServicesSpecification);
        this.hidServices.addHidServicesListener((HidServicesListener)this);
        this.printAttachedDevices();
        this.startScan();
    }

    public void stopUsbHidController() {
        if (PlantronicsREST.hasActiveDevice) {
            PlantronicsREST.closeDevice();
        } else if (this.hidServices != null) {
            this.stopScan();
            this.onDisconnectCall();
            if (ClientUtil.getOS() == ClientUtil.OS.MAC) {
                try {
                    Thread.sleep(1100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void hidDeviceAttached(HidServicesEvent event) {
        HidDevice hidDevice = event.getHidDevice();
        this.hidDeviceAttached(hidDevice);
    }

    private void hidDeviceAttached(HidDevice hidDevice) {
        Mixer.Info[] mixerInfo;
        if (hidDevice == null || hidDevice.getProduct() == null || hidDevice.getUsagePage() != this.decode("0xb") && hidDevice.getUsage() != this.decode("0x5") || hidDevice.getUsagePage() != this.decode("0xb") && hidDevice.getUsage() == this.decode("0x5") || hidDevice.getProduct().isEmpty() || hidDevice.getProduct().toLowerCase().contains("mouse") || hidDevice.getProduct().toLowerCase().contains("keyboard") || hidDevice.getManufacturer().contains("Microsoft") || hidDevice.getSerialNumber().isEmpty()) {
            return;
        }
        for (Mixer.Info info : mixerInfo = AudioSystem.getMixerInfo()) {
            if (!info.getClass().getSimpleName().contains("DirectAudioDeviceInfo")) continue;
            this.addToCanConnectHid(hidDevice);
        }
    }

    private int decode(String hex) {
        return Integer.decode(hex);
    }

    private synchronized void addToCanConnectHid(HidDevice hidDevice) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "try to add hidDevice: " + hidDevice + "  " + hidDevice.isClosed());
        if (!this.canOpenHidDevices.contains(hidDevice)) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "add hid p device isPlantronicsPolyProduct : " + this.isPlantronicsPolyProduct(hidDevice));
            if (this.isPlantronicsPolyProduct(hidDevice)) {
                Optional<HidDevice> optionalHidDevice = this.canOpenHidDevices.stream().filter(hidDevice1 -> hidDevice1.getProductId() == hidDevice.getProductId() && hidDevice1.getSerialNumber().equals(hidDevice.getSerialNumber())).findAny();
                if (optionalHidDevice.isEmpty()) {
                    this.canOpenHidDevices.add(hidDevice);
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "add hid p device : " + hidDevice);
                    TimerExecutor.getInstance().setMyAction(PlantronicsREST::doShowDeviceInfo).startWithDelay(20L);
                }
            } else {
                this.canOpenHidDevices.add(hidDevice);
                if (this.isYealinkLinkProduct(hidDevice)) {
                    this.initYelinkDTMF();
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "add hid hash=" + hidDevice.hashCode() + " device  =" + hidDevice + " hidDevice.isClosed() : " + hidDevice.isClosed());
            }
        }
    }

    public void hidDeviceDetached(HidServicesEvent event) {
        HidDevice hidDevice = event.getHidDevice();
        if (this.canOpenHidDevices.remove(hidDevice)) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "PlantronicsREST.hasActiveDevice : " + PlantronicsREST.hasActiveDevice);
            if (PlantronicsREST.hasActiveDevice) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "PlantronicsREST noneMatch : " + this.canOpenHidDevices.stream().noneMatch(hidDevice1 -> this.isPlantronicsPolyProduct(hidDevice)));
                if (this.canOpenHidDevices.stream().noneMatch(hidDevice1 -> this.isPlantronicsPolyProduct(hidDevice))) {
                    PlantronicsREST.closeDevice();
                    PlantronicsREST.hasActiveDevice = false;
                }
            } else {
                hidDevice.close();
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "close HidDevice " + hidDevice);
        }
    }

    public void hidFailure(HidServicesEvent event) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "hidFailure HidDevice " + event.getHidDevice() + " error : " + event.getHidDevice().getLastErrorMessage());
    }

    @Override
    public void onDisconnectCall() {
        if (PlantronicsREST.hasActiveDevice) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (clientConnector.getMute()) {
                    PlantronicsREST.onMute(false);
                }
            });
            PlantronicsREST.onTerminateCall();
            PlantronicsREST.closeDevice();
        } else {
            this.lastConnectedTime = 0L;
            for (HidDevice hidDevice : this.canOpenHidDevices) {
                byte[] command = new byte[]{0, 0, 0};
                this.sendLEDCommand(hidDevice, LED_COMMAND.DISCONNECT, command);
                TimerExecutor.getInstance().setMyAction(() -> ((HidDevice)hidDevice).close()).startWithDelay(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPresentCall(boolean isIncomingCall) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onPresentCall openedDevices.size() =" + this.canOpenHidDevices.size() + " PlantronicsREST.hasActiveDevice=" + PlantronicsREST.hasActiveDevice);
        if (PlantronicsREST.hasActiveDevice) {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null && PlantronicsREST.openDevice()) {
                PlantronicsREST.onPresentCall(isIncomingCall, lineInfo.toString().replace(" ", "%20"));
            }
        } else {
            List<HidDevice> list = this.canOpenHidDevices;
            synchronized (list) {
                for (int i = this.canOpenHidDevices.size() - 1; i >= 0; --i) {
                    HidDevice hidDevice = this.canOpenHidDevices.get(i);
                    if (hidDevice.isClosed()) {
                        hidDevice.open();
                    }
                    if (!hidDevice.isClosed()) {
                        if (!isIncomingCall) continue;
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "open hid device : " + hidDevice);
                        this.sendLEDCommand(hidDevice, true);
                        continue;
                    }
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "hid device : " + hidDevice + " is closed");
                }
            }
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onPresentCall openedDevices.size() =" + this.canOpenHidDevices.size());
    }

    @Override
    public void onConnectedCall() {
        try {
            if (!PlantronicsREST.hasActiveDevice) {
                this.canOpenHidDevices.forEach(hidDevice -> {
                    try {
                        if (!hidDevice.isClosed()) {
                            this.lastConnectedTime = System.currentTimeMillis();
                            this.sendLEDCommand((HidDevice)hidDevice, false);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
            } else {
                LineInfo lineInfo = AudioCaller.getActiveLine();
                PlantronicsREST.onConnectCall(lineInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void sendLEDCommand(HidDevice hidDevice, boolean isRinging) {
        LED_COMMAND ledCommand;
        byte[] bytes = new byte[2];
        LED_COMMAND lED_COMMAND = ledCommand = isRinging ? LED_COMMAND.RING : LED_COMMAND.OFF_HOOK;
        bytes[0] = isRinging ? (this.isCustomBTRelease(hidDevice) ? 4 : (this.isJabraProProduct(hidDevice) ? 24 : (this.isJabraLinkProduct(hidDevice) ? 24 : (byte)(bytes[0] | 4)))) : (this.isCustomBTRelease(hidDevice) ? (this.getReportID(hidDevice) == 5 ? 2 : 1) : (this.isJabraProduct(hidDevice) ? 1 : (this.isYealinkLinkProduct(hidDevice) ? (int)(bytes[0] | 1) : (int)(bytes[0] | 1))));
        this.sendLEDCommand(hidDevice, ledCommand, bytes);
    }

    public void onMute(boolean isMute) {
        this.canOpenHidDevices.forEach(hidDevice -> this.onMute((HidDevice)hidDevice, isMute));
    }

    public void onMute(HidDevice hidDevice, boolean isMute) {
        LineInfo lineInfo = AudioCaller.getActiveLine();
        if (lineInfo != null && (lineInfo.getState() == 1 || lineInfo.getState() == 2)) {
            return;
        }
        if (PlantronicsREST.hasActiveDevice) {
            PlantronicsREST.onMute(isMute);
        } else if (!this.canOpenHidDevices.isEmpty()) {
            LED_COMMAND ledCommand = isMute ? LED_COMMAND.MUTE : LED_COMMAND.UNMUTE;
            byte[] bytes = new byte[64];
            if (isMute) {
                if (this.isCustomBTRelease(hidDevice)) {
                    bytes[0] = this.getReportID(hidDevice) == 5 ? 18 : 3;
                } else if (this.isJabraProduct(hidDevice)) {
                    bytes[0] = 39;
                } else if (this.isYealinkLinkProduct(hidDevice)) {
                    bytes[0] = (byte)(bytes[0] | 1);
                    bytes[0] = (byte)(bytes[0] | 2);
                } else {
                    bytes[0] = (byte)(bytes[0] | 1);
                    bytes[0] = (byte)(bytes[0] | 2);
                    bytes[0] = (byte)(bytes[0] | 0x10);
                }
            } else {
                bytes[0] = this.isCustomBTRelease(hidDevice) ? (this.getReportID(hidDevice) == 5 ? 2 : 1) : (this.isJabraLinkProduct(hidDevice) ? 23 : (byte)(bytes[0] | 1));
            }
            this.sendLEDCommand(hidDevice, ledCommand, bytes);
        }
    }

    public void onHold(boolean isHold) {
        this.canOpenHidDevices.forEach(hidDevice -> this.onHold((HidDevice)hidDevice, isHold));
    }

    private void onHold(HidDevice hidDevice, boolean isHold) {
        if (!this.isYealinkLinkProduct(hidDevice)) {
            return;
        }
        if (!hidDevice.isClosed() && hidDevice.getProduct() != null && !hidDevice.getProduct().startsWith("Yealink BT")) {
            LED_COMMAND ledCommand = isHold ? LED_COMMAND.HOLD : LED_COMMAND.RESUME;
            byte[] bytes = new byte[64];
            bytes[0] = isHold ? (byte)(bytes[0] | 8) : (byte)(bytes[0] | 1);
            this.sendLEDCommand(hidDevice, ledCommand, bytes);
        }
    }

    private void sendLEDCommand(HidDevice hidDevice, LED_COMMAND ledCommand, byte[] command) {
        byte reportId = this.getReportID(hidDevice);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "sendLEDComment reportId = " + reportId + " command = " + ledCommand);
        this.printBytes(command[0]);
        if (!hidDevice.isClosed()) {
            HidDeviceStructure hidDeviceStructure = hidDevice.getHidDeviceStructure();
            int sent = HidApi.write((HidDeviceStructure)hidDeviceStructure, (byte[])command, (int)(ClientUtil.getOS() == ClientUtil.OS.MAC ? 2 : 16), (byte)reportId);
            if (sent == -1) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "sendLEDRing HidApi.write getLastErrorMessage : " + HidApi.getLastErrorMessage((HidDeviceStructure)hidDeviceStructure));
            } else {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "sendLEDRing HidApi.write sent : " + sent);
            }
        }
    }

    public void hidDataReceived(HidServicesEvent event) {
        this.dataReceived(event);
    }

    private synchronized void dataReceived(HidServicesEvent event) {
        HidDevice hidDevice = event.getHidDevice();
        byte[] dataReceived = event.getDataReceived();
        StringBuilder keyData = new StringBuilder();
        if (ClientUtil.getOS() == ClientUtil.OS.MAC && this.isYealinkLinkProduct(hidDevice)) {
            for (byte b : dataReceived) {
                keyData.append(String.format("%02x", b));
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "hidDataReceived 1 keyData=" + keyData + " dataReceived[0]=" + dataReceived[0] + " " + keyData.toString().contains("0200000002010000"));
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "hidDataReceived 2 keyData=" + keyData + " dataReceived[0]=" + dataReceived[0]);
        if (!this.isCustomBTRelease(hidDevice) && dataReceived[0] != 2 && !keyData.toString().startsWith("9b0100009b000000")) {
            return;
        }
        keyData = new StringBuilder();
        for (byte b : dataReceived) {
            keyData.append(String.format("%02x", b));
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "hidDataReceived  dataReceived.length=" + dataReceived.length + " hidDevice=" + hidDevice.getProduct() + " report Id = " + dataReceived[0] + " from " + keyData);
        StringBuilder firstByte = new StringBuilder();
        this.printBytes(dataReceived[1]);
        for (int i = 0; i < 8; ++i) {
            firstByte.append(this.getBit(dataReceived[1], i) ? "1 " : "0 ");
        }
        LineInfo lineInfo = AudioCaller.getIncomingCallLine();
        ClientSingleton.toLog(this.getClass().getSimpleName(), " getIncomingCallLine=" + lineInfo + " isCustomRelease(hidDevice)=" + this.isCustomBTRelease(hidDevice) + " isJabraProduct(hidDevice)=" + this.isJabraProduct(hidDevice) + " isYealinkLinkProduct(hidDevice)=" + this.isYealinkLinkProduct(hidDevice) + " dataReceived[1]=" + dataReceived[1]);
        if (this.isYealinkLinkProduct(hidDevice)) {
            this.yealinkAction(hidDevice, dataReceived, keyData, lineInfo);
        } else if (this.isCustomBTRelease(hidDevice)) {
            this.customBTAction(hidDevice, dataReceived, lineInfo);
        } else if (this.isJabraProduct(hidDevice)) {
            this.jabraAction(hidDevice, dataReceived, keyData, lineInfo);
        } else {
            this.usbHidAction(hidDevice, dataReceived, keyData, firstByte, lineInfo);
        }
    }

    private void usbHidAction(HidDevice hidDevice, byte[] dataReceived, StringBuilder keyData, StringBuilder firstByte, LineInfo lineInfo) {
        if (dataReceived[0] != 2) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), " command =" + keyData + " rejected");
            return;
        }
        if (lineInfo != null) {
            if (this.getBit(dataReceived[1], 0)) {
                this.answerCall(lineInfo);
            }
        } else if (firstByte.toString().startsWith("1 1 1") || dataReceived[1] == 5) {
            this.setMute();
        } else if (!(firstByte.toString().startsWith("1 1") || (lineInfo = AudioCaller.getActiveLine()) == null || (dataReceived[0] != 2 || firstByte.toString().startsWith("1 0 0") || hidDevice.getProduct() == null || "Jabra Evolve 65".equals(hidDevice.getProduct()) || !hidDevice.getProduct().startsWith("Jabra") || firstByte.toString().startsWith("0 0 0 1 0 0 0 0") || firstByte.toString().startsWith("1 0 1 0 0 0 0 0")) && !firstByte.toString().startsWith("0 0 0 0 0 0 0 0"))) {
            this.dropCall(lineInfo);
        }
    }

    private void jabraAction(HidDevice hidDevice, byte[] dataReceived, StringBuilder keyData, LineInfo lineInfo) {
        if (lineInfo != null) {
            if (this.isJabraEngageProduct(hidDevice) && dataReceived[1] == 22) {
                this.answerCall(lineInfo);
            } else if (this.isJabraProProduct(hidDevice) && dataReceived[1] == 8) {
                this.answerCall(lineInfo);
            } else if (dataReceived[1] == 1 || dataReceived[1] == 5) {
                this.answerCall(lineInfo);
            }
        } else if (this.isJabraProProduct(hidDevice)) {
            if (dataReceived[1] == 10) {
                lineInfo = AudioCaller.getActiveLine();
                this.dropCall(lineInfo);
            } else if (dataReceived[1] == 27) {
                this.setMute();
            }
        } else if (dataReceived[1] == 6) {
            lineInfo = AudioCaller.getActiveLine();
            this.dropCall(lineInfo);
        } else if (keyData.toString().contains("020f")) {
            this.setMute();
        }
    }

    private void customBTAction(HidDevice hidDevice, byte[] dataReceived, LineInfo lineInfo) {
        if (lineInfo != null) {
            if (dataReceived[1] == 1) {
                this.answerCall(lineInfo);
            }
        } else if (dataReceived[1] == 0 || dataReceived.length >= 8 && dataReceived[5] == 0) {
            lineInfo = AudioCaller.getActiveLine();
            this.dropCall(lineInfo);
        } else if (dataReceived[1] == 5 || dataReceived[1] == 21 || this.getReportID(hidDevice) == 5 && dataReceived[1] == 1) {
            this.setMute();
        }
    }

    private void yealinkAction(HidDevice hidDevice, byte[] dataReceived, StringBuilder keyData, LineInfo lineInfo) {
        if (lineInfo != null) {
            if (dataReceived[1] == 2 || keyData.toString().startsWith("0200000002010000") || keyData.toString().startsWith("9b0100009b000000")) {
                this.answerCall(lineInfo);
            } else if ("0240000002000000".contentEquals(keyData)) {
                this.dropCall(lineInfo);
            }
        } else {
            lineInfo = AudioCaller.getActiveLine();
            if (!this.yelinkDTMF.isEmpty() && this.yelinkDTMF.containsKey(keyData.toString())) {
                char ch = this.yelinkDTMF.get(keyData.toString()).charValue();
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "send digit : " + ch);
                    clientConnector.sendDigit(ch);
                });
            } else if (dataReceived[1] == 0 || dataReceived.length >= 8 && dataReceived[5] == 0 || "0240000002000000".contentEquals(keyData.toString())) {
                this.dropCall(lineInfo);
            } else if (dataReceived[1] == 9) {
                this.setHold(lineInfo);
            } else if (dataReceived[1] == 5 || dataReceived[1] == 21 || this.getReportID(hidDevice) == 5 && dataReceived[1] == 1) {
                this.setMute();
            }
        }
    }

    private void answerCall(LineInfo lineInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), " AudioCaller.answerCall");
        AudioCaller.answerCall(lineInfo);
    }

    private void dropCall(LineInfo lineInfo) {
        Map localProperties = ClientSingleton.getInstance().getClientConnector().get().getProperties();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "dropCall lineInfo = " + lineInfo + " localProperties.get(Constants.IGNORE_END_CALL)=" + localProperties.get("ignoreEndCall"));
        if (localProperties.get("ignoreEndCall") != null && ((Boolean)localProperties.get("ignoreEndCall")).booleanValue()) {
            return;
        }
        if (this.lastConnectedTime != 0L) {
            long delta = System.currentTimeMillis() - this.lastConnectedTime;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "dropCall delta=" + delta + " ms");
            if (delta < 3000L) {
                return;
            }
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), " AudioCaller.dropCall ");
        this.lastConnectedTime = 0L;
        AudioCaller.dropCall(lineInfo);
    }

    private void setMute() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), " AudioCaller.mute");
        AudioCaller.setMute();
    }

    private void setHold(LineInfo lineInfo) {
        if (lineInfo != null) {
            if (lineInfo.getState() == 3) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), " AudioCaller.hold");
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.holdCall(lineInfo));
            } else if (lineInfo.getState() == 4) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), " AudioCaller.resume");
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.setActiveLine(lineInfo));
            }
        }
    }

    private boolean getBit(byte theByte, int position) {
        return 1 == (theByte >> position & 1);
    }

    private void printBytes(byte byteS) {
        StringBuilder keyData1 = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            keyData1.append(this.getBit(byteS, i) ? "1 " : "0 ");
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "byte info =" + keyData1);
    }

    private boolean isCustomBTRelease(HidDevice hidDevice) {
        return hidDevice.getVendorId() == 13323;
    }

    private byte getReportID(HidDevice hidDevice) {
        if (this.isCustomBTRelease(hidDevice) && (hidDevice.getProductId() == 82 || hidDevice.getProductId() == 68)) {
            return 5;
        }
        return 2;
    }

    private boolean isYealinkLinkProduct(HidDevice hidDevice) {
        return hidDevice != null && hidDevice.getVendorId() == this.decode("0x6993");
    }

    private boolean isPlantronicsPolyProduct(HidDevice hidDevice) {
        return hidDevice != null && hidDevice.getVendorId() == this.decode("0x47f");
    }

    private boolean isJabraLinkProduct(HidDevice hidDevice) {
        return hidDevice != null && hidDevice.getProduct() != null && (hidDevice.getProduct().contains("Jabra Link") || hidDevice.getProduct().contains("Jabra MOTION"));
    }

    private boolean isJabraEngageProduct(HidDevice hidDevice) {
        return hidDevice != null && hidDevice.getProduct() != null && (hidDevice.getProduct().contains("Jabra Engage 55") || hidDevice.getProduct().contains("Jabra Engage 65") || hidDevice.getProduct().contains("Jabra Engage 75") || hidDevice.getProduct().contains("Jabra PRO"));
    }

    private boolean isJabraProProduct(HidDevice hidDevice) {
        return hidDevice != null && hidDevice.getProduct() != null && hidDevice.getProduct().contains("Jabra PRO");
    }

    private boolean isJabraProduct(HidDevice hidDevice) {
        return this.isJabraEngageProduct(hidDevice) || this.isJabraLinkProduct(hidDevice) || this.isJabraProProduct(hidDevice);
    }

    private void startScan() {
        this.stopScan();
        this.down = false;
        this.scanThread = new Thread(() -> {
            while (!this.down) {
                if (AudioCaller.getActiveLine() == null) {
                    this.hidServices.scan();
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.hidServices.removeHidServicesListener((HidServicesListener)this);
            this.hidServices.stop();
        });
        this.scanThread.setPriority(1);
        this.scanThread.setDaemon(true);
        this.scanThread.setName("UsbHidController device scanner");
        this.scanThread.start();
    }

    private void stopScan() {
        this.down = true;
    }

    private void initYelinkNumbers() {
        this.yelinkNumbers.put("0200010002000000", "1");
        this.yelinkNumbers.put("0280010002000000", "2");
        this.yelinkNumbers.put("0200020002000000", "3");
        this.yelinkNumbers.put("0280020002000000", "4");
        this.yelinkNumbers.put("0200030002000000", "5");
        this.yelinkNumbers.put("0280030002000000", "6");
        this.yelinkNumbers.put("0200040002000000", "7");
        this.yelinkNumbers.put("0280040002000000", "8");
        this.yelinkNumbers.put("0200050002000000", "9");
        this.yelinkNumbers.put("0280000002000000", "0");
        this.yelinkNumbers.put("0280050002000000", "*");
        this.yelinkNumbers.put("0200060002000000", "#");
    }

    private void initYelinkDTMF() {
        this.yelinkDTMF.put("0201010002010000", Character.valueOf('1'));
        this.yelinkDTMF.put("0281010002010000", Character.valueOf('2'));
        this.yelinkDTMF.put("0201020002010000", Character.valueOf('3'));
        this.yelinkDTMF.put("0281020002010000", Character.valueOf('4'));
        this.yelinkDTMF.put("0201030002010000", Character.valueOf('5'));
        this.yelinkDTMF.put("0281030002010000", Character.valueOf('6'));
        this.yelinkDTMF.put("0201040002010000", Character.valueOf('7'));
        this.yelinkDTMF.put("0281040002010000", Character.valueOf('8'));
        this.yelinkDTMF.put("0201050002010000", Character.valueOf('9'));
        this.yelinkDTMF.put("0281000002010000", Character.valueOf('0'));
        this.yelinkDTMF.put("0281050002010000", Character.valueOf('*'));
        this.yelinkDTMF.put("0201060002010000", Character.valueOf('#'));
    }

    private void printAttachedDevices() {
        this.hidServices.getAttachedHidDevices().forEach(hidDevice -> ClientSingleton.toLog(this.getClass().getSimpleName(), "AttachedDevice hidDevice: " + hidDevice));
        Mixer.Info[] mixerInfo = AudioSystem.getMixerInfo();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "AudioSystem mixerInfo");
        for (Mixer.Info info : mixerInfo) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), info.getClass().getSimpleName() + " : " + info);
        }
    }

    private static /* synthetic */ void lambda$yealinkAction$7(AtomicReference number, String key, String value) {
        String um = (String)number.get();
        um = um.replace(key, value);
        number.set(um);
    }

    private static enum LED_COMMAND {
        RING,
        OFF_HOOK,
        MUTE,
        UNMUTE,
        HOLD,
        RESUME,
        DISCONNECT;

    }
}

