/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.usb.planctronics_poly;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.usb.planctronics_poly.EventsListenerThread;
import net.sipsnet.client.utils.usb.planctronics_poly.RESTConvenienceClass;
import smile.cti.client.LineInfo;

public class PlantronicsREST {
    static String sessionId = "";
    static boolean pluginRegistered = false;
    static int callid = 0;
    private static EventsListenerThread eventslistener = null;
    static final String PLUGIN_NAME = "Ringotel_Shell_Plantronics_Plugin";
    static final String BASE_URL = "http://127.0.0.1:32017/";
    public static final String TAG = "PlantronicsREST";
    public static boolean DEBUG = false;
    public static boolean hasActiveDevice = false;

    public static boolean openDevice() {
        PlantronicsREST.doAttachDevice();
        if (!sessionId.isEmpty()) {
            PlantronicsREST.doStartEventsListener(sessionId);
        } else {
            ClientSingleton.toLog(TAG, "open Plantronics device error");
            PlantronicsREST.doReleaseDevice();
        }
        return !sessionId.isEmpty();
    }

    public static void closeDevice() {
        ClientSingleton.toLog(TAG, "closeDevice");
        PlantronicsREST.doStopEventsListener();
        sessionId = "";
        PlantronicsREST.doReleaseDevice();
    }

    public static void doShowDeviceInfo() {
        RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/DeviceServices/Info");
    }

    public static void doAttachDevice() {
        String tmpResult = RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/DeviceServices/Attach?uid=0123456789");
        int pos = tmpResult.indexOf("\"Result\":\"");
        if (pos > -1) {
            if ((pos = (tmpResult = tmpResult.substring(pos + 10)).indexOf("\"")) > -1) {
                tmpResult = tmpResult.substring(0, pos);
                ClientSingleton.toLog(TAG, "Session id is: " + tmpResult);
                sessionId = tmpResult;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(PlantronicsREST.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (sessionId.length() > 0) {
                RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/SessionManager/Register?name=Ringotel_Shell_Plantronics_Plugin");
                pluginRegistered = true;
                ClientSingleton.toLog(TAG, "Plugin Plantronics registered");
            }
        } else {
            ClientSingleton.toLog(TAG, "Error: Connecting to Device failed, no Result/session detected in response");
        }
    }

    public static void doReleaseDevice() {
        RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/SessionManager/UnRegister?name=Ringotel_Shell_Plantronics_Plugin");
        pluginRegistered = false;
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PlantronicsREST.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (sessionId.length() > 0) {
            RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/DeviceServices/Release?sess=" + sessionId);
            sessionId = "";
        }
    }

    public static void onPresentCall(boolean isInboundCall, String caller_name) {
        ++callid;
        if (sessionId.length() > 0 && pluginRegistered) {
            RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/CallServices/" + (isInboundCall ? "IncomingCall" : "OutgoingCall") + "?name=Ringotel_Shell_Plantronics_Plugin&callID=%7B%22Id%22%3A%22" + callid + "%22%7D&contact=%7B%22Name%22%3A%22" + caller_name + "%22%7D&route=ToHeadset&tones=Unknown");
        } else {
            ClientSingleton.toLog(TAG, "Error: You need to Attach device first");
        }
    }

    public static void onTerminateCall() {
        if (sessionId.length() > 0 && pluginRegistered) {
            RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/CallServices/TerminateCall?name=Ringotel_Shell_Plantronics_Plugin&callID=%7B%22Id%22%3A%22" + callid + "%22%7D");
        } else {
            ClientSingleton.toLog(TAG, "Error: You need to Attach device first");
        }
    }

    public static void onConnectCall(LineInfo lineInfo) {
        if (sessionId.length() > 0 && pluginRegistered) {
            RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/CallServices/" + (lineInfo.isInbound() ? "AnswerCall" : "ResumeCall") + "?name=Ringotel_Shell_Plantronics_Plugin&callID=%7B%22Id%22%3A%22" + callid + "%22%7D");
        } else {
            ClientSingleton.toLog(TAG, "Error: You need to Attach device");
        }
    }

    public static void doHoldCall() {
        if (sessionId.length() > 0 && pluginRegistered) {
            RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/CallServices/HoldCall?name=Ringotel_Shell_Plantronics_Plugin&callID=%7B%22Id%22%3A%22" + callid + "%22%7D");
        } else {
            ClientSingleton.toLog(TAG, "Error: You need to Attach device");
        }
    }

    public static void onMute(boolean muted) {
        if (sessionId.length() > 0 && pluginRegistered) {
            RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/CallServices/MuteCall?name=Ringotel_Shell_Plantronics_Plugin&muted=" + muted);
        } else {
            ClientSingleton.toLog(TAG, "Error: You need to Attach device first");
        }
    }

    private static void doStartEventsListener(String sessid) {
        if (eventslistener == null) {
            eventslistener = new EventsListenerThread(sessid);
            eventslistener.start();
        }
    }

    private static void doStopEventsListener() {
        if (eventslistener != null) {
            eventslistener.shotDown();
            eventslistener = null;
        }
    }

    private static void doGetCallManagerState() {
        if (sessionId.length() > 0 && pluginRegistered) {
            RESTConvenienceClass.sendRESTCommand("http://127.0.0.1:32017/Spokes/CallServices/CallManagerState");
        } else {
            ClientSingleton.toLog(TAG, "Error: You need to Attach device first");
        }
    }
}

