/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.RichTextViwer;

import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.scene.effect.BlendMode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.utils.viewers.RichTextViwer.Highlight;
import smile.cti.client.ClientConnector;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;

public class InnerTextArea
extends TextArea
implements FileTransferListener {
    private final double NEW_LINE_HEIGHT = 16.0;
    private final double TOP_PADDING = 2.0;
    private final double BOTTOM_PADDING = 2.0;
    private final double TA_HEIGHT = 16.0;
    private final ArrayList<Highlight> highlightArrayList = new ArrayList();
    private int highlightStartPos = -1;
    private int highlightEndPos = -1;
    private final Path highlightPath = new Path();
    private Group selectionGroup;
    private StackPane contentPane;
    private Region textContent;
    private boolean highlightInProgress = false;
    public final int FILE_HIGH_LITE = 0;
    public final int LINK_HIGH_LITE = 1;
    public final int SEARCH_HIGH_LITE = 2;
    private int highlightMode = 0;
    private final Pane parentPane;
    private final Font currentFont;
    private final String textColor;
    private final FileInfo fileInfo;
    private boolean isNeedResize = true;
    private final EventHandler<? super MouseEvent> withPopupMenu;

    public InnerTextArea(FileInfo fileInfo, Pane parentPane, String textColor, boolean isNeedResize, EventHandler<? super MouseEvent> eventHandler) {
        this.parentPane = parentPane;
        this.textColor = textColor;
        this.fileInfo = fileInfo;
        this.isNeedResize = isNeedResize;
        this.withPopupMenu = eventHandler;
        if (this.withPopupMenu != null) {
            this.setTextFormatter(new TextFormatter(change -> {
                change.setAnchor(change.getCaretPosition());
                return change;
            }));
        }
        this.setWrapText(true);
        this.setEditable(false);
        this.currentFont = Font.font((String)"Roboto", (double)12.0);
        this.init();
    }

    private void init() {
        this.setHighlightStyle(0);
        this.highlightPath.setCursor(Cursor.HAND);
        this.highlightPath.setManaged(false);
        this.highlightPath.setStroke(null);
        this.highlightPath.setBlendMode(BlendMode.ADD);
        this.highlightPath.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            Optional<ClientConnector> optionalClientConnector;
            String word = ((Text)this.textContent.lookup(".text")).getText().trim();
            if (word.contains("http:") || word.contains("https:")) {
                ClientSingleton.getInstance().openWebBrowser(word);
            } else if (this.fileInfo != null && (optionalClientConnector = ClientSingleton.getInstance().getClientConnector()).isPresent()) {
                if (this.fileInfo.isLoaded()) {
                    try {
                        File file = optionalClientConnector.get().getFile(this.fileInfo);
                        ClientSingleton.getInstance().openFile(file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.fileInfo.addTransfrerListener((FileTransferListener)this);
                    optionalClientConnector.get().loadFile(this.fileInfo);
                }
            }
        });
        ScrollBar scrollBarv = (ScrollBar)this.lookup(".scroll-bar:vertical");
        if (scrollBarv != null) {
            scrollBarv.setDisable(true);
        }
        this.textProperty().addListener((obs, oldVal, newVal) -> this.removeHighlight());
        this.widthProperty().addListener((obs, oldVal, newVal) -> {
            if (this.highlightStartPos > -1 && this.highlightEndPos > -1 && this.selectionGroup != null) {
                this.highlightInProgress = true;
                this.selectRange(this.highlightStartPos, this.highlightEndPos);
            }
        });
        this.sceneProperty().addListener((observableNewScene, oldScene, newScene) -> {
            if (newScene != null) {
                this.applyCss();
                Node text = this.lookup(".text");
                if (this.withPopupMenu != null) {
                    text.setOnContextMenuRequested(Event::consume);
                    text.addEventHandler(MouseEvent.MOUSE_ENTERED, event -> text.setCursor(Cursor.HAND));
                    text.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> text.setCursor(Cursor.DEFAULT));
                    text.addEventHandler(MouseEvent.MOUSE_PRESSED, this.withPopupMenu);
                }
                if (this.isNeedResize) {
                    this.prefHeightProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                        double height = 2.0 + text.getBoundsInLocal().getHeight() + 2.0;
                        this.setMinHeight(height + 10.0);
                        this.setMaxHeight(height + 10.0);
                        try {
                            this.parentPane.setMinHeight(height + 10.0);
                            this.parentPane.setMaxHeight(height + 10.0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return height;
                    }, (Observable[])new Observable[]{text.boundsInLocalProperty()}));
                    text.boundsInLocalProperty().addListener((observableBoundsAfter, boundsBefore, boundsAfter) -> ClientSingleton.getInstance().runLater(() -> ((InnerTextArea)this).requestLayout()));
                }
            }
        });
    }

    public void highlight(int startPos, int endPos) {
        this.highlightStartPos = startPos;
        this.highlightEndPos = endPos;
        this.highlightInProgress = true;
        this.selectRange(this.highlightStartPos, this.highlightEndPos);
    }

    public void setHighlightStyle(int mode) {
        this.highlightMode = mode;
    }

    public Path getHighlightPath() {
        return this.highlightPath;
    }

    protected void layoutChildren() {
        Region content1;
        super.layoutChildren();
        if ((this.selectionGroup == null || this.contentPane == null) && (content1 = (Region)this.lookup(".content")) != null) {
            this.contentPane = (StackPane)content1.getParent();
            this.textContent = content1;
            this.textContent.getChildrenUnmodifiable().stream().filter(node -> node instanceof Group).map(node -> (Group)node).filter(grp -> {
                boolean notSelectionGroup = grp.getChildren().stream().anyMatch(node -> !(node instanceof Path));
                return !notSelectionGroup;
            }).findFirst().ifPresent(n -> {
                n.boundsInLocalProperty().addListener((obs, old, bil) -> {
                    if (this.highlightInProgress) {
                        this.updateHightlightBounds();
                    }
                });
                this.selectionGroup = n;
            });
        }
    }

    private void updateHightlightBounds() {
        if (!this.selectionGroup.getChildren().isEmpty()) {
            Path p = (Path)this.selectionGroup.getChildren().get(0);
            ArrayList elements = new ArrayList(p.getElements());
            this.highlightPath.getElements().clear();
            this.highlightPath.getElements().addAll(elements);
            Text textNode = (Text)this.textContent.lookup(".text");
            if (this.highlightMode == 1) {
                textNode.setUnderline(true);
            }
            this.highlightPath.setLayoutX(textNode.getLayoutX());
            this.highlightPath.setLayoutY(textNode.getLayoutY());
            if (this.contentPane != null && !this.contentPane.getChildren().contains((Object)this.highlightPath)) {
                this.contentPane.getChildren().add((Object)this.highlightPath);
            }
            this.highlightInProgress = false;
            ClientSingleton.getInstance().runLater(() -> ((InnerTextArea)this).deselect());
        }
    }

    public void removeHighlight() {
        if (this.contentPane != null) {
            this.contentPane.getChildren().remove((Object)this.highlightPath);
        }
        this.highlightStartPos = -1;
        this.highlightEndPos = -1;
    }

    public void transferStarted(FileInfo fileInfo) {
    }

    public void transferProgress(FileInfo fileInfo) {
    }

    public void transferEnded(FileInfo fileInfo) {
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        if (fileInfo.isLoaded()) {
            try {
                File file = ClientSingleton.getInstance().getClientConnector().get().getFile(fileInfo);
                ClientSingleton.getInstance().openFile(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setWhiteBackground() {
        Theme.getInstance().applyTextAreaTo(Theme.WHITE_TEXT_AREA, this);
    }

    public void setAlertBackground() {
        Theme.getInstance().applyTextAreaTo(Theme.ALERT_TEXT_AREA, this);
    }

    public void setReplayBackground() {
        Theme.getInstance().applyTextAreaTo(Theme.REPLY_TEXT_AREA, this);
    }

    public void setOutgoingBackground() {
        Theme.getInstance().applyTextAreaTo(Theme.OUTGOING_TEXT_AREA, this);
    }

    public void setIncomingBackground() {
        Theme.getInstance().applyTextAreaTo(Theme.INCOMING_TEXT_AREA, this);
    }

    public void setCommentBackground() {
        Theme.getInstance().applyTextAreaTo(Theme.COMMENT_TEXT_AREA, this);
    }

    public void setProfileBackground() {
        Theme.getInstance().applyTextAreaTo(Theme.PROFILE_TEXT_AREA, this);
    }

    public StringProperty getTextProperty() {
        return this.textProperty();
    }
}

