/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.avatar;

import java.util.Map;
import java.util.StringTokenizer;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.image.ImageUtil;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class AvatarPane
extends HBox
implements IGUIObservable,
IActionOnRelease {
    private Label labelAvatar;
    private int size = 32;
    private String backgroundColor = "white";
    private int fontSize = 14;
    private String paneId;
    private boolean reload = false;
    private Object objectInfo;
    private HBox innerBox;
    private ImageView fx_ivImageViewer;
    private Image image;

    public AvatarPane setSize(int size) {
        this.size = size;
        return this;
    }

    public AvatarPane setObjectInfo(Object objectInfo) {
        this.objectInfo = objectInfo;
        return this;
    }

    public AvatarPane setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public AvatarPane setDefaultBackgroundColor() {
        if (this.objectInfo != null) {
            this.backgroundColor = AvatarPane.getAvatarBackground(this.objectInfo);
        }
        return this;
    }

    public AvatarPane setFontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public AvatarPane setReload(boolean reload) {
        this.reload = reload;
        return this;
    }

    public AvatarPane() {
    }

    public static AvatarPane getInstance() {
        return new AvatarPane();
    }

    public static AvatarPane getInstance(Object object, int width, String backgroundColor) {
        return new AvatarPane(object, width, backgroundColor);
    }

    public static AvatarPane getInstance(Object object, int width, int fontSize, boolean reload) {
        String color = AvatarPane.getAvatarBackground(object);
        return new AvatarPane(object, width, color, fontSize, reload);
    }

    private static String getAvatarBackground(Object object) {
        if (object == null) {
            return ClientSingleton.getInstance().getStyleValue(Constants.SUBJECT_TEXT_FILL);
        }
        StringBuilder s = new StringBuilder(String.valueOf(Math.abs(object.toString().hashCode())));
        while (s.length() < 6) {
            s.append("1");
        }
        StringBuilder hash = new StringBuilder(s.toString());
        String color = "rgba(1" + hash.charAt(0) + hash.charAt(1) + ",1" + hash.charAt(2) + hash.charAt(3) + ",1" + hash.charAt(4) + hash.charAt(5) + ", 0.5)";
        return color;
    }

    public static AvatarPane getInstance(Object object, int width, String backgroundColor, int fontSize, boolean reload) {
        return new AvatarPane(object, width, backgroundColor, fontSize, reload);
    }

    private AvatarPane(Object object, int size, String backgroundColor) {
        this(object, size, backgroundColor, 15, false);
    }

    private AvatarPane(Object object, int size, String backgroundColor, int fontSize, boolean reload) {
        this.objectInfo = object;
        this.size = size;
        this.backgroundColor = backgroundColor;
        this.fontSize = fontSize;
        this.reload = reload;
        this.setMinWidth(size);
        this.setMaxWidth(size);
        this.build();
    }

    public AvatarPane build() {
        this.addInnerBox();
        if (this.objectInfo instanceof ContactInfo) {
            this.paneId = ClientSingleton.getInstance().getUserID((ContactInfo)this.objectInfo);
        } else if (this.objectInfo instanceof SessionInfo) {
            this.paneId = ((SessionInfo)this.objectInfo).getSessionId();
        }
        this.setLabelView();
        if (this.hasAvatar()) {
            if (this.reload) {
                this.setPreloadImage(this.reload, false);
            } else {
                String avatarId = this.getAvatarId();
                if (avatarId != null) {
                    this.setAvatarImage(avatarId);
                } else {
                    this.loadAvatar();
                }
            }
        }
        return this;
    }

    private void setPreloadImage(boolean withSave, boolean withLoad) {
        MyThreadPoolManager.getInstance().execute(() -> {
            try {
                boolean isSetImage;
                ClientConnector clientConnector = ClientSingleton.getInstance().getClientConnector().get();
                this.createImageView();
                if (withLoad) {
                    if (!ImageUtil.loadAvatar.contains(this.paneId)) {
                        ImageUtil.loadAvatar.add(this.paneId);
                        if (this.objectInfo instanceof ContactInfo) {
                            clientConnector.loadAvatar((ContactInfo)this.objectInfo);
                        } else {
                            clientConnector.loadAvatar((SessionInfo)this.objectInfo);
                        }
                    }
                    ClientSingleton.getInstance().addObserver(this, new String[]{IntentConstants.CONTACT_IMAGE_LOAD, IntentConstants.SESSION_IMAGE_LOAD});
                }
                if (isSetImage = ClientSingleton.getInstance().setPreloadAvatar(this.fx_ivImageViewer, this.objectInfo, this.size, withSave)) {
                    ClientSingleton.getInstance().runLater(this::onSetImageView);
                }
            }
            catch (Exception ex) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "setPreloadImage error : " + ex.getMessage());
            }
        });
    }

    private void createImageView() {
        if (this.fx_ivImageViewer == null) {
            this.fx_ivImageViewer = new ImageView();
            this.fx_ivImageViewer.setSmooth(true);
            this.fx_ivImageViewer.setPreserveRatio(true);
            this.fx_ivImageViewer.setPickOnBounds(true);
        }
    }

    private void setAvatarImage(String id) {
        this.createImageView();
        boolean isSetAvatarImage = ClientSingleton.getInstance().setAvatarImage(this.fx_ivImageViewer, id, this.size, this.size);
        if (isSetAvatarImage) {
            ClientSingleton.getInstance().runLater(this::onSetImageView);
        } else {
            this.setPreloadImage(true, false);
        }
    }

    private void loadAvatar() {
        this.setPreloadImage(!this.reload, true);
    }

    private void onSetImageView() {
        if (this.fx_ivImageViewer == null) {
            return;
        }
        Rectangle clip = new Rectangle(this.fx_ivImageViewer.getFitWidth(), this.fx_ivImageViewer.getFitHeight());
        int ARC_WIDTH = (int)this.fx_ivImageViewer.getFitWidth();
        clip.setArcWidth((double)ARC_WIDTH);
        int ARC_HEIGHT = (int)this.fx_ivImageViewer.getFitHeight();
        clip.setArcHeight((double)ARC_HEIGHT);
        this.fx_ivImageViewer.setClip((Node)clip);
        this.addInnerBox();
        this.innerBox.getChildren().clear();
        this.innerBox.getChildren().add((Object)this.fx_ivImageViewer);
    }

    private void addInnerBox() {
        if (this.innerBox == null) {
            this.innerBox = new HBox();
            this.innerBox.setMaxWidth((double)this.size);
            this.innerBox.setMinWidth((double)this.size);
            this.innerBox.setAlignment(Pos.CENTER_LEFT);
            this.setAlignment(Pos.CENTER);
            this.getChildren().add((Object)this.innerBox);
        }
    }

    public void setLabelView() {
        if (this.fontSize == -1) {
            return;
        }
        ClientSingleton.getInstance().runLater(() -> {
            String chars = this.getContactChars();
            if (this.labelAvatar == null) {
                this.labelAvatar = new Label();
                this.labelAvatar.setMinHeight((double)this.size);
                this.labelAvatar.setMinWidth((double)this.size);
                this.labelAvatar.setAlignment(Pos.CENTER);
            }
            int radius = this.size / 2;
            String stRadius = " " + radius + " " + radius + " " + radius + " " + radius + ";";
            String color = Theme.getInstance().isDarkTheme() ? "white" : "#252b40";
            this.labelAvatar.setStyle("-fx-text-fill: " + color + ";-fx-font-size:" + this.fontSize + ";-fx-border-radius:" + stRadius + "-fx-background-radius:" + stRadius + "-fx-background-color:" + this.backgroundColor + ";");
            this.innerBox.getChildren().clear();
            this.labelAvatar.setText(chars);
            this.innerBox.getChildren().add((Object)this.labelAvatar);
        });
    }

    private boolean hasAvatar() {
        if (this.objectInfo instanceof ContactInfo) {
            return ((ContactInfo)this.objectInfo).hasAvatar();
        }
        if (this.objectInfo instanceof SessionInfo) {
            SessionInfo sessionInfo = (SessionInfo)this.objectInfo;
            if (sessionInfo.hasAvatar()) {
                return true;
            }
            if (sessionInfo.getParties().size() == 1) {
                ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
                return contactInfo.hasAvatar();
            }
        }
        return false;
    }

    public String getAvatarId() {
        String avatarId = null;
        if (this.objectInfo instanceof ContactInfo) {
            if (((ContactInfo)this.objectInfo).hasAvatar()) {
                avatarId = ((ContactInfo)this.objectInfo).getUserID();
            }
        } else if (this.objectInfo instanceof SessionInfo) {
            SessionInfo sessionInfo = (SessionInfo)this.objectInfo;
            if (sessionInfo.hasAvatar()) {
                avatarId = sessionInfo.getSessionId();
            } else if (sessionInfo.getParties().size() == 1) {
                ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
                avatarId = ClientSingleton.getInstance().getUserID(contactInfo);
            }
        }
        return avatarId;
    }

    public String getSessionId() {
        if (this.objectInfo instanceof SessionInfo) {
            SessionInfo sessionInfo = (SessionInfo)this.objectInfo;
            return sessionInfo.getSessionId();
        }
        return null;
    }

    private void removeAvatar(Object objectInfo) throws Exception {
        if (objectInfo instanceof ContactInfo) {
            ClientSingleton.getInstance().removeAvatar(((ContactInfo)objectInfo).getUserID());
        } else {
            ContactInfo contactInfo;
            SessionInfo sessionInfo = (SessionInfo)objectInfo;
            if (sessionInfo.hasAvatar()) {
                ClientSingleton.getInstance().removeAvatar(sessionInfo.getSessionId());
            } else if (sessionInfo.getParties().size() == 1 && (contactInfo = (ContactInfo)sessionInfo.getParties().get(0)).hasAvatar()) {
                ClientSingleton.getInstance().removeAvatar(ClientSingleton.getInstance().getUserID(contactInfo));
            }
        }
    }

    private String getContactChars() {
        StringBuilder ret = new StringBuilder();
        if (this.objectInfo != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.objectInfo.toString(), " ");
            for (int i = 1; tokenizer.hasMoreTokens() && i <= 2; ++i) {
                try {
                    String word = tokenizer.nextToken();
                    char c = '\u0000';
                    for (int index = 0; index < word.length(); ++index) {
                        char c1 = word.charAt(index);
                        if (!Character.isAlphabetic(c1) && !Character.isDigit(c1)) continue;
                        c = c1;
                        break;
                    }
                    if (c == '\u0000') {
                        c = word.charAt(0);
                    }
                    ret.append(String.valueOf(c).toUpperCase());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            ret = new StringBuilder("U");
        }
        return ret.toString();
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        SessionInfo sessionInfo;
        int event;
        if (data.containsKey("contactInfo")) {
            ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
            if (ClientSingleton.getInstance().getUserID(contactInfo).equals(this.paneId)) {
                ImageUtil.loadAvatar.remove(this.paneId);
                String avatarId = this.getAvatarId();
                if (avatarId != null) {
                    ClientSingleton.getInstance().removeAvatar(avatarId);
                    this.createImageView();
                    this.setAvatarImage(avatarId);
                    ClientSingleton.getInstance().removeObserver(this, new String[]{IntentConstants.CONTACT_IMAGE_LOAD, IntentConstants.SESSION_IMAGE_LOAD});
                }
            }
        } else if (data.containsKey(IntentConstants.SESSION_IMAGE_LOAD) && (event = ((Integer)data.get("event")).intValue()) == 3 && (sessionInfo = (SessionInfo)data.get("sessionInfo")).getSessionId().equals(this.paneId)) {
            ImageUtil.loadAvatar.remove(this.paneId);
            String avatarId = this.getAvatarId();
            if (avatarId != null) {
                ClientSingleton.getInstance().removeAvatar(avatarId);
                this.setAvatarImage(avatarId);
                ClientSingleton.getInstance().removeObserver(this, new String[]{IntentConstants.CONTACT_IMAGE_LOAD, IntentConstants.SESSION_IMAGE_LOAD});
            }
        }
    }

    public void setMouseListeners(EventHandler<MouseEvent> mouseEvent) {
        this.innerBox.setOnMouseExited(event -> {
            ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
            this.setSelection(false);
        });
        this.innerBox.setOnMouseEntered(event -> {
            ((Node)event.getSource()).setCursor(Cursor.HAND);
            this.setSelection(true);
        });
        this.innerBox.setOnMouseClicked(mouseEvent);
    }

    private void setSelection(boolean mode) {
        String baseStyle = "-fx-background-color: " + this.backgroundColor + ";-fx-background-insets: 0 0 0 0;-fx-border-insets: 2 2 2 2;-fx-border-radius: " + this.size + " " + this.size + " " + this.size + " " + this.size + ";-fx-background-radius: " + this.size + " " + this.size + " " + this.size + " " + this.size + ";";
        this.innerBox.setStyle(baseStyle + (mode ? "-fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.16), 4, 0, 0, 0);" : ""));
    }

    @Override
    public void onRelease() {
        ClientSingleton.getInstance().removeObserver(this, new String[]{IntentConstants.CONTACT_IMAGE_LOAD, IntentConstants.SESSION_IMAGE_LOAD});
        this.objectInfo = null;
        this.fx_ivImageViewer = null;
        this.image = null;
        this.getChildren().clear();
    }

    public void updateAvatar() {
        String avatarId = this.getAvatarId();
        if (avatarId != null) {
            ClientSingleton.getInstance().removeAvatar(avatarId);
            this.setAvatarImage(avatarId);
        }
    }

    public void setImageView(Image writableImage) {
        this.createImageView();
        this.fx_ivImageViewer.setFitWidth(writableImage.getWidth());
        this.fx_ivImageViewer.setFitHeight(writableImage.getHeight());
        this.fx_ivImageViewer.setImage(writableImage);
        this.onSetImageView();
    }

    public void setImageView(int size, Image writableImage) {
        this.createImageView();
        this.fx_ivImageViewer.setFitWidth((double)size);
        this.fx_ivImageViewer.setFitHeight((double)size);
        this.fx_ivImageViewer.setImage(writableImage);
        this.onSetImageView();
    }
}

