/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.buttoncombobox;

import java.util.ArrayList;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.contextmenu.IMenuActionListener;
import net.sipsnet.client.utils.viewers.contextmenu.MyContextMenu;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;

public class MenuImageButton
extends ImageButton
implements IMenuActionListener {
    private final List<MyPair<String, EventHandler<MouseEvent>>> itemsList = new ArrayList<MyPair<String, EventHandler<MouseEvent>>>();
    private final Stage owner;
    private ICallPanesVisibility iCallPanesVisibility;
    private MyContextMenu myContextMenu;
    private EventHandler<MouseEvent> exitEvent = event -> ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
    private EventHandler<MouseEvent> clickedEvent = event -> {
        if (this.getMyContextMenu() == null) {
            this.createMenu();
        }
        if (!this.getMyContextMenu().isShowing()) {
            if (this.iCallPanesVisibility != null) {
                this.iCallPanesVisibility.setCallPanesVisible();
            }
            this.getMyContextMenu().show((Node)this);
        } else {
            if (this.iCallPanesVisibility != null) {
                this.iCallPanesVisibility.setCallPanesUnVisible();
            }
            this.getMyContextMenu().hide();
        }
        event.consume();
    };

    public void setICallPanesVisibility(ICallPanesVisibility iCallPanesVisibility) {
        this.iCallPanesVisibility = iCallPanesVisibility;
    }

    public MyContextMenu getMyContextMenu() {
        return this.myContextMenu;
    }

    private void createMenu() {
        this.myContextMenu = MyContextMenu.getInstance(false, this.owner);
        for (MyPair<String, EventHandler<MouseEvent>> pair : this.itemsList) {
            if (pair.getColor() != null) {
                this.addMenuItem(pair.getKey(), (EventHandler<MouseEvent>)((EventHandler)pair.getValue()), pair.getColor());
                continue;
            }
            this.addMenuItem(pair.getKey(), (EventHandler<MouseEvent>)((EventHandler)pair.getValue()));
        }
        this.itemsList.clear();
    }

    @Override
    public void setImagePath(String image) {
        super.setImagePath(image);
    }

    public MenuImageButton() {
        this(ClientSingleton.getInstance().getParentWindow());
    }

    public MenuImageButton(Stage owner) {
        this.owner = owner;
        this.setMouseCursor();
    }

    public void clear() {
        if (this.myContextMenu != null) {
            this.myContextMenu.clear();
        }
    }

    public void setDefaultImage() {
        this.setImagePath("buttons/menu.png");
    }

    private void setMouseCursor() {
        super.setOnMouseExitedEvent(this.exitEvent);
        super.setOnMouseClickedEvent(this.clickedEvent);
    }

    @Override
    public void setBackgroundColor(String backgroundColor) {
        super.setBackgroundColor(backgroundColor);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
    }

    public HBox addMenuItem(Object title, EventHandler<MouseEvent> eventHandler) {
        return this.addMenuItem(title, eventHandler, this);
    }

    public HBox addMenuItem(Object title, EventHandler<MouseEvent> eventHandler, String color) {
        return this.myContextMenu.addMenuItem(title, eventHandler, this, color);
    }

    public void addMenuItemToList(String title, EventHandler<MouseEvent> eventHandler) {
        this.itemsList.add(new MyPair(title, eventHandler));
    }

    public void addMenuItemToList(String title, EventHandler<MouseEvent> eventHandler, String color) {
        MyPair myPair = new MyPair(title, eventHandler);
        myPair.setColor(color);
        this.itemsList.add(myPair);
    }

    public void addMenuItem(Object title, IMenuActionListener iMenuActionListener) {
        this.addMenuItem(title, null, iMenuActionListener);
    }

    public HBox addMenuItem(Object title, EventHandler<MouseEvent> eventHandler, IMenuActionListener iMenuActionListener) {
        if (this.getMyContextMenu() == null) {
            this.createMenu();
        }
        return this.myContextMenu.addMenuItem(title, eventHandler, iMenuActionListener);
    }

    public void removeMenuItem(Object title) {
        this.myContextMenu.removeMenuItem(title);
    }

    public void setMenuItemTitle(Object oldTitle, Object newTitle) {
        this.myContextMenu.setMenuItemTitle(oldTitle, newTitle);
    }

    public void addIfAbsentMenuItem(Object title, EventHandler<MouseEvent> eventHandler, IMenuActionListener iMenuActionListener) {
        this.myContextMenu.addIfAbsentMenuItem(title, eventHandler, iMenuActionListener);
    }

    public void addIfAbsentMenuItem(int index, HBox item) {
        this.myContextMenu.addIfAbsentMenuItem(index, item);
    }

    public void removeIfPresentMenuItem(HBox item) {
        this.myContextMenu.removeIfPresentMenuItem(item);
    }

    public boolean isShowing() {
        if (this.myContextMenu != null) {
            return this.myContextMenu.isShowing();
        }
        return false;
    }

    @Override
    public void actionPerformed(Object item) {
    }

    @Override
    public void dropDownHided() {
        if (this.iCallPanesVisibility != null) {
            this.iCallPanesVisibility.setCallPanesUnVisible();
        }
    }

    public void hideMenu() {
        if (this.myContextMenu != null && this.myContextMenu.isShowing()) {
            this.myContextMenu.hide();
        }
        if (this.iCallPanesVisibility != null) {
            this.iCallPanesVisibility.setCallPanesUnVisible();
        }
    }

    @Override
    public void onRelease() {
        super.onRelease();
        this.exitEvent = null;
        this.clickedEvent = null;
        if (this.myContextMenu != null) {
            this.myContextMenu.onRelease();
        }
    }

    class MyPair<T, S>
    extends Pair<String, EventHandler<MouseEvent>> {
        String color;

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public MyPair(String o, EventHandler<MouseEvent> o2) {
            super((Object)o, o2);
            this.color = null;
        }
    }
}

