/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.buttons.labelbutton;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.IActionOnRelease;

public class MyLabelButton
extends HBox
implements IActionOnRelease {
    private SimpleBooleanProperty selectedBackground = new SimpleBooleanProperty(false);
    private SimpleDoubleProperty buttonWidth = new SimpleDoubleProperty((Object)10, "buttonWidth");
    private SimpleIntegerProperty buttonHeight = new SimpleIntegerProperty((Object)10, "buttonHeight");
    private SimpleStringProperty buttonLabelText = new SimpleStringProperty((Object)"", "buttonLabelText");
    private final SimpleStringProperty buttonBackground = new SimpleStringProperty((Object)"", "buttonBackground");
    private final SimpleStringProperty buttonTextFill = new SimpleStringProperty((Object)"", "buttonTextFill");
    private final Label buttonLabel;
    private final String rounded = "-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;";
    private final String unselectButton = "-fx-background-color: #c2c5d2;-fx-text-fill: #646a7e;-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;";
    private ChangeListener<Number> buttonHeightListener = (observable, oldValue, newValue) -> {
        this.setMinHeight(newValue.doubleValue());
        this.setMaxHeight(newValue.doubleValue());
    };
    private ChangeListener<Number> buttonWidthListener = (observable, oldValue, newValue) -> {
        if (newValue.intValue() != -1) {
            this.setMinWidth(newValue.doubleValue());
            this.setMaxWidth(newValue.doubleValue());
        } else {
            this.setMinWidth(0.0);
            this.setMaxWidth(Double.MAX_VALUE);
        }
    };
    private ChangeListener<String> buttonTextListener = (observable, oldValue, newValue) -> {
        try {
            this.initLabel(ClientSingleton.getInstance().getString((String)newValue));
        }
        catch (Exception ex) {
            this.initLabel((String)newValue);
        }
    };
    private final ChangeListener<String> buttonBackgroundListener = (observable, oldValue, newValue) -> this.setStyle((String)newValue);
    private final ChangeListener<String> buttonTextFillListener = (observable, oldValue, newValue) -> this.setTextFill((String)newValue);
    private ChangeListener<Boolean> selectedBackgroundListener = (observable, oldValue, newValue) -> this.setEnabled((boolean)newValue);
    private EventHandler<MouseEvent> actionEvent = null;

    public MyLabelButton() {
        this(false);
    }

    public MyLabelButton(boolean withSelectedSelector) {
        this.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.buttonHeight.addListener(this.buttonHeightListener);
        this.buttonWidth.addListener(this.buttonWidthListener);
        this.buttonLabelText.addListener(this.buttonTextListener);
        this.buttonBackground.addListener(this.buttonBackgroundListener);
        this.buttonTextFill.addListener(this.buttonTextFillListener);
        this.selectedBackground.addListener(this.selectedBackgroundListener);
        this.buttonLabel = new Label();
        if (!withSelectedSelector) {
            ClientSingleton.getInstance().getStyle(Constants.BUTTON_BACKGROUND_STYLE).ifPresent(style -> {
                style = "-fx-text-fill:white;-fx-background-color:" + (String)style + ";-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;";
                this.buttonLabel.setStyle((String)style);
                this.setStyle((String)style);
            });
            this.setMouseCursor();
        } else {
            this.setStyle("-fx-background-color: #c2c5d2;-fx-text-fill: #646a7e;-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;");
            this.buttonLabel.setStyle("-fx-background-color: #c2c5d2;-fx-text-fill: #646a7e;-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;");
        }
    }

    public MyLabelButton(String labelText, int height) {
        this(labelText, height, false);
    }

    public MyLabelButton(String labelText, int height, boolean withSelectedSelector) {
        this(withSelectedSelector);
        this.buttonHeight.set(height);
        this.buttonLabelText.set(labelText);
    }

    private void initLabel(String text) {
        this.buttonLabel.setText(text);
        double width = new Text(text).getLayoutBounds().getWidth();
        this.buttonWidth.set(width + 100.0);
        this.getChildren().clear();
        this.getChildren().add((Object)this.buttonLabel);
    }

    private void setTextFill(String color) {
        this.buttonLabel.setTextFill((Paint)Color.web((String)color));
    }

    public void addMouseEventHandler(EventHandler<MouseEvent> event) {
        this.actionEvent = event;
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.actionEvent);
    }

    public void setMouseCursor() {
        this.setOnMouseExited(event -> ((Node)event.getSource()).setCursor(Cursor.DEFAULT));
        this.setOnMouseEntered(event -> ((Node)event.getSource()).setCursor(Cursor.HAND));
    }

    public double getButtonWidth() {
        return this.buttonWidth.get();
    }

    public SimpleDoubleProperty buttonWidthProperty() {
        return this.buttonWidth;
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth.set((double)buttonWidth);
    }

    public int getButtonHeight() {
        return this.buttonHeight.get();
    }

    public SimpleIntegerProperty buttonHeightProperty() {
        return this.buttonHeight;
    }

    public void setButtonHeight(int buttonHeight) {
        this.buttonHeight.set(buttonHeight);
    }

    public String getButtonLabelText() {
        return this.buttonLabelText.get();
    }

    public SimpleStringProperty buttonLabelTextProperty() {
        return this.buttonLabelText;
    }

    public void setButtonLabelText(String buttonLabelText) {
        this.buttonLabelText.set(buttonLabelText);
    }

    public void setButtonBackground(String background) {
        this.buttonBackground.set(background);
    }

    public void setButtonTextFill(String buttonTextFill) {
        this.buttonTextFill.set(buttonTextFill);
    }

    public void setSelectedBackground(boolean selectedBackground) {
        this.selectedBackground.set(selectedBackground);
    }

    public void setEnabled(boolean newValue) {
        if (newValue) {
            ClientSingleton.getInstance().getStyle(Constants.BUTTON_BACKGROUND_STYLE).ifPresent(style -> {
                style = "-fx-text-fill:white;-fx-background-color:" + (String)style + ";-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;";
                this.buttonLabel.setStyle((String)style);
                this.setStyle((String)style);
            });
            this.setMouseCursor();
        } else {
            this.setStyle("-fx-background-color: #c2c5d2;-fx-text-fill: #646a7e;-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;");
            this.buttonLabel.setStyle("-fx-background-color: #c2c5d2;-fx-text-fill: #646a7e;-fx-border-radius: 12 12 12 12;-fx-background-radius: 12 12 12 12;");
            this.removeMouseListeners();
        }
    }

    public boolean isSelectedBackground() {
        return this.selectedBackground.get();
    }

    @Override
    public void onRelease() {
        this.buttonHeight.removeListener(this.buttonHeightListener);
        this.buttonWidth.removeListener(this.buttonWidthListener);
        this.buttonLabelText.removeListener(this.buttonTextListener);
        this.buttonBackground.removeListener(this.buttonBackgroundListener);
        this.buttonTextFill.removeListener(this.buttonTextFillListener);
        this.selectedBackground.removeListener(this.selectedBackgroundListener);
        this.buttonHeight = null;
        this.buttonWidth = null;
        this.buttonLabelText = null;
        this.selectedBackground = null;
        this.selectedBackgroundListener = null;
        this.buttonHeightListener = null;
        this.buttonWidthListener = null;
        this.buttonTextListener = null;
        this.removeMouseListeners();
        this.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.actionEvent);
    }

    public void removeMouseListeners() {
        this.setOnMouseExited(null);
        this.setOnMouseEntered(null);
    }

    public boolean isEnabled() {
        return this.selectedBackground.get();
    }
}

