/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.combobox;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Stage;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.contextmenu.IMenuActionListener;
import net.sipsnet.client.utils.viewers.contextmenu.MyContextMenu;

public class MyComboBox
extends HBox
implements IMenuActionListener,
IActionOnRelease {
    private Pos arrowPosition = Pos.CENTER_LEFT;
    private String backgroundColor = "transparent";
    private Pane component;
    private ImageView comboBoxArrow;
    private boolean isRoundedCorners = true;
    private int width = 40;
    private int height = 25;
    private ImageView imageView;
    private StackPane stackPane;
    private boolean isShowEnabled = true;
    private MyContextMenu myContextMenu;
    private Label checkMenuLabel;
    private String NOT_FOCUSED_STYLE = "";
    private String FOCUSED_STYLE = "";
    private EventHandler<MouseEvent> mouseEventHandler = event -> {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "mouseEventHandler isShowEnabled=" + this.isShowEnabled + " myContextMenu.isShowing()=" + this.myContextMenu.isShowing());
        if (this.myContextMenu.isShowing()) {
            this.myContextMenu.hide();
        } else if (this.isShowEnabled) {
            TimerExecutor.getInstance().setMyAction(() -> this.myContextMenu.show((Node)this)).startWithDelayInGUIThread(100L);
        }
    };
    private final EventHandler<MouseEvent> mouseEntered = event -> ((Node)event.getSource()).setCursor(Cursor.HAND);
    private EventHandler<MouseEvent> mouseExited = event -> {
        if (!this.myContextMenu.isShowing()) {
            ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
        }
    };

    public boolean isRoundedCorners() {
        return this.isRoundedCorners;
    }

    public MyComboBox setShowEnabled(boolean showEnabled) {
        this.isShowEnabled = showEnabled;
        return this;
    }

    public void setRemoveComboBoxArrowArrow() {
        this.isShowEnabled = false;
        this.stackPane.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.stackPane.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.stackPane.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        this.stackPane.getChildren().remove((Object)this.comboBoxArrow);
        this.checkMenuLabel.setAlignment(Pos.CENTER_LEFT);
    }

    public MyComboBox setWidth(int width) {
        this.width = width;
        return this;
    }

    public MyComboBox setHeight(int height) {
        this.height = height;
        return this;
    }

    public Pos getArrowPosition() {
        return this.arrowPosition;
    }

    public MyComboBox setArrowPosition(Pos arrowPosition) {
        this.arrowPosition = arrowPosition;
        return this;
    }

    public MyComboBox setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setMenuStyle();
        return this;
    }

    public MyComboBox setRoundedCorners(boolean roundedCorners) {
        this.isRoundedCorners = roundedCorners;
        this.setMenuStyle();
        return this;
    }

    public void setNotFocusedStyle() {
        this.setStyle(this.NOT_FOCUSED_STYLE);
    }

    public static MyComboBox getInstance() {
        return new MyComboBox(ClientSingleton.getInstance().getParentWindow());
    }

    public static MyComboBox getInstance(Stage owner) {
        return new MyComboBox(owner);
    }

    public void setElementId(String elementId) {
        if (this.myContextMenu != null) {
            this.myContextMenu.setElementId(elementId);
        }
    }

    public MyComboBox() {
        this(ClientSingleton.getInstance().getParentWindow());
    }

    public MyComboBox(Stage owner) {
        this.setAlignment(Pos.CENTER_LEFT);
        this.myContextMenu = MyContextMenu.getInstance(true, owner);
        this.myContextMenu.addIMenuActionListener(this);
        this.myContextMenu.removeScrollBar();
        ClientSingleton.getInstance().getStyle(Constants.TABS_SEARCH_BACKGROUND).ifPresent(this::setBackgroundColor);
    }

    public MyComboBox build() {
        this.setPrefWidth(this.width);
        this.setPrefHeight(this.height);
        this.setMaxHeight(this.height);
        this.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.initComponents();
        this.setMenuStyle();
        return this;
    }

    public MyComboBox setExtraBackgroundColor() {
        this.myContextMenu.setExtraBackgroundColor(this.backgroundColor);
        return this;
    }

    public int getSelectedIndex() {
        return this.myContextMenu.getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.myContextMenu.getSelectedItem();
    }

    public void setSelectedItem(Object title) {
        if (title == null) {
            return;
        }
        this.myContextMenu.setSelectedItem(title);
        ClientSingleton.getInstance().runLater(() -> {
            if (this.checkMenuLabel == null) {
                this.initComponents();
                this.checkMenuLabel.setText(title.toString());
            } else {
                this.checkMenuLabel.setText(title.toString());
            }
        });
    }

    public void changeLabel(String title) {
        this.checkMenuLabel.setText(title);
    }

    public void addMenuItem(Object title, EventHandler eventHandler) {
        this.addMenuItem(title, eventHandler, null);
    }

    public void addMenuItem(Object title, IMenuActionListener IMenuActionListener2) {
        this.addMenuItem(title, null, IMenuActionListener2);
    }

    public void addMenuItem(Object title, EventHandler eventHandler, IMenuActionListener IMenuActionListener2) {
        this.myContextMenu.addMenuItem(title, (EventHandler<MouseEvent>)eventHandler, IMenuActionListener2);
    }

    public void addItemsList(List<?> items) {
        this.myContextMenu.addItemsList(items, this, false);
    }

    public void addItemsList(List<?> items, boolean withResize) {
        this.myContextMenu.addItemsList(items, this, withResize);
    }

    public void addItemsList(List<?> items, IMenuActionListener iMenuActionListener, boolean withResize) {
        this.myContextMenu.addItemsList(items, iMenuActionListener, withResize);
    }

    private void initComponents() {
        if (this.stackPane != null) {
            return;
        }
        this.stackPane = new StackPane();
        this.checkMenuLabel = new Label();
        VBox.setVgrow((Node)this.stackPane, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.stackPane, (Priority)Priority.ALWAYS);
        this.checkMenuLabel.setAlignment(Pos.CENTER);
        this.checkMenuLabel.prefHeightProperty().bind((ObservableValue)this.stackPane.heightProperty().subtract(20));
        this.checkMenuLabel.prefWidthProperty().bind((ObservableValue)this.stackPane.widthProperty().subtract(10));
        this.checkMenuLabel.setTextFill((Paint)Color.web((String)"#969aae"));
        this.stackPane.getChildren().add((Object)this.checkMenuLabel);
        StackPane.setAlignment((Node)this.checkMenuLabel, (Pos)Pos.CENTER);
        if (this.component != null) {
            this.stackPane.getChildren().add((Object)this.component);
            StackPane.setMargin((Node)this.component, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
            StackPane.setAlignment((Node)this.component, (Pos)Pos.CENTER_LEFT);
        }
        if (this.isShowEnabled) {
            this.stackPane.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
            this.stackPane.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
            this.stackPane.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
            this.comboBoxArrow = this.getArrowHBox();
            StackPane.setMargin((Node)this.comboBoxArrow, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
            this.stackPane.getChildren().add((Object)this.comboBoxArrow);
            StackPane.setAlignment((Node)this.comboBoxArrow, (Pos)(this.arrowPosition == Pos.CENTER_LEFT ? Pos.CENTER_LEFT : Pos.CENTER_RIGHT));
        }
        this.getChildren().add((Object)this.stackPane);
    }

    public MyComboBox addStateLabel(Pane pane) {
        this.component = pane;
        return this;
    }

    public void setLabelAlignment(Pos position) {
        if (this.checkMenuLabel != null) {
            this.checkMenuLabel.setAlignment(position);
        }
    }

    public void setLabelForegroundColor(String color) {
        if (this.checkMenuLabel != null) {
            this.checkMenuLabel.setTextFill((Paint)Color.web((String)color));
        }
    }

    public void setLabelFont(Font font) {
        if (this.checkMenuLabel != null) {
            this.checkMenuLabel.setFont(font);
        }
    }

    public MyComboBox setLabelStyle(String style) {
        if (this.checkMenuLabel != null) {
            this.checkMenuLabel.setStyle(style);
        }
        return this;
    }

    public void setArrowRightMargin(int margin) {
        if (this.imageView != null) {
            StackPane.setMargin((Node)this.imageView, (Insets)new Insets(0.0, (double)margin, 0.0, 0.0));
        }
    }

    public void setArrowLeftMargin(int margin) {
        if (this.imageView != null) {
            StackPane.setMargin((Node)this.imageView, (Insets)new Insets(0.0, 0.0, 0.0, (double)margin));
        }
    }

    private ImageView getArrowHBox() {
        this.imageView = new ImageView();
        this.imageView.setStyle("-fx-background-color: transparent");
        ClientSingleton.getInstance().setImageToImageView(this.imageView, "buttons/arrow_down.png");
        this.imageView.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.imageView.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.imageView.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        return this.imageView;
    }

    @Override
    public void actionPerformed(Object item) {
        this.checkMenuLabel.setText(item.toString());
        this.myContextMenu.hide();
    }

    public void hide() {
        this.myContextMenu.hide();
    }

    @Override
    public void dropDownHided() {
        this.setStyle(this.NOT_FOCUSED_STYLE);
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    private void setMenuStyle() {
        int radius = this.isRoundedCorners ? 10 : 0;
        String border = "-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + "; -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + "; ";
        this.NOT_FOCUSED_STYLE = border + "-fx-background-color:" + this.backgroundColor + ";";
        this.FOCUSED_STYLE = border + "-fx-background-insets: 0 0 0 0;-fx-background-color:" + this.backgroundColor + ";-fx-effect: dropshadow(three-pass-box, #656a7c, 4, 0, 0, 0);";
    }

    @Override
    public void onRelease() {
        if (this.myContextMenu != null) {
            this.myContextMenu.onRelease();
        }
        if (this.stackPane != null) {
            this.stackPane.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
            this.stackPane.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
            this.stackPane.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        }
        if (this.imageView != null) {
            this.imageView.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
            this.imageView.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
            this.imageView.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        }
        this.mouseEventHandler = null;
        this.mouseExited = null;
    }

    public void setPopUpWidth(int width) {
        if (this.myContextMenu != null) {
            this.myContextMenu.setWidth(width);
        }
    }

    public void clearePopUp() {
        if (this.myContextMenu != null) {
            this.myContextMenu.clear();
        }
    }

    public String get() {
        if (this.myContextMenu != null) {
            this.myContextMenu.get();
        }
        return "null";
    }
}

