/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.combobox;

import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.combobox.IContextMenuActionListener;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.utils.viewers.contextmenu.IMenuActionListener;

public class MyContextComboBox
extends HBox
implements IMenuActionListener,
IActionOnRelease {
    private Pos arrowPosition = Pos.CENTER_LEFT;
    private String backgroundColor = "#f3f4f7";
    private int selectedIndex;
    private String selectedItem;
    private boolean isRoundedCorners = true;
    private int width = 40;
    private int height = 20;
    private ImageView imageView;
    private HBox hBox;
    private ContextMenu myContextMenu;
    private Label checkMenuLabel;
    private String NOT_FOCUSED_STYLE = "";
    private String FOCUSED_STYLE = "";
    private EventHandler<MouseEvent> mouseEventHandler = event -> {
        if (this.myContextMenu.isShowing()) {
            this.myContextMenu.hide();
            this.setStyle(this.NOT_FOCUSED_STYLE);
        } else {
            this.setStyle(this.FOCUSED_STYLE);
            Bounds boundsInScene = this.localToScreen(this.getBoundsInLocal());
            this.myContextMenu.show((Node)this, boundsInScene.getMinX(), boundsInScene.getMaxY());
        }
    };
    private final EventHandler<MouseEvent> mouseEntered = event -> {
        ((Node)event.getSource()).setCursor(Cursor.HAND);
        this.setStyle(this.FOCUSED_STYLE);
    };
    private EventHandler<MouseEvent> mouseExited = event -> {
        if (!this.myContextMenu.isShowing()) {
            ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
            this.setStyle(this.NOT_FOCUSED_STYLE);
        }
    };

    public boolean isRoundedCorners() {
        return this.isRoundedCorners;
    }

    public void setElementId(String elementId) {
        if (this.myContextMenu != null) {
            this.myContextMenu.setId(elementId);
        }
    }

    public MyContextComboBox setWidth(int width) {
        this.width = width;
        return this;
    }

    public MyContextComboBox setHeight(int height) {
        this.height = height;
        return this;
    }

    public MyContextComboBox setArrowPosition(Pos arrowPosition) {
        this.arrowPosition = arrowPosition;
        return this;
    }

    public MyContextComboBox setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.setMenuStyle();
        this.setStyle(this.NOT_FOCUSED_STYLE);
        return this;
    }

    public MyContextComboBox setRoundedCorners(boolean roundedCorners) {
        this.isRoundedCorners = roundedCorners;
        this.setMenuStyle();
        this.setStyle(this.NOT_FOCUSED_STYLE);
        return this;
    }

    public static MyContextComboBox getInstance() {
        return new MyContextComboBox();
    }

    public MyContextComboBox() {
        this.setAlignment(Pos.CENTER_LEFT);
        this.myContextMenu = new MaxSizedContextMenu();
        this.myContextMenu.setMaxHeight(300.0);
    }

    public MyContextComboBox build() {
        this.setPrefWidth(this.width);
        this.setPrefHeight(this.height);
        this.setMaxHeight(this.height);
        this.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.initComponents();
        this.setMenuStyle();
        this.setStyle(this.NOT_FOCUSED_STYLE);
        return this;
    }

    public void setSelectedItem(Object title) {
        if (this.checkMenuLabel == null) {
            ClientSingleton.getInstance().runLater(() -> {
                this.initComponents();
                this.checkMenuLabel.setText(title.toString());
            });
        } else {
            this.checkMenuLabel.setText(title.toString());
        }
        this.selectedItem = title.toString();
    }

    public void addItemsListToMenu(List<?> titles, IContextMenuActionListener iContextMenuActionListener) {
        for (int i = 0; i < titles.size(); ++i) {
            Object title = titles.get(i);
            if (i == 0) {
                this.selectedIndex = 0;
                this.selectedItem = title.toString();
            }
            MenuItem menuItem = new MenuItem(title.toString());
            menuItem.setId(String.valueOf(i));
            menuItem.setOnAction(eventHandler -> {
                MenuItem menuItem1 = (MenuItem)eventHandler.getSource();
                this.setSelectedItem(menuItem1.getText());
                this.selectedIndex = Integer.parseInt(menuItem1.getId());
                iContextMenuActionListener.actionPerformed(menuItem1.getText(), this.selectedIndex);
            });
            this.myContextMenu.getItems().add((Object)menuItem);
        }
    }

    private void initComponents() {
        this.hBox = new HBox();
        this.hBox.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.hBox.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.hBox.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        this.hBox.setAlignment(Pos.CENTER);
        this.checkMenuLabel = new Label();
        VBox.setVgrow((Node)this.hBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.hBox, (Priority)Priority.ALWAYS);
        this.hBox.getChildren().add((Object)this.checkMenuLabel);
        this.checkMenuLabel.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.checkMenuLabel.setMaxHeight(20.0);
        this.checkMenuLabel.setMinWidth(20.0);
        this.checkMenuLabel.setStyle("-fx-text-fill: #969aae;-fx-font-size: 11px;");
        ImageView imageView = this.getArrowHBox();
        if (this.arrowPosition == Pos.CENTER_LEFT) {
            this.getChildren().add((Object)imageView);
        }
        this.getChildren().addAll((Object[])new Node[]{this.hBox});
        if (this.arrowPosition != Pos.CENTER_LEFT) {
            this.getChildren().add((Object)imageView);
        }
    }

    private ImageView getArrowHBox() {
        this.imageView = new ImageView();
        this.imageView.setStyle("-fx-background-color: white");
        this.imageView.setFitWidth(10.0);
        this.imageView.setFitHeight(6.0);
        ClientSingleton.getInstance().setImageToImageView(this.imageView, "buttons/arrow_down.png");
        this.imageView.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.imageView.addEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.imageView.addEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        HBox.setMargin((Node)this.imageView, (Insets)new Insets(0.0, 3.0, 0.0, 5.0));
        return this.imageView;
    }

    @Override
    public void actionPerformed(Object item) {
        this.checkMenuLabel.setText(item.toString());
        this.myContextMenu.hide();
        this.setStyle(this.NOT_FOCUSED_STYLE);
    }

    public void hide() {
        this.setStyle(this.NOT_FOCUSED_STYLE);
        this.myContextMenu.hide();
    }

    @Override
    public void dropDownHided() {
        this.setStyle(this.NOT_FOCUSED_STYLE);
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    private void setMenuStyle() {
        int radius = this.isRoundedCorners ? 10 : 0;
        String border = "-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + "; -fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + "; ";
        this.NOT_FOCUSED_STYLE = border + "-fx-background-color:" + this.backgroundColor + ";";
        this.FOCUSED_STYLE = border + "-fx-background-insets: 0 0 0 0;-fx-background-color:" + this.backgroundColor + ";-fx-effect: dropshadow(three-pass-box, #656a7c, 4, 0, 0, 0);";
    }

    @Override
    public void onRelease() {
        if (this.myContextMenu != null) {
            this.myContextMenu.getItems().clear();
        }
        this.hBox.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.hBox.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.hBox.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        this.imageView.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.imageView.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
        this.imageView.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        this.mouseEventHandler = null;
        this.mouseEventHandler = null;
        this.mouseExited = null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public void setEditable(boolean mode) {
        if (!mode) {
            this.hBox.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
            this.hBox.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
            this.hBox.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
            this.imageView.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
            this.imageView.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.mouseEntered);
            this.imageView.removeEventHandler(MouseEvent.MOUSE_EXITED, this.mouseExited);
        }
    }
}

