/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.label;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.utils.viewers.IActionOnRelease;

public class MyLabel
extends HBox
implements IActionOnRelease {
    private FontWeight currentWeight = FontWeight.NORMAL;
    private final String underlinedStyle = " -fx-border-color: #969aae;    -fx-border-width: 0 0 1 0;    -fx-background-color: transparent;";
    private final String notUnderLinedStyle = "    -fx-border-width: 0 0 0 0;     -fx-background-color: transparent;";
    private final int radius = 7;
    private String unselectedStyle = "-fx-border-radius: 0 0 0 0; -fx-background-radius: 0 0 0 0 ; -fx-background-color: transparent;";
    private boolean isSelected;
    private SimpleIntegerProperty labelFontSize = new SimpleIntegerProperty((Object)12, "labelFontSize");
    private SimpleStringProperty labelFontFamily = new SimpleStringProperty((Object)"Arial", "labelFontFamily");
    private SimpleStringProperty labelFontColor = new SimpleStringProperty((Object)"gray", "labelFontColor");
    private SimpleIntegerProperty labelMarginLeft = new SimpleIntegerProperty((Object)0, "labelMarginLeft");
    private SimpleIntegerProperty labelMarginRight = new SimpleIntegerProperty((Object)0, "labelMarginRight");
    private final SimpleStringProperty text = new SimpleStringProperty((Object)"", "text");
    private SimpleBooleanProperty isUnderline = new SimpleBooleanProperty((Object)false, "isUnderline");
    private final SimpleBooleanProperty withRightBorder = new SimpleBooleanProperty((Object)false, "withRightBorder");
    private final SimpleStringProperty backgroundColor = new SimpleStringProperty((Object)"transparent", "backgroundColor");
    private final SimpleBooleanProperty isRounded = new SimpleBooleanProperty((Object)false, "isRounded");
    private final Label label = new Label();
    private ChangeListener<Number> marginLeftListener = (observable, oldValue, newValue) -> HBox.setMargin((Node)this.label, (Insets)new Insets(0.0, (double)this.getLabelMarginRight(), 0.0, (double)newValue.intValue()));
    private ChangeListener<Number> marginRightListener = (observable, oldValue, newValue) -> HBox.setMargin((Node)this.label, (Insets)new Insets(0.0, (double)newValue.intValue(), 0.0, (double)this.getLabelMarginLeft()));
    private ChangeListener<Number> fontSizeListener = (observable, oldValue, newValue) -> this.label.setFont(Font.font((String)this.getLabelFontFamily(), (FontWeight)this.currentWeight, (double)newValue.intValue()));
    private ChangeListener<String> fontFamilyListener = (observable, oldValue, newValue) -> this.label.setFont(Font.font((String)newValue, (FontWeight)this.currentWeight, (double)this.getLabelFontSize()));
    private ChangeListener<String> fontColorListener = (observable, oldValue, newValue) -> this.label.setStyle("-fx-text-fill:" + newValue + ";");
    private ChangeListener<Boolean> underlineListener = (observable, oldValue, newValue) -> {
        if (newValue.booleanValue()) {
            this.label.setStyle(this.getUnSelectedStyle());
        } else {
            this.label.setStyle(this.getUnSelectedStyle());
        }
    };
    private final ChangeListener<Boolean> withRightBorderListener = (observable, oldValue, newValue) -> this.setStyle(this.getUnSelectedStyle());
    private final ChangeListener<Boolean> isRoundedListener = (observable, oldValue, newValue) -> this.setStyle(this.getUnSelectedStyle());
    private final ChangeListener<String> backgroundColorListener = (observable, oldValue, newValue) -> this.setStyle(this.getUnSelectedStyle());
    private final ChangeListener<String> textListener = (observable, oldValue, newValue) -> ClientSingleton.getInstance().runLater(() -> {
        try {
            this.label.setText(ClientSingleton.getInstance().getString((String)newValue));
        }
        catch (Exception ex) {
            this.label.setText(newValue);
        }
    });
    private EventHandler<MouseEvent> mouseEventHandler;

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setCurrentWeight(FontWeight currentWeight) {
        this.currentWeight = currentWeight;
    }

    public void setSelectedStyle(boolean isSelected) {
        if (isSelected) {
            if (this.isUnderline.get()) {
                this.label.setStyle("    -fx-border-width: 0 0 0 0;     -fx-background-color: transparent;");
            }
            this.label.setStyle("-fx-text-fill:#ffffff;");
        } else {
            this.label.setStyle(null);
            if (this.isUnderline.get()) {
                this.label.setStyle(" -fx-border-color: #969aae;    -fx-border-width: 0 0 1 0;    -fx-background-color: transparent;");
            }
            this.label.setStyle("-fx-text-fill:" + this.getLabelFontColor() + ";");
        }
        this.isSelected = isSelected;
        Theme.getInstance().applyTabCellTo((Pane)this, isSelected);
    }

    public String getUnSelectedStyle() {
        this.unselectedStyle = (this.isIsRounded() ? "-fx-border-radius: 7 7 7 7; -fx-background-radius: 7 7 7 7; " : "-fx-border-radius: 0 0 0 0; -fx-background-radius: 0 0 0 0 ; ") + "-fx-background-color: " + this.getBackgroundColor() + ";" + (this.isWithRightBorder() ? "-fx-padding:0 10 0 0; -fx-border-color: #969aae;-fx-border-width: 0 1 0 0;" : "");
        return this.unselectedStyle;
    }

    public void setUnderlinedStyle() {
        this.label.setStyle(" -fx-border-color: #969aae;    -fx-border-width: 0 0 1 0;    -fx-background-color: transparent;");
    }

    public Label getLabel() {
        return this.label;
    }

    public void addMouseEventHandler(EventHandler<MouseEvent> event) {
        this.mouseEventHandler = event;
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventHandler);
        this.label.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventHandler);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        ClientSingleton.getInstance().setMouseCursor((Node)this.label);
    }

    public MyLabel() {
        this.labelMarginLeft.addListener(this.marginLeftListener);
        this.labelMarginRight.addListener(this.marginRightListener);
        this.labelFontSize.addListener(this.fontSizeListener);
        this.labelFontFamily.addListener(this.fontFamilyListener);
        this.labelFontColor.addListener(this.fontColorListener);
        this.isUnderline.addListener(this.underlineListener);
        this.withRightBorder.addListener(this.withRightBorderListener);
        this.isRounded.addListener(this.isRoundedListener);
        this.backgroundColor.addListener(this.backgroundColorListener);
        this.text.addListener(this.textListener);
        this.backgroundColor.set("transparent");
        this.label.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.label.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.label.setAlignment(Pos.CENTER);
        this.getChildren().add((Object)this.label);
        this.setStyle(this.getUnSelectedStyle());
    }

    public void bindLabel(int subtract) {
        this.label.prefHeightProperty().unbind();
        this.label.prefWidthProperty().unbind();
        this.label.setPrefHeight((double)subtract);
        this.label.setPrefWidth((double)subtract);
        this.label.setMaxHeight((double)subtract);
        this.label.setMaxWidth((double)subtract);
    }

    public void setTextAlignment(Pos alignment) {
        this.label.setAlignment(alignment);
    }

    public void setLabelStyle(String style) {
        this.label.setStyle(style);
    }

    public String getText() {
        return this.text.get();
    }

    public SimpleStringProperty textProperty() {
        return this.text;
    }

    public void setText(String textLabel) {
        this.text.set(textLabel);
    }

    public void setMinWidthByText() {
        Text labelText = new Text(this.text.get());
        labelText.setFont(this.label.getFont());
        double width = labelText.getLayoutBounds().getWidth();
        this.setPrefWidth(width);
    }

    public void setLabelStyleClass(String style) {
        this.label.getStyleClass().add((Object)style);
    }

    public String getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public SimpleStringProperty backgroundColorProperty() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor.set(backgroundColor);
    }

    public boolean isIsRounded() {
        return this.isRounded.get();
    }

    public SimpleBooleanProperty isRoundedProperty() {
        return this.isRounded;
    }

    public void setIsRounded(boolean isRounded) {
        this.isRounded.set(isRounded);
    }

    public int getLabelMarginLeft() {
        return this.labelMarginLeft.get();
    }

    public SimpleIntegerProperty labelMarginLeftProperty() {
        return this.labelMarginLeft;
    }

    public void setLabelMarginLeft(int labelMarginLeft) {
        this.labelMarginLeft.set(labelMarginLeft);
    }

    public int getLabelMarginRight() {
        return this.labelMarginRight.get();
    }

    public SimpleIntegerProperty labelMarginRightProperty() {
        return this.labelMarginRight;
    }

    public void setLabelMarginRight(int labelMarginRight) {
        this.labelMarginRight.set(labelMarginRight);
    }

    public int getLabelFontSize() {
        return this.labelFontSize.get();
    }

    public SimpleIntegerProperty labelFontSizeProperty() {
        return this.labelFontSize;
    }

    public void setLabelFontSize(int labelFontSize) {
        this.labelFontSize.set(labelFontSize);
    }

    public String getLabelFontFamily() {
        return this.labelFontFamily.get();
    }

    public SimpleStringProperty labelFontFamilyProperty() {
        return this.labelFontFamily;
    }

    public void setLabelFontFamily(String labelFontFamily) {
        this.labelFontFamily.set(labelFontFamily);
    }

    public String getLabelFontColor() {
        return this.labelFontColor.get();
    }

    public SimpleStringProperty labelFontColorProperty() {
        return this.labelFontColor;
    }

    public void setLabelFontColor(String labelFontColor) {
        this.labelFontColor.set(labelFontColor);
    }

    public boolean isIsUnderline() {
        return this.isUnderline.get();
    }

    public SimpleBooleanProperty isUnderlineProperty() {
        return this.isUnderline;
    }

    public void setIsUnderline(boolean isUnderline) {
        this.isUnderline.set(isUnderline);
    }

    public boolean isWithRightBorder() {
        return this.withRightBorder.get();
    }

    public SimpleBooleanProperty withRightBorderProperty() {
        return this.withRightBorder;
    }

    public void setWithRightBorder(boolean withRightBorder) {
        this.withRightBorder.set(withRightBorder);
    }

    @Override
    public void onRelease() {
        this.labelMarginLeft.removeListener(this.marginLeftListener);
        this.labelMarginRight.removeListener(this.marginRightListener);
        this.labelFontSize.removeListener(this.fontSizeListener);
        this.labelFontFamily.removeListener(this.fontFamilyListener);
        this.labelFontColor.removeListener(this.fontColorListener);
        this.isUnderline.removeListener(this.underlineListener);
        this.withRightBorder.removeListener(this.withRightBorderListener);
        this.isRounded.removeListener(this.isRoundedListener);
        this.backgroundColor.removeListener(this.backgroundColorListener);
        if (this.mouseEventHandler != null) {
            this.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventHandler);
            this.label.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventHandler);
            ClientSingleton.getInstance().removeMouseCursor((Node)this);
            ClientSingleton.getInstance().removeMouseCursor((Node)this.label);
        }
        this.labelMarginLeft = null;
        this.labelMarginRight = null;
        this.labelFontSize = null;
        this.labelFontFamily = null;
        this.labelFontColor = null;
        this.isUnderline = null;
        this.marginLeftListener = null;
        this.marginRightListener = null;
        this.fontSizeListener = null;
        this.fontFamilyListener = null;
        this.fontColorListener = null;
        this.underlineListener = null;
    }

    public int getContentWidth() {
        Text text = new Text(this.label.getText());
        return (int)text.getBoundsInLocal().getWidth();
    }
}

