/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.mylistview;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.Interpolator;
import javafx.animation.TranslateTransition;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Bounds;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.mylistview.interfaces.IChangeScrollState;
import net.sipsnet.client.utils.viewers.mylistview.interfaces.ScrollingState;
import net.sipsnet.client.utils.viewers.mylistview.internal.VelocityTracker;

public class FlingPane
extends Region {
    private IChangeScrollState iChangeScrollState;
    private ObjectProperty<Pane> content;
    private final Rectangle clipRect = new Rectangle();
    private boolean isWithMouseDrag;
    private final ObjectProperty<FlingDirection> flingDirection = new SimpleObjectProperty((Object)FlingDirection.BOTH, "flingDirection");
    private final VelocityTracker tracker = new VelocityTracker();
    final AtomicReference<TranslateTransition> currentTransition = new AtomicReference();

    public void setWithMouseDrag(IChangeScrollState iChangeScrollState) {
        this.iChangeScrollState = iChangeScrollState;
        this.mouseDrag();
    }

    public FlingPane() {
        this(null);
    }

    public FlingPane(IChangeScrollState iChangeScrollState) {
        this.iChangeScrollState = iChangeScrollState;
        this.setFocusTraversable(false);
        this.setClip((Node)this.clipRect);
        this.contentProperty().addListener((observable, oldValue, newValue) -> {
            this.getChildren().clear();
            if (newValue != null) {
                this.getChildren().add(newValue);
            }
            this.layout();
        });
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> this.requestFocus());
    }

    public void onScrollAction(double fromY, double deltaY) {
        if (this.currentTransition.get() != null) {
            this.currentTransition.get().stop();
        }
        float velocityX = this.tracker.getXVelocity();
        float velocityY = (float)deltaY;
        double setFromY = fromY * -1.0;
        this.scroll(velocityX, velocityY, setFromY);
    }

    private void scroll(float velocityX, float velocityY, double setFromY) {
        if (this.content != null && this.content.get() != null) {
            double newValue;
            TranslateTransition translate = new TranslateTransition(new Duration(1000.0), (Node)this.content.get());
            translate.setInterpolator(Interpolator.EASE_OUT);
            Bounds layoutBounds = ((Pane)this.content.get()).getLayoutBounds();
            Double backBouncingX = null;
            Double backBouncingY = null;
            Double targetX = null;
            Double targetY = null;
            if (Math.abs(velocityX) < 10.0f) {
                velocityX = 0.0f;
            }
            if (Math.abs(velocityY) < 10.0f) {
                velocityY = 0.0f;
            }
            if (this.flingDirection.get() == FlingDirection.HORIZONTAL || this.flingDirection.get() == FlingDirection.BOTH) {
                double viewWith;
                targetX = ((Pane)this.content.get()).getTranslateX();
                double controlWidth = layoutBounds.getWidth();
                if (controlWidth < (viewWith = this.getWidth()) && targetX < controlWidth) {
                    targetX = 0.0;
                } else if (targetX > 0.0) {
                    targetX = 0.0;
                } else if (targetX < (controlWidth - viewWith) * -1.0) {
                    targetX = (controlWidth - viewWith) * -1.0;
                } else {
                    targetX = targetX + (double)velocityX;
                    if (controlWidth < viewWith && targetX < controlWidth) {
                        targetX = -100.0;
                        backBouncingX = 0.0;
                    } else if (targetX > 0.0) {
                        targetX = 100.0;
                        backBouncingX = 0.0;
                    } else if (targetX < (controlWidth - viewWith) * -1.0) {
                        targetX = (controlWidth - viewWith) * -1.0 - 100.0;
                        backBouncingX = (controlWidth - viewWith) * -1.0;
                    }
                }
            }
            if (this.flingDirection.get() == FlingDirection.VERTICAL || this.flingDirection.get() == FlingDirection.BOTH) {
                double viewHeight;
                targetY = setFromY;
                double controlHeight = layoutBounds.getHeight();
                if (controlHeight < (viewHeight = this.getHeight()) && targetY < controlHeight) {
                    targetY = 0.0;
                } else if (targetY > 0.0) {
                    targetY = 0.0;
                } else if (targetY < (controlHeight - viewHeight) * -1.0) {
                    targetY = (controlHeight - viewHeight) * -1.0;
                } else {
                    targetY = targetY + (double)velocityY;
                    if (controlHeight < viewHeight && targetY < controlHeight) {
                        targetY = 0.0;
                        backBouncingY = 0.0;
                    } else if (targetY > 0.0) {
                        targetY = 0.0;
                        backBouncingY = 0.0;
                    } else if (targetY < (controlHeight - viewHeight) * -1.0) {
                        targetY = (controlHeight - viewHeight) * -1.0;
                        backBouncingY = (controlHeight - viewHeight) * -1.0;
                    }
                }
            }
            if (targetX != null) {
                translate.setFromX(((Pane)this.content.get()).getTranslateX());
                translate.setToX(targetX.doubleValue());
            }
            if (targetY != null) {
                translate.setFromY(setFromY);
                translate.setToY(targetY.doubleValue());
            }
            double d = newValue = targetY == null ? 0.0 : targetY * -1.0;
            if (backBouncingX == null && backBouncingY == null) {
                translate.setOnFinished(event -> {
                    this.currentTransition.set(null);
                    if (this.iChangeScrollState != null) {
                        this.iChangeScrollState.setCurrentScrollingState(ScrollingState.NOT_SCROLLING);
                    }
                });
            }
            translate.play();
            this.currentTransition.set(translate);
        }
    }

    private void mouseDrag() {
        AtomicReference deltaEvent = new AtomicReference();
        this.setOnMousePressed(event -> {
            this.tracker.addMovement((MouseEvent)event);
            deltaEvent.set(event);
            if (this.currentTransition.get() != null) {
                this.currentTransition.get().stop();
            }
            if (this.iChangeScrollState != null) {
                this.iChangeScrollState.setCurrentScrollingState(ScrollingState.FLING_SCROLLING);
            }
        });
        this.setOnMouseDragged(event -> {
            try {
                if (!((Node)event.getSource()).getCursor().equals(Cursor.CLOSED_HAND)) {
                    ((Node)event.getSource()).setCursor(Cursor.CLOSED_HAND);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tracker.addMovement((MouseEvent)event);
            if (this.flingDirection.get() == FlingDirection.HORIZONTAL || this.flingDirection.get() == FlingDirection.BOTH) {
                double delta = event.getX() - ((MouseEvent)deltaEvent.get()).getX();
                ((Pane)this.content.get()).setTranslateX(((Pane)this.content.get()).getTranslateX() + delta);
            }
            if (this.flingDirection.get() == FlingDirection.VERTICAL || this.flingDirection.get() == FlingDirection.BOTH) {
                double delta = event.getY() - ((MouseEvent)deltaEvent.get()).getY();
                double targetY = ((Pane)this.content.get()).getTranslateY() + delta;
                ((Pane)this.content.get()).setTranslateY(targetY);
            }
            deltaEvent.set(event);
        });
        this.setOnMouseReleased(event -> {
            this.tracker.addMovement((MouseEvent)event);
            this.tracker.computeCurrentVelocity(500);
            float velocityX = this.tracker.getXVelocity();
            float velocityY = this.tracker.getYVelocity();
            double setFromY = ((Pane)this.content.get()).getTranslateY();
            this.scroll(velocityX, velocityY, setFromY);
            ((Node)event.getSource()).setCursor(Cursor.DEFAULT);
        });
    }

    public final void setContent(Pane value) {
        this.contentProperty().set((Object)value);
    }

    public final Optional<Pane> getContent() {
        return Optional.ofNullable(this.content == null ? null : (Pane)this.content.get());
    }

    public final ObjectProperty<Pane> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty((Object)this, "content");
        }
        return this.content;
    }

    public final ObjectProperty<FlingDirection> flingDirection() {
        return this.flingDirection;
    }

    public void setFlingDirection(FlingDirection value) {
        this.flingDirection.set((Object)value);
    }

    public FlingDirection getFlingDirection() {
        return (FlingDirection)((Object)this.flingDirection.get());
    }

    public void clear() {
        if (this.content != null && this.content.get() != null) {
            ((Pane)this.content.get()).getChildren().clear();
            ((Pane)this.content.get()).resize(((Pane)this.content.get()).getWidth(), 0.0);
            if (((Pane)this.content.get()).getTranslateY() != 0.0) {
                ((Pane)this.content.get()).setTranslateY(0.0);
            }
        }
    }

    public void setList(List<Pane> list) {
        this.clear();
        ((Pane)this.content.get()).getChildren().addAll(list);
        ((Pane)this.content.get()).layout();
        this.layout();
    }

    protected void addItemByIndex(Pane pane, int index) {
        if (this.content != null && this.content.get() != null) {
            if (((Pane)this.content.get()).getChildren().contains((Object)pane)) {
                return;
            }
            try {
                throw new Exception("addItem 1");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ((Pane)this.content.get()).getChildren().add(index, (Object)pane);
            }
        }
    }

    protected double addItemToUp(Pane pane) {
        return this.addItem(pane, true);
    }

    protected double addItemToBottom(Pane pane) {
        return this.addItem(pane, false);
    }

    private double addItem(Pane pane, boolean toTop) {
        double height = 10.0;
        if (this.content != null && this.content.get() != null) {
            if (((Pane)this.content.get()).getChildren().contains((Object)pane)) {
                return height;
            }
            if (toTop) {
                ((Pane)this.content.get()).getChildren().add(0, (Object)pane);
            } else {
                ((Pane)this.content.get()).getChildren().add((Object)pane);
            }
            ((Pane)this.content.get()).layout();
            this.layout();
            height = pane.getHeight();
        }
        return height;
    }

    public void removePane(String id) {
        for (int i = ((Pane)this.content.get()).getChildren().size() - 1; i >= 0; --i) {
            Node node = (Node)((Pane)this.content.get()).getChildren().get(i);
            if (!id.equals(node.getId())) continue;
            ((Pane)this.content.get()).getChildren().remove(i);
        }
    }

    public void removePaneByHash(int hash) {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "removePaneByHash=" + hash);
        for (int i = ((Pane)this.content.get()).getChildren().size() - 1; i >= 0; --i) {
            Node node = (Node)((Pane)this.content.get()).getChildren().get(i);
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "node.hashCode()=" + node.hashCode());
            if (node.hashCode() != hash) continue;
            ((Pane)this.content.get()).getChildren().remove(i);
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.clipRect.setWidth(this.getWidth());
        this.clipRect.setHeight(this.getHeight());
    }

    public Pane removeContent() {
        Pane pane = (Pane)this.content.get();
        this.content.set(null);
        return pane;
    }

    public static enum FlingDirection {
        BOTH,
        HORIZONTAL,
        VERTICAL;

    }
}

