/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.mylistview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import net.sipsnet.client.utils.scheduledwork.MyScheduledService;
import net.sipsnet.client.utils.viewers.mylistview.FlingPane;
import net.sipsnet.client.utils.viewers.mylistview.IScrollListener;
import net.sipsnet.client.utils.viewers.mylistview.interfaces.IChangeScrollState;
import net.sipsnet.client.utils.viewers.mylistview.interfaces.IFlingPane;
import net.sipsnet.client.utils.viewers.mylistview.interfaces.ScrollingState;
import net.sipsnet.client.utils.viewers.mylistview.internal.IOnScrollAction;

public class MyListView
extends HBox
implements IChangeScrollState {
    private ScrollingState currentScrollState = ScrollingState.NOT_SCROLLING;
    private FlingPane flingPane;
    private ScrollBar scrollBar;
    private double currentHeight = 480.0;
    private MyTranslateChangeListener myTranslateChangeListener;
    private MyHeightChangeListener myHeightChangeListener;
    private IScrollListener iScrollListener;
    private IOnScrollAction iOnScrollAction;
    private IFlingPane iFlingPane;
    private boolean forceStop = false;
    public static double SCROLL_SPEED = 450.0;

    public void setForceStop(boolean forceStop) {
        this.forceStop = forceStop;
    }

    public MyListView(IFlingPane iFlingPane) {
        this.iFlingPane = iFlingPane;
        this.initComponents();
    }

    public MyListView() {
        this.initComponents();
    }

    public void clear() {
        this.flingPane.clear();
    }

    public void setFocus() {
        this.flingPane.requestFocus();
    }

    public void add(Pane item) {
        this.add(item, false);
    }

    public void add(Pane item, boolean toUp) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            if (toUp) {
                this.flingPane.addItemToUp(item);
            } else {
                this.flingPane.addItemToBottom(item);
            }
        });
    }

    public boolean add(int index, Pane item) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            if (index < pane.getChildren().size()) {
                this.flingPane.addItemByIndex((Pane)pane, index);
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    public void addListToTop(List<Pane> list) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            double height = 0.0;
            for (Pane item : list) {
                height += this.flingPane.addItemToUp(item);
            }
            pane.setTranslateY(-height);
        });
    }

    public void addListToBottom(List<Pane> list) {
        for (Pane item : list) {
            this.flingPane.addItemToBottom(item);
        }
        this.setScrollBarValues(this.getHeight());
    }

    public void addItem(Pane item, boolean toTop) {
        this.addItem(item, toTop, false);
    }

    public void addItem(Pane item, boolean toTop, boolean moveDown) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            if (toTop) {
                double height = this.flingPane.addItemToUp(item);
                this.setScrollBarValues(this.getHeight());
                this.scrollBar.setValue(height / 2.0);
            } else {
                this.currentScrollState = ScrollingState.FIRST_INIT;
                this.flingPane.addItemToBottom(item);
            }
        });
    }

    public void setList(List<Pane> list) {
        this.setList(list, false, false);
    }

    public void setList(List<Pane> list, boolean toUp, boolean withOpaque) {
        int index;
        VBox vBox = new VBox();
        vBox.setStyle("-fx-background-color:  transparent;");
        vBox.heightProperty().addListener((ChangeListener)this.myHeightChangeListener);
        this.invalidateList(vBox);
        if (withOpaque) {
            this.hideOpaquePane();
        }
        for (index = 0; index < 50 && index < list.size() && !this.forceStop; ++index) {
            Pane pane = list.get(index);
            this.add(pane, toUp);
        }
        if (index < list.size() && !this.forceStop) {
            AtomicInteger newIndex = new AtomicInteger(index);
            MyScheduledService.getInstance(this.getClass().getSimpleName() + " setList").setOnSchedulerSucceeded((EventHandler<WorkerStateEvent>)((EventHandler)event -> {
                Optional<Pane> oPane = this.flingPane.getContent();
                oPane.ifPresent(pane -> {
                    while (newIndex.get() < list.size() && !this.forceStop) {
                        Pane item = (Pane)list.get(newIndex.get());
                        this.add(item, toUp);
                        newIndex.getAndIncrement();
                    }
                    this.setScrollBarValues(this.getHeight());
                });
            })).startWithDelay(Duration.millis((double)200.0));
        }
    }

    public int getContentSize() {
        Optional<Pane> oPanel = this.flingPane.getContent();
        return oPanel.map(pane -> pane.getChildren().size()).orElse(0);
    }

    public synchronized void addListAndScrollDown(List<Pane> list) {
        this.currentScrollState = ScrollingState.FIRST_INIT;
        this.flingPane.setList(list);
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            this.setScrollBarValues(this.getHeight());
            if (this.getHeight() < pane.getHeight()) {
                double nValue = this.scrollBar.getMax() * -1.0;
                pane.setTranslateY(nValue);
                this.scrollBar.setValue(this.currentScrollState == ScrollingState.FIRST_INIT ? 0.0 : this.scrollBar.getMax());
            }
        });
    }

    private void setScrollBarVisibility() {
        this.flingPane.getContent().ifPresent(pane -> {
            if (this.getHeight() != 0.0 && pane.getHeight() > this.getHeight()) {
                if (!this.scrollBar.isVisible()) {
                    this.scrollBar.setVisible(true);
                }
            } else {
                this.scrollBar.setVisible(false);
            }
        });
    }

    private void moveScrollBarWithDelay() {
        this.moveScrollBarWithDelay(50L);
    }

    public void moveScrollBarWithDelay(long delay) {
        MyScheduledService.getInstance(this.getClass().getSimpleName() + " moveScrollBarWithDelay").setOnSchedulerSucceeded((EventHandler<WorkerStateEvent>)((EventHandler)event -> this.moveScrollBarToMaxPosition())).startWithDelay(Duration.millis((double)delay));
    }

    public void moveScrollBarToMaxPosition() {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            this.setScrollBarValues(this.getHeight());
            if (this.getHeight() < pane.getHeight()) {
                double nValue = this.scrollBar.getMax() * -1.0;
                pane.setTranslateY(nValue);
                this.scrollBar.setValue(this.currentScrollState == ScrollingState.FIRST_INIT ? 0.0 : this.scrollBar.getMax());
                pane.setVisible(true);
            }
        });
    }

    public void addList(List<Pane> list) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            ArrayList<Pane> items = new ArrayList<Pane>((Collection<Pane>)pane.getChildren());
            items.addAll(list);
            this.setList(items);
        });
    }

    public void addList(Pane item, List<Pane> list) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            Pane cell;
            int index;
            ArrayList<Pane> items = new ArrayList<Pane>((Collection<Pane>)pane.getChildren());
            for (index = 0; index < items.size() && !(cell = (Pane)items.get(index)).equals(item); ++index) {
            }
            int i = 0;
            for (Pane cell2 : list) {
                items.add(index + ++i, cell2);
            }
            this.setList(items);
        });
    }

    public void removeItem(String id) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            this.flingPane.removePane(id);
            this.setScrollBarValues(this.getHeight());
        });
    }

    public void removeItemByHash(int hash) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            this.flingPane.removePaneByHash(hash);
            this.setScrollBarValues(this.getHeight());
        });
    }

    public void removeList(List<Pane> list) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            ArrayList<Pane> items = new ArrayList<Pane>((Collection<Pane>)pane.getChildren());
            for (Pane cell : list) {
                items.remove(cell);
            }
            this.setList(items);
        });
    }

    public void setContent(VBox pane, IOnScrollAction iOnScrollAction) {
        this.iOnScrollAction = iOnScrollAction;
        pane.setAlignment(Pos.BOTTOM_LEFT);
        pane.heightProperty().addListener((ChangeListener)this.myHeightChangeListener);
        this.invalidateList(pane);
    }

    private void invalidateList(VBox viewList) {
        if (this.myTranslateChangeListener == null) {
            this.myTranslateChangeListener = new MyTranslateChangeListener();
        }
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            pane.translateYProperty().removeListener((ChangeListener)this.myTranslateChangeListener);
            pane.heightProperty().removeListener((ChangeListener)this.myHeightChangeListener);
            pane.prefWidthProperty().unbind();
            this.myHeightChangeListener.setOldPane((Pane)pane);
            pane.resize(pane.getWidth(), 0.0);
            if (pane.getTranslateY() != 0.0) {
                pane.setTranslateY(0.0);
            }
        });
        viewList.translateYProperty().addListener((ChangeListener)this.myTranslateChangeListener);
        viewList.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> viewList.requestFocus());
        viewList.setStyle("-fx-background:red;");
        this.flingPane.setContent((Pane)viewList);
    }

    private void setScrollBarValues(double height) {
        Optional<Pane> oPane = this.flingPane.getContent();
        oPane.ifPresent(pane -> {
            this.currentHeight = height;
            this.scrollBar.setMax(pane.getHeight() - this.currentHeight);
            this.scrollBar.setVisibleAmount(this.scrollBar.getMax() * this.currentHeight / pane.getHeight());
        });
    }

    public void setScrollListener(IOnScrollAction iOnScrollAction) {
        this.iOnScrollAction = iOnScrollAction;
    }

    public void setWithMouseDrag() {
        this.flingPane.setWithMouseDrag(this);
    }

    public void moveDown() {
        this.flingPane.onScrollAction(this.scrollBar.getValue(), this.scrollBar.getValue() - this.scrollBar.getMax());
        this.scrollBar.setValue(this.scrollBar.getMax());
    }

    @Override
    public void setCurrentScrollingState(ScrollingState currentState) {
        this.currentScrollState = currentState;
    }

    public void refreshListHeight() {
        this.flingPane.getContent().ifPresent(pane -> pane.setPrefHeight(this.getHeight()));
    }

    private ScrollBar getScrollBar() {
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setOrientation(Orientation.VERTICAL);
        scrollBar.getStylesheets().add((Object)this.getClass().getResource("/fxml/utils/scrollbar.css").toExternalForm());
        scrollBar.setOnMouseExited(event -> {
            if (this.currentScrollState != ScrollingState.SCROLLBAR_SCROLLING) {
                this.setScrollBarPaneWidth(false, Cursor.DEFAULT);
            }
        });
        scrollBar.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            this.currentScrollState = ScrollingState.SCROLLBAR_SCROLLING;
        });
        scrollBar.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.currentScrollState == ScrollingState.SCROLLBAR_SCROLLING) {
                double nValue = newValue.doubleValue() * -1.0;
                Optional<Pane> oPane = this.flingPane.getContent();
                oPane.ifPresent(pane -> pane.setTranslateY(nValue));
            }
            if (this.iScrollListener != null) {
                if (this.currentScrollState != ScrollingState.ADD_CHILD_TO_SCROLL) {
                    if (oldValue.doubleValue() < newValue.doubleValue()) {
                        if (newValue.doubleValue() < 15.0) {
                            this.currentScrollState = ScrollingState.ADD_CHILD_TO_SCROLL;
                            this.iScrollListener.scrollDown(scrollBar.getMax(), newValue.doubleValue());
                        }
                    } else {
                        this.iScrollListener.scrollUp(scrollBar.getMax(), newValue.doubleValue());
                    }
                } else {
                    this.currentScrollState = ScrollingState.NOT_SCROLLING;
                }
            }
            if (this.iFlingPane != null && this.currentScrollState != ScrollingState.FIRST_INIT) {
                if (newValue.doubleValue() >= scrollBar.getMax() - 10.0) {
                    this.iFlingPane.hideButton();
                } else {
                    this.iFlingPane.showButton();
                }
            }
        });
        return scrollBar;
    }

    private void setScrollBarPaneWidth(boolean isFocused, Cursor cursor) {
        int FOCUSED_WIDTH = 10;
        int NOT_FOCUSED_WIDTH = 5;
        int oldWidth = (int)this.scrollBar.getWidth();
        int width = FOCUSED_WIDTH;
        if (this.scrollBar.getMaxWidth() != (double)width) {
            this.scrollBar.setPrefWidth((double)width);
            this.scrollBar.setMinWidth((double)width);
            this.scrollBar.setMaxWidth((double)width);
        }
        if (this.scrollBar != null && this.scrollBar.getCursor() != cursor) {
            this.scrollBar.setCursor(cursor);
        }
    }

    private List<Node> getVisibleNodes() {
        ArrayList<Node> visibleNodes = new ArrayList<Node>();
        Optional<Pane> oPane = this.flingPane.getContent();
        if (oPane.isPresent()) {
            VBox pane = (VBox)oPane.get();
            Bounds paneBounds = pane.localToScene(pane.getBoundsInParent());
            for (Node n : pane.getChildrenUnmodifiable()) {
                Bounds nodeBounds = n.localToScene(n.getBoundsInLocal());
                if (!paneBounds.intersects(nodeBounds)) continue;
                visibleNodes.add(n);
            }
        }
        return visibleNodes;
    }

    public ObservableList<Node> getChildrenPanes() {
        Optional<Pane> oPane = this.flingPane.getContent();
        if (oPane.isPresent()) {
            return oPane.get().getChildren();
        }
        return FXCollections.observableArrayList();
    }

    private void initComponents() {
        this.myHeightChangeListener = new MyHeightChangeListener();
        this.flingPane = this.iFlingPane != null ? new FlingPane(this) : new FlingPane();
        this.flingPane.setFlingDirection(FlingPane.FlingDirection.VERTICAL);
        HBox.setHgrow((Node)this.flingPane, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.flingPane, (Priority)Priority.ALWAYS);
        this.scrollBar = this.getScrollBar();
        this.setScrollBarPaneWidth(false, Cursor.DEFAULT);
        this.flingPane.addEventFilter(ScrollEvent.SCROLL, event -> {
            if (this.currentScrollState != ScrollingState.SCROLLBAR_SCROLLING) {
                if (this.currentScrollState != ScrollingState.FLING_SCROLLING) {
                    this.currentScrollState = ScrollingState.FLING_SCROLLING;
                }
                this.flingPane.onScrollAction(this.scrollBar.getValue(), event.getDeltaY() < 0.0 ? -SCROLL_SPEED : SCROLL_SPEED);
                if (this.iOnScrollAction != null) {
                    this.iOnScrollAction.scrolling();
                }
            } else {
                ((Node)event.getSource()).getScene().setCursor(Cursor.HAND);
            }
        });
        this.flingPane.setStyle("-fx-background-color:  transparent;");
        this.getChildren().addAll((Object[])new Node[]{this.flingPane, this.scrollBar});
        VBox listPane = new VBox();
        listPane.setAlignment(Pos.BOTTOM_LEFT);
        listPane.heightProperty().addListener((ChangeListener)this.myHeightChangeListener);
        listPane.setStyle("-fx-background-color:  transparent;");
        if (this.myTranslateChangeListener == null) {
            this.myTranslateChangeListener = new MyTranslateChangeListener();
        }
        listPane.translateYProperty().addListener((ChangeListener)this.myTranslateChangeListener);
        listPane.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> listPane.requestFocus());
        this.flingPane.setContent((Pane)listPane);
        this.setStyle("-fx-background-color:  transparent;");
        this.scrollBar.setVisible(false);
    }

    public void removeScrollBar() {
        this.scrollBar.setVisible(false);
    }

    public void setMyHeightChangeListener(boolean mode) {
        if (mode) {
            this.heightProperty().addListener((observableValue, oldValue, newValue) -> this.setScrollBarValues(newValue.doubleValue()));
        }
    }

    public void showOpaquePane() {
        this.flingPane.getContent().ifPresent(pane -> {
            pane.layout();
            pane.setVisible(true);
        });
    }

    public void hideOpaquePane() {
        this.flingPane.getContent().ifPresent(pane -> pane.setVisible(false));
    }

    class MyHeightChangeListener
    implements ChangeListener<Number> {
        private Pane oldPane;

        MyHeightChangeListener() {
        }

        public void setOldPane(Pane oldPane) {
            this.oldPane = oldPane;
        }

        public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
            Optional<Pane> oPane = MyListView.this.flingPane.getContent();
            oPane.ifPresent(pane -> {
                MyListView.this.setScrollBarVisibility();
                if (MyListView.this.getHeight() != 0.0 && pane.getHeight() < MyListView.this.getHeight()) {
                    if (MyListView.this.currentScrollState == ScrollingState.FIRST_INIT) {
                        MyListView.this.moveScrollBarWithDelay();
                        MyListView.this.currentScrollState = ScrollingState.NOT_SCROLLING;
                    }
                } else if (MyListView.this.currentScrollState == ScrollingState.FIRST_INIT) {
                    MyListView.this.moveScrollBarWithDelay();
                    MyListView.this.currentScrollState = ScrollingState.NOT_SCROLLING;
                } else if (MyListView.this.currentScrollState == ScrollingState.ADD_CHILD_TO_SCROLL) {
                    double delta = newValue.doubleValue() - oldValue.doubleValue();
                    double oldScrollValue = MyListView.this.scrollBar.getValue();
                    MyListView.this.scrollBar.setMax(newValue.doubleValue() - MyListView.this.currentHeight);
                    MyListView.this.scrollBar.setVisibleAmount(MyListView.this.scrollBar.getMax() * MyListView.this.currentHeight / newValue.doubleValue());
                    MyListView.this.scrollBar.setValue(oldScrollValue + delta);
                } else if (this.oldPane != null && pane.getHeight() < this.oldPane.getHeight()) {
                    pane.setTranslateY(this.oldPane.getTranslateY());
                    MyListView.this.scrollBar.setValue(this.oldPane.getTranslateY() * -1.0);
                    MyListView.this.setScrollBarValues(MyListView.this.getHeight());
                } else {
                    MyListView.this.setScrollBarValues(MyListView.this.getHeight());
                }
                if (MyListView.this.iFlingPane != null) {
                    if (MyListView.this.scrollBar.getValue() >= MyListView.this.scrollBar.getMax() - 10.0) {
                        MyListView.this.iFlingPane.hideButton();
                    } else {
                        MyListView.this.iFlingPane.showButton();
                    }
                }
            });
        }
    }

    class MyTranslateChangeListener
    implements ChangeListener<Number> {
        MyTranslateChangeListener() {
        }

        public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
            if (MyListView.this.currentScrollState == ScrollingState.FLING_SCROLLING) {
                MyListView.this.scrollBar.setValue(newValue.doubleValue() * -1.0);
                if (MyListView.this.iFlingPane != null) {
                    MyListView.this.iFlingPane.correctionTranslateY(newValue.doubleValue());
                }
            }
        }
    }
}

