/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javafx.scene.Node;
import net.sipsnet.client.utils.viewers.richtext.EmptyLinkedImage;
import net.sipsnet.client.utils.viewers.richtext.RealLinkedImage;
import org.fxmisc.richtext.model.Codec;

public interface LinkedImage {
    public static <S> Codec<LinkedImage> codec() {
        return new Codec<LinkedImage>(){

            public String getName() {
                return "LinkedImage";
            }

            public void encode(DataOutputStream os, LinkedImage linkedImage) throws IOException {
                if (linkedImage.isReal()) {
                    os.writeBoolean(true);
                    String externalPath = linkedImage.getImagePath().replace("\\", "/");
                    Codec.STRING_CODEC.encode(os, (Object)externalPath);
                } else {
                    os.writeBoolean(false);
                }
            }

            public LinkedImage decode(DataInputStream is) throws IOException {
                if (is.readBoolean()) {
                    String imagePath = (String)Codec.STRING_CODEC.decode(is);
                    imagePath = imagePath.replace("\\", "/");
                    return new RealLinkedImage(imagePath, false);
                }
                return new EmptyLinkedImage();
            }
        };
    }

    public boolean isReal();

    public String getImagePath();

    public Node createNode();
}

