/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.text.BreakIterator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import net.sipsnet.client.click2dial.GetSelectedText;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.StyledWord;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.richtext.LinkedImageOps;
import net.sipsnet.client.utils.viewers.richtext.TextStyle;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.emoji.utils.EmojiClass;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.reactfx.Subscription;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class MyStyledClassesTextArea
extends StyleClassedTextArea {
    public static final int lineHeight = 20;
    private final IInnerMessageTextArea iInnerMessageTextArea;
    private final String helloMessage = ClientSingleton.getInstance().getString("write_message");
    private final List<StyledWord> styledLinkList = new ArrayList<StyledWord>();
    private double caretPositionX = -1.0;
    private double caretPositionY = -1.0;
    private final List<Integer> newLines = new ArrayList<Integer>();
    private static final TextOps<String, TextStyle> styledTextOps = SegmentOps.styledTextOps();
    private static final LinkedImageOps<TextStyle> linkedImageOps = new LinkedImageOps();
    private List<String> mentions = new ArrayList<String>();
    private StyleSpansBuilder<Collection<String>> defaultStyleSpans;

    public MyStyledClassesTextArea(IInnerMessageTextArea iInnerMessageTextArea) {
        this(iInnerMessageTextArea, null, "#252b40");
        this.setEditable(false);
    }

    public MyStyledClassesTextArea(IInnerMessageTextArea iInnerMessageTextArea, String textColor) {
        this(iInnerMessageTextArea, null, textColor);
        this.setEditable(false);
    }

    public MyStyledClassesTextArea(IInnerMessageTextArea iInnerMessageTextArea, ChangeListener<Boolean> listener) {
        this(iInnerMessageTextArea, listener, "#252b40");
    }

    public MyStyledClassesTextArea(IInnerMessageTextArea iInnerMessageTextArea, ChangeListener<Boolean> listener, String textColor) {
        this(iInnerMessageTextArea, listener, textColor, 12);
    }

    public MyStyledClassesTextArea(IInnerMessageTextArea iInnerMessageTextArea, ChangeListener<Boolean> listener, String textColor, int size) {
        super(true);
        this.setWrapText(true);
        this.iInnerMessageTextArea = iInnerMessageTextArea;
        this.init();
        if (listener != null) {
            this.focusedProperty().addListener(listener);
            this.createPalaceHolder();
        }
        Subscription cleanupWhenFinished = this.multiPlainChanges().successionEnds(Duration.ofMillis(500L)).subscribe(change -> this.setStyleSpans(0, this.computeHighlighting(this.getText())));
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        spansBuilder.add(Collections.singleton("underlined"), 0);
        this.setStyleSpans(0, spansBuilder.create());
    }

    public void initMentions(SessionInfo sessionInfo) {
        this.mentions.clear();
        if (!sessionInfo.isGroup()) {
            return;
        }
        this.mentions = ((Stream)sessionInfo.getParties().stream().parallel()).map(member -> "@" + member.toString()).collect(Collectors.toList());
    }

    private void createPalaceHolder() {
        TimerExecutor.getInstance().startInGUI(() -> {
            Text placeHolder = new Text(this.helloMessage);
            try {
                ClientSingleton.getInstance().setStyledTextFont(placeHolder, false, "#A7AAB2");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int width = ClientSingleton.getInstance().getContentTextWidth(20, this.helloMessage);
            int height = ClientSingleton.getInstance().getContentTextHeight(20, this.helloMessage);
            HBox hBox = new HBox();
            hBox.setMaxSize((double)width, (double)height);
            hBox.getChildren().add((Object)placeHolder);
            this.setPlaceholder((Node)hBox);
        });
    }

    protected void configurePlaceholder(Node placeholder) {
        placeholder.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> 0.0, (Observable[])new Observable[]{this.heightProperty(), placeholder.layoutBoundsProperty()}));
        placeholder.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> 10.0, (Observable[])new Observable[]{this.widthProperty(), placeholder.layoutBoundsProperty()}));
    }

    public String getTextString() {
        return this.getText();
    }

    private void moveCaretToEnd() {
        this.lineEnd(NavigationActions.SelectionPolicy.CLEAR);
    }

    private void setCaretPosition(int position) {
        this.moveTo(position);
    }

    public void setContentToStyledTextArea(String text) {
        this.styledLinkList.clear();
        this.replaceText(0, 0, text);
        this.notifyResizePane();
    }

    public void setText(String text) {
        this.setTAText(text);
    }

    private void setTAText(String text) {
        ClientSingleton.getInstance().runLater(() -> {
            try {
                this.replaceText(0, this.getText().length(), text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void clearMessage(String message) {
        if (message != null && !message.isEmpty()) {
            this.setContentToStyledTextArea(message);
        } else if (this.iInnerMessageTextArea != null) {
            this.iInnerMessageTextArea.clearMessagePane(20);
            this.setTAText("");
            this.styledLinkList.clear();
        }
    }

    private void init() {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem1 = new MenuItem(ClientSingleton.getInstance().getString("context_menu_copy"));
        MenuItem menuItem2 = new MenuItem(ClientSingleton.getInstance().getString("context_menu_select_all"));
        MenuItem menuItem3 = new MenuItem(ClientSingleton.getInstance().getString("context_menu_past"));
        menuItem1.setOnAction(event -> this.copy());
        menuItem2.setOnAction(event -> this.selectAll());
        menuItem3.setOnAction(event -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            if (this.getStyleCodecs().isPresent()) {
                ClientSingleton.getInstance().runLater(() -> this.insertText(this.getText().length(), clipboard.getString()));
            }
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{menuItem1, menuItem2});
        this.setContextMenu(contextMenu);
        contextMenu.setOnShowing(windowEvent -> {
            if (!this.styledLinkList.isEmpty()) {
                if (contextMenu.getItems().size() > 3) {
                    contextMenu.getItems().remove(contextMenu.getItems().size() - 1);
                    contextMenu.getItems().remove(contextMenu.getItems().size() - 1);
                }
                this.styledLinkList.stream().filter(styledWord -> styledWord.inInterval(this.getCaretPosition())).findAny().ifPresent(styledWord -> {
                    MenuItem menuItem4 = new MenuItem(ClientSingleton.getInstance().getString("linkItem1"));
                    menuItem4.setOnAction(event -> ClientSingleton.getInstance().openWebBrowser(styledWord.getWord()));
                    contextMenu.getItems().add((Object)menuItem4);
                    MenuItem menuItem5 = new MenuItem(ClientSingleton.getInstance().getString("linkItem2"));
                    menuItem4.setOnAction(event -> {
                        try {
                            GetSelectedText.setClipboardText(styledWord.getWord());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ClientSingleton.getInstance().openWebBrowser(styledWord.getWord());
                    });
                    contextMenu.getItems().add((Object)menuItem5);
                });
            }
            if (this.isEditable()) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                if (this.getStyleCodecs().isPresent() && clipboard != null) {
                    if (!clipboard.getString().isEmpty() && !contextMenu.getItems().contains((Object)menuItem3)) {
                        contextMenu.getItems().add((Object)menuItem3);
                    } else {
                        contextMenu.getItems().remove((Object)menuItem3);
                    }
                }
            }
        });
        this.totalHeightEstimateProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null && this.iInnerMessageTextArea != null) {
                ClientSingleton.getInstance().runLater(this::notifyResizePane);
            }
        });
        this.textProperty().addListener((observableValue, oldValue, newValue) -> {
            if (oldValue != null && oldValue.length() > 20 && newValue.length() == 0) {
                this.iInnerMessageTextArea.resizeParent(25, 1);
            }
            if (newValue.isEmpty()) {
                this.newLines.clear();
            } else if (this.newLines.stream().anyMatch(integer -> integer > newValue.length())) {
                for (int index = this.newLines.size() - 1; index >= 0; --index) {
                    if (this.newLines.get(index) <= newValue.length()) continue;
                    this.newLines.remove(index);
                }
            }
        });
        this.caretBoundsProperty().addListener((observableValue, bounds, newValue) -> newValue.ifPresent(bounds1 -> {
            this.caretPositionX = bounds1.getMaxX();
            this.caretPositionY = bounds1.getMinY();
        }));
    }

    private void notifyResizePane() {
        try {
            int count = 0;
            for (int i = 0; i < this.getParagraphs().size(); ++i) {
                count += this.getParagraphLinesCount(i);
            }
            this.iInnerMessageTextArea.resizeParent((int)this.computePrefHeight(this.getLayoutBounds().getWidth()), count);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private StyleSpans<Collection<String>> computeHighlighting(String text) {
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        int lastIndex = wb.first();
        int lastKwEnd = 0;
        while (lastIndex != -1) {
            int firstIndex = lastIndex;
            lastIndex = wb.next();
            if (lastIndex == -1 || !Character.isLetterOrDigit(text.charAt(firstIndex))) continue;
            String word = text.substring(firstIndex, lastIndex).toLowerCase();
            if (!this.mentions.contains(word)) {
                spansBuilder.add(Collections.emptyList(), firstIndex - lastKwEnd);
                spansBuilder.add(Collections.singleton("underlined"), lastIndex - firstIndex);
                lastKwEnd = lastIndex;
            }
            System.err.println();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }

    public static Map<Integer, ContactInfo> getMentions(String content) {
        HashMap<Integer, ContactInfo> map = new HashMap<Integer, ContactInfo>();
        if (!content.contains("@")) {
            return map;
        }
        SessionInfo sessionInfo = ClientSingleton.getInstance().getCurrentSessionInfo();
        if (!sessionInfo.isGroup()) {
            return map;
        }
        ((Stream)sessionInfo.getParties().stream().parallel()).filter(member -> content.contains(member.toString())).forEach(member -> {
            String mention = "@" + member;
            int mentionLen = 0;
            int index = 0;
            while (index != -1) {
                if ((index = content.indexOf(mention, index + mentionLen)) != -1) {
                    map.put(index, (ContactInfo)member);
                }
                mentionLen = mention.length();
            }
        });
        return map;
    }

    public double getCaretPositionX() {
        if (this.caretPositionX == -1.0) {
            Bounds boundsInScene = this.localToScreen(this.getBoundsInLocal());
            this.caretPositionX = boundsInScene.getMinX() + 25.0;
        }
        return this.caretPositionX;
    }

    public double getCaretPositionY() {
        if (this.caretPositionY == -1.0) {
            Bounds boundsInScene = this.localToScreen(this.getBoundsInLocal());
            this.caretPositionY = boundsInScene.getMinY();
        }
        return this.caretPositionY;
    }

    public void addInputMap() {
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY})), event -> {
            String message = this.getTextString().trim();
            if (!message.isEmpty() && this.iInnerMessageTextArea != null) {
                this.iInnerMessageTextArea.sendMessage(message);
                this.clearMessage(null);
            }
        }));
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), event -> this.copy()));
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), event -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            if (this.getStyleCodecs().isPresent() && clipboard != null) {
                int position = this.getCaretPosition();
                String text = clipboard.getString();
                if (text != null) {
                    char[] chars = text.toCharArray();
                    for (int index = 0; index < chars.length; ++index) {
                        if (chars[index] != '\n') continue;
                        this.newLines.add(index);
                    }
                    this.insertText(position, clipboard.getString());
                    this.notifyResizePane();
                }
            }
        }));
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), event -> this.insertNewLineInText()));
    }

    public void insertNewLineInText() {
        if (this.getText().isEmpty()) {
            this.insertText(this.getText().length(), "\n");
            this.moveCaretToEnd();
        } else {
            int position;
            int n = position = this.getCaretPosition() > this.getText().length() ? this.getText().length() - 1 : this.getCaretPosition();
            if (!this.getMentionsList().isEmpty()) {
                String text = this.getTextString();
                if (text.length() > this.getText().length()) {
                    position += text.length() - this.getText().length();
                }
                StringBuilder sbText = new StringBuilder(text);
                sbText.insert(position, "\n");
                this.setContentToStyledTextArea(sbText.toString());
            } else {
                StringBuilder sbText = new StringBuilder(this.getText());
                sbText.insert(position, "\n");
                this.setText(sbText.toString());
            }
            this.newLines.add(position);
            this.setCaretPosition(Math.min(this.getCaretPosition() + 1, this.getText().length()));
        }
    }

    public List<String> getMentionsList() {
        return new ArrayList<String>();
    }

    public void insertEmoji(EmojiClass emoji) {
    }

    public void insertMentionText(ContactInfo contactInfo) {
    }
}

