/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.paint.Color;
import javafx.scene.text.TextAlignment;
import net.sipsnet.client.utils.viewers.richtext.Indent;
import net.sipsnet.client.utils.viewers.richtext.TextStyle;
import org.fxmisc.richtext.model.Codec;

class ParStyle {
    public static final ParStyle EMPTY = new ParStyle();
    public static final Codec<ParStyle> CODEC = new Codec<ParStyle>(){
        private final Codec<Optional<TextAlignment>> OPT_ALIGNMENT_CODEC = Codec.optionalCodec((Codec)Codec.enumCodec(TextAlignment.class));
        private final Codec<Optional<Color>> OPT_COLOR_CODEC = Codec.optionalCodec((Codec)Codec.COLOR_CODEC);

        public String getName() {
            return "par-style";
        }

        public void encode(DataOutputStream os, ParStyle t) throws IOException {
            this.OPT_ALIGNMENT_CODEC.encode(os, t.alignment);
            this.OPT_COLOR_CODEC.encode(os, t.backgroundColor);
            os.writeInt(t.indent.map(i -> i.level).orElse(0));
            os.writeInt(t.foldCount);
        }

        public ParStyle decode(DataInputStream is) throws IOException {
            return new ParStyle((Optional)this.OPT_ALIGNMENT_CODEC.decode(is), (Optional)this.OPT_COLOR_CODEC.decode(is), Optional.of(new Indent(is.readInt())), is.readInt());
        }
    };
    final Optional<TextAlignment> alignment;
    final Optional<Color> backgroundColor;
    final Optional<Indent> indent;
    final int foldCount;

    public static ParStyle alignLeft() {
        return EMPTY.updateAlignment(TextAlignment.LEFT);
    }

    public static ParStyle alignCenter() {
        return EMPTY.updateAlignment(TextAlignment.CENTER);
    }

    public static ParStyle alignRight() {
        return EMPTY.updateAlignment(TextAlignment.RIGHT);
    }

    public static ParStyle alignJustify() {
        return EMPTY.updateAlignment(TextAlignment.JUSTIFY);
    }

    public static ParStyle backgroundColor(Color color) {
        return EMPTY.updateBackgroundColor(color);
    }

    public static ParStyle folded() {
        return EMPTY.updateFold(Boolean.TRUE);
    }

    public static ParStyle unfolded() {
        return EMPTY.updateFold(Boolean.FALSE);
    }

    private ParStyle() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), 0);
    }

    private ParStyle(Optional<TextAlignment> alignment, Optional<Color> backgroundColor, Optional<Indent> indent, int folds) {
        this.alignment = alignment;
        this.backgroundColor = backgroundColor;
        this.foldCount = folds;
        this.indent = indent;
    }

    public int hashCode() {
        return Objects.hash(this.alignment, this.backgroundColor, this.indent, this.foldCount);
    }

    public boolean equals(Object other) {
        if (other instanceof ParStyle) {
            ParStyle that = (ParStyle)other;
            return Objects.equals(this.alignment, that.alignment) && Objects.equals(this.backgroundColor, that.backgroundColor) && Objects.equals(this.indent, that.indent) && this.foldCount == that.foldCount;
        }
        return false;
    }

    public String toString() {
        return this.toCss();
    }

    public String toCss() {
        StringBuilder sb = new StringBuilder();
        this.alignment.ifPresent(al -> {
            String cssAlignment;
            switch (al) {
                case LEFT: {
                    cssAlignment = "left";
                    break;
                }
                case CENTER: {
                    cssAlignment = "center";
                    break;
                }
                case RIGHT: {
                    cssAlignment = "right";
                    break;
                }
                case JUSTIFY: {
                    cssAlignment = "justify";
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unreachable code");
                }
            }
            sb.append("-fx-text-alignment: " + cssAlignment + ";");
        });
        this.backgroundColor.ifPresent(color -> sb.append("-fx-background-color: " + TextStyle.cssColor(color) + ";"));
        if (this.foldCount > 0) {
            sb.append("visibility: collapse;");
        }
        return sb.toString();
    }

    public ParStyle updateWith(ParStyle mixin) {
        return new ParStyle(mixin.alignment.isPresent() ? mixin.alignment : this.alignment, mixin.backgroundColor.isPresent() ? mixin.backgroundColor : this.backgroundColor, mixin.indent.isPresent() ? mixin.indent : this.indent, mixin.foldCount + this.foldCount);
    }

    public ParStyle updateAlignment(TextAlignment alignment) {
        return new ParStyle(Optional.of(alignment), this.backgroundColor, this.indent, this.foldCount);
    }

    public ParStyle updateBackgroundColor(Color backgroundColor) {
        return new ParStyle(this.alignment, Optional.of(backgroundColor), this.indent, this.foldCount);
    }

    public ParStyle updateIndent(Indent indent) {
        return new ParStyle(this.alignment, this.backgroundColor, Optional.ofNullable(indent), this.foldCount);
    }

    public ParStyle increaseIndent() {
        return this.updateIndent(this.indent.map(Indent::increase).orElseGet(Indent::new));
    }

    public ParStyle decreaseIndent() {
        return this.updateIndent(this.indent.filter(in -> in.level > 1).map(Indent::decrease).orElse(null));
    }

    public Indent getIndent() {
        return this.indent.get();
    }

    public boolean isIndented() {
        return this.indent.map(in -> in.level > 0).orElse(false);
    }

    public ParStyle updateFold(boolean fold) {
        int foldLevels = fold ? this.foldCount + 1 : Math.max(0, this.foldCount - 1);
        return new ParStyle(this.alignment, this.backgroundColor, this.indent, foldLevels);
    }

    public boolean isFolded() {
        return this.foldCount > 0;
    }
}

