/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.paint.Color;
import org.fxmisc.richtext.model.Codec;

class TextStyle {
    public static final TextStyle EMPTY = new TextStyle();
    public static final Codec<TextStyle> CODEC = new Codec<TextStyle>(){
        private final Codec<Optional<String>> OPT_STRING_CODEC = Codec.optionalCodec((Codec)Codec.STRING_CODEC);
        private final Codec<Optional<Color>> OPT_COLOR_CODEC = Codec.optionalCodec((Codec)Codec.COLOR_CODEC);

        public String getName() {
            return "text-style";
        }

        public void encode(DataOutputStream os, TextStyle s) throws IOException {
            os.writeByte(this.encodeBoldItalicUnderlineStrikethrough(s));
            os.writeInt(this.encodeOptionalUint(s.fontSize));
            this.OPT_STRING_CODEC.encode(os, s.fontFamily);
            this.OPT_COLOR_CODEC.encode(os, s.textColor);
            this.OPT_COLOR_CODEC.encode(os, s.backgroundColor);
        }

        public TextStyle decode(DataInputStream is) throws IOException {
            byte bius = is.readByte();
            Optional<Integer> fontSize = this.decodeOptionalUint(is.readInt());
            Optional fontFamily = (Optional)this.OPT_STRING_CODEC.decode(is);
            Optional textColor = (Optional)this.OPT_COLOR_CODEC.decode(is);
            Optional bgrColor = (Optional)this.OPT_COLOR_CODEC.decode(is);
            return new TextStyle(this.bold(bius), this.italic(bius), this.underline(bius), this.strikethrough(bius), fontSize, fontFamily, textColor, bgrColor);
        }

        private int encodeBoldItalicUnderlineStrikethrough(TextStyle s) {
            return this.encodeOptionalBoolean(s.bold) << 6 | this.encodeOptionalBoolean(s.italic) << 4 | this.encodeOptionalBoolean(s.underline) << 2 | this.encodeOptionalBoolean(s.strikethrough);
        }

        private Optional<Boolean> bold(byte bius) throws IOException {
            return this.decodeOptionalBoolean(bius >> 6 & 3);
        }

        private Optional<Boolean> italic(byte bius) throws IOException {
            return this.decodeOptionalBoolean(bius >> 4 & 3);
        }

        private Optional<Boolean> underline(byte bius) throws IOException {
            return this.decodeOptionalBoolean(bius >> 2 & 3);
        }

        private Optional<Boolean> strikethrough(byte bius) throws IOException {
            return this.decodeOptionalBoolean(bius >> 0 & 3);
        }

        private int encodeOptionalBoolean(Optional<Boolean> ob) {
            return ob.map(b -> 2 + (b != false ? 1 : 0)).orElse(0);
        }

        private Optional<Boolean> decodeOptionalBoolean(int i) throws IOException {
            switch (i) {
                case 0: {
                    return Optional.empty();
                }
                case 2: {
                    return Optional.of(false);
                }
                case 3: {
                    return Optional.of(true);
                }
            }
            throw new MalformedInputException(0);
        }

        private int encodeOptionalUint(Optional<Integer> oi) {
            return oi.orElse(-1);
        }

        private Optional<Integer> decodeOptionalUint(int i) {
            return i < 0 ? Optional.empty() : Optional.of(i);
        }
    };
    final Optional<Boolean> bold;
    final Optional<Boolean> italic;
    final Optional<Boolean> underline;
    final Optional<Boolean> strikethrough;
    final Optional<Integer> fontSize;
    final Optional<String> fontFamily;
    final Optional<Color> textColor;
    final Optional<Color> backgroundColor;

    public static TextStyle bold(boolean bold) {
        return EMPTY.updateBold(bold);
    }

    public static TextStyle italic(boolean italic) {
        return EMPTY.updateItalic(italic);
    }

    public static TextStyle underline(boolean underline) {
        return EMPTY.updateUnderline(underline);
    }

    public static TextStyle strikethrough(boolean strikethrough) {
        return EMPTY.updateStrikethrough(strikethrough);
    }

    public static TextStyle fontSize(int fontSize) {
        return EMPTY.updateFontSize(fontSize);
    }

    public static TextStyle fontFamily(String family) {
        return EMPTY.updateFontFamily(family);
    }

    public static TextStyle textColor(Color color) {
        return EMPTY.updateTextColor(color);
    }

    public static TextStyle backgroundColor(Color color) {
        return EMPTY.updateBackgroundColor(color);
    }

    static String cssColor(Color color) {
        int red = (int)(color.getRed() * 255.0);
        int green = (int)(color.getGreen() * 255.0);
        int blue = (int)(color.getBlue() * 255.0);
        return "rgb(" + red + ", " + green + ", " + blue + ")";
    }

    public TextStyle() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public TextStyle(Optional<Boolean> bold, Optional<Boolean> italic, Optional<Boolean> underline, Optional<Boolean> strikethrough, Optional<Integer> fontSize, Optional<String> fontFamily, Optional<Color> textColor, Optional<Color> backgroundColor) {
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.fontSize = fontSize;
        this.fontFamily = fontFamily;
        this.textColor = textColor;
        this.backgroundColor = backgroundColor;
    }

    public int hashCode() {
        return Objects.hash(this.bold, this.italic, this.underline, this.strikethrough, this.fontSize, this.fontFamily, this.textColor, this.backgroundColor);
    }

    public boolean equals(Object other) {
        if (other instanceof TextStyle) {
            TextStyle that = (TextStyle)other;
            return Objects.equals(this.bold, that.bold) && Objects.equals(this.italic, that.italic) && Objects.equals(this.underline, that.underline) && Objects.equals(this.strikethrough, that.strikethrough) && Objects.equals(this.fontSize, that.fontSize) && Objects.equals(this.fontFamily, that.fontFamily) && Objects.equals(this.textColor, that.textColor) && Objects.equals(this.backgroundColor, that.backgroundColor);
        }
        return false;
    }

    public String toString() {
        ArrayList styles = new ArrayList();
        this.bold.ifPresent(b -> styles.add(b.toString()));
        this.italic.ifPresent(i -> styles.add(i.toString()));
        this.underline.ifPresent(u -> styles.add(u.toString()));
        this.strikethrough.ifPresent(s -> styles.add(s.toString()));
        this.fontSize.ifPresent(s -> styles.add(s.toString()));
        this.fontFamily.ifPresent(f -> styles.add(f));
        this.textColor.ifPresent(c -> styles.add(c.toString()));
        this.backgroundColor.ifPresent(b -> styles.add(b.toString()));
        return String.join((CharSequence)",", styles);
    }

    public String toCss() {
        Color color;
        StringBuilder sb = new StringBuilder();
        if (this.bold.isPresent()) {
            if (this.bold.get().booleanValue()) {
                sb.append("-fx-font-weight: bold;");
            } else {
                sb.append("-fx-font-weight: normal;");
            }
        }
        if (this.italic.isPresent()) {
            if (this.italic.get().booleanValue()) {
                sb.append("-fx-font-style: italic;");
            } else {
                sb.append("-fx-font-style: normal;");
            }
        }
        if (this.underline.isPresent()) {
            if (this.underline.get().booleanValue()) {
                sb.append("-fx-underline: true;");
            } else {
                sb.append("-fx-underline: false;");
            }
        }
        if (this.strikethrough.isPresent()) {
            if (this.strikethrough.get().booleanValue()) {
                sb.append("-fx-strikethrough: true;");
            } else {
                sb.append("-fx-strikethrough: false;");
            }
        }
        if (this.fontSize.isPresent()) {
            sb.append("-fx-font-size: " + this.fontSize.get() + "pt;");
        }
        if (this.fontFamily.isPresent()) {
            sb.append("-fx-font-family: " + this.fontFamily.get() + ";");
        }
        if (this.textColor.isPresent()) {
            color = this.textColor.get();
            sb.append("-fx-fill: " + TextStyle.cssColor(color) + ";");
        }
        if (this.backgroundColor.isPresent()) {
            color = this.backgroundColor.get();
            sb.append("-rtfx-background-color: " + TextStyle.cssColor(color) + ";");
        }
        return sb.toString();
    }

    public TextStyle updateWith(TextStyle mixin) {
        return new TextStyle(mixin.bold.isPresent() ? mixin.bold : this.bold, mixin.italic.isPresent() ? mixin.italic : this.italic, mixin.underline.isPresent() ? mixin.underline : this.underline, mixin.strikethrough.isPresent() ? mixin.strikethrough : this.strikethrough, mixin.fontSize.isPresent() ? mixin.fontSize : this.fontSize, mixin.fontFamily.isPresent() ? mixin.fontFamily : this.fontFamily, mixin.textColor.isPresent() ? mixin.textColor : this.textColor, mixin.backgroundColor.isPresent() ? mixin.backgroundColor : this.backgroundColor);
    }

    public TextStyle updateBold(boolean bold) {
        return new TextStyle(Optional.of(bold), this.italic, this.underline, this.strikethrough, this.fontSize, this.fontFamily, this.textColor, this.backgroundColor);
    }

    public TextStyle updateItalic(boolean italic) {
        return new TextStyle(this.bold, Optional.of(italic), this.underline, this.strikethrough, this.fontSize, this.fontFamily, this.textColor, this.backgroundColor);
    }

    public TextStyle updateUnderline(boolean underline) {
        return new TextStyle(this.bold, this.italic, Optional.of(underline), this.strikethrough, this.fontSize, this.fontFamily, this.textColor, this.backgroundColor);
    }

    public TextStyle updateStrikethrough(boolean strikethrough) {
        return new TextStyle(this.bold, this.italic, this.underline, Optional.of(strikethrough), this.fontSize, this.fontFamily, this.textColor, this.backgroundColor);
    }

    public TextStyle updateFontSize(int fontSize) {
        return new TextStyle(this.bold, this.italic, this.underline, this.strikethrough, Optional.of(fontSize), this.fontFamily, this.textColor, this.backgroundColor);
    }

    public TextStyle updateFontFamily(String fontFamily) {
        return new TextStyle(this.bold, this.italic, this.underline, this.strikethrough, this.fontSize, Optional.of(fontFamily), this.textColor, this.backgroundColor);
    }

    public TextStyle updateTextColor(Color textColor) {
        return new TextStyle(this.bold, this.italic, this.underline, this.strikethrough, this.fontSize, this.fontFamily, Optional.of(textColor), this.backgroundColor);
    }

    public TextStyle updateBackgroundColor(Color backgroundColor) {
        return new TextStyle(this.bold, this.italic, this.underline, this.strikethrough, this.fontSize, this.fontFamily, this.textColor, Optional.of(backgroundColor));
    }
}

