/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.searchtextfield;

import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;

public class SearchTextField
extends HBox {
    private final SimpleIntegerProperty textFontSize = new SimpleIntegerProperty((Object)14, "textFontSize");
    private final SimpleStringProperty textFontFamily = new SimpleStringProperty((Object)"Roboto-Regular", "textFontFamily");
    private final SimpleStringProperty textFontColor = new SimpleStringProperty((Object)"#656a7c", "textFontColor");
    private final SimpleStringProperty backgroundColor = new SimpleStringProperty((Object)"#dce0ec", "backgroundColor");
    private final SimpleIntegerProperty textMarginLeft = new SimpleIntegerProperty((Object)0, "textMarginLeft");
    private final SimpleIntegerProperty textMarginRight = new SimpleIntegerProperty((Object)0, "textMarginRight");
    private final SimpleIntegerProperty textWidth = new SimpleIntegerProperty((Object)240, "textWidth");
    private final SimpleIntegerProperty textHeight = new SimpleIntegerProperty((Object)30, "textHeight");
    private final SimpleStringProperty promptText = new SimpleStringProperty((Object)"", "promptText");
    private final SimpleIntegerProperty cornerRadius = new SimpleIntegerProperty((Object)13, "cornerRadius");
    private final TextField textField = new TextField();

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String text) {
        this.textField.setText(text);
        this.textField.positionCaret(this.textField.getText().length());
    }

    public void setCaretPosition() {
        this.textField.positionCaret(this.textField.getText().length());
    }

    public void setInputFilter(EventHandler<KeyEvent> event) {
        this.textField.addEventFilter(KeyEvent.KEY_TYPED, event);
    }

    private String getTextFieldBaseStyle() {
        return "    -fx-font-family: " + this.textFontFamily.get() + ";    -fx-font-size: " + this.textFontSize.get() + "px ;    -fx-text-fill: " + this.textFontColor.get() + ";-fx-background-color: -fx-control-inner-background;";
    }

    private String getSearchHBoxStyle() {
        return " -fx-control-inner-background: " + this.backgroundColor.get() + ";    -fx-border-radius: " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + ";    -fx-background-radius: " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + ";-fx-background-color: -fx-control-inner-background;";
    }

    public SearchTextField() {
        this(true);
    }

    public SearchTextField(boolean withSearchImage) {
        this.textHeight.addListener((observable, oldValue, newValue) -> {
            this.setMinHeight(newValue.doubleValue());
            this.setMaxHeight(newValue.doubleValue());
        });
        this.textWidth.addListener((observable, oldValue, newValue) -> {
            this.setMinWidth(newValue.doubleValue());
            this.setMaxWidth(newValue.doubleValue());
        });
        this.textMarginLeft.addListener((observable, oldValue, newValue) -> HBox.setMargin((Node)this.textField, (Insets)new Insets(5.0, (double)this.getTextMarginRight(), 5.0, (double)newValue.intValue())));
        this.textMarginRight.addListener((observable, oldValue, newValue) -> HBox.setMargin((Node)this.textField, (Insets)new Insets(5.0, (double)newValue.intValue(), 5.0, (double)this.getTextMarginLeft())));
        this.textFontSize.addListener((observable, oldValue, newValue) -> this.textField.setStyle(this.getTextFieldBaseStyle()));
        this.textFontFamily.addListener((observable, oldValue, newValue) -> this.textField.setStyle(this.getTextFieldBaseStyle()));
        this.textFontColor.addListener((observable, oldValue, newValue) -> this.textField.setStyle(this.getTextFieldBaseStyle()));
        this.backgroundColor.addListener((observable, oldValue, newValue) -> this.textField.setStyle(this.getTextFieldBaseStyle()));
        this.cornerRadius.addListener((observable, oldValue, newValue) -> this.setStyle(this.getSearchHBoxStyle()));
        this.promptText.addListener((observable, oldValue, newValue) -> this.textField.setPromptText(ClientSingleton.getInstance().getString((String)newValue)));
        this.setAlignment(Pos.CENTER_LEFT);
        if (withSearchImage) {
            MyImageView myImageView = new MyImageView(14, 14);
            myImageView.setImage("search/searchbar_search.png");
            HBox.setMargin((Node)myImageView, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
            this.getChildren().add((Object)myImageView);
        } else {
            HBox.setMargin((Node)this.textField, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        }
        this.getChildren().add((Object)this.textField);
        this.initComponent();
        this.setStyle(this.getSearchHBoxStyle());
        this.textField.setStyle(this.getTextFieldBaseStyle());
    }

    private void initComponent() {
        this.setTextFontSize(14);
        this.setTextFontColor("#656a7c");
        this.setTextFontFamily("Roboto-Regular");
        this.setBackgroundColor("#dce0ec");
        this.setTextWidth(250);
        this.setTextHeight(30);
        this.setCornerRadius(13);
    }

    public void addListener(ChangeListener<? super String> changeListener) {
        this.textField.textProperty().addListener(changeListener);
    }

    private void setSize() {
        this.setMinHeight(this.textWidth.doubleValue());
        this.setMaxHeight(this.textHeight.doubleValue());
    }

    public int getTextWidth() {
        return this.textWidth.get();
    }

    public SimpleIntegerProperty textWidthProperty() {
        return this.textWidth;
    }

    public void setTextWidth(int textWidth) {
        this.textWidth.set(textWidth);
    }

    public int getTextHeight() {
        return this.textHeight.get();
    }

    public SimpleIntegerProperty textHeightProperty() {
        return this.textHeight;
    }

    public void setTextHeight(int textHeight) {
        this.textHeight.set(textHeight);
    }

    public String getPromptText() {
        return this.promptText.get();
    }

    public SimpleStringProperty promptTextProperty() {
        return this.promptText;
    }

    public void setPromptText(String textLabel) {
        this.promptText.set(textLabel);
    }

    public int getTextMarginLeft() {
        return this.textMarginLeft.get();
    }

    public SimpleIntegerProperty textMarginLeftProperty() {
        return this.textMarginLeft;
    }

    public void setTextMarginLeft(int textMarginLeft) {
        this.textMarginLeft.set(textMarginLeft);
    }

    public int getTextMarginRight() {
        return this.textMarginRight.get();
    }

    public SimpleIntegerProperty textMarginRightProperty() {
        return this.textMarginRight;
    }

    public void setTextMarginRight(int textMarginRight) {
        this.textMarginRight.set(textMarginRight);
    }

    public int getTextFontSize() {
        return this.textFontSize.get();
    }

    public SimpleIntegerProperty textFontSizeProperty() {
        return this.textFontSize;
    }

    public void setTextFontSize(int textFontSize) {
        this.textFontSize.set(textFontSize);
    }

    public String getTextFontFamily() {
        return this.textFontFamily.get();
    }

    public SimpleStringProperty textFontFamilyProperty() {
        return this.textFontFamily;
    }

    public void setTextFontFamily(String textFontFamily) {
        this.textFontFamily.set(textFontFamily);
    }

    public String getTextFontColor() {
        return this.textFontColor.get();
    }

    public SimpleStringProperty textFontColorProperty() {
        return this.textFontColor;
    }

    public void setTextFontColor(String textFontColor) {
        this.textFontColor.set(textFontColor);
    }

    public String getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public SimpleStringProperty backgroundColorProperty() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor.set(backgroundColor);
    }

    public int getCornerRadius() {
        return this.cornerRadius.get();
    }

    public SimpleIntegerProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius.set(cornerRadius);
    }
}

