/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.slider;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.slider.IMySliderPane;
import net.sipsnet.client.utils.viewers.slider.MySlider;

public class MySliderPane
extends VBox
implements IMySliderPane,
IActionOnRelease {
    private final SimpleBooleanProperty showBoundaryValues = new SimpleBooleanProperty();
    private final SimpleStringProperty thumbLabelSuffix = new SimpleStringProperty();
    private MySlider mySlider = new MySlider();
    private final Label thumbLabel;
    private Pane thumbPane = new Pane();
    private StackPane bottomPane = new StackPane();
    private HBox boundaryLabelsPane;
    private Label minValueLabel;
    private Label maxValueLabel;
    private ChangeListener<Number> changeListener;

    public MySliderPane() {
        this.thumbLabelSuffix.set("%.0f");
        this.thumbPane.setStyle("-fx-background-color:transparent;");
        this.thumbLabel = new Label();
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.thumbLabel);
        this.thumbLabel.textProperty().bind((ObservableValue)this.mySlider.valueProperty().asString(this.getThumbLabelSuffix()));
        this.mySlider.setIMySliderPane(this);
        this.mySlider.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.mySlider.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.thumbPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.thumbPane.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.thumbPane.getChildren().add((Object)this.thumbLabel);
        this.bottomPane.getChildren().add((Object)this.thumbPane);
        this.getChildren().addAll((Object[])new Node[]{this.mySlider, this.bottomPane});
        this.thumbLabel.setLayoutX(0.0);
        this.showBoundaryValues.set(false);
        this.boundaryLabelsPane = new HBox();
        this.boundaryLabelsPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.boundaryLabelsPane.prefHeightProperty().bind((ObservableValue)this.heightProperty());
        this.minValueLabel = new Label();
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.minValueLabel);
        this.minValueLabel.setText(String.valueOf(this.mySlider.getMin()));
        HBox empty = new HBox();
        HBox.setHgrow((Node)empty, (Priority)Priority.ALWAYS);
        this.maxValueLabel = new Label();
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.maxValueLabel);
        this.maxValueLabel.setText(String.valueOf(this.mySlider.getMax()));
        this.setMinValue(0.0);
        this.setMaxValue(100.0);
        this.boundaryLabelsPane.getChildren().addAll((Object[])new Node[]{this.minValueLabel, empty, this.maxValueLabel});
        this.showBoundaryValues.addListener((event, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.bottomPane.getChildren().add(0, (Object)this.boundaryLabelsPane);
            } else {
                this.bottomPane.getChildren().remove((Object)this.boundaryLabelsPane);
            }
        });
    }

    public void addValueListener(ChangeListener<Number> changeListener) {
        this.changeListener = changeListener;
        this.mySlider.valueProperty().addListener(changeListener);
    }

    public void setMaxValue(double value) {
        this.mySlider.setMax(value);
        this.maxValueLabel.setText(String.valueOf((int)value));
    }

    public void setMinValue(double value) {
        this.mySlider.setMin(value);
        this.minValueLabel.setText(String.valueOf((int)this.mySlider.getMin()));
    }

    public void setValue(double value) {
        ClientSingleton.getInstance().runLater(() -> this.mySlider.setValue(value));
    }

    public double getValue() {
        return this.mySlider.getValue();
    }

    public void setIndicatorValue(double value) {
        this.mySlider.setValue(value);
    }

    @Override
    public void moveToX(double value) {
        value = this.thumbPane.getWidth() * (value / 100.0);
        if (value < this.thumbLabel.getWidth() + 10.0) {
            if (this.minValueLabel.isVisible()) {
                this.minValueLabel.setVisible(false);
            }
        } else if (!this.minValueLabel.isVisible()) {
            this.minValueLabel.setVisible(true);
        }
        if (value > this.thumbPane.getWidth() - this.thumbLabel.getWidth() - 10.0) {
            if (this.maxValueLabel.isVisible()) {
                this.maxValueLabel.setVisible(false);
            }
        } else if (!this.maxValueLabel.isVisible()) {
            this.maxValueLabel.setVisible(true);
        }
        value = value - this.thumbLabel.getWidth() / 2.0 < 0.0 ? 0.0 : (value + this.thumbLabel.getWidth() > this.thumbPane.getWidth() ? this.thumbPane.getWidth() - this.thumbLabel.getWidth() : (value -= this.thumbLabel.getWidth() / 2.0));
        this.thumbLabel.setLayoutX(value);
    }

    public String getThumbLabelSuffix() {
        return this.thumbLabelSuffix.get();
    }

    public SimpleStringProperty thumbLabelSuffixProperty() {
        return this.thumbLabelSuffix;
    }

    public void setThumbLabelSuffix(String thumbLabelSuffix) {
        thumbLabelSuffix = this.getThumbLabelSuffix() + " " + (String)thumbLabelSuffix;
        this.thumbLabel.textProperty().unbind();
        this.thumbLabel.textProperty().bind((ObservableValue)this.mySlider.valueProperty().asString((String)thumbLabelSuffix));
        this.thumbLabelSuffix.set((String)thumbLabelSuffix);
    }

    public boolean isShowBoundaryValues() {
        return this.showBoundaryValues.get();
    }

    public SimpleBooleanProperty showBoundaryValuesProperty() {
        return this.showBoundaryValues;
    }

    public void setShowBoundaryValues(boolean showBoundaryValues) {
        this.showBoundaryValues.set(showBoundaryValues);
    }

    @Override
    public void onRelease() {
        if (this.changeListener != null) {
            this.mySlider.valueProperty().removeListener(this.changeListener);
        }
        this.mySlider.prefWidthProperty().unbind();
        this.mySlider.prefHeightProperty().unbind();
        this.thumbPane.prefWidthProperty().unbind();
        this.thumbPane.prefHeightProperty().unbind();
        this.thumbLabel.textProperty().unbind();
        this.thumbPane.getChildren().clear();
        this.bottomPane.getChildren().clear();
        this.boundaryLabelsPane.getChildren().clear();
        this.getChildren().clear();
        this.thumbPane = null;
        this.bottomPane = null;
        this.boundaryLabelsPane = null;
        this.minValueLabel = null;
        this.maxValueLabel = null;
        this.mySlider = null;
    }
}

