/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.statespane;

import javafx.geometry.Pos;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;

public class StatesPane
extends HBox {
    private final ImageView fx_ivState;
    private final VIEW_MODE viewMode;

    private StatesPane(VIEW_MODE viewMode) {
        this.viewMode = viewMode;
        this.setAlignment(Pos.CENTER);
        int width = this.viewMode == VIEW_MODE.HANDLER_MODE ? 9 : 20;
        int height = this.viewMode == VIEW_MODE.HANDLER_MODE ? 7 : 20;
        this.setMinHeight(height);
        this.setMinWidth(width);
        this.setMaxHeight(height);
        this.setMaxWidth(width);
        this.setPrefHeight(height);
        this.setPrefWidth(width);
        this.fx_ivState = new ImageView();
        this.getChildren().add((Object)this.fx_ivState);
        this.fx_ivState.setPreserveRatio(true);
        this.fx_ivState.setPickOnBounds(true);
    }

    public static StatesPane getInstance(VIEW_MODE viewMode) {
        return new StatesPane(viewMode);
    }

    public void setState(int state) {
        this.getResourcePBXStateImage(this.fx_ivState, state);
    }

    public boolean isPaneVisibility() {
        return this.fx_ivState.isVisible();
    }

    public void setPaneVisibility(boolean mode) {
        if (!mode) {
            if (this.fx_ivState.isVisible()) {
                this.fx_ivState.setVisible(false);
                this.fx_ivState.setManaged(true);
            }
        } else if (!this.fx_ivState.isVisible()) {
            this.fx_ivState.setVisible(true);
            this.fx_ivState.setManaged(true);
        }
    }

    private void getResourcePBXStateImage(ImageView imageView, int clientState) {
        String path = null;
        switch (clientState) {
            case 4: {
                if (this.viewMode == VIEW_MODE.MENU_MODE) {
                    if (ClientSingleton.getInstance().getConnectedSipDevice() != null && ClientSingleton.getInstance().isPhoneConnected()) {
                        path = "states/states10/state_phone.png";
                        break;
                    }
                    path = "states/states10/state_atdesk.png";
                    break;
                }
                path = "states/states10/state_atdesk.png";
                break;
            }
            case 1: {
                String string = path = this.viewMode == VIEW_MODE.MENU_MODE ? "states/states10/state_online.png" : "states/state_online.png";
                if (WhiteLabels.isCustomMenuOnlineStatus()) {
                    path = this.viewMode == VIEW_MODE.MENU_MODE ? "states/states10/state_online_green.png" : "states/state_online_green.png";
                    break;
                }
                path = this.viewMode == VIEW_MODE.MENU_MODE ? "states/states10/state_online.png" : "states/state_online.png";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                path = this.viewMode == VIEW_MODE.MENU_MODE ? "states/states10/state_busy.png" : "states/state_busy.png";
                break;
            }
            case 2: 
            case 5: {
                path = this.viewMode == VIEW_MODE.MENU_MODE ? "states/states10/state_away.png" : "states/state_away.png";
                break;
            }
            case 0: {
                String string = path = this.viewMode == VIEW_MODE.MENU_MODE ? "states/states10/state_offline.png" : "states/state_offline.png";
            }
        }
        if (path == null) {
            this.setPaneVisibility(false);
        } else {
            if (!this.isPaneVisibility()) {
                this.setPaneVisibility(true);
            }
            ClientSingleton.getInstance().setCachedImage(imageView, path);
        }
    }

    public static enum VIEW_MODE {
        MENU_MODE,
        HANDLER_MODE;

    }
}

