/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.audiomessage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.audiorecorder.VoiceMessageRecorder;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import smile.cti.client.SessionInfo;
import smile.cti.phone.PhoneDevice;

public class AudioMessagePane
extends VBox {
    private final int paneWidth = 300;
    private final int paneHeight = 300;
    private final Circle smallCircle = new Circle();
    private final Circle bigCircle = new Circle();
    private FadeTransition fadeTransition;
    private MyPopupWindow myPopupWindow;
    private Timeline timeline;
    private Label timerLabel;
    private long startTime = 0L;
    private MicTest mtest;
    private ByteArrayOutputStream outputStream;
    private ProgressBar fx_pbRecordIndicator;
    private VoiceMessageRecorder voiceMessageRecorder;
    private final SessionInfo sessionInfo;
    private final int currentMessageType;

    public AudioMessagePane() {
        this(null, 0);
    }

    public AudioMessagePane(SessionInfo sessionInfo, int currentMessageType) {
        this.sessionInfo = sessionInfo;
        this.currentMessageType = currentMessageType;
        this.initComponents();
    }

    private void initComponents() {
        this.setMaxWidth(300.0);
        this.setMaxHeight(300.0);
        StackPane header = this.getHeader();
        header.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        HBox footer = this.getFooter();
        footer.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        String color = ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR);
        this.fadeTransition = new FadeTransition(Duration.seconds((double)1.0), (Node)this.bigCircle);
        this.fadeTransition.setFromValue(0.2);
        this.fadeTransition.setToValue(0.7);
        this.fadeTransition.setAutoReverse(true);
        this.fadeTransition.setCycleCount(-1);
        this.smallCircle.setRadius(60.0);
        this.smallCircle.setFill((Paint)Color.web((String)(Theme.getInstance().isDarkTheme() ? color : "#d9e0ef")));
        ClientSingleton.getInstance().setMouseCursor((Node)this.smallCircle);
        this.smallCircle.setOnMousePressed(event -> this.action());
        this.bigCircle.setRadius(90.0);
        this.bigCircle.setFill((Paint)Color.web((String)(Theme.getInstance().isDarkTheme() ? color : "#d9e0ef")));
        this.bigCircle.setOpacity(0.0);
        MyImageView myImageView = new MyImageView(18, 18);
        myImageView.setImage("chat/bottompane/audio_message.png");
        myImageView.setOnMousePressed(event -> this.action());
        ClientSingleton.getInstance().setMouseCursor((Node)myImageView);
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        stackPane.getChildren().addAll((Object[])new Node[]{this.bigCircle, this.smallCircle, myImageView});
        VBox.setMargin((Node)stackPane, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        this.setPadding(new Insets(10.0, 20.0, 10.0, 20.0));
        this.getChildren().addAll((Object[])new Node[]{header, stackPane, footer});
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.5), evt -> this.timerTick(), new KeyValue[0])});
        this.timeline.setCycleCount(-1);
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this);
        this.myPopupWindow.show();
    }

    private void timerTick() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        long seconds = (System.currentTimeMillis() - this.startTime) / 1000L;
        long hours = seconds / 3600L;
        long minutes = (seconds -= hours * 3600L) / 60L;
        this.timerLabel.setText((Serializable)(minutes < 10L ? "0" + minutes : Long.valueOf(minutes)) + ":" + (Serializable)(seconds < 10L ? "0" + seconds : Long.valueOf(seconds -= minutes * 60L)));
    }

    private void action() {
        PhoneDevice device = ClientSingleton.getInstance().getClientConnector().get().getPhoneDevice();
        if (this.mtest == null) {
            this.mtest = new MicTest();
        }
        if (this.fadeTransition.getStatus() != Animation.Status.STOPPED) {
            if (this.mtest.running) {
                this.mtest.running = false;
                this.fx_pbRecordIndicator.progressProperty().unbind();
                device.setAudioCaptureTest(false);
                this.fx_pbRecordIndicator.setProgress(0.0);
                this.mtest = null;
            }
            try {
                this.voiceMessageRecorder.stopRecord();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.fadeTransition.stop();
            this.timeline.stop();
            this.bigCircle.setOpacity(0.0);
        } else {
            try {
                this.fx_pbRecordIndicator.progressProperty().unbind();
                this.fx_pbRecordIndicator.progressProperty().bind((ObservableValue)this.mtest.progressProperty());
                if (this.voiceMessageRecorder == null) {
                    this.voiceMessageRecorder = new VoiceMessageRecorder(ClientSingleton.getInstance().getClientConnector().get().getPhoneDevice());
                }
                this.voiceMessageRecorder.startRecord();
                new Thread((Runnable)((Object)this.mtest)).start();
            }
            catch (Exception e) {
                e.printStackTrace();
                ClientSingleton.getInstance().showAlert(e.getMessage());
            }
            this.bigCircle.setOpacity(0.2);
            this.timeline.play();
            this.fadeTransition.play();
        }
    }

    private HBox getFooter() {
        HBox hBox = new HBox();
        hBox.setPrefHeight(30.0);
        hBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        this.timerLabel = new Label();
        this.timerLabel.setText("00:00");
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.timerLabel);
        this.fx_pbRecordIndicator = new ProgressBar();
        Theme.getInstance().applyTo(Constants.PROGRESS_BAR_STYLE, (Control)this.fx_pbRecordIndicator);
        this.fx_pbRecordIndicator.setProgress(0.0);
        this.fx_pbRecordIndicator.setPrefHeight(6.0);
        HBox indicator = new HBox();
        indicator.setPrefHeight(30.0);
        indicator.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)indicator, (Priority)Priority.ALWAYS);
        this.fx_pbRecordIndicator.prefWidthProperty().bind((ObservableValue)indicator.widthProperty().subtract(40));
        indicator.getChildren().add((Object)this.fx_pbRecordIndicator);
        HBox button = new HBox();
        button.setPrefHeight(30.0);
        button.setAlignment(Pos.CENTER);
        button.setMinWidth(80.0);
        ImageButton imageButton = new ImageButton();
        imageButton.setSize(20, 20);
        imageButton.setImagePath("chat/dark_send.png");
        imageButton.setBackgroundColor("transparent");
        imageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.voiceMessageRecorder != null) {
                try {
                    File file = this.voiceMessageRecorder.getFile();
                    if (file != null && file.exists()) {
                        MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                            block7: {
                                if (this.sessionInfo != null) {
                                    try {
                                        if (this.sessionInfo.getStatus() <= 0 && this.sessionInfo.canSMS()) {
                                            AudioCaller.sendSmsMms(this.sessionInfo, file, false);
                                            break block7;
                                        }
                                        clientConnector.sendVoiceMessage(file, this.sessionInfo, this.currentMessageType);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                } else {
                                    try {
                                        clientConnector.setVoicemailPrompt(file);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.myPopupWindow.hide();
        }));
        button.getChildren().add((Object)imageButton);
        hBox.getChildren().addAll((Object[])new Node[]{this.timerLabel, indicator, imageButton});
        return hBox;
    }

    private StackPane getHeader() {
        StackPane stackPane = new StackPane();
        stackPane.setPrefHeight(30.0);
        stackPane.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)stackPane, (Priority)Priority.ALWAYS);
        Label title = new Label();
        title.setText(ClientSingleton.getInstance().getString(this.sessionInfo != null ? "audio_message" : "settings_pbx_voice_rec_sbj2"));
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)title);
        title.setAlignment(Pos.CENTER);
        CloseImageButton closeImageButton = new CloseImageButton();
        closeImageButton.setSize(20, 20);
        closeImageButton.setBackgroundColor("transparent");
        closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            this.myPopupWindow.hide();
            if (this.fadeTransition.getStatus() != Animation.Status.STOPPED) {
                this.fadeTransition.stop();
            }
        }));
        closeImageButton.requestFocus();
        StackPane.setAlignment((Node)closeImageButton, (Pos)Pos.CENTER_RIGHT);
        HBox titleBox = new HBox();
        titleBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)titleBox, (Priority)Priority.ALWAYS);
        titleBox.getChildren().add((Object)title);
        stackPane.getChildren().addAll((Object[])new Node[]{titleBox, closeImageButton});
        return stackPane;
    }

    class MicTest
    extends Task<Void> {
        boolean running;
        int maxValue = 2000;

        MicTest() {
        }

        protected Void call() throws Exception {
            AtomicReference deviceAtomicReference = new AtomicReference();
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> deviceAtomicReference.set(clientConnector.getPhoneDevice()));
            this.running = true;
            while (this.running) {
                float level = ((PhoneDevice)deviceAtomicReference.get()).getAudioCaptureLevel();
                this.updateProgress(level, this.maxValue);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.updateProgress(0L, this.maxValue);
            return null;
        }
    }
}

