/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.callhistory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.MyScheduledService;
import net.sipsnet.client.utils.viewers.buttoncombobox.MenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.mylistview.internal.IOnScrollAction;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class HistoryViewerController
implements IOnScrollAction {
    private final int HEADER_HEIGHT = 40;
    private final int LINE_HEIGHT = 30;
    private final List<MenuImageButton> menuImageButtons = new ArrayList<MenuImageButton>();
    private final IOnCloseViewer iOnCloseViewer;
    private final VBox mainScrollNode = new VBox();
    private final Map<String, Pane> records = new HashMap<String, Pane>();
    private SessionInfo sessionInfo = null;
    private final boolean withCloseButton;
    private final ObservableList<MessageInfo> messageInfos = FXCollections.observableArrayList();
    private final VirtualFlow<MessageInfo, ?> virtualFlow = VirtualFlow.createVertical(this.messageInfos, messageInfo -> {
        Pane activityCell = this.getActivity((MessageInfo)messageInfo);
        activityCell.applyCss();
        activityCell.layout();
        return Cell.wrapNode((Node)activityCell);
    });
    private final VirtualizedScrollPane<VirtualFlow<MessageInfo, ?>> scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.AS_NEEDED);

    public VBox getNode() {
        return this.mainScrollNode;
    }

    public HistoryViewerController(IOnCloseViewer iOnCloseViewer, SessionInfo sessionInfo) {
        this(iOnCloseViewer, sessionInfo, false);
    }

    public HistoryViewerController(IOnCloseViewer iOnCloseViewer, SessionInfo sessionInfo, boolean withCloseButton) {
        this.iOnCloseViewer = iOnCloseViewer;
        this.sessionInfo = sessionInfo;
        this.withCloseButton = withCloseButton;
        this.mainScrollNode.setMinWidth(300.0);
        this.mainScrollNode.setMaxWidth(300.0);
        HBox header = this.getHeader();
        header.prefWidthProperty().bind((ObservableValue)this.mainScrollNode.widthProperty());
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.getChildren().add(this.scrollPane);
        AnchorPane.setTopAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setRightAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setLeftAnchor(this.scrollPane, (Double)0.0);
        VBox.setVgrow((Node)anchorPane, (Priority)Priority.ALWAYS);
        this.mainScrollNode.getChildren().addAll((Object[])new Node[]{header, anchorPane});
        anchorPane.prefWidthProperty().bind((ObservableValue)this.mainScrollNode.widthProperty());
        this.scrollPane.prefWidthProperty().bind((ObservableValue)this.mainScrollNode.widthProperty());
        this.mainScrollNode.setStyle("-fx-background-color:transparent");
        Task task = new Task(){

            public List<MessageInfo> call() {
                return HistoryViewerController.this.loadHistory();
            }
        };
        MyScheduledService.getInstance((Task<Object>)task, this.getClass().getSimpleName()).setOnSchedulerSucceeded((EventHandler<WorkerStateEvent>)((EventHandler)event -> {
            this.messageInfos.addAll((Collection)((List)task.getValue()));
            this.virtualFlow.visibleCells();
            this.virtualFlow.applyCss();
            this.virtualFlow.layout();
        })).startWithDelay(Duration.millis((double)100.0));
        Theme.getInstance().applyTo(Constants.PROFILE_VIRTUALIZED_SCROLL, (Pane)this.mainScrollNode);
        Theme.getInstance().applyProfilesPaneTo((Pane)header);
        Theme.getInstance().applyProfilesPaneTo((Pane)anchorPane);
        header.getStyleClass().add((Object)"blockPane");
        anchorPane.getStyleClass().add((Object)"blockPane");
    }

    private List<MessageInfo> loadHistory() {
        ArrayList<MessageInfo> calls = new ArrayList<MessageInfo>();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ArrayList activities = new ArrayList();
            for (SessionInfo si : clientConnector.getCalls("")) {
                if (!si.getSessionId().equals(this.sessionInfo.getSessionId())) continue;
                SessionInfo sessionInfo1 = clientConnector.getSessionInfo(this.sessionInfo.getSessionId());
                if (sessionInfo1 == null) break;
                activities.addAll(sessionInfo1.getMessages().stream().filter(messageInfo -> messageInfo.getStatus() == 5 || messageInfo.getStatus() == 6 || messageInfo.getStatus() == 6).collect(Collectors.toList()));
                break;
            }
            if (activities.isEmpty()) {
                activities.addAll(this.sessionInfo.getMessages().stream().filter(messageInfo -> messageInfo.getStatus() == 5 || messageInfo.getStatus() == 6 || messageInfo.getStatus() == 6).collect(Collectors.toList()));
            }
            calls.addAll(activities);
        });
        return calls;
    }

    private Pane getActivity(MessageInfo messageInfo) {
        HBox activityHeader = this.getActivityHeader(messageInfo);
        activityHeader.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty().subtract(10));
        return activityHeader;
    }

    private HBox getActivityHeader(MessageInfo messageInfo) {
        HBox activityHeader = new HBox();
        activityHeader.setAlignment(Pos.CENTER_LEFT);
        Pair<String, ImageButton> labels = this.getLabels(messageInfo);
        Label myLabel = new Label();
        HBox.setHgrow((Node)myLabel, (Priority)Priority.ALWAYS);
        myLabel.setAlignment(Pos.CENTER_LEFT);
        myLabel.setPrefHeight(30.0);
        myLabel.setText((String)labels.getKey());
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)myLabel);
        long timeStart = messageInfo.getTime();
        Label dateLabel = new Label();
        HBox.setMargin((Node)dateLabel, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        dateLabel.setPrefHeight(30.0);
        dateLabel.setAlignment(Pos.CENTER_LEFT);
        Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)myLabel);
        dateLabel.setText(ClientSingleton.getInstance().getDateTimeString(timeStart));
        activityHeader.getChildren().add((Object)((Node)labels.getValue()));
        activityHeader.getChildren().add((Object)myLabel);
        activityHeader.getChildren().add((Object)dateLabel);
        return activityHeader;
    }

    private Pair<String, ImageButton> getLabels(MessageInfo messageInfo) {
        int status = messageInfo.getStatus();
        String type = "";
        ImageButton imageView = new ImageButton();
        imageView.setBackgroundColor("transparent");
        imageView.setSize(40, 40);
        imageView.setImagePath("activity/email.png");
        if (status == 5) {
            type = ClientSingleton.getInstance().getString("call_incoming");
            imageView.setImagePath("activity/activity_incomingcall_icon.png");
        } else if (status == 6) {
            type = ClientSingleton.getInstance().getString("call_outgoing");
            imageView.setImagePath("activity/activity_outgoingcall_icon.png");
        } else if (status == 12) {
            type = ClientSingleton.getInstance().getString("call_missed");
            imageView.setImagePath("activity/activity_incomingcall_icon.png");
        }
        return new Pair((Object)type, (Object)imageView);
    }

    private HBox getHeader() {
        HBox headerVBox = new HBox();
        headerVBox.setMinHeight(40.0);
        headerVBox.setMaxHeight(40.0);
        headerVBox.setAlignment(Pos.CENTER_LEFT);
        Label title = new Label();
        title.setText(ClientSingleton.getInstance().getString("tab_calls"));
        HBox.setHgrow((Node)title, (Priority)Priority.ALWAYS);
        headerVBox.getChildren().add((Object)title);
        headerVBox.setPadding(new Insets(5.0, 5.0, 0.0, 5.0));
        title.prefHeightProperty().bind((ObservableValue)headerVBox.heightProperty());
        HBox.setMargin((Node)title, (Insets)new Insets(0.0, 12.0, 0.0, 12.0));
        if (this.withCloseButton) {
            HBox closeBox = new HBox();
            closeBox.prefHeightProperty().bind((ObservableValue)headerVBox.heightProperty());
            closeBox.setAlignment(Pos.CENTER_LEFT);
            headerVBox.getChildren().add((Object)closeBox);
            closeBox.setMinWidth(20.0);
            closeBox.setAlignment(Pos.CENTER_RIGHT);
            HBox.setMargin((Node)closeBox, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            CloseImageButton closeImageButton = new CloseImageButton();
            closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.iOnCloseViewer.onCloseViewer()));
            closeBox.getChildren().add((Object)closeImageButton);
        }
        headerVBox.requestFocus();
        Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)title);
        Theme.getInstance().applyProfilesPaneTo((Pane)headerVBox);
        VBox.setMargin((Node)headerVBox, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        return headerVBox;
    }

    @Override
    public void scrolling() {
        for (MenuImageButton menuImageButton : this.menuImageButtons) {
            menuImageButton.hideMenu();
        }
    }
}

