/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocallnotification;

import java.util.HashMap;
import java.util.Timer;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.event.EventHandler;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.calls.utils.CallLineUtils;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class CallBasePane
extends HBox {
    private final Stage owner;
    protected final ICallNotificationPaneResize iCallNotificationPaneResize;
    private double xOffset;
    private double yOffset;
    private Timer timer;
    private Label lbConnectTimer;
    private CallViewButton holdCallImageButton;
    private CallViewButton muteCallImageButton;
    private CallViewButton hangupCallImageButton;
    private CallViewButton recordCallImageButton;
    private CallViewButton answerCallImageButton;
    private CallViewButton answerVideoCallImageButton;
    private LineInfo lineInfo;
    private VBox fx_MainPane;
    private double fixedX = -1.0;
    private double fixedY = -1.0;
    protected IRingtoneMuteState iRingtoneMuteState;
    private boolean isFirstCallPosition = true;
    private final SimpleIntegerProperty nodeWidth = new SimpleIntegerProperty(0);
    private final SimpleIntegerProperty nodeHeight = new SimpleIntegerProperty(0);
    private MyPopupWindow childWindow;
    private boolean isHoldState = false;

    public boolean isFirstCallPosition() {
        return this.isFirstCallPosition;
    }

    public void setFirstCallPosition(boolean firstCallPosition) {
        this.isFirstCallPosition = firstCallPosition;
    }

    public void setCurrentSize() {
    }

    protected void setNodeWidth(int nodeWidth) {
        this.nodeWidth.set(nodeWidth);
    }

    protected void setNodeHeight(int nodeHeight) {
        this.nodeHeight.set(nodeHeight + 25);
    }

    public void setContent(VBox fx_MainPane, Pane pane) {
        this.getChildren().clear();
        this.getChildren().add((Object)pane);
        this.fx_MainPane = fx_MainPane;
    }

    public void clearTimer() {
        this.isHoldState = false;
        if (this.lbConnectTimer != null) {
            this.lbConnectTimer.setText("00:00");
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public CallViewButton getAnswerCallImageButton() {
        if (this.answerCallImageButton == null) {
            this.answerCallImageButton = new CallViewButton(WhiteLabels.isCustomAnswerButton() ? "answer_button/callpanel_answer.png" : "call_notification/callpanel_answer.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "AnswerCallButton was pressed");
                AudioCaller.answerCall(this.lineInfo);
                this.lineInfo.setVideo(false);
                event.consume();
            }));
        }
        return this.answerCallImageButton;
    }

    public CallViewButton getAnswerVideoCallImageButton() {
        if (this.answerVideoCallImageButton == null) {
            this.answerVideoCallImageButton = new CallViewButton(WhiteLabels.isCustomAnswerButton() ? "answer_button/callpanel_answer_video.png" : "call_notification/callpanel_answer_video.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "AnswerVideoCallButton was pressed");
                AudioCaller.answerCall(this.lineInfo, true);
                event.consume();
            }));
        }
        return this.answerVideoCallImageButton;
    }

    public void setBackgroundColor(boolean isHold) {
        if (isHold) {
            Theme.getInstance().applyCallPaneTo(Theme.CALL_PANE_HOLD_BACKGROUND, (Pane)this.fx_MainPane);
        } else {
            Theme.getInstance().applyCallPaneTo(Theme.CALL_NOTIFICATION_BACKGROUND, (Pane)this.fx_MainPane);
        }
    }

    protected LineInfo getLineInfo() {
        return this.lineInfo;
    }

    protected boolean isConference() {
        return this.lineInfo.isConference() || this.getLineInfo().getState() == 5;
    }

    public void setHoldState(boolean holdState) {
        this.isHoldState = holdState;
    }

    protected CallViewButton getHoldCallImageButton() {
        if (this.holdCallImageButton == null) {
            this.holdCallImageButton = CallLineUtils.getHoldCallImageButton(this::getLineInfo);
        }
        return this.holdCallImageButton;
    }

    protected CallViewButton getMuteCallImageButton() {
        if (this.muteCallImageButton == null) {
            this.muteCallImageButton = CallLineUtils.getMuteCallImageButton();
        }
        return this.muteCallImageButton;
    }

    protected CallViewButton getHangupCallImageButton() {
        if (this.hangupCallImageButton == null) {
            this.hangupCallImageButton = CallLineUtils.getHangupCallImageButton(this::getLineInfo);
        }
        return this.hangupCallImageButton;
    }

    protected CallViewButton getRecordCallImageButton() {
        if (this.recordCallImageButton == null) {
            this.recordCallImageButton = CallLineUtils.getRecordCallImageButton(this::getLineInfo);
        }
        return this.recordCallImageButton;
    }

    public CallBasePane(Stage owner, ICallNotificationPaneResize iCallNotificationPaneResize) {
        this.owner = owner;
        this.iCallNotificationPaneResize = iCallNotificationPaneResize;
    }

    public void getNumber(Label label, Pane parent) {
        this.getNumber(label, parent, false);
    }

    public void getNumber(Label label, Pane parent, boolean isMultiline) {
        CallLineUtils.getNumber(this.getLineInfo(), label, parent, isMultiline);
    }

    public String getNumber() {
        return CallLineUtils.getNumber(this.getLineInfo());
    }

    public void setChildWindow(MyPopupWindow childWindow) {
        this.childWindow = childWindow;
    }

    public void fixCoordinates() {
        this.fixedX = this.owner.getX();
        this.fixedY = this.owner.getY();
    }

    public void setOnFixedCoordinate() {
        if (this.fixedX != -1.0) {
            this.owner.setX(this.fixedX);
            this.owner.setY(this.fixedY);
        }
    }

    public Pair<Double, Double> getFixedPosition() {
        if (this.isFirstCallPosition()) {
            return null;
        }
        return new Pair((Object)this.owner.getX(), (Object)this.owner.getY());
    }

    protected void setX(double x) {
        this.owner.setX(x);
    }

    protected void setY(double y) {
        this.owner.setY(y);
    }

    protected double getX() {
        return this.owner.getX();
    }

    protected double getY() {
        return this.owner.getY();
    }

    public static int getCallViewNotificationMode() {
        return null != ClientSingleton.getInstance().getClientConnector().get().getProperty(Constants.SHOW_POPUP) ? (Integer)ClientSingleton.getInstance().getClientConnector().get().getProperty(Constants.SHOW_POPUP) : 0;
    }

    protected void setLineInfo(LineInfo lineInfo) {
        this.lineInfo = lineInfo;
    }

    public Pane setLineInfoParameters() {
        return null;
    }

    public int getNodeWidth() {
        return this.nodeWidth.get();
    }

    public int getNodeHeight() {
        return this.nodeHeight.get();
    }

    protected void initDraggedListener(HBox pane) {
        pane.setOnMousePressed(event -> {
            this.xOffset = this.owner.getX() - event.getScreenX();
            this.yOffset = this.owner.getY() - event.getScreenY();
        });
        pane.setOnMouseDragged(event -> {
            if (this.isFirstCallPosition) {
                this.setFirstCallPosition(false);
            }
            this.owner.setX(event.getScreenX() + this.xOffset);
            this.owner.setY(event.getScreenY() + this.yOffset);
            if (this.childWindow != null) {
                Stage childWindowStage = this.childWindow.getStage();
                double x = event.getScreenX() + this.xOffset;
                childWindowStage.setX(x += ((double)this.getNodeWidth() - childWindowStage.getWidth()) / 2.0);
                if (this.childWindow.isUpStyle()) {
                    childWindowStage.setY(event.getScreenY() - childWindowStage.getHeight() + this.yOffset);
                } else {
                    double y = event.getScreenY() + this.getHeight() + this.yOffset + 15.0;
                    childWindowStage.setY(y);
                }
            }
        });
    }

    public void openSession() {
        this.openSession(null);
    }

    public void openSession(MouseEvent event) {
        if (this.getLineInfo() == null || event != null && event.getClickCount() < 2) {
            return;
        }
        SessionInfo sessionInfo = this.getLineInfo().getSessionInfo();
        if (sessionInfo != null) {
            if (!sessionInfo.isGroup() && (this.getLineInfo().isConference() || this.getLineInfo().getState() == 5)) {
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", this.getLineInfo().getSessionInfo());
            data.put("tab", 4);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        }
    }

    public void openHistoryViewer() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", this.lineInfo.getSessionInfo());
        data.put(Constants.OPEN_SESSION_MODE, Constants.OPEN_SESSION_WITH_CALL_HISTORY);
        ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        ClientSingleton.getInstance().getParentWindow().requestFocus();
    }

    public void openCallActivityViewer() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", this.lineInfo.getSessionInfo());
        data.put(Constants.OPEN_SESSION_MODE, Constants.OPEN_SESSION_WITH_ACTIVITY);
        ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        ClientSingleton.getInstance().getParentWindow().requestFocus();
    }

    protected void addRingtoneMuteStateListener(IRingtoneMuteState iRingtoneMuteState) {
    }

    protected void setRingtoneMuteState() {
    }
}

