/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocallnotification;

import java.io.IOException;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.views.calls.audiocallnotification.CallBasePane;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class CallIncomingNotificationPane
extends CallBasePane {
    private HBox fx_AvatarPane;
    private Label fx_lbCallingName;
    private Label fx_lbCallingNumber;
    private HBox fx_hbBottomButtonsPane;
    private Label fx_lbCallTrunk;
    private Pane fx_lbCallInfo;
    private CallViewButton muteCallImageButton;
    private HBox fx_hbButtonPane2;
    private HBox fx_hbCallInfoLabel;

    public CallIncomingNotificationPane(Stage stage, LineInfo lineInfo, ICallNotificationPaneResize iCallNotificationPaneResize, IRingtoneMuteState iRingtoneMuteState) {
        super(stage, iCallNotificationPaneResize);
        super.setLineInfo(lineInfo);
        this.iRingtoneMuteState = iRingtoneMuteState;
        this.setIncomingCallPane();
    }

    public HBox setLineInfoParameters() {
        if (AudioCaller.getWorkingLinesCount() == 1) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.setMute(false));
        }
        this.fx_lbCallingName.setText(this.getLineInfo().getPartyName());
        SessionInfo sessionInfo = this.getLineInfo().getSessionInfo();
        AvatarPane avatarPane = AvatarPane.getInstance(sessionInfo, 32, 14, true);
        this.fx_AvatarPane.getChildren().clear();
        this.fx_AvatarPane.getChildren().add((Object)avatarPane);
        this.getNumber(this.fx_lbCallingNumber, this.fx_lbCallInfo, false);
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "setLineInfoParameters getLineInfo().isVideoEnabled()=" + this.getLineInfo().isVideoEnabled() + " canVideo=" + ClientSingleton.getInstance().canVideo());
        if (ClientSingleton.getInstance().canVideo() && this.getLineInfo().isVideoEnabled()) {
            if (!this.fx_hbBottomButtonsPane.getChildren().contains((Object)this.fx_hbButtonPane2)) {
                this.fx_hbBottomButtonsPane.getChildren().add(2, (Object)this.fx_hbButtonPane2);
            }
        } else {
            this.fx_hbBottomButtonsPane.getChildren().remove((Object)this.fx_hbButtonPane2);
        }
        this.fx_hbBottomButtonsPane.setMaxWidth((double)(this.fx_hbBottomButtonsPane.getChildren().size() * 34));
        AudioCaller.addTrunkLabel(this.getLineInfo(), this.fx_lbCallTrunk, this.fx_lbCallInfo);
        boolean isMuting = this.iRingtoneMuteState == null || !this.iRingtoneMuteState.isRingtoneMuted();
        ClientSingleton.getInstance().setCachedImage(this.muteCallImageButton, isMuting ? "call_notification/callpanel_incoming_mute_off.png" : "call_notification/callpanel_incoming_mute_on.png");
        this.setNodeWidth(318);
        this.setNodeHeight(120);
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "getView  done");
        if (AudioCaller.getWorkingLinesCount() == 1) {
            this.iCallNotificationPaneResize.relocateOnStartPosition();
        }
        return this;
    }

    private void setIncomingCallPane() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/line/notification/incomingcallpane_small.fxml"));
        try {
            ImageView fx_LogoPane;
            loader.setResources(ClientSingleton.getInstance().getResourceBundle());
            VBox incomingCallPane = (VBox)loader.load();
            HBox fx_MutePane = (HBox)loader.getNamespace().get((Object)"fx_MutePane");
            this.muteCallImageButton = new CallViewButton("call_notification/callpanel_incoming_mute_off.png", (EventHandler<MouseEvent>)((EventHandler)str -> this.iRingtoneMuteState.setRingtoneMuteState(true)));
            if (fx_MutePane != null) {
                fx_MutePane.getChildren().add((Object)this.muteCallImageButton);
            }
            this.fx_AvatarPane = (HBox)loader.getNamespace().get((Object)"fx_AvatarPane");
            this.fx_hbBottomButtonsPane = (HBox)loader.getNamespace().get((Object)"fx_hbBottomButtonsPane");
            HBox fx_hbButtonPane1 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane1");
            this.fx_hbButtonPane2 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane2");
            HBox fx_hbButtonPane3 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane3");
            this.fx_lbCallingName = (Label)loader.getNamespace().get((Object)"fx_lbCallingName");
            this.fx_lbCallingNumber = (Label)loader.getNamespace().get((Object)"fx_lbCallingNumber");
            this.fx_hbCallInfoLabel = (HBox)loader.getNamespace().get((Object)"fx_hbCallInfoLabel");
            fx_hbButtonPane1.getChildren().add((Object)this.getAnswerCallImageButton());
            if (ClientSingleton.getInstance().canVideo()) {
                this.fx_hbButtonPane2.getChildren().add((Object)this.getAnswerVideoCallImageButton());
            }
            fx_hbButtonPane3.getChildren().add((Object)this.getHangupCallImageButton());
            this.fx_lbCallTrunk = (Label)loader.getNamespace().get((Object)"fx_lbCallTrunk");
            this.fx_lbCallInfo = (Pane)loader.getNamespace().get((Object)"fx_lbCallInfo");
            Label fx_lbAppName = (Label)loader.getNamespace().get((Object)"fx_lbAppName");
            if (fx_lbAppName != null) {
                fx_lbAppName.setText(ClientSingleton.getInstance().getPackageName());
            }
            if ((fx_LogoPane = (ImageView)loader.getNamespace().get((Object)"fx_LogoPane")) != null) {
                ClientSingleton.getInstance().setImageToImageView(fx_LogoPane, "notify_emblem.png");
            }
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_AvatarPane);
            this.fx_AvatarPane.setOnMousePressed(eventMouse -> this.openSession());
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbCallingName);
            this.fx_lbCallingName.setOnMousePressed(eventMouse -> this.openSession());
            ClientSingleton.getInstance().setMouseCursor((Node)fx_LogoPane);
            HBox fx_hbLogo = (HBox)loader.getNamespace().get((Object)"fx_hbLogo");
            ClientSingleton.getInstance().setMouseCursor((Node)fx_hbLogo);
            fx_hbLogo.setOnMousePressed(event -> {
                if (ClientSingleton.getInstance().getCurrentViewMode() == 1) {
                    ClientSingleton.getInstance().showWindow();
                } else {
                    this.openSession();
                }
            });
            VBox fx_MainPane = (VBox)loader.getNamespace().get((Object)"fx_MainPane");
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbCallingName, Theme.WHITE_EXTRA_COLOR);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbCallingNumber, Theme.WHITE_EXTRA_COLOR);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbCallTrunk, Theme.WHITE_EXTRA_COLOR);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)fx_lbAppName, Theme.WHITE_EXTRA_COLOR);
            super.setContent(fx_MainPane, (Pane)incomingCallPane);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setRingtoneMuteState() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> ClientSingleton.getInstance().setCachedImage(this.muteCallImageButton, "call_notification/callpanel_incoming_mute_on.png"));
    }

    @Override
    public void addRingtoneMuteStateListener(IRingtoneMuteState iRingtoneMuteState) {
        this.iRingtoneMuteState = iRingtoneMuteState;
    }
}

