/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocallnotification;

import java.io.IOException;
import java.util.HashMap;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.views.calls.audiocallnotification.CallBasePane;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.calls.utils.LineTimer;
import smile.cti.client.LineInfo;

public class CallSmallNotificationPane
extends CallBasePane {
    private Label fx_lbConnectSmallCallingName;
    private Label fx_lbConnectSmallCallingNumber;
    private Label fx_lbConnectSmallTimer;
    private HBox fx_ConnectAvatarPane;
    private final int CONNECTED_VIEW = 0;
    public static final int OUTGOING_VIEW = 1;
    private int currentViewMode = 0;
    private final int defaultWidth = 318;
    private final int defaultHeight = 91;
    private HBox fx_hbCallInfo;
    private HBox fx_hbCallInfoLabel;

    public CallSmallNotificationPane(Stage stage, LineInfo lineInfo, ICallNotificationPaneResize iCallNotificationPaneResize) {
        super(stage, iCallNotificationPaneResize);
        super.setLineInfo(lineInfo);
        this.setSmallConnectPane();
        this.setMaxWidth(318.0);
        this.setWidth(318.0);
        this.setMinWidth(318.0);
        this.setMaxHeight(91.0);
        this.setHeight(91.0);
        this.setMinHeight(91.0);
        LineTimer.getInstance().addToLine(lineInfo, this.fx_lbConnectSmallTimer);
    }

    @Override
    public void setCurrentSize() {
        this.setNodeWidth(318);
        this.setNodeHeight(91);
    }

    public int getCurrentViewMode() {
        return this.currentViewMode;
    }

    public HBox setLineInfoParameters() {
        this.fx_lbConnectSmallTimer.setText("");
        try {
            AvatarPane avatarPane = AvatarPane.getInstance(this.getLineInfo().getSessionInfo(), 32, 16, false);
            this.fx_ConnectAvatarPane.getChildren().clear();
            this.fx_ConnectAvatarPane.getChildren().add((Object)avatarPane);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.getLineInfo().getState() != 1) {
            this.getNumber(this.fx_lbConnectSmallCallingNumber, (Pane)this.fx_hbCallInfo);
        } else {
            this.fx_lbConnectSmallCallingNumber.setText(ClientSingleton.getInstance().getString("call_detail_outgoing"));
        }
        this.fx_lbConnectSmallCallingName.setText(this.getLineInfo().getState() == 5 ? ClientSingleton.getInstance().getString("call_conference") : this.getLineInfo().getPartyName());
        if (this.getLineInfo().getState() != 5 && this.fx_lbConnectSmallCallingName.getText().equalsIgnoreCase(this.fx_lbConnectSmallCallingNumber.getText())) {
            this.fx_lbConnectSmallCallingNumber.setText("");
        }
        if (this.getLineInfo().getState() == 1 && AudioCaller.getWorkingLinesCount() == 1) {
            this.iCallNotificationPaneResize.relocateOnStartPosition();
        }
        return this;
    }

    public void setSmallConnectPane() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/line/notification/connectcallpane_small.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        try {
            VBox connectSmallCallPane = (VBox)loader.load();
            this.fx_ConnectAvatarPane = (HBox)loader.getNamespace().get((Object)"fx_ConnectAvatarPane");
            HBox fx_hbConnectButtonPane1 = (HBox)loader.getNamespace().get((Object)"fx_hbConnectButtonPane1");
            fx_hbConnectButtonPane1.getChildren().add((Object)this.getHoldCallImageButton());
            HBox fx_hbConnectButtonPane2 = (HBox)loader.getNamespace().get((Object)"fx_hbConnectButtonPane2");
            fx_hbConnectButtonPane2.getChildren().add((Object)this.getMuteCallImageButton());
            HBox fx_hbConnectButtonPane3 = (HBox)loader.getNamespace().get((Object)"fx_hbConnectButtonPane3");
            fx_hbConnectButtonPane3.getChildren().add((Object)this.getHangupCallImageButton());
            this.fx_hbCallInfo = (HBox)loader.getNamespace().get((Object)"fx_hbCallInfo");
            this.fx_hbCallInfoLabel = (HBox)loader.getNamespace().get((Object)"fx_hbCallInfoLabel");
            this.fx_lbConnectSmallCallingName = (Label)loader.getNamespace().get((Object)"fx_lbConnectCallingName");
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_lbConnectSmallCallingName);
            this.fx_lbConnectSmallCallingName.setOnMouseClicked(eventMouse -> {
                if (eventMouse.getClickCount() == 2) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("sessionInfo", this.getLineInfo().getSessionInfo());
                    ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
                    ClientSingleton.getInstance().getParentWindow().requestFocus();
                }
            });
            this.fx_lbConnectSmallCallingNumber = (Label)loader.getNamespace().get((Object)"fx_lbConnectCallingNumber");
            this.fx_lbConnectSmallTimer = (Label)loader.getNamespace().get((Object)"fx_lbConnectTimer");
            ImageView fx_LogoPane = (ImageView)loader.getNamespace().get((Object)"fx_LogoPane");
            if (fx_LogoPane != null) {
                ClientSingleton.getInstance().setImageToImageView(fx_LogoPane, "notify_emblem.png");
            }
            this.currentViewMode = 0;
            VBox fx_MainPane = (VBox)loader.getNamespace().get((Object)"fx_RootPane");
            this.setCurrentSize();
            super.setContent(fx_MainPane, (Pane)connectSmallCallPane);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void setSmallOutcomePane() {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/line/notification/outcomecallpane_small.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        try {
            VBox connectSmallCallPane = (VBox)loader.load();
            this.fx_ConnectAvatarPane = (HBox)loader.getNamespace().get((Object)"fx_ConnectAvatarPane");
            HBox fx_hbConnectButtonPane1 = (HBox)loader.getNamespace().get((Object)"fx_hbConnectButtonPane1");
            fx_hbConnectButtonPane1.getChildren().add((Object)this.getHangupCallImageButton());
            this.fx_lbConnectSmallCallingName = (Label)loader.getNamespace().get((Object)"fx_lbConnectCallingName");
            this.fx_lbConnectSmallCallingNumber = (Label)loader.getNamespace().get((Object)"fx_lbConnectCallingNumber");
            this.fx_hbCallInfoLabel = (HBox)loader.getNamespace().get((Object)"fx_hbCallInfoLabel");
            Label fx_lbAppName = (Label)loader.getNamespace().get((Object)"fx_lbAppName");
            if (fx_lbAppName != null) {
                fx_lbAppName.setText(ClientSingleton.getInstance().getPackageName());
                Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)fx_lbAppName, Theme.WHITE_EXTRA_COLOR);
            }
            ImageView fx_LogoPane = (ImageView)loader.getNamespace().get((Object)"fx_LogoPane");
            ClientSingleton.getInstance().setImageToImageView(fx_LogoPane, "notify_emblem.png");
            this.currentViewMode = 1;
            VBox fx_MainPane = (VBox)loader.getNamespace().get((Object)"fx_RootPane");
            this.setCurrentSize();
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbConnectSmallCallingName, Theme.WHITE_EXTRA_COLOR);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbConnectSmallCallingNumber, Theme.WHITE_EXTRA_COLOR);
            super.setContent(fx_MainPane, (Pane)connectSmallCallPane);
            if (AudioCaller.getWorkingLinesCount() == 1) {
                this.iCallNotificationPaneResize.relocateOnStartPosition();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

