/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocallnotification.inoutcall;

import java.io.IOException;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.views.calls.audiocallnotification.CallBasePane;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.calls.utils.CallLineUtils;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class CallInOutNotificationPane
extends CallBasePane {
    private HBox fx_AvatarPane;
    private Label fx_lbCallingName;
    private Label fx_lbCallingNumber;
    private HBox fx_hbBottomButtonsPane;
    private Label fx_lbCallTrunk;
    private Pane fx_lbCallInfo;
    private CallViewButton muteCallImageButton;
    private HBox fx_hbButtonPane1;
    private HBox fx_hbButtonPane2;
    private HBox fx_hbButtonPane3;
    private final SimpleBooleanProperty muting = new SimpleBooleanProperty();

    public boolean isMuting() {
        return this.muting.get();
    }

    public void setMuting(boolean muting) {
        this.muting.set(muting);
    }

    public CallInOutNotificationPane(Stage stage, ICallNotificationPaneResize iCallNotificationPaneResize, IRingtoneMuteState iRingtoneMuteState) {
        super(stage, iCallNotificationPaneResize);
        this.iRingtoneMuteState = iRingtoneMuteState;
        this.setIncomingCallPane();
    }

    public Pane getView(boolean isIncomingCall, LineInfo lineInfo) {
        boolean isVideoConnected;
        this.setLineInfo(lineInfo);
        this.setIncomingCallPane();
        if (AudioCaller.getWorkingLinesCount() == 1) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.setMute(false));
        }
        this.fx_lbCallingName.setText(CallLineUtils.getName(lineInfo));
        SessionInfo sessionInfo = this.getLineInfo().getSessionInfo();
        AvatarPane avatarPane = AvatarPane.getInstance(sessionInfo, 60, "#f1f2f5", 28, true);
        HBox.setMargin((Node)avatarPane, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        this.fx_AvatarPane.getChildren().clear();
        this.fx_AvatarPane.getChildren().add((Object)avatarPane);
        boolean bl = isVideoConnected = ClientSingleton.getInstance().canVideo() && lineInfo != null && lineInfo.isVideoEnabled();
        if (!isIncomingCall) {
            this.fx_hbBottomButtonsPane.getChildren().remove((Object)this.fx_hbButtonPane1);
            this.fx_hbBottomButtonsPane.getChildren().remove((Object)this.fx_hbButtonPane2);
        } else {
            if (!this.fx_hbBottomButtonsPane.getChildren().contains((Object)this.fx_hbButtonPane1)) {
                this.fx_hbBottomButtonsPane.getChildren().add((Object)this.fx_hbButtonPane1);
            }
            if (!this.fx_hbBottomButtonsPane.getChildren().contains((Object)this.fx_hbButtonPane3)) {
                this.fx_hbBottomButtonsPane.getChildren().add((Object)this.fx_hbButtonPane3);
            }
            this.fx_hbButtonPane2.setVisible(isVideoConnected);
        }
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_AvatarPane);
        this.fx_AvatarPane.setOnMousePressed(eventMouse -> this.openSession());
        this.getNumber(this.fx_lbCallingNumber, this.fx_lbCallInfo, true);
        AudioCaller.addTrunkLabel(lineInfo, this.fx_lbCallTrunk, this.fx_lbCallInfo);
        this.setMuting(false);
        boolean isRingtoneMuted = this.iRingtoneMuteState == null || !this.iRingtoneMuteState.isRingtoneMuted();
        this.muteCallImageButton.setImagePath(isRingtoneMuted ? "call_notification/callpanel_incoming_mute_off.png" : "call_notification/callpanel_incoming_mute_on.png");
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "getView isIncomingCall=" + isIncomingCall + " done");
        return this;
    }

    private void setIncomingCallPane() {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "setIncomingCallPane");
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/fxml/line/notification/incomingcallpane.fxml"));
        try {
            ImageView fx_LogoPane;
            loader.setResources(ClientSingleton.getInstance().getResourceBundle());
            VBox incomingCallPane = (VBox)loader.load();
            HBox fx_MutePane = (HBox)loader.getNamespace().get((Object)"fx_MutePane");
            this.muteCallImageButton = new CallViewButton("call_notification/callpanel_incoming_mute_off.png", (EventHandler<MouseEvent>)((EventHandler)str -> this.iRingtoneMuteState.setRingtoneMuteState(true)));
            if (fx_MutePane != null) {
                fx_MutePane.getChildren().add((Object)this.muteCallImageButton);
            }
            this.fx_AvatarPane = (HBox)loader.getNamespace().get((Object)"fx_AvatarPane");
            this.fx_hbBottomButtonsPane = (HBox)loader.getNamespace().get((Object)"fx_hbBottomButtonsPane");
            this.fx_hbButtonPane1 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane1");
            this.fx_hbButtonPane2 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane2");
            this.fx_hbButtonPane3 = (HBox)loader.getNamespace().get((Object)"fx_hbButtonPane3");
            this.fx_lbCallingName = (Label)loader.getNamespace().get((Object)"fx_lbCallingName");
            this.fx_lbCallingNumber = (Label)loader.getNamespace().get((Object)"fx_lbCallingNumber");
            this.fx_hbButtonPane3.getChildren().add((Object)this.getHangupCallImageButton());
            this.fx_hbButtonPane1.getChildren().add((Object)this.getAnswerCallImageButton());
            if (ClientSingleton.getInstance().canVideo()) {
                this.fx_hbButtonPane2.getChildren().add((Object)this.getAnswerVideoCallImageButton());
            }
            this.fx_lbCallTrunk = (Label)loader.getNamespace().get((Object)"fx_lbCallTrunk");
            this.fx_lbCallInfo = (Pane)loader.getNamespace().get((Object)"fx_lbCallInfo");
            Label fx_lbAppName = (Label)loader.getNamespace().get((Object)"fx_lbAppName");
            if (fx_lbAppName != null) {
                fx_lbAppName.setText(ClientSingleton.getInstance().getPackageName());
                Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)fx_lbAppName, Theme.WHITE_EXTRA_COLOR);
            }
            if ((fx_LogoPane = (ImageView)loader.getNamespace().get((Object)"fx_LogoPane")) != null) {
                ClientSingleton.getInstance().setImageToImageView(fx_LogoPane, "notify_emblem.png");
            }
            VBox fx_MainPane = (VBox)loader.getNamespace().get((Object)"fx_MainPane");
            Theme.getInstance().applyCallPaneTo(Theme.CALL_NOTIFICATION_BACKGROUND, (Pane)fx_MainPane);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbCallingName, Theme.WHITE_EXTRA_COLOR);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbCallingNumber, Theme.WHITE_EXTRA_COLOR);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbCallTrunk, Theme.WHITE_EXTRA_COLOR);
            this.setNodeWidth(165);
            this.setNodeHeight(204);
            super.setContent(fx_MainPane, (Pane)incomingCallPane);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setRingMute() {
        if (!this.isMuting()) {
            this.setMuting(true);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                clientConnector.stopPlayRing();
                this.muteCallImageButton.setImagePath("call_notification/callpanel_incoming_mute_on.png");
            });
        }
    }

    @Override
    public void setRingtoneMuteState() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> ClientSingleton.getInstance().setCachedImage(this.muteCallImageButton, "call_notification/callpanel_incoming_mute_on.png"));
    }

    @Override
    public void addRingtoneMuteStateListener(IRingtoneMuteState iRingtoneMuteState) {
        this.iRingtoneMuteState = iRingtoneMuteState;
    }
}

