/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocallnotification.inoutcall;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.calls.audiocallnotification.inoutcall.CallInOutNotificationPane;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineInfo;

public class CallInOutNotificationStage
implements ICallNotificationPaneResize {
    private final HBox rootPane;
    private final Stage mainStage;
    private final CallInOutNotificationPane inoutCallStage;
    private final SimpleBooleanProperty showing = new SimpleBooleanProperty();

    public void setMuting(boolean muting) {
        this.inoutCallStage.setMuting(muting);
    }

    public boolean isMuting() {
        return this.inoutCallStage.isMuting();
    }

    public CallInOutNotificationStage(IRingtoneMuteState iRingtoneMuteState) {
        this.mainStage = new Stage();
        this.rootPane = new HBox();
        this.rootPane.setStyle("-fx-background-color:transparent;-fx-border-radius: 8 8 8 8;\n    -fx-background-radius: 8 8 8 8;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);");
        this.inoutCallStage = new CallInOutNotificationPane(this.mainStage, this, iRingtoneMuteState);
        this.mainStage.initStyle(StageStyle.TRANSPARENT);
        this.mainStage.initModality(Modality.NONE);
        Stage primaryStage = new Stage();
        primaryStage.initStyle(StageStyle.UTILITY);
        primaryStage.setOpacity(0.0);
        primaryStage.setHeight(0.0);
        primaryStage.setWidth(0.0);
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            primaryStage.show();
        }
        this.mainStage.initOwner((Window)primaryStage);
        Scene scene = new Scene((Parent)this.rootPane, 10.0, 10.0);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.mainStage.setScene(scene);
        this.mainStage.setMinWidth(this.rootPane.minHeight(-1.0));
        this.mainStage.setMinHeight(this.rootPane.minHeight(-1.0));
        this.mainStage.setX(-5000.0);
        this.mainStage.setY(Constants.INVISIBLE_POSITION_Y);
        this.rootPane.setVisible(false);
        this.showing.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                ClientSingleton.getInstance().toCenterInScreen(this.mainStage);
                this.rootPane.setVisible(true);
                this.mainStage.toFront();
                this.mainStage.requestFocus();
                this.mainStage.show();
            } else {
                this.mainStage.toBack();
                this.mainStage.hide();
                if (this.rootPane.isVisible()) {
                    this.rootPane.setVisible(false);
                }
                this.mainStage.setX(-5000.0);
                this.mainStage.setY(Constants.INVISIBLE_POSITION_Y);
            }
            this.mainStage.setAlwaysOnTop(newValue.booleanValue());
        });
        this.mainStage.setOnShown(event -> {
            this.rootPane.applyCss();
            this.rootPane.requestFocus();
            this.mainStage.requestFocus();
        });
        this.mainStage.setWidth((double)this.inoutCallStage.getNodeWidth());
        this.mainStage.setHeight((double)this.inoutCallStage.getNodeHeight());
        this.initHotKey();
        this.showing.set(false);
    }

    public void initView(LineInfo lineInfo, boolean isIncomingMode) {
        this.rootPane.getChildren().clear();
        this.rootPane.getChildren().add((Object)this.inoutCallStage.getView(isIncomingMode, lineInfo));
    }

    public void hideNotification() {
        if (this.isShowing()) {
            this.setShowing(false);
        }
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public void setShowing(boolean showing) {
        this.showing.set(showing);
    }

    @Override
    public synchronized boolean onResize() {
        this.mainStage.setWidth((double)this.inoutCallStage.getNodeWidth());
        this.mainStage.setHeight((double)this.inoutCallStage.getNodeHeight());
        return true;
    }

    @Override
    public void relocateOnStartPosition() {
    }

    private void initHotKey() {
        boolean isMac = ClientUtil.getOS() == ClientUtil.OS.MAC;
        KeyCodeCombination kcAnswerCall = new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{isMac ? KeyCombination.SHORTCUT_DOWN : KeyCombination.CONTROL_DOWN});
        this.mainStage.getScene().getAccelerators().put((Object)kcAnswerCall, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null && lineInfo.getState() == 2) {
                AudioCaller.answerCall(lineInfo, false);
            }
        });
        KeyCodeCombination kcDropCall = new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{isMac ? KeyCombination.SHORTCUT_DOWN : KeyCombination.CONTROL_DOWN});
        this.mainStage.getScene().getAccelerators().put((Object)kcDropCall, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                AudioCaller.dropCall(lineInfo);
            }
        });
    }

    public void setRingtoneMuteState() {
        this.inoutCallStage.setRingtoneMuteState();
    }
}

