/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocontrolls;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;

public class AssistanceLinePane
extends HBox {
    private HBox hbButton1;
    private ArrayList<String> androids;
    private HBox hbTitle;
    private final AtomicInteger width = new AtomicInteger(50);
    private Label lbContactTitle;

    public void setContactStateTitle(String name) {
        for (int index = 0; index < this.androids.size(); ++index) {
            String version = this.androids.get(index);
            if (!name.contains(version)) continue;
            name = name.replace(version, "");
            break;
        }
        this.lbContactTitle.setText(name);
        this.hbTitle.setMaxWidth(270.0);
        this.hbTitle.setMinWidth(270.0);
    }

    public AssistanceLinePane() {
        this.initAndroidsVersion();
        this.initPane();
    }

    private void initPane() {
        Theme.getInstance().applyCallPaneTo(Theme.CALL_LINE_BACKGROUND, (Pane)this);
        VBox.setMargin((Node)this, (Insets)new Insets(3.0, 8.0, 3.0, 0.0));
        this.setAlignment(Pos.CENTER_LEFT);
        this.hbTitle = new HBox();
        HBox.setHgrow((Node)this.hbTitle, (Priority)Priority.ALWAYS);
        this.hbTitle.setAlignment(Pos.CENTER_LEFT);
        this.lbContactTitle = new Label();
        HBox.setMargin((Node)this.lbContactTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.lbContactTitle.setStyle("-fx-text-fill: white;     -fx-font-family: \"HelveticaNeue\";     -fx-font-weight: bold;     -fx-font-size: 13px;     -fx-background-color: transparent;");
        this.setMinHeight(40.0);
        this.setMaxHeight(40.0);
        this.hbTitle.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.hbTitle.getChildren().add((Object)this.lbContactTitle);
        this.getChildren().add((Object)this.hbTitle);
        this.setMaxWidth(292.0);
        this.setMinWidth(292.0);
        this.hbTitle.maxWidthProperty().unbind();
    }

    public void addCallButton() {
        if (this.hbButton1 == null) {
            this.hbButton1 = new HBox();
            this.hbButton1.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
            ImageView hbAnswerCall = new ImageView();
            hbAnswerCall.setId("hbAnswerCall");
            ClientSingleton.getInstance().setImageToImageView(hbAnswerCall, WhiteLabels.isCustomAnswerButton() ? "answer_button/answer_small.png" : "line/answer_small.png");
            hbAnswerCall.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.makeCall(clientConnector.getUserInfo(false))));
            HBox.setMargin((Node)hbAnswerCall, (Insets)new Insets(8.0, 5.0, 0.0, 5.0));
            ClientSingleton.getInstance().setMouseCursor((Node)hbAnswerCall);
            this.hbButton1.getChildren().add((Object)hbAnswerCall);
        }
        this.hbTitle.setMaxWidth((double)(300.0f - (float)this.width.get() + 5.0f));
        this.hbTitle.setMinWidth((double)(300.0f - (float)this.width.get() + 5.0f));
        if (!this.getChildren().contains((Object)this.hbButton1)) {
            this.getChildren().add((Object)this.hbButton1);
        }
    }

    public void removeCallButton() {
        this.getChildren().remove((Object)this.hbButton1);
    }

    private void initAndroidsVersion() {
        this.androids = new ArrayList();
        this.androids.add("Android 15");
        this.androids.add("Android 14");
        this.androids.add("Android 13");
        this.androids.add("Android 12.1");
        this.androids.add("Android 12");
        this.androids.add("Android 11");
        this.androids.add("Android 10");
        this.androids.add("Android 9");
        this.androids.add("Android 8.1");
        this.androids.add("Android 8");
        this.androids.add("Android 7.1.2");
        this.androids.add("Android 7.1");
        this.androids.add("Android 7");
    }
}

