/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocontrolls;

import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.views.calls.audiocontrolls.CallLinePaneBase;
import net.sipsnet.client.views.calls.audiocontrolls.ILineInfoPaneListener;
import net.sipsnet.client.views.calls.utils.CallLineUtils;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import smile.cti.client.LineInfo;

public class HoldCallLinePane
extends CallLinePaneBase {
    private static final String TAG = "SimpleCallPane";
    private HBox hbAvatarBox;
    private Label lbContactTitle;
    private HBox hbButton1;

    public HoldCallLinePane(ILineInfoPaneListener iLineInfoPaneListener, ICallPanesVisibility iCallPanesVisibility) {
        super(iLineInfoPaneListener, iCallPanesVisibility);
        this.createSimpleFirstLine();
    }

    private void createSimpleFirstLine() {
        this.setMinHeight(40.0);
        this.prefHeight(60.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.hbAvatarBox = new HBox();
        this.hbAvatarBox.setMinHeight(45.0);
        this.hbAvatarBox.prefHeight(45.0);
        this.hbAvatarBox.setFillHeight(true);
        this.hbAvatarBox.setAlignment(Pos.CENTER);
        HBox.setMargin((Node)this.hbAvatarBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.getChildren().add((Object)this.hbAvatarBox);
        HBox titleBox = new HBox();
        titleBox.setAlignment(Pos.CENTER_LEFT);
        this.lbContactTitle = new Label();
        HBox.setMargin((Node)this.lbContactTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.lbContactTitle.setStyle("-fx-text-fill: white;     -fx-font-family: \"HelveticaNeue\";     -fx-font-weight: bold;     -fx-font-size: 13px;     -fx-background-color: transparent;");
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        this.lbContactTitle.setOnMouseClicked(eventMouse -> this.iLineInfoPaneListener.openSession());
        titleBox.setOnMouseClicked(eventMouse -> this.iLineInfoPaneListener.openSession());
        this.lbContactTitle.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        titleBox.getChildren().add((Object)this.lbContactTitle);
        this.getChildren().add((Object)titleBox);
        HBox.setHgrow((Node)titleBox, (Priority)Priority.ALWAYS);
        Region region1 = new Region();
        this.getChildren().add((Object)region1);
        this.hbButton1 = new HBox();
        this.hbButton1.setAlignment(Pos.CENTER);
        this.hbButton1.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        final CallViewButton callViewButton = CallLineUtils.getHoldCallImageButton(this::getLineInfo, "line/callscreen_hold_on.png");
        callViewButton.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                callViewButton.setSize(24, 24);
                callViewButton.getChildren().removeListener((ListChangeListener)this);
            }
        });
        callViewButton.setSize(24, 24);
        this.hbButton1.setMaxWidth(24.0);
        this.hbButton1.setMaxHeight(24.0);
        this.hbButton1.getChildren().add((Object)callViewButton);
        this.getChildren().add((Object)this.hbButton1);
        HBox.setMargin((Node)this.hbButton1, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        HBox hbButton2 = new HBox();
        hbButton2.setAlignment(Pos.CENTER);
        hbButton2.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        hbButton2.getChildren().add((Object)CallLineUtils.getHangupCallImageButton(WhiteLabels.isCustomHangupButton() ? "hangup_button/hangup_small.png" : "line/hangup_small.png", this::getLineInfo));
        this.getChildren().add((Object)hbButton2);
        HBox.setMargin((Node)this.hbButton1, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
    }

    public void initButtons(LineInfo lineInfo) {
    }

    public void setCallInfo(LineInfo lineInfo) {
        this.setLineInfo(lineInfo);
        ClientSingleton.toLog(TAG, "setCallInfo lineInfo=" + lineInfo + " state=" + lineInfo.getState() + "\nlineInfo=" + lineInfo + " state=" + lineInfo.getState() + "\nlineInfo.getPartyNumber()=" + lineInfo.getPartyNumber() + "\nlineInfo.getPartyName()=" + lineInfo.getPartyName() + "\nlineInfo.getContacts()=" + lineInfo.getContacts());
        this.lbContactTitle.setText(lineInfo.getState() == 15 ? ClientSingleton.getInstance().getString("call_line_transferring") : (lineInfo.getState() == 5 ? ClientSingleton.getInstance().getString("call_conference") : lineInfo.getPartyName()));
        AvatarPane avatarPane = AvatarPane.getInstance(lineInfo.getSessionInfo(), 32, 16, false);
        if (this.hbAvatarBox != null) {
            this.hbAvatarBox.getChildren().clear();
            this.hbAvatarBox.getChildren().add((Object)avatarPane);
        }
    }
}

