/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocontrolls;

import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.toogleswitch.SimpleToggleSwitch;
import smile.cti.client.LineInfo;

public class HoldToggleSwitch
extends SimpleToggleSwitch {
    private final LineInfo lineInfo;
    private final EventHandler<MouseEvent> mouseEventHandler = event -> this.onHold();

    public void onHold() {
        TimerExecutor.getInstance().start(() -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setToggleSwitcherSelected " + super.isSelected() + " lineInfo.getState()=" + this.lineInfo.getState());
            if (this.lineInfo.getState() == 4) {
                AudioCaller.setActiveLine(this.lineInfo);
            } else {
                AudioCaller.setHoldLine(this.lineInfo);
            }
        });
    }

    public HoldToggleSwitch(LineInfo lineInfo) {
        this.lineInfo = lineInfo;
        this.setMinWidth(30.0);
        this.setPrefWidth(30.0);
        HBox.setMargin((Node)this, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
    }

    @Override
    public void onRelease() {
        super.onRelease();
        this.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
    }
}

