/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocontrolls;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import smile.cti.client.ContactInfo;

public class ParkingLinePane
extends HBox {
    private final ContactInfo contactInfo;

    public ParkingLinePane(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
        this.initPane();
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "ParkingLinePane initiated slot = " + contactInfo);
    }

    private void initPane() {
        Theme.getInstance().applyCallPaneTo(Theme.CALL_LINE_BACKGROUND, (Pane)this);
        int height = 44;
        VBox.setMargin((Node)this, (Insets)new Insets(3.0, 8.0, 3.0, 0.0));
        this.setAlignment(Pos.CENTER_LEFT);
        HBox hbAvatarBox = new HBox();
        hbAvatarBox.setMinHeight((double)height);
        hbAvatarBox.prefHeight((double)height);
        hbAvatarBox.setFillHeight(true);
        hbAvatarBox.setAlignment(Pos.CENTER);
        ImageView ivAvatar = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(ivAvatar, "line/parkedcall_ava.png");
        hbAvatarBox.getChildren().add((Object)ivAvatar);
        HBox.setMargin((Node)hbAvatarBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.getChildren().add((Object)hbAvatarBox);
        Label lbContactTitle = new Label(this.contactInfo.toString());
        HBox.setMargin((Node)lbContactTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        lbContactTitle.setStyle("-fx-text-fill: white;     -fx-font-family: \"HelveticaNeue\";     -fx-font-weight: bold;     -fx-font-size: 13px;     -fx-background-color: transparent;");
        HBox.setHgrow((Node)lbContactTitle, (Priority)Priority.ALWAYS);
        lbContactTitle.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.getChildren().add((Object)lbContactTitle);
        Region region1 = new Region();
        HBox.setHgrow((Node)region1, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)region1);
        HBox hbButton1 = new HBox();
        hbButton1.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.getChildren().add((Object)hbButton1);
        ImageView hbAnswerCall = new ImageView();
        hbAnswerCall.setId("hbAnswerCall");
        ClientSingleton.getInstance().setImageToImageView(hbAnswerCall, WhiteLabels.isCustomAnswerButton() ? "answer_button/answer_small.png" : "line/answer_small.png");
        hbAnswerCall.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "MakeCallButton was pressed");
            clientConnector.makeCall(this.contactInfo);
        }));
        HBox.setMargin((Node)hbAnswerCall, (Insets)new Insets(8.0, 5.0, 0.0, 5.0));
        ClientSingleton.getInstance().setMouseCursor((Node)hbAnswerCall);
        hbButton1.getChildren().add((Object)hbAnswerCall);
    }

    public int getState() {
        return this.contactInfo.getState();
    }
}

