/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.chatline;

import java.util.HashMap;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.utils.viewers.toogleswitch.IMyToggleSwitcher;
import net.sipsnet.client.utils.viewers.toogleswitch.MyToggleSwitch;
import net.sipsnet.client.views.calls.callaudiosettings.AudioSettingsController;
import net.sipsnet.client.views.calls.utils.LineTimer;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.chat.utils.IOnHidePane;
import net.sipsnet.client.views.keypad.KeyPadPane;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class CallLinePane
implements IOnHidePane,
IMyToggleSwitcher {
    private final StackPane fx_hbCallTopPaneBackground;
    private MaxSizedContextMenu myContextMenu;
    private Label fx_lbCallTimer;
    private Label fx_lbCallType;
    private final HBox fx_hbCallTopPane;
    private CallViewButton muteCallImageButton;
    private CallViewButton recordCallImageButton;
    private CallViewButton holdCallImageButton;
    private final ImageButton fx_ivCallTopMenu;
    private LineInfo lineInfo;
    private KeyPadPane keyPadPane;
    private final ICallPanesVisibility iCallPanesVisibility;
    private MyToggleSwitch myToggleSwitch;
    public Pane fx_lbCallInfo;
    public Label fx_lbCallTrunk;
    private CallViewButton speakerCallImageButton;
    private boolean isRingtoneMute = false;
    private final StackPane fx_spTopPane;
    private HBox nActionButtonPane;
    private IRingtoneMuteState iRingtoneMuteState;

    public CallLinePane(StackPane fx_spTopPane, ICallPanesVisibility iCallPanesVisibility) {
        this.fx_spTopPane = fx_spTopPane;
        this.fx_hbCallTopPaneBackground = (StackPane)fx_spTopPane.lookup("#fx_hbCallTopPaneBackground");
        this.fx_hbCallTopPane = (HBox)fx_spTopPane.lookup("#fx_hbCallTopPane");
        this.fx_hbCallTopPane.prefWidthProperty().bind((ObservableValue)this.fx_hbCallTopPaneBackground.widthProperty());
        this.iCallPanesVisibility = iCallPanesVisibility;
        if (this.fx_lbCallTimer == null) {
            this.fx_lbCallTimer = (Label)this.fx_hbCallTopPane.lookup("#fx_lbCallTimer");
        }
        if (this.fx_lbCallType == null) {
            this.fx_lbCallType = (Label)this.fx_hbCallTopPane.lookup("#fx_lbCallType");
        }
        ImageView fx_hbCallTopPaneImage = (ImageView)this.fx_hbCallTopPaneBackground.lookup("#fx_hbCallTopPaneImage");
        ClientSingleton.getInstance().setImageToImageView(fx_hbCallTopPaneImage, "call_notification/callpanel_background_tr.png");
        this.fx_ivCallTopMenu = new ImageButton();
        this.fx_ivCallTopMenu.setSize(20, 32);
        this.fx_ivCallTopMenu.setImagePath("call_notification/callpanel_menu.png");
        this.fx_ivCallTopMenu.setStyle("-fx-background-color:transparent;");
        this.fx_ivCallTopMenu.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.myContextMenu.show((Node)this.fx_ivCallTopMenu, mouseEvent.getScreenX(), mouseEvent.getScreenY())));
        HBox.setMargin((Node)this.fx_ivCallTopMenu, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        this.setBackgroundColor(false);
        this.initActionCallPane();
        this.initCallMenu();
    }

    private void initActionCallPane() {
        this.nActionButtonPane = new HBox();
        this.nActionButtonPane.setAlignment(Pos.CENTER_RIGHT);
        VBox.setVgrow((Node)this.nActionButtonPane, (Priority)Priority.ALWAYS);
        String imagePath = "call_notification/callpanel_mute_off.png";
        this.muteCallImageButton = new CallViewButton(imagePath, (EventHandler<MouseEvent>)((EventHandler)str -> AudioCaller.setMute()));
        this.muteCallImageButton.setTooltip("tooltip_mute");
        this.nActionButtonPane.getChildren().add((Object)this.muteCallImageButton);
        CallViewButton transfer = new CallViewButton("call_notification/callpanel_transfer.png", (EventHandler<MouseEvent>)((EventHandler)str -> ClientSingleton.getInstance().transferCallTo(this.lineInfo, true, true)));
        transfer.setTooltip("tooltip_transfer");
        this.nActionButtonPane.getChildren().add((Object)transfer);
        imagePath = "call_notification/callpanel_hold_off.png";
        this.holdCallImageButton = new CallViewButton(imagePath, (EventHandler<MouseEvent>)((EventHandler)str -> TimerExecutor.getInstance().start(() -> {
            if (this.lineInfo.getState() == 4) {
                AudioCaller.setActiveLine(this.lineInfo);
            } else {
                AudioCaller.setHoldLine(this.lineInfo);
            }
        })));
        this.holdCallImageButton.setTooltip("tooltip_hold");
        this.nActionButtonPane.getChildren().add((Object)this.holdCallImageButton);
        CallViewButton hangupButton = this.getHangupButton();
        this.nActionButtonPane.getChildren().add((Object)hangupButton);
    }

    public void setTitles(LineInfo lineInfo_) {
        this.lineInfo = lineInfo_;
        ClientSingleton.getInstance().runLater(() -> {
            SessionInfo sessionInfo = ClientSingleton.getInstance().getSessionInfo(this.lineInfo);
            AvatarPane avatarPane = AvatarPane.getInstance(sessionInfo, 32, 16, false);
            VBox fx_vbCallAvatar = (VBox)this.fx_hbCallTopPane.lookup("#fx_vbCallAvatar");
            fx_vbCallAvatar.getChildren().clear();
            fx_vbCallAvatar.getChildren().add((Object)avatarPane);
            this.setTitle(this.lineInfo);
            LineTimer.getInstance().addToLine(this.lineInfo, this.fx_lbCallTimer);
        });
    }

    public void setCallTopMenuVisibility(boolean mode) {
        if (mode) {
            if (!this.fx_hbCallTopPane.getChildren().contains((Object)this.fx_ivCallTopMenu)) {
                this.fx_hbCallTopPane.getChildren().add(0, (Object)this.fx_ivCallTopMenu);
            }
        } else {
            this.fx_hbCallTopPane.getChildren().remove((Object)this.fx_ivCallTopMenu);
        }
    }

    public void setTitle(LineInfo lineInfo_) {
        this.lineInfo = lineInfo_;
        Label label = (Label)this.fx_hbCallTopPane.lookup("#fx_lbCallContactName");
        label.setText(this.lineInfo.getState() == 15 ? ClientSingleton.getInstance().getString("call_line_transferring") : (this.lineInfo.isConference() ? ClientSingleton.getInstance().getString("call_conference") : this.lineInfo.getPartyName()));
        Label fx_lbCallTrunk = (Label)this.fx_hbCallTopPane.lookup("#fx_lbCallTrunk");
        Pane fx_lbCallInfo = (Pane)this.fx_hbCallTopPane.lookup("#fx_lbCallInfo");
        if (this.lineInfo.isConference()) {
            fx_lbCallInfo.getChildren().remove((Object)fx_lbCallTrunk);
        } else {
            AudioCaller.addTrunkLabel(this.lineInfo, fx_lbCallTrunk, fx_lbCallInfo);
            switch (this.lineInfo.getState()) {
                case 2: {
                    this.fx_lbCallType.setText(ClientSingleton.getInstance().getString("call_detail_incoming"));
                    this.fx_lbCallTimer.setText("");
                    break;
                }
                case 1: {
                    this.fx_lbCallType.setText(ClientSingleton.getInstance().getString("call_detail_outgoing"));
                    this.fx_lbCallTimer.setText("");
                    break;
                }
                default: {
                    this.fx_lbCallType.setText("");
                }
            }
        }
    }

    public void setInputCallSet(LineInfo lineInfo_) {
        this.lineInfo = lineInfo_;
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        this.isRingtoneMute = false;
        boolean ringtoneMuteState = this.iRingtoneMuteState == null || !this.iRingtoneMuteState.isRingtoneMuted();
        this.speakerCallImageButton = new CallViewButton(ringtoneMuteState ? "call_notification/callpanel_incoming_mute_off.png" : "call_notification/callpanel_incoming_mute_on.png", (EventHandler<MouseEvent>)((EventHandler)str -> this.iRingtoneMuteState.setRingtoneMuteState(true)));
        hBox.getChildren().add((Object)this.speakerCallImageButton);
        CallViewButton answerAudioButton = new CallViewButton(WhiteLabels.isCustomAnswerButton() ? "answer_button/callpanel_answer.png" : "call_notification/callpanel_answer.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
            ClientSingleton.getInstance().setMyVideoEnabledFlag(this.lineInfo, false);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "OnAnswer start");
            AudioCaller.answerCall(this.lineInfo);
        }));
        hBox.getChildren().add((Object)answerAudioButton);
        if (ClientSingleton.getInstance().canVideo() && (this.lineInfo.getState() == 2 && this.lineInfo.isVideoEnabled() || ClientSingleton.getInstance().isMyVideoEnabledFlag(this.lineInfo))) {
            CallViewButton answerVideoButton = new CallViewButton(WhiteLabels.isCustomAnswerButton() ? "answer_button/callpanel_answer_video.png" : "call_notification/callpanel_answer_video.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
                ClientSingleton.getInstance().setMyVideoEnabledFlag(this.lineInfo, true);
                AudioCaller.answerCall(this.lineInfo, true);
            }));
            hBox.getChildren().add((Object)answerVideoButton);
        }
        CallViewButton hangupButton = this.getHangupButton();
        hBox.getChildren().add((Object)hangupButton);
        HBox buttonsBox = (HBox)this.fx_hbCallTopPane.lookup("#fx_hbCallButton");
        buttonsBox.getChildren().clear();
        buttonsBox.getChildren().add((Object)hBox);
        this.setBackgroundColor(false);
        this.setCallTopMenuVisibility(false);
    }

    public void setRingtoneMuteState(boolean state) {
        this.speakerCallImageButton.setImagePath("call_notification/callpanel_incoming_mute_on.png");
    }

    public void setOutputCallSet(LineInfo lineInfo_) {
        this.lineInfo = lineInfo_;
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_RIGHT);
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        CallViewButton hangupButton = this.getHangupButton();
        hBox.getChildren().add((Object)hangupButton);
        HBox buttonsBox = (HBox)this.fx_hbCallTopPane.lookup("#fx_hbCallButton");
        buttonsBox.getChildren().clear();
        buttonsBox.getChildren().add((Object)hBox);
        this.setBackgroundColor(false);
        this.setCallTopMenuVisibility(false);
    }

    private CallViewButton getHangupButton() {
        CallViewButton callViewButton = new CallViewButton();
        callViewButton.init(false, WhiteLabels.isCustomHangupButton() ? "hangup_button/callpanel_hangup.png" : "call_notification/callpanel_hangup.png", (EventHandler<MouseEvent>)((EventHandler)str -> {
            if (callViewButton.canPress()) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "AudioCaller.dropCall lineInfo = " + this.lineInfo);
                AudioCaller.dropCall(this.lineInfo);
            }
        }));
        callViewButton.setTooltip("tooltip_hang_up");
        callViewButton.setEnableDelay();
        return callViewButton;
    }

    public void setConnectCallSet(LineInfo lineInfo_) {
        this.lineInfo = lineInfo_;
        ClientSingleton.getInstance().runLater(() -> {
            HBox buttonsBox = (HBox)this.fx_hbCallTopPane.lookup("#fx_hbCallButton");
            buttonsBox.getChildren().clear();
            buttonsBox.getChildren().add((Object)this.nActionButtonPane);
            if (ClientSingleton.getInstance().canRecord()) {
                this.onRecordCall(this.lineInfo, this.lineInfo.isRecording());
                if (!this.nActionButtonPane.getChildren().contains((Object)this.recordCallImageButton)) {
                    int index = this.nActionButtonPane.getChildren().size() > 1 ? this.nActionButtonPane.getChildren().size() - 1 : this.nActionButtonPane.getChildren().size();
                    this.nActionButtonPane.getChildren().add(index, (Object)this.recordCallImageButton);
                }
            } else {
                this.nActionButtonPane.getChildren().remove((Object)this.recordCallImageButton);
            }
            this.onHoldCall(this.lineInfo);
            this.onMute();
            this.setVideoMenuItem();
            this.setCallTopMenuVisibility(true);
        });
    }

    public void onMute() {
        String imagePath;
        boolean isMute = AudioCaller.isMute();
        String string = imagePath = isMute ? "call_notification/callpanel_mute_on.png" : "call_notification/callpanel_mute_off.png";
        if (this.muteCallImageButton == null) {
            this.muteCallImageButton = new CallViewButton(imagePath, (EventHandler<MouseEvent>)((EventHandler)str -> AudioCaller.setMute()));
            this.muteCallImageButton.setTooltip("tooltip_mute");
        } else {
            this.muteCallImageButton.setImageView(imagePath);
        }
        if (this.getLineInfo() != null) {
            this.muteCallImageButton.setVisible(this.getLineInfo().getState() != 4);
        }
    }

    public void onHoldCall(LineInfo lineInfo_) {
        String imagePath;
        this.lineInfo = lineInfo_;
        String string = imagePath = this.lineInfo.getState() == 4 ? "call_notification/callpanel_hold_on.png" : "call_notification/callpanel_hold_off.png";
        if (this.holdCallImageButton == null) {
            this.holdCallImageButton = new CallViewButton(imagePath, (EventHandler<MouseEvent>)((EventHandler)str -> TimerExecutor.getInstance().start(() -> {
                if (this.lineInfo.getState() == 4) {
                    AudioCaller.setActiveLine(this.lineInfo);
                } else {
                    AudioCaller.setHoldLine(this.lineInfo);
                }
            })));
            this.holdCallImageButton.setTooltip("tooltip_hold");
        } else {
            this.holdCallImageButton.setImageView(imagePath);
        }
        if (this.getLineInfo().isConference() || this.getLineInfo().getState() == 5) {
            this.nActionButtonPane.getChildren().remove((Object)this.holdCallImageButton);
        } else if (!this.nActionButtonPane.getChildren().contains((Object)this.holdCallImageButton)) {
            this.nActionButtonPane.getChildren().add(Math.max(this.nActionButtonPane.getChildren().size() - 1, 0), (Object)this.holdCallImageButton);
        }
        this.setBackgroundColor(this.lineInfo.getState() == 4);
        if (this.muteCallImageButton != null) {
            this.muteCallImageButton.setVisible(this.getLineInfo().getState() != 4);
        }
    }

    public void setBackgroundColor(boolean isHold) {
        if (isHold) {
            Theme.getInstance().applyCallPaneTo(Theme.CALL_PANE_HOLD_BACKGROUND, (Pane)this.fx_hbCallTopPane);
        } else {
            Theme.getInstance().applyCallPaneTo(Theme.CALL_CHAT_LINE_BACKGROUND, (Pane)this.fx_hbCallTopPane);
        }
    }

    public void onRecordCall(LineInfo lineInfo_, boolean isRecording) {
        String imagePath;
        this.lineInfo = lineInfo_;
        String string = imagePath = isRecording ? "call_notification/callpanel_record_on.png" : "call_notification/callpanel_record_off.png";
        if (this.recordCallImageButton == null) {
            this.recordCallImageButton = new CallViewButton(imagePath, (EventHandler<MouseEvent>)((EventHandler)str -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "onRecordCall lineInfo=" + this.lineInfo + " lineInfo.isRecording()=" + this.lineInfo.isRecording());
                ClientSingleton.getInstance().setRecordingState(!this.lineInfo.isRecording());
            }));
            this.recordCallImageButton.setTooltip("tooltip_recording");
        } else {
            this.recordCallImageButton.setImageView(imagePath);
        }
        if (this.myToggleSwitch != null) {
            this.myToggleSwitch.setSelected(isRecording);
        }
    }

    private void initCallMenu() {
        if (this.myContextMenu == null) {
            Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this.fx_hbCallTopPane);
            this.myContextMenu = new MaxSizedContextMenu();
            this.myContextMenu.setMaxHeight(300.0);
            this.myContextMenu.setMinWidth(200.0);
            this.myContextMenu.setPrefWidth(200.0);
            this.myContextMenu.setMaxWidth(200.0);
        }
        MenuItem menuItem = new MenuItem(ClientSingleton.getInstance().getString("filter"));
        menuItem.setOnAction(event -> this.iCallPanesVisibility.switchToFilter());
        this.myContextMenu.getItems().add((Object)menuItem);
        menuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu1"));
        menuItem.setOnAction(event -> ClientSingleton.getInstance().transferCallTo(this.lineInfo, this.iCallPanesVisibility, true));
        this.myContextMenu.getItems().add((Object)menuItem);
        menuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu2"));
        menuItem.setOnAction(event -> ClientSingleton.getInstance().addParticipantToCall(this.lineInfo, this.iCallPanesVisibility, true));
        this.myContextMenu.getItems().add((Object)menuItem);
        menuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu5"));
        menuItem.setOnAction(event -> AudioSettingsController.getInstance().showPopUP());
        this.myContextMenu.getItems().add((Object)menuItem);
    }

    private void setVideoMenuItem() {
        if (this.myContextMenu == null) {
            this.initCallMenu();
        }
        if (ClientSingleton.getInstance().canVideo(this.lineInfo)) {
            Optional<MenuItem> optionalMenuItem = this.myContextMenu.getItems().stream().filter(menuItem -> menuItem.getId() != null && "videoMenuItem".equals(menuItem.getId())).findAny();
            if (optionalMenuItem.isEmpty()) {
                MenuItem menuItem2 = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu0"));
                menuItem2.setOnAction(event -> {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("lineInfo", this.lineInfo);
                    ClientSingleton.getInstance().doNotify(Constants.START_VIDEO, data);
                });
                menuItem2.setId("videoMenuItem");
                this.myContextMenu.getItems().add(1, (Object)menuItem2);
            }
        } else {
            this.myContextMenu.getItems().removeIf(menuItem -> menuItem.getId() != null && "videoMenuItem".equals(menuItem.getId()));
        }
        if (ClientSingleton.getInstance().canRecord()) {
            if (this.myToggleSwitch == null) {
                MenuItem recordingMenuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu3"));
                recordingMenuItem.setOnAction(event -> this.myToggleSwitch.setSelectedWithAction(!this.lineInfo.isRecording()));
                this.myContextMenu.getItems().add((Object)recordingMenuItem);
                this.myToggleSwitch = new MyToggleSwitch();
                this.myToggleSwitch.setMinWidth(30.0);
                this.myToggleSwitch.setPrefWidth(30.0);
                this.myToggleSwitch.setSelected(this.lineInfo.isRecording());
                this.myToggleSwitch.addSelectedListener(this);
                recordingMenuItem.setGraphic((Node)this.myToggleSwitch);
            } else {
                this.myToggleSwitch.setSelected(this.lineInfo.isRecording());
            }
        }
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    public void clearLine() {
    }

    @Override
    public void onHidePane() {
        this.iCallPanesVisibility.setCallPanesUnVisible();
    }

    @Override
    public void setToggleSwitcherSelected(boolean isSelected) {
        ClientSingleton.getInstance().setRecordingState(!this.lineInfo.isRecording());
    }

    public void setRingtoneMuteState() {
        if (this.speakerCallImageButton != null) {
            ClientSingleton.getInstance().setCachedImage(this.speakerCallImageButton, "call_notification/callpanel_incoming_mute_on.png");
        }
    }

    public void addRingtoneMuteStateStateListener(IRingtoneMuteState iRingtoneMuteState) {
        this.iRingtoneMuteState = iRingtoneMuteState;
    }

    public void clearCallLinePane() {
        this.iRingtoneMuteState = null;
        ClientSingleton.getInstance().releaseViewResources((Pane)this.fx_spTopPane);
    }
}

