/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.utils;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.event.EventHandler;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;
import net.sipsnet.client.views.calls.callconference.CallConferenceController;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;

public class CallLineUtils {
    public static CallViewButton getHoldCallImageButton(Supplier<LineInfo> lineInfoSupplier) {
        return CallLineUtils.getHoldCallImageButton(lineInfoSupplier, "call_notification/callpanel_hold_off.png");
    }

    public static CallViewButton getHoldOnCallImageButton(Supplier<LineInfo> lineInfoSupplier) {
        return CallLineUtils.getHoldCallImageButton(lineInfoSupplier, "call_notification/callpanel_hold_on.png");
    }

    public static CallViewButton getHoldCallImageButton(Supplier<LineInfo> lineInfoSupplier, String icon) {
        CallViewButton holdCallImageButton = new CallViewButton(icon, (EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog("CallLineUtils", "HoldCallButton was pressed");
            if (lineInfoSupplier.get() != null) {
                LineInfo lineInfo = (LineInfo)lineInfoSupplier.get();
                if (AudioCaller.getWorkingLinesCount() == 2 && lineInfo.getState() != 4) {
                    LineInfo li = AudioCaller.getLineOnHold(lineInfo);
                    if (li != null) {
                        AudioCaller.setActiveLine(li);
                    } else {
                        CallLineUtils.onHoldAction(lineInfo);
                    }
                } else {
                    CallLineUtils.onHoldAction(lineInfo);
                }
            }
            event.consume();
        }));
        holdCallImageButton.setTooltip("tooltip_hold");
        return holdCallImageButton;
    }

    private static void onHoldAction(LineInfo lineInfo) {
        if (lineInfo.getState() == 4) {
            AudioCaller.setActiveLine(lineInfo);
        } else {
            AudioCaller.setHoldLine(lineInfo);
        }
    }

    public static CallViewButton getMuteCallImageButton() {
        CallViewButton muteCallImageButton = new CallViewButton("call_notification/callpanel_mute_off.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog("CallLineUtils", "MuteCallButton was pressed");
            AudioCaller.setMute();
            event.consume();
        }));
        muteCallImageButton.setTooltip("tooltip_mute");
        return muteCallImageButton;
    }

    public static CallViewButton getHangupCallImageButton(Supplier<LineInfo> lineInfoSupplier) {
        return CallLineUtils.getHangupCallImageButton(null, lineInfoSupplier);
    }

    public static CallViewButton getHangupCallImageButton(String imagePath, Supplier<LineInfo> lineInfoSupplier) {
        if (imagePath == null) {
            imagePath = WhiteLabels.isCustomHangupButton() ? "hangup_button/callpanel_hangup.png" : "call_notification/callpanel_hangup.png";
        }
        CallViewButton hangupCallImageButton = new CallViewButton();
        hangupCallImageButton.init(false, imagePath, (EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog("CallLineUtils", "HangupCallButton was pressed: hangupCallImageButton.canPress()=" + hangupCallImageButton.canPress());
            if (hangupCallImageButton.canPress()) {
                LineInfo lineInfo = (LineInfo)lineInfoSupplier.get();
                AudioCaller.dropCall(lineInfo);
            }
        }));
        hangupCallImageButton.setTooltip("tooltip_hang_up");
        hangupCallImageButton.setEnableDelay();
        return hangupCallImageButton;
    }

    public static CallViewButton getVideoCallImageButton(Supplier<LineInfo> lineInfoSupplier) {
        CallViewButton callViewButton = new CallViewButton("notification/call/callpanel_video_off.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog("VideoCallImageButton", "VideoCallButton was pressed");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("lineInfo", lineInfoSupplier.get());
            ClientSingleton.getInstance().doNotify(Constants.START_VIDEO, data);
            event.consume();
        }));
        callViewButton.setTooltip("tooltip_video");
        return callViewButton;
    }

    public static CallViewButton getTransferCallImageButton(Supplier<LineInfo> lineInfoSupplier) {
        CallViewButton transferButton = new CallViewButton("notification/call/callpanel_transfer.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog("TransferButton", "TransferCallButton was pressed");
            if (lineInfoSupplier.get() != null) {
                ClientSingleton.getInstance().transferCallTo((LineInfo)lineInfoSupplier.get(), false, true);
            }
            event.consume();
        }));
        transferButton.setTooltip("tooltip_transfer");
        return transferButton;
    }

    public static CallViewButton getRecordCallImageButton(Supplier<LineInfo> lineInfoSupplier) {
        CallViewButton recordCallImageButton = null;
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (optionalClientConnector.isPresent()) {
            boolean isSelected = lineInfoSupplier.get().isRecording();
            recordCallImageButton = new CallViewButton(isSelected ? "call_notification/callpanel_record_on.png" : "call_notification/callpanel_record_off.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
                ClientSingleton.toLog("TransferButton", "RecordCallButton was pressed: lineInfoSupplier.get()=" + lineInfoSupplier.get());
                if (lineInfoSupplier.get() != null) {
                    ClientSingleton.getInstance().setRecordingState(!((LineInfo)lineInfoSupplier.get()).isRecording());
                }
                event.consume();
            }));
            recordCallImageButton.setTooltip("tooltip_recording");
        }
        return recordCallImageButton;
    }

    public static CallViewButton getAppParticipated(Supplier<LineInfo> lineInfoSupplier) {
        CallViewButton addCall = new CallViewButton("notification/call/callpanel_add_user.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.getInstance().addParticipantToCall(null, (LineInfo)lineInfoSupplier.get(), false, false);
            event.consume();
        }));
        addCall.setTooltip("tooltip_add_call");
        return addCall;
    }

    public static CallViewButton getConferenceControl(Supplier<LineInfo> lineInfoSupplier) {
        CallViewButton addCall = new CallViewButton("notification/call/callpanel_conf_remove.png", (EventHandler<MouseEvent>)((EventHandler)event -> {
            CallConferenceController.getInstance().showPopUP((LineInfo)lineInfoSupplier.get());
            event.consume();
        }));
        addCall.setTooltip("tooltip_conference_control");
        return addCall;
    }

    public static void getNumber(LineInfo lineInfo, Label label, Pane pane, boolean isMultiline) {
        String number = CallLineUtils.getNumber(lineInfo, isMultiline);
        if (number.isEmpty()) {
            pane.getChildren().remove((Object)label);
        } else {
            label.setText(number);
            if (!pane.getChildren().contains((Object)label)) {
                pane.getChildren().add((Object)label);
            }
        }
    }

    public static String getNumber(LineInfo lineInfo) {
        return CallLineUtils.getNumber(lineInfo, false);
    }

    public static String getNumber(LineInfo lineInfo, boolean isMultiline) {
        String number = "";
        if (CallLineUtils.isConference(lineInfo)) {
            number = lineInfo.getSessionInfo() != null && lineInfo.getSessionInfo().isGroup() ? lineInfo.getSessionInfo().toString() : "";
        } else {
            ContactInfo contactInfo;
            number = lineInfo.getPartyNumber();
            if (number == null) {
                number = "";
            } else if (lineInfo.getContacts() != null && !lineInfo.getContacts().isEmpty() && (contactInfo = (ContactInfo)lineInfo.getContacts().iterator().next()) != null && ClientSingleton.getInstance().getUserID(contactInfo).equals(number)) {
                number = "";
            }
        }
        if (number.isEmpty()) {
            if (lineInfo.getState() == 2) {
                number = ClientSingleton.getInstance().getString("call_incoming");
            } else if (lineInfo.getState() == 1 || lineInfo.getState() == 15) {
                number = ClientSingleton.getInstance().getString("call_outgoing");
            }
        }
        return number;
    }

    public static String getName(LineInfo lineInfo) {
        String name = lineInfo.getCallerName();
        if (name == null) {
            if (lineInfo.getState() == 15) {
                name = ClientSingleton.getInstance().getString("call_line_transferring");
            } else if (lineInfo.isConference() || lineInfo.getState() == 5) {
                name = ClientSingleton.getInstance().getString("call_conference");
            } else {
                name = lineInfo.getPartyName().trim();
                if (name.equals(ClientSingleton.getInstance().getClientConnector().get().getUserId())) {
                    name = ClientSingleton.getInstance().getUserInfo().toString();
                }
            }
        } else {
            name = lineInfo.isConference() ? ClientSingleton.getInstance().getString("call_conference") : lineInfo.getPartyName();
        }
        return name;
    }

    public static boolean isConference(LineInfo lineInfo) {
        return lineInfo.isConference() || lineInfo.getState() == 5;
    }

    public static void onHoldCall(CallViewButton holdCallButton, LineInfo lineInfo) {
        if (lineInfo == null) {
            return;
        }
        holdCallButton.setImageView(lineInfo.getState() == 4 ? "call_notification/callpanel_hold_on.png" : "call_notification/callpanel_hold_off.png");
    }

    public static void onHoldCallSmallIcons(CallViewButton holdCallButton, LineInfo lineInfo) {
        if (lineInfo == null) {
            return;
        }
        holdCallButton.setImageView(lineInfo.getState() == 4 ? "line/callscreen_hold_on.png" : "line/callscreen_hold_off.png");
    }

    public static void onRecordCall(CallViewButton recordCallButton, LineInfo lineInfo) {
        if (lineInfo == null || lineInfo.hashCode() != lineInfo.hashCode()) {
            return;
        }
        recordCallButton.setImageView(lineInfo.isRecording() ? "call_notification/callpanel_record_on.png" : "call_notification/callpanel_record_off.png");
        recordCallButton.setTooltip(lineInfo.isRecording() ? "tooltip_disable_recording" : "tooltip_recording");
    }

    public static void onMute(CallViewButton muteCallButton) {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            muteCallButton.setImageView(clientConnector.getMute() ? "call_notification/callpanel_mute_on.png" : "call_notification/callpanel_mute_off.png");
            muteCallButton.setTooltip(clientConnector.getMute() ? "tooltip_unmute" : "tooltip_mute");
        });
    }
}

