/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.scene.control.Label;
import smile.cti.client.LineInfo;

public class LineTimer {
    private final Map<LineInfo, List<Label>> lineList = new HashMap<LineInfo, List<Label>>();
    private final Map<LineInfo, Long> linesStartTimes = new HashMap<LineInfo, Long>();
    private Timer timer;
    private TimerTask timerTask;
    private static LineTimer lineTimer;

    private LineTimer() {
    }

    public static LineTimer getInstance() {
        if (lineTimer == null) {
            lineTimer = new LineTimer();
        }
        return lineTimer;
    }

    public void addToLine(LineInfo lineInfo, Label label) {
        if (label == null) {
            return;
        }
        this.lineList.forEach((li, labels) -> labels.removeIf(label1 -> label1.equals(label)));
        List labelLine = this.lineList.computeIfAbsent(lineInfo, k -> new ArrayList());
        if (!labelLine.contains(label)) {
            labelLine.add(label);
        }
    }

    public void startConnectLine(LineInfo lineInfo) {
        if (!this.linesStartTimes.containsKey(lineInfo)) {
            this.linesStartTimes.put(lineInfo, System.currentTimeMillis());
            if (this.linesStartTimes.size() == 1) {
                this.startTimer();
            }
        }
    }

    public void stopConnectLine(LineInfo lineInfo) {
        this.linesStartTimes.remove(lineInfo);
        if (this.linesStartTimes.isEmpty()) {
            List<Label> labelList = this.lineList.get(lineInfo);
            if (labelList != null) {
                labelList.forEach(label -> label.setText(""));
            }
            this.stopTimer();
        }
    }

    private void stopTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    private void startTimer() {
        this.timer = new Timer();
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                LineTimer.this.linesStartTimes.forEach((lineInfo, startFirstConnect) -> LineTimer.this.onTick((LineInfo)lineInfo, (long)startFirstConnect));
            }
        };
        this.timer.scheduleAtFixedRate(this.timerTask, 1000L, 1000L);
    }

    private void onTick(LineInfo lineInfo, long startFirstConnect) {
        Object minutesString;
        long now = System.currentTimeMillis();
        long delta = now - startFirstConnect;
        long seconds = (delta + 500L) / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long remainderMinutes = minutes - hours * 60L;
        long remainderSeconds = seconds - minutes * 60L;
        Object secondsString = Long.toString(remainderSeconds);
        if (((String)secondsString).length() < 2) {
            secondsString = "0" + (String)secondsString;
        }
        if (((String)(minutesString = Long.toString(remainderMinutes))).length() < 2) {
            minutesString = "0" + (String)minutesString;
        }
        String time = (String)minutesString + ":" + (String)secondsString;
        if (hours > 0L) {
            Object hoursString = Long.toString(hours);
            if (((String)hoursString).length() < 2) {
                hoursString = "0" + (String)hoursString;
            }
            time = (String)hoursString + ":" + time;
        }
        String timeText = time;
        if (Platform.isFxApplicationThread()) {
            this.setText(lineInfo, timeText);
        } else {
            Platform.runLater(() -> this.setText(lineInfo, timeText));
        }
    }

    private void setText(LineInfo lineInfo, String timeText) {
        List<Label> labelList = this.lineList.get(lineInfo);
        if (labelList != null) {
            labelList.forEach(label -> label.setText(timeText));
        }
    }
}

