/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.videocall;

import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.image.WritableImage;
import javafx.util.Duration;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.stage.ResizeHelper;
import net.sipsnet.client.views.calls.videocall.Frame;
import net.sipsnet.client.views.calls.videocall.IDisplayPane;

public class DisplayPane
implements IDisplayPane {
    private final int mode;
    private WritableImage writableImage = new WritableImage(1, 1);
    private final BlockingQueue<Frame> frames = new ArrayBlockingQueue<Frame>(25);
    private Timeline timeline;
    private final SimpleBooleanProperty isDrawFrame = new SimpleBooleanProperty();
    private final SimpleBooleanProperty withNotification = new SimpleBooleanProperty();
    private boolean playing = false;
    private Frame frame;
    private final SimpleObjectProperty<Pair<Double, Double>> fitToPane = new SimpleObjectProperty();
    protected String id;

    public void setFitToPane(Pair<Double, Double> fitToPane) {
        this.fitToPane.set(fitToPane);
    }

    public DisplayPane(String id, int mode) {
        this.id = id;
        this.mode = mode;
        this.isDrawFrame.set(true);
        this.isDrawFrame.addListener((event, oldValue, newValue) -> ClientSingleton.toLog(this.getClass().getSimpleName(), "isDrawFrame.addListener newValue=" + newValue));
        this.withNotification.set(true);
        this.withNotification.addListener((event, oldValue, newValue) -> ClientSingleton.toLog(this.getClass().getSimpleName(), "withNotification.addListener newValue=" + newValue));
    }

    private boolean isIsDrawFrame() {
        return this.isDrawFrame.get();
    }

    private void setIsDrawFrame(boolean isDrawFrame) {
        this.isDrawFrame.set(isDrawFrame);
    }

    public void startPlaying() {
        this.frames.clear();
        this.playing = true;
        if (this.timeline == null) {
            this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)0.0), event -> {
                try {
                    this.drawFrame();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, new KeyValue[0]), new KeyFrame(Duration.millis((double)30.0), new KeyValue[0])});
            this.timeline.setCycleCount(-1);
            this.timeline.statusProperty().addListener((obs, oldStatus, newStatus) -> {
                if (newStatus == Animation.Status.STOPPED) {
                    this.stopPlaying();
                    this.writableImage = null;
                }
            });
        }
        this.timeline.play();
    }

    public void stopPlaying() {
        this.playing = false;
        this.frames.clear();
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline = null;
        }
        this.writableImage = null;
    }

    public void onStopDrawFrame() {
    }

    public boolean drawFrame() throws Exception {
        if (this.frames.isEmpty() || ResizeHelper.isResize || !this.playing) {
            return false;
        }
        if (this.frame != null) {
            this.frame.release();
            this.frame = null;
        }
        this.frame = (Frame)this.frames.poll();
        if (this.frame != null && this.frame.getWidth() > 0 && this.frame.getHeight() > 0 && (this.writableImage == null || this.frame.getWidth() != this.getCurrentFrameWidth() || this.frame.getHeight() != this.getCurrentFrameHeight())) {
            this.timeline.stop();
            this.writableImage = new WritableImage(this.frame.getWidth(), this.frame.getHeight());
            if (this.isWithNotification()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("width", this.frame.getWidth());
                data.put("height", this.frame.getHeight());
                ClientSingleton.getInstance().doNotify(Constants.FRAME_SIZE_CHANGED, data);
            }
            TimerExecutor.getInstance().setMyAction(this::startPlaying).startWithDelayInGUIThread(50L);
        }
        return true;
    }

    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public void addVideoFrame(Frame frame) {
        try {
            this.frames.add(frame);
        }
        catch (IllegalStateException ex) {
            this.frames.poll();
        }
    }

    @Override
    public void clear() {
        this.stopPlaying();
    }

    @Override
    public void start() {
        this.startPlaying();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public String getPixelFormat() {
        return null;
    }

    @Override
    public boolean isCameraViewer() {
        return false;
    }

    public WritableImage getWritableImage() {
        return this.writableImage;
    }

    public void setWritableImage(WritableImage writableImage) {
        this.writableImage = writableImage;
    }

    public int getCurrentFrameWidth() {
        return (int)(this.writableImage != null ? this.writableImage.getWidth() : 0.0);
    }

    public int getCurrentFrameHeight() {
        return (int)(this.writableImage != null ? this.writableImage.getHeight() : 0.0);
    }

    public boolean isWithNotification() {
        return this.withNotification.get();
    }

    public void setWithNotification(boolean withNotification) {
        this.withNotification.set(withNotification);
    }

    public void continueDrawFrame() {
        this.setIsDrawFrame(true);
    }

    public void stopDrawFrame() {
        this.setIsDrawFrame(false);
    }
}

